/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBlockWallable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import org.apache.commons.lang3.Validate;

public class ItemBanner
extends ItemBlockWallable {
    private static final String PATTERN_PREFIX = "block.minecraft.banner.";

    public ItemBanner(Block var0, Block var1, Item.Info var2) {
        super(var0, var1, var2, EnumDirection.DOWN);
        Validate.isInstanceOf(BlockBannerAbstract.class, (Object)var0);
        Validate.isInstanceOf(BlockBannerAbstract.class, (Object)var1);
    }

    public static void appendHoverTextFromBannerBlockEntityTag(ItemStack var02, List<IChatBaseComponent> var1) {
        NBTTagCompound var22 = ItemBlock.getBlockEntityData(var02);
        if (var22 == null || !var22.contains("Patterns")) {
            return;
        }
        NBTTagList var3 = var22.getList("Patterns", 10);
        for (int var4 = 0; var4 < var3.size() && var4 < 6; ++var4) {
            NBTTagCompound var5 = var3.getCompound(var4);
            EnumColor var6 = EnumColor.byId(var5.getInt("Color"));
            Holder<EnumBannerPatternType> var7 = EnumBannerPatternType.byHash(var5.getString("Pattern"));
            if (var7 == null) continue;
            var7.unwrapKey().map(var0 -> var0.location().toShortLanguageKey()).ifPresent(var2 -> var1.add(IChatBaseComponent.translatable(PATTERN_PREFIX + var2 + "." + var6.getName()).withStyle(EnumChatFormat.GRAY)));
        }
    }

    public EnumColor getColor() {
        return ((BlockBannerAbstract)this.getBlock()).getColor();
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        ItemBanner.appendHoverTextFromBannerBlockEntityTag(var0, var2);
    }
}

