/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.InteractionResultWrapper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;

public class InstrumentItem
extends Item {
    private static final String TAG_INSTRUMENT = "instrument";
    private final TagKey<Instrument> instruments;

    public InstrumentItem(Item.Info var0, TagKey<Instrument> var1) {
        super(var0);
        this.instruments = var1;
    }

    @Override
    public void appendHoverText(ItemStack var0, @Nullable World var1, List<IChatBaseComponent> var2, TooltipFlag var3) {
        super.appendHoverText(var0, var1, var2, var3);
        Optional var4 = this.getInstrument(var0).flatMap(Holder::unwrapKey);
        if (var4.isPresent()) {
            IChatMutableComponent var5 = IChatBaseComponent.translatable(SystemUtils.makeDescriptionId(TAG_INSTRUMENT, ((ResourceKey)var4.get()).location()));
            var2.add(var5.withStyle(EnumChatFormat.GRAY));
        }
    }

    public static ItemStack create(Item var0, Holder<Instrument> var1) {
        ItemStack var2 = new ItemStack(var0);
        InstrumentItem.setSoundVariantId(var2, var1);
        return var2;
    }

    public static void setRandom(ItemStack var0, TagKey<Instrument> var12, RandomSource var2) {
        Optional var3 = BuiltInRegistries.INSTRUMENT.getTag(var12).flatMap(var1 -> var1.getRandomElement(var2));
        var3.ifPresent(var1 -> InstrumentItem.setSoundVariantId(var0, var1));
    }

    private static void setSoundVariantId(ItemStack var0, Holder<Instrument> var1) {
        NBTTagCompound var2 = var0.getOrCreateTag();
        var2.putString(TAG_INSTRUMENT, var1.unwrapKey().orElseThrow(() -> new IllegalStateException("Invalid instrument")).location().toString());
    }

    @Override
    public InteractionResultWrapper<ItemStack> use(World var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        Optional<? extends Holder<Instrument>> var4 = this.getInstrument(var3);
        if (var4.isPresent()) {
            Instrument var5 = var4.get().value();
            var1.startUsingItem(var2);
            InstrumentItem.play(var0, var1, var5);
            var1.getCooldowns().addCooldown(this, var5.useDuration());
            var1.awardStat(StatisticList.ITEM_USED.get(this));
            return InteractionResultWrapper.consume(var3);
        }
        return InteractionResultWrapper.fail(var3);
    }

    @Override
    public int getUseDuration(ItemStack var02) {
        Optional<? extends Holder<Instrument>> var1 = this.getInstrument(var02);
        return var1.map(var0 -> ((Instrument)var0.value()).useDuration()).orElse(0);
    }

    private Optional<? extends Holder<Instrument>> getInstrument(ItemStack var0) {
        Iterator<Holder<Instrument>> var2;
        NBTTagCompound var1 = var0.getTag();
        if (var1 != null && var1.contains(TAG_INSTRUMENT, 8) && (var2 = MinecraftKey.tryParse(var1.getString(TAG_INSTRUMENT))) != null) {
            return BuiltInRegistries.INSTRUMENT.getHolder(ResourceKey.create(Registries.INSTRUMENT, (MinecraftKey)((Object)var2)));
        }
        var2 = BuiltInRegistries.INSTRUMENT.getTagOrEmpty(this.instruments).iterator();
        if (var2.hasNext()) {
            return Optional.of((Holder)var2.next());
        }
        return Optional.empty();
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.TOOT_HORN;
    }

    private static void play(World var0, EntityHuman var1, Instrument var2) {
        SoundEffect var3 = var2.soundEvent().value();
        float var4 = var2.range() / 16.0f;
        var0.playSound(var1, var1, var3, SoundCategory.RECORDS, var4, 1.0f);
        var0.gameEvent(GameEvent.INSTRUMENT_PLAY, var1.position(), GameEvent.a.of(var1));
    }
}

