/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.EnumAnimation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SuspiciousSandBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class BrushItem
extends Item {
    public static final int TICKS_BETWEEN_SWEEPS = 10;
    private static final int USE_DURATION = 225;

    public BrushItem(Item.Info var0) {
        super(var0);
    }

    @Override
    public EnumInteractionResult useOn(ItemActionContext var0) {
        EntityHuman var1 = var0.getPlayer();
        if (var1 != null) {
            var1.startUsingItem(var0.getHand());
        }
        return EnumInteractionResult.CONSUME;
    }

    @Override
    public EnumAnimation getUseAnimation(ItemStack var0) {
        return EnumAnimation.BRUSH;
    }

    @Override
    public int getUseDuration(ItemStack var0) {
        return 225;
    }

    @Override
    public void onUseTick(World var02, EntityLiving var1, ItemStack var2, int var3) {
        if (var3 < 0 || !(var1 instanceof EntityHuman)) {
            var1.releaseUsingItem();
            return;
        }
        EntityHuman var4 = (EntityHuman)var1;
        MovingObjectPositionBlock var5 = Item.getPlayerPOVHitResult(var02, var4, RayTrace.FluidCollisionOption.NONE);
        BlockPosition var6 = var5.getBlockPos();
        if (var5.getType() == MovingObjectPosition.EnumMovingObjectType.MISS) {
            var1.releaseUsingItem();
            return;
        }
        int var7 = this.getUseDuration(var2) - var3 + 1;
        if (var7 == 1 || var7 % 10 == 0) {
            SuspiciousSandBlockEntity var9;
            boolean var10;
            TileEntity tileEntity;
            IBlockData var8 = var02.getBlockState(var6);
            this.spawnDustParticles(var02, var5, var8, var1.getViewVector(0.0f));
            var02.playSound(var4, var6, SoundEffects.BRUSH_BRUSHING, SoundCategory.PLAYERS);
            if (!var02.isClientSide() && var8.is(Blocks.SUSPICIOUS_SAND) && (tileEntity = var02.getBlockEntity(var6)) instanceof SuspiciousSandBlockEntity && (var10 = (var9 = (SuspiciousSandBlockEntity)tileEntity).brush(var02.getGameTime(), var4, var5.getDirection()))) {
                var2.hurtAndBreak(1, var1, var0 -> var0.broadcastBreakEvent(EnumItemSlot.MAINHAND));
            }
        }
    }

    public void spawnDustParticles(World var0, MovingObjectPositionBlock var1, IBlockData var2, Vec3D var3) {
        double var4 = 3.0;
        int var6 = var0.getRandom().nextInt(7, 12);
        ParticleParamBlock var7 = new ParticleParamBlock(Particles.BLOCK, var2);
        EnumDirection var8 = var1.getDirection();
        a var9 = a.fromDirection(var3, var8);
        Vec3D var10 = var1.getLocation();
        for (int var11 = 0; var11 < var6; ++var11) {
            var0.addParticle(var7, var10.x - (double)(var8 == EnumDirection.WEST ? 1.0E-6f : 0.0f), var10.y, var10.z - (double)(var8 == EnumDirection.NORTH ? 1.0E-6f : 0.0f), var9.xd() * 3.0 * var0.getRandom().nextDouble(), 0.0, var9.zd() * 3.0 * var0.getRandom().nextDouble());
        }
    }

    record a(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static a fromDirection(Vec3D var0, EnumDirection var1) {
            double var2 = 0.0;
            return switch (var1) {
                default -> throw new IncompatibleClassChangeError();
                case EnumDirection.DOWN -> new a(-var0.x(), 0.0, var0.z());
                case EnumDirection.UP -> new a(var0.z(), 0.0, -var0.x());
                case EnumDirection.NORTH -> new a(1.0, 0.0, -0.1);
                case EnumDirection.SOUTH -> new a(-1.0, 0.0, 0.1);
                case EnumDirection.WEST -> new a(-0.1, 0.0, -1.0);
                case EnumDirection.EAST -> new a(0.1, 0.0, 1.0);
            };
        }
    }
}

