/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityFurnace;

public class SlotFurnaceResult
extends Slot {
    private final EntityHuman player;
    private int removeCount;

    public SlotFurnaceResult(EntityHuman var0, IInventory var1, int var2, int var3, int var4) {
        super(var1, var2, var3, var4);
        this.player = var0;
    }

    @Override
    public boolean mayPlace(ItemStack var0) {
        return false;
    }

    @Override
    public ItemStack remove(int var0) {
        if (this.hasItem()) {
            this.removeCount += Math.min(var0, this.getItem().getCount());
        }
        return super.remove(var0);
    }

    @Override
    public void onTake(EntityHuman var0, ItemStack var1) {
        this.checkTakeAchievements(var1);
        super.onTake(var0, var1);
    }

    @Override
    protected void onQuickCraft(ItemStack var0, int var1) {
        this.removeCount += var1;
        this.checkTakeAchievements(var0);
    }

    @Override
    protected void checkTakeAchievements(ItemStack var0) {
        var0.onCraftedBy(this.player.level, this.player, this.removeCount);
        if (this.player instanceof EntityPlayer && this.container instanceof TileEntityFurnace) {
            ((TileEntityFurnace)this.container).awardUsedRecipesAndPopExperience((EntityPlayer)this.player);
        }
        this.removeCount = 0;
    }
}

