/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.LegacyUpgradeRecipe;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

@Deprecated(forRemoval=true)
public class LegacySmithingMenu
extends ContainerAnvilAbstract {
    private final World level;
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;
    @Nullable
    private LegacyUpgradeRecipe selectedRecipe;
    private final List<LegacyUpgradeRecipe> recipes;

    public LegacySmithingMenu(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public LegacySmithingMenu(int var02, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.LEGACY_SMITHING, var02, var1, var2);
        this.level = var1.player.level;
        this.recipes = this.level.getRecipeManager().getAllRecipesFor(Recipes.SMITHING).stream().filter(var0 -> var0 instanceof LegacyUpgradeRecipe).map(var0 -> (LegacyUpgradeRecipe)var0).toList();
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, var0 -> true).withSlot(1, 76, 47, var0 -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return this.selectedRecipe != null && this.selectedRecipe.matches(this.inputSlots, this.level);
    }

    @Override
    protected void onTake(EntityHuman var02, ItemStack var12) {
        var12.onCraftedBy(var02.level, var02, var12.getCount());
        this.resultSlots.awardUsedRecipes(var02);
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.access.execute((var0, var1) -> var0.levelEvent(1044, (BlockPosition)var1, 0));
    }

    private void shrinkStackInSlot(int var0) {
        ItemStack var1 = this.inputSlots.getItem(var0);
        var1.shrink(1);
        this.inputSlots.setItem(var0, var1);
    }

    @Override
    public void createResult() {
        List<LegacyUpgradeRecipe> var02 = this.level.getRecipeManager().getRecipesFor(Recipes.SMITHING, this.inputSlots, this.level).stream().filter(var0 -> var0 instanceof LegacyUpgradeRecipe).map(var0 -> (LegacyUpgradeRecipe)var0).toList();
        if (var02.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            LegacyUpgradeRecipe var1 = var02.get(0);
            ItemStack var2 = var1.assemble(this.inputSlots, this.level.registryAccess());
            if (var2.isItemEnabled(this.level.enabledFeatures())) {
                this.selectedRecipe = var1;
                this.resultSlots.setRecipeUsed(var1);
                this.resultSlots.setItem(0, var2);
            }
        }
    }

    @Override
    public int getSlotToQuickMoveTo(ItemStack var0) {
        return this.shouldQuickMoveToAdditionalSlot(var0) ? 1 : 0;
    }

    protected boolean shouldQuickMoveToAdditionalSlot(ItemStack var0) {
        return this.recipes.stream().anyMatch(var1 -> var1.isAdditionIngredient(var0));
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }
}

