/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class ContainerSmithing
extends ContainerAnvilAbstract {
    public static final int TEMPLATE_SLOT = 0;
    public static final int BASE_SLOT = 1;
    public static final int ADDITIONAL_SLOT = 2;
    public static final int RESULT_SLOT = 3;
    public static final int TEMPLATE_SLOT_X_PLACEMENT = 8;
    public static final int BASE_SLOT_X_PLACEMENT = 26;
    public static final int ADDITIONAL_SLOT_X_PLACEMENT = 44;
    private static final int RESULT_SLOT_X_PLACEMENT = 98;
    public static final int SLOT_Y_PLACEMENT = 48;
    private final World level;
    @Nullable
    private SmithingRecipe selectedRecipe;
    private final List<SmithingRecipe> recipes;

    public ContainerSmithing(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerSmithing(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.SMITHING, var0, var1, var2);
        this.level = var1.player.level;
        this.recipes = this.level.getRecipeManager().getAllRecipesFor(Recipes.SMITHING);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 8, 48, var0 -> this.recipes.stream().anyMatch(var1 -> var1.isTemplateIngredient((ItemStack)var0))).withSlot(1, 26, 48, var0 -> this.recipes.stream().anyMatch(var1 -> var1.isBaseIngredient((ItemStack)var0) && var1.isTemplateIngredient(((Slot)this.slots.get(0)).getItem()))).withSlot(2, 44, 48, var0 -> this.recipes.stream().anyMatch(var1 -> var1.isAdditionIngredient((ItemStack)var0) && var1.isTemplateIngredient(((Slot)this.slots.get(0)).getItem()))).withResultSlot(3, 98, 48).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(Blocks.SMITHING_TABLE);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return this.selectedRecipe != null && this.selectedRecipe.matches(this.inputSlots, this.level);
    }

    @Override
    protected void onTake(EntityHuman var02, ItemStack var12) {
        var12.onCraftedBy(var02.level, var02, var12.getCount());
        this.resultSlots.awardUsedRecipes(var02);
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.access.execute((var0, var1) -> var0.levelEvent(1044, (BlockPosition)var1, 0));
    }

    private void shrinkStackInSlot(int var0) {
        ItemStack var1 = this.inputSlots.getItem(var0);
        var1.shrink(1);
        this.inputSlots.setItem(var0, var1);
    }

    @Override
    public void createResult() {
        List<SmithingRecipe> var0 = this.level.getRecipeManager().getRecipesFor(Recipes.SMITHING, this.inputSlots, this.level);
        if (var0.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            SmithingRecipe var1 = var0.get(0);
            ItemStack var2 = var1.assemble(this.inputSlots, this.level.registryAccess());
            if (var2.isItemEnabled(this.level.enabledFeatures())) {
                this.selectedRecipe = var1;
                this.resultSlots.setRecipeUsed(var1);
                this.resultSlots.setItem(0, var2);
            }
        }
    }

    @Override
    public int getSlotToQuickMoveTo(ItemStack var0) {
        return this.recipes.stream().map(var1 -> ContainerSmithing.findSlotMatchingIngredient(var1, var0)).filter(Optional::isPresent).findFirst().orElse(Optional.of(0)).get();
    }

    private static Optional<Integer> findSlotMatchingIngredient(SmithingRecipe var0, ItemStack var1) {
        if (var0.isTemplateIngredient(var1)) {
            return Optional.of(0);
        }
        if (var0.isBaseIngredient(var1)) {
            return Optional.of(1);
        }
        if (var0.isAdditionIngredient(var1)) {
            return Optional.of(2);
        }
        return Optional.empty();
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultSlots && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public boolean canMoveIntoInputSlots(ItemStack var0) {
        return this.recipes.stream().map(var1 -> ContainerSmithing.findSlotMatchingIngredient(var1, var0)).anyMatch(Optional::isPresent);
    }
}

