/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.AutoRecipeStackManager;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.AutoRecipeOutput;
import net.minecraft.world.inventory.ContainerProperties;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.IContainerProperties;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotFurnaceFuel;
import net.minecraft.world.inventory.SlotFurnaceResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.item.crafting.RecipeCooking;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityFurnace;

public abstract class ContainerFurnace
extends ContainerRecipeBook<IInventory> {
    public static final int INGREDIENT_SLOT = 0;
    public static final int FUEL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    public static final int SLOT_COUNT = 3;
    public static final int DATA_COUNT = 4;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final IInventory container;
    private final IContainerProperties data;
    protected final World level;
    private final Recipes<? extends RecipeCooking> recipeType;
    private final RecipeBookType recipeBookType;

    protected ContainerFurnace(Containers<?> var0, Recipes<? extends RecipeCooking> var1, RecipeBookType var2, int var3, PlayerInventory var4) {
        this(var0, var1, var2, var3, var4, new InventorySubcontainer(3), new ContainerProperties(4));
    }

    protected ContainerFurnace(Containers<?> var0, Recipes<? extends RecipeCooking> var1, RecipeBookType var2, int var3, PlayerInventory var4, IInventory var5, IContainerProperties var6) {
        super(var0, var3);
        int var7;
        this.recipeType = var1;
        this.recipeBookType = var2;
        ContainerFurnace.checkContainerSize(var5, 3);
        ContainerFurnace.checkContainerDataCount(var6, 4);
        this.container = var5;
        this.data = var6;
        this.level = var4.player.level;
        this.addSlot(new Slot(var5, 0, 56, 17));
        this.addSlot(new SlotFurnaceFuel(this, var5, 1, 56, 53));
        this.addSlot(new SlotFurnaceResult(var4.player, var5, 2, 116, 35));
        for (var7 = 0; var7 < 3; ++var7) {
            for (int var8 = 0; var8 < 9; ++var8) {
                this.addSlot(new Slot(var4, var8 + var7 * 9 + 9, 8 + var8 * 18, 84 + var7 * 18));
            }
        }
        for (var7 = 0; var7 < 9; ++var7) {
            this.addSlot(new Slot(var4, var7, 8 + var7 * 18, 142));
        }
        this.addDataSlots(var6);
    }

    @Override
    public void fillCraftSlotsStackedContents(AutoRecipeStackManager var0) {
        if (this.container instanceof AutoRecipeOutput) {
            ((AutoRecipeOutput)((Object)this.container)).fillStackedContents(var0);
        }
    }

    @Override
    public void clearCraftingContent() {
        this.getSlot(0).set(ItemStack.EMPTY);
        this.getSlot(2).set(ItemStack.EMPTY);
    }

    @Override
    public boolean recipeMatches(IRecipe<? super IInventory> var0) {
        return var0.matches(this.container, this.level);
    }

    @Override
    public int getResultSlotIndex() {
        return 2;
    }

    @Override
    public int getGridWidth() {
        return 1;
    }

    @Override
    public int getGridHeight() {
        return 1;
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.container.stillValid(var0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 2) {
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 1 || var1 == 0 ? !this.moveItemStackTo(var4, 3, 39, false) : (this.canSmelt(var4) ? !this.moveItemStackTo(var4, 0, 1, false) : (this.isFuel(var4) ? !this.moveItemStackTo(var4, 1, 2, false) : (var1 >= 3 && var1 < 30 ? !this.moveItemStackTo(var4, 30, 39, false) : var1 >= 30 && var1 < 39 && !this.moveItemStackTo(var4, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
        }
        return var2;
    }

    protected boolean canSmelt(ItemStack var0) {
        return this.level.getRecipeManager().getRecipeFor(this.recipeType, new InventorySubcontainer(var0), this.level).isPresent();
    }

    protected boolean isFuel(ItemStack var0) {
        return TileEntityFurnace.isFuel(var0);
    }

    public int getBurnProgress() {
        int var0 = this.data.get(2);
        int var1 = this.data.get(3);
        if (var1 == 0 || var0 == 0) {
            return 0;
        }
        return var0 * 24 / var1;
    }

    public int getLitProgress() {
        int var0 = this.data.get(1);
        if (var0 == 0) {
            var0 = 200;
        }
        return this.data.get(0) * 13 / var0;
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    @Override
    public RecipeBookType getRecipeBookType() {
        return this.recipeBookType;
    }

    @Override
    public boolean shouldMoveToInventory(int var0) {
        return var0 != 1;
    }
}

