/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.saveddata.maps.WorldMap;

public class ContainerCartography
extends Container {
    public static final int MAP_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final int INV_SLOT_START = 3;
    private static final int INV_SLOT_END = 30;
    private static final int USE_ROW_SLOT_START = 30;
    private static final int USE_ROW_SLOT_END = 39;
    private final ContainerAccess access;
    long lastSoundTime;
    public final IInventory container = new InventorySubcontainer(2){

        @Override
        public void setChanged() {
            ContainerCartography.this.slotsChanged(this);
            super.setChanged();
        }
    };
    private final InventoryCraftResult resultContainer = new InventoryCraftResult(){

        @Override
        public void setChanged() {
            ContainerCartography.this.slotsChanged(this);
            super.setChanged();
        }
    };

    public ContainerCartography(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerCartography(int var0, PlayerInventory var1, final ContainerAccess var2) {
        super(Containers.CARTOGRAPHY_TABLE, var0);
        int var3;
        this.access = var2;
        this.addSlot(new Slot(this.container, 0, 15, 15){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.is(Items.FILLED_MAP);
            }
        });
        this.addSlot(new Slot(this.container, 1, 15, 52){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return var0.is(Items.PAPER) || var0.is(Items.MAP) || var0.is(Items.GLASS_PANE);
            }
        });
        this.addSlot(new Slot(this.resultContainer, 2, 145, 39){

            @Override
            public boolean mayPlace(ItemStack var0) {
                return false;
            }

            @Override
            public void onTake(EntityHuman var02, ItemStack var12) {
                ((Slot)ContainerCartography.this.slots.get(0)).remove(1);
                ((Slot)ContainerCartography.this.slots.get(1)).remove(1);
                var12.getItem().onCraftedBy(var12, var02.level, var02);
                var2.execute((var0, var1) -> {
                    long var22 = var0.getGameTime();
                    if (ContainerCartography.this.lastSoundTime != var22) {
                        var0.playSound(null, (BlockPosition)var1, SoundEffects.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, SoundCategory.BLOCKS, 1.0f, 1.0f);
                        ContainerCartography.this.lastSoundTime = var22;
                    }
                });
                super.onTake(var02, var12);
            }
        });
        for (var3 = 0; var3 < 3; ++var3) {
            for (int var4 = 0; var4 < 9; ++var4) {
                this.addSlot(new Slot(var1, var4 + var3 * 9 + 9, 8 + var4 * 18, 84 + var3 * 18));
            }
        }
        for (var3 = 0; var3 < 9; ++var3) {
            this.addSlot(new Slot(var1, var3, 8 + var3 * 18, 142));
        }
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return ContainerCartography.stillValid(this.access, var0, Blocks.CARTOGRAPHY_TABLE);
    }

    @Override
    public void slotsChanged(IInventory var0) {
        ItemStack var1 = this.container.getItem(0);
        ItemStack var2 = this.container.getItem(1);
        ItemStack var3 = this.resultContainer.getItem(2);
        if (!var3.isEmpty() && (var1.isEmpty() || var2.isEmpty())) {
            this.resultContainer.removeItemNoUpdate(2);
        } else if (!var1.isEmpty() && !var2.isEmpty()) {
            this.setupResultSlot(var1, var2, var3);
        }
    }

    private void setupResultSlot(ItemStack var0, ItemStack var1, ItemStack var2) {
        this.access.execute((var3, var4) -> {
            ItemStack var6;
            WorldMap var5 = ItemWorldMap.getSavedData(var0, var3);
            if (var5 == null) {
                return;
            }
            if (var1.is(Items.PAPER) && !var5.locked && var5.scale < 4) {
                var6 = var0.copy();
                var6.setCount(1);
                var6.getOrCreateTag().putInt("map_scale_direction", 1);
                this.broadcastChanges();
            } else if (var1.is(Items.GLASS_PANE) && !var5.locked) {
                var6 = var0.copy();
                var6.setCount(1);
                var6.getOrCreateTag().putBoolean("map_to_lock", true);
                this.broadcastChanges();
            } else if (var1.is(Items.MAP)) {
                var6 = var0.copy();
                var6.setCount(2);
                this.broadcastChanges();
            } else {
                this.resultContainer.removeItemNoUpdate(2);
                this.broadcastChanges();
                return;
            }
            if (!ItemStack.matches(var6, var2)) {
                this.resultContainer.setItem(2, var6);
                this.broadcastChanges();
            }
        });
    }

    @Override
    public boolean canTakeItemForPickAll(ItemStack var0, Slot var1) {
        return var1.container != this.resultContainer && super.canTakeItemForPickAll(var0, var1);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            if (var1 == 2) {
                var4.getItem().onCraftedBy(var4, var0.level, var0);
                if (!this.moveItemStackTo(var4, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                var3.onQuickCraft(var4, var2);
            } else if (var1 == 1 || var1 == 0 ? !this.moveItemStackTo(var4, 3, 39, false) : (var4.is(Items.FILLED_MAP) ? !this.moveItemStackTo(var4, 0, 1, false) : (var4.is(Items.PAPER) || var4.is(Items.MAP) || var4.is(Items.GLASS_PANE) ? !this.moveItemStackTo(var4, 1, 2, false) : (var1 >= 3 && var1 < 30 ? !this.moveItemStackTo(var4, 30, 39, false) : var1 >= 30 && var1 < 39 && !this.moveItemStackTo(var4, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            }
            var3.setChanged();
            if (var4.getCount() == var2.getCount()) {
                return ItemStack.EMPTY;
            }
            var3.onTake(var0, var4);
            this.broadcastChanges();
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.resultContainer.removeItemNoUpdate(2);
        this.access.execute((var1, var2) -> this.clearContainer(var0, this.container));
    }
}

