/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import com.mojang.logging.LogUtils;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvilAbstract;
import net.minecraft.world.inventory.ContainerProperty;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.block.BlockAnvil;
import net.minecraft.world.level.block.state.IBlockData;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class ContainerAnvil
extends ContainerAnvilAbstract {
    public static final int INPUT_SLOT = 0;
    public static final int ADDITIONAL_SLOT = 1;
    public static final int RESULT_SLOT = 2;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final boolean DEBUG_COST = false;
    public static final int MAX_NAME_LENGTH = 50;
    public int repairItemCountCost;
    public String itemName;
    public final ContainerProperty cost = ContainerProperty.standalone();
    private static final int COST_FAIL = 0;
    private static final int COST_BASE = 1;
    private static final int COST_ADDED_BASE = 1;
    private static final int COST_REPAIR_MATERIAL = 1;
    private static final int COST_REPAIR_SACRIFICE = 2;
    private static final int COST_INCOMPATIBLE_PENALTY = 1;
    private static final int COST_RENAME = 1;
    private static final int INPUT_SLOT_X_PLACEMENT = 27;
    private static final int ADDITIONAL_SLOT_X_PLACEMENT = 76;
    private static final int RESULT_SLOT_X_PLACEMENT = 134;
    private static final int SLOT_Y_PLACEMENT = 47;

    public ContainerAnvil(int var0, PlayerInventory var1) {
        this(var0, var1, ContainerAccess.NULL);
    }

    public ContainerAnvil(int var0, PlayerInventory var1, ContainerAccess var2) {
        super(Containers.ANVIL, var0, var1, var2);
        this.addDataSlot(this.cost);
    }

    @Override
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 27, 47, var0 -> true).withSlot(1, 76, 47, var0 -> true).withResultSlot(2, 134, 47).build();
    }

    @Override
    protected boolean isValidBlock(IBlockData var0) {
        return var0.is(TagsBlock.ANVIL);
    }

    @Override
    protected boolean mayPickup(EntityHuman var0, boolean var1) {
        return (var0.getAbilities().instabuild || var0.experienceLevel >= this.cost.get()) && this.cost.get() > 0;
    }

    @Override
    protected void onTake(EntityHuman var0, ItemStack var12) {
        if (!var0.getAbilities().instabuild) {
            var0.giveExperienceLevels(-this.cost.get());
        }
        this.inputSlots.setItem(0, ItemStack.EMPTY);
        if (this.repairItemCountCost > 0) {
            ItemStack var22 = this.inputSlots.getItem(1);
            if (!var22.isEmpty() && var22.getCount() > this.repairItemCountCost) {
                var22.shrink(this.repairItemCountCost);
                this.inputSlots.setItem(1, var22);
            } else {
                this.inputSlots.setItem(1, ItemStack.EMPTY);
            }
        } else {
            this.inputSlots.setItem(1, ItemStack.EMPTY);
        }
        this.cost.set(0);
        this.access.execute((var1, var2) -> {
            IBlockData var3 = var1.getBlockState((BlockPosition)var2);
            if (!var0.getAbilities().instabuild && var3.is(TagsBlock.ANVIL) && var0.getRandom().nextFloat() < 0.12f) {
                IBlockData var4 = BlockAnvil.damage(var3);
                if (var4 == null) {
                    var1.removeBlock((BlockPosition)var2, false);
                    var1.levelEvent(1029, (BlockPosition)var2, 0);
                } else {
                    var1.setBlock((BlockPosition)var2, var4, 2);
                    var1.levelEvent(1030, (BlockPosition)var2, 0);
                }
            } else {
                var1.levelEvent(1030, (BlockPosition)var2, 0);
            }
        });
    }

    @Override
    public void createResult() {
        int var7;
        ItemStack var0 = this.inputSlots.getItem(0);
        this.cost.set(1);
        int var1 = 0;
        int var2 = 0;
        int var3 = 0;
        if (var0.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.cost.set(0);
            return;
        }
        ItemStack var4 = var0.copy();
        ItemStack var5 = this.inputSlots.getItem(1);
        Map<Enchantment, Integer> var6 = EnchantmentManager.getEnchantments(var4);
        var2 += var0.getBaseRepairCost() + (var5.isEmpty() ? 0 : var5.getBaseRepairCost());
        this.repairItemCountCost = 0;
        if (!var5.isEmpty()) {
            int n2 = var7 = var5.is(Items.ENCHANTED_BOOK) && !ItemEnchantedBook.getEnchantments(var5).isEmpty() ? 1 : 0;
            if (var4.isDamageableItem() && var4.getItem().isValidRepairItem(var0, var5)) {
                int var9;
                int var8 = Math.min(var4.getDamageValue(), var4.getMaxDamage() / 4);
                if (var8 <= 0) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
                for (var9 = 0; var8 > 0 && var9 < var5.getCount(); ++var9) {
                    int var10 = var4.getDamageValue() - var8;
                    var4.setDamageValue(var10);
                    ++var1;
                    var8 = Math.min(var4.getDamageValue(), var4.getMaxDamage() / 4);
                }
                this.repairItemCountCost = var9;
            } else {
                int var10;
                int var9;
                if (!(var7 != 0 || var4.is(var5.getItem()) && var4.isDamageableItem())) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
                if (var4.isDamageableItem() && var7 == 0) {
                    int var8 = var0.getMaxDamage() - var0.getDamageValue();
                    var9 = var5.getMaxDamage() - var5.getDamageValue();
                    var10 = var9 + var4.getMaxDamage() * 12 / 100;
                    int var11 = var8 + var10;
                    int var12 = var4.getMaxDamage() - var11;
                    if (var12 < 0) {
                        var12 = 0;
                    }
                    if (var12 < var4.getDamageValue()) {
                        var4.setDamageValue(var12);
                        var1 += 2;
                    }
                }
                Map<Enchantment, Integer> var8 = EnchantmentManager.getEnchantments(var5);
                var9 = 0;
                var10 = 0;
                for (Enchantment var12 : var8.keySet()) {
                    int var14;
                    if (var12 == null) continue;
                    int var13 = var6.getOrDefault(var12, 0);
                    var14 = var13 == (var14 = var8.get(var12).intValue()) ? var14 + 1 : Math.max(var14, var13);
                    boolean var15 = var12.canEnchant(var0);
                    if (this.player.getAbilities().instabuild || var0.is(Items.ENCHANTED_BOOK)) {
                        var15 = true;
                    }
                    for (Enchantment var17 : var6.keySet()) {
                        if (var17 == var12 || var12.isCompatibleWith(var17)) continue;
                        var15 = false;
                        ++var1;
                    }
                    if (!var15) {
                        var10 = 1;
                        continue;
                    }
                    var9 = 1;
                    if (var14 > var12.getMaxLevel()) {
                        var14 = var12.getMaxLevel();
                    }
                    var6.put(var12, var14);
                    int var16 = 0;
                    switch (var12.getRarity()) {
                        case COMMON: {
                            var16 = 1;
                            break;
                        }
                        case UNCOMMON: {
                            var16 = 2;
                            break;
                        }
                        case RARE: {
                            var16 = 4;
                            break;
                        }
                        case VERY_RARE: {
                            var16 = 8;
                        }
                    }
                    if (var7 != 0) {
                        var16 = Math.max(1, var16 / 2);
                    }
                    var1 += var16 * var14;
                    if (var0.getCount() <= 1) continue;
                    var1 = 40;
                }
                if (var10 != 0 && var9 == 0) {
                    this.resultSlots.setItem(0, ItemStack.EMPTY);
                    this.cost.set(0);
                    return;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)this.itemName)) {
            if (var0.hasCustomHoverName()) {
                var3 = 1;
                var1 += var3;
                var4.resetHoverName();
            }
        } else if (!this.itemName.equals(var0.getHoverName().getString())) {
            var3 = 1;
            var1 += var3;
            var4.setHoverName(IChatBaseComponent.literal(this.itemName));
        }
        this.cost.set(var2 + var1);
        if (var1 <= 0) {
            var4 = ItemStack.EMPTY;
        }
        if (var3 == var1 && var3 > 0 && this.cost.get() >= 40) {
            this.cost.set(39);
        }
        if (this.cost.get() >= 40 && !this.player.getAbilities().instabuild) {
            var4 = ItemStack.EMPTY;
        }
        if (!var4.isEmpty()) {
            var7 = var4.getBaseRepairCost();
            if (!var5.isEmpty() && var7 < var5.getBaseRepairCost()) {
                var7 = var5.getBaseRepairCost();
            }
            if (var3 != var1 || var3 == 0) {
                var7 = ContainerAnvil.calculateIncreasedRepairCost(var7);
            }
            var4.setRepairCost(var7);
            EnchantmentManager.setEnchantments(var6, var4);
        }
        this.resultSlots.setItem(0, var4);
        this.broadcastChanges();
    }

    public static int calculateIncreasedRepairCost(int var0) {
        return var0 * 2 + 1;
    }

    public void setItemName(String var0) {
        this.itemName = var0;
        if (this.getSlot(2).hasItem()) {
            ItemStack var1 = this.getSlot(2).getItem();
            if (StringUtils.isBlank((CharSequence)var0)) {
                var1.resetHoverName();
            } else {
                var1.setHoverName(IChatBaseComponent.literal(this.itemName));
            }
        }
        this.createResult();
    }

    public int getCost() {
        return this.cost.get();
    }
}

