/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionRegistry;
import net.minecraft.world.item.alchemy.PotionUtil;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<EntityLiving> WATER_SENSITIVE_OR_ON_FIRE = var0 -> var0.isSensitiveToWater() || var0.isOnFire();

    public EntityPotion(EntityTypes<? extends EntityPotion> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityPotion(World var0, EntityLiving var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, var1, var0);
    }

    public EntityPotion(World var0, double var1, double var3, double var5) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, var1, var3, var5, var0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected float getGravity() {
        return 0.05f;
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (this.level.isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        PotionRegistry var2 = PotionUtil.getPotion(var1);
        List<MobEffect> var3 = PotionUtil.getMobEffects(var1);
        boolean var4 = var2 == Potions.WATER && var3.isEmpty();
        EnumDirection var5 = var0.getDirection();
        BlockPosition var6 = var0.getBlockPos();
        BlockPosition var7 = var6.relative(var5);
        if (var4) {
            this.dowseFire(var7);
            this.dowseFire(var7.relative(var5.getOpposite()));
            for (EnumDirection var9 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                this.dowseFire(var7.relative(var9));
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        boolean var4;
        super.onHit(var0);
        if (this.level.isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        PotionRegistry var2 = PotionUtil.getPotion(var1);
        List<MobEffect> var3 = PotionUtil.getMobEffects(var1);
        boolean bl = var4 = var2 == Potions.WATER && var3.isEmpty();
        if (var4) {
            this.applyWater();
        } else if (!var3.isEmpty()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud(var1, var2);
            } else {
                this.applySplash(var3, var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY ? ((MovingObjectPositionEntity)var0).getEntity() : null);
            }
        }
        int var5 = var2.hasInstantEffects() ? 2007 : 2002;
        this.level.levelEvent(var5, this.blockPosition(), PotionUtil.getColor(var1));
        this.discard();
    }

    private void applyWater() {
        AxisAlignedBB var0 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var1 = this.level.getEntitiesOfClass(EntityLiving.class, var0, WATER_SENSITIVE_OR_ON_FIRE);
        for (EntityLiving var3 : var1) {
            double var4 = this.distanceToSqr(var3);
            if (!(var4 < 16.0)) continue;
            if (var3.isSensitiveToWater()) {
                var3.hurt(this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!var3.isOnFire() || !var3.isAlive()) continue;
            var3.extinguishFire();
        }
        List<Axolotl> var2 = this.level.getEntitiesOfClass(Axolotl.class, var0);
        for (Axolotl var4 : var2) {
            var4.rehydrate();
        }
    }

    private void applySplash(List<MobEffect> var0, @Nullable Entity var1) {
        AxisAlignedBB var22 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var3 = this.level.getEntitiesOfClass(EntityLiving.class, var22);
        if (!var3.isEmpty()) {
            Entity var4 = this.getEffectSource();
            for (EntityLiving var6 : var3) {
                double var7;
                if (!var6.isAffectedByPotions() || !((var7 = this.distanceToSqr(var6)) < 16.0)) continue;
                double var9 = var6 == var1 ? 1.0 : 1.0 - Math.sqrt(var7) / 4.0;
                for (MobEffect var12 : var0) {
                    MobEffectList var13 = var12.getEffect();
                    if (var13.isInstantenous()) {
                        var13.applyInstantenousEffect(this, this.getOwner(), var6, var12.getAmplifier(), var9);
                        continue;
                    }
                    int var14 = var12.mapDuration(var2 -> (int)(var9 * (double)var2 + 0.5));
                    MobEffect var15 = new MobEffect(var13, var14, var12.getAmplifier(), var12.isAmbient(), var12.isVisible());
                    if (var15.endsWithin(20)) continue;
                    var6.addEffect(var15, var4);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(ItemStack var0, PotionRegistry var1) {
        EntityAreaEffectCloud var2 = new EntityAreaEffectCloud(this.level, this.getX(), this.getY(), this.getZ());
        Entity var3 = this.getOwner();
        if (var3 instanceof EntityLiving) {
            var2.setOwner((EntityLiving)var3);
        }
        var2.setRadius(3.0f);
        var2.setRadiusOnUse(-0.5f);
        var2.setWaitTime(10);
        var2.setRadiusPerTick(-var2.getRadius() / (float)var2.getDuration());
        var2.setPotion(var1);
        for (MobEffect var5 : PotionUtil.getCustomEffects(var0)) {
            var2.addEffect(new MobEffect(var5));
        }
        NBTTagCompound var4 = var0.getTag();
        if (var4 != null && var4.contains("CustomPotionColor", 99)) {
            var2.setFixedColor(var4.getInt("CustomPotionColor"));
        }
        this.level.addFreshEntity(var2);
    }

    public boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPosition var0) {
        IBlockData var1 = this.level.getBlockState(var0);
        if (var1.is(TagsBlock.FIRE)) {
            this.level.removeBlock(var0, false);
        } else if (AbstractCandleBlock.isLit(var1)) {
            AbstractCandleBlock.extinguish(null, var1, this.level, var0);
        } else if (BlockCampfire.isLitCampfire(var1)) {
            this.level.levelEvent(null, 1009, var0, 0);
            BlockCampfire.dowse(this.getOwner(), this.level, var0, var1);
            this.level.setBlockAndUpdate(var0, (IBlockData)var1.setValue(BlockCampfire.LIT, false));
        }
    }
}

