/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityEgg
extends EntityProjectileThrowable {
    public EntityEgg(EntityTypes<? extends EntityEgg> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityEgg(World var0, EntityLiving var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.EGG, var1, var0);
    }

    public EntityEgg(World var0, double var1, double var3, double var5) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.EGG, var1, var3, var5, var0);
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 3) {
            double var1 = 0.08;
            for (int var3 = 0; var3 < 8; ++var3) {
                this.level.addParticle(new ParticleParamItem(Particles.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08, ((double)this.random.nextFloat() - 0.5) * 0.08);
            }
        }
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        var0.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (!this.level.isClientSide) {
            if (this.random.nextInt(8) == 0) {
                int var1 = 1;
                if (this.random.nextInt(32) == 0) {
                    var1 = 4;
                }
                for (int var2 = 0; var2 < var1; ++var2) {
                    EntityChicken var3 = EntityTypes.CHICKEN.create(this.level);
                    if (var3 == null) continue;
                    var3.setAge(-24000);
                    var3.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), 0.0f);
                    this.level.addFreshEntity(var3);
                }
            }
            this.level.broadcastEntityEvent(this, (byte)3);
            this.discard();
        }
    }

    @Override
    protected Item getDefaultItem() {
        return Items.EGG;
    }
}

