/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.ThrowingComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.SignatureValidator;

public record ProfilePublicKey(a data) {
    public static final IChatBaseComponent EXPIRED_PROFILE_PUBLIC_KEY = IChatBaseComponent.translatable("multiplayer.disconnect.expired_public_key");
    private static final IChatBaseComponent INVALID_SIGNATURE = IChatBaseComponent.translatable("multiplayer.disconnect.invalid_public_key_signature");
    public static final Duration EXPIRY_GRACE_PERIOD = Duration.ofHours(8L);
    public static final Codec<ProfilePublicKey> TRUSTED_CODEC = a.CODEC.xmap(ProfilePublicKey::new, ProfilePublicKey::data);

    public static ProfilePublicKey createValidated(SignatureValidator var0, UUID var1, a var2, Duration var3) throws b {
        if (var2.hasExpired(var3)) {
            throw new b(EXPIRED_PROFILE_PUBLIC_KEY);
        }
        if (!var2.validateSignature(var0, var1)) {
            throw new b(INVALID_SIGNATURE);
        }
        return new ProfilePublicKey(var2);
    }

    public SignatureValidator createSignatureValidator() {
        return SignatureValidator.from(this.data.key, "SHA256withRSA");
    }

    public static final class a
    extends Record {
        private final Instant expiresAt;
        final PublicKey key;
        private final byte[] keySignature;
        private static final int MAX_KEY_SIGNATURE_SIZE = 4096;
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.INSTANT_ISO8601.fieldOf("expires_at").forGetter(a::expiresAt), (App)MinecraftEncryption.PUBLIC_KEY_CODEC.fieldOf("key").forGetter(a::key), (App)ExtraCodecs.BASE64_STRING.fieldOf("signature_v2").forGetter(a::keySignature)).apply((Applicative)var0, a::new));

        public a(PacketDataSerializer var0) {
            this(var0.readInstant(), var0.readPublicKey(), var0.readByteArray(4096));
        }

        public a(Instant var0, PublicKey var1, byte[] var2) {
            this.expiresAt = var0;
            this.key = var1;
            this.keySignature = var2;
        }

        public void write(PacketDataSerializer var0) {
            var0.writeInstant(this.expiresAt);
            var0.writePublicKey(this.key);
            var0.writeByteArray(this.keySignature);
        }

        boolean validateSignature(SignatureValidator var0, UUID var1) {
            return var0.validate(this.signedPayload(var1), this.keySignature);
        }

        private byte[] signedPayload(UUID var0) {
            byte[] var1 = this.key.getEncoded();
            byte[] var2 = new byte[24 + var1.length];
            ByteBuffer var3 = ByteBuffer.wrap(var2).order(ByteOrder.BIG_ENDIAN);
            var3.putLong(var0.getMostSignificantBits()).putLong(var0.getLeastSignificantBits()).putLong(this.expiresAt.toEpochMilli()).put(var1);
            return var2;
        }

        public boolean hasExpired() {
            return this.expiresAt.isBefore(Instant.now());
        }

        public boolean hasExpired(Duration var0) {
            return this.expiresAt.plus(var0).isBefore(Instant.now());
        }

        @Override
        public boolean equals(Object var0) {
            if (var0 instanceof a) {
                a var1 = (a)var0;
                return this.expiresAt.equals(var1.expiresAt) && this.key.equals(var1.key) && Arrays.equals(this.keySignature, var1.keySignature);
            }
            return false;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "expiresAt", "key", "keySignature"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "expiresAt;key;keySignature", "expiresAt", "key", "keySignature"}, this);
        }

        public Instant expiresAt() {
            return this.expiresAt;
        }

        public PublicKey key() {
            return this.key;
        }

        public byte[] keySignature() {
            return this.keySignature;
        }
    }

    public static class b
    extends ThrowingComponent {
        public b(IChatBaseComponent var0) {
            super(var0);
        }
    }
}

