/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.warden;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class WardenSpawnTracker {
    public static final Codec<WardenSpawnTracker> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("ticks_since_last_warning").orElse((Object)0).forGetter(var0 -> var0.ticksSinceLastWarning), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("warning_level").orElse((Object)0).forGetter(var0 -> var0.warningLevel), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("cooldown_ticks").orElse((Object)0).forGetter(var0 -> var0.cooldownTicks)).apply((Applicative)var02, WardenSpawnTracker::new));
    public static final int MAX_WARNING_LEVEL = 4;
    private static final double PLAYER_SEARCH_RADIUS = 16.0;
    private static final int WARNING_CHECK_DIAMETER = 48;
    private static final int DECREASE_WARNING_LEVEL_EVERY_INTERVAL = 12000;
    private static final int WARNING_LEVEL_INCREASE_COOLDOWN = 200;
    private int ticksSinceLastWarning;
    private int warningLevel;
    private int cooldownTicks;

    public WardenSpawnTracker(int var0, int var1, int var2) {
        this.ticksSinceLastWarning = var0;
        this.warningLevel = var1;
        this.cooldownTicks = var2;
    }

    public void tick() {
        if (this.ticksSinceLastWarning >= 12000) {
            this.decreaseWarningLevel();
            this.ticksSinceLastWarning = 0;
        } else {
            ++this.ticksSinceLastWarning;
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void reset() {
        this.ticksSinceLastWarning = 0;
        this.warningLevel = 0;
        this.cooldownTicks = 0;
    }

    public static OptionalInt tryWarn(WorldServer var02, BlockPosition var1, EntityPlayer var2) {
        if (WardenSpawnTracker.hasNearbyWarden(var02, var1)) {
            return OptionalInt.empty();
        }
        List<EntityPlayer> var3 = WardenSpawnTracker.getNearbyPlayers(var02, var1);
        if (!var3.contains(var2)) {
            var3.add(var2);
        }
        if (var3.stream().anyMatch(var0 -> var0.getWardenSpawnTracker().map(WardenSpawnTracker::onCooldown).orElse(false))) {
            return OptionalInt.empty();
        }
        Optional<WardenSpawnTracker> var4 = var3.stream().flatMap(var0 -> var0.getWardenSpawnTracker().stream()).max(Comparator.comparingInt(WardenSpawnTracker::getWarningLevel));
        if (var4.isPresent()) {
            WardenSpawnTracker var5 = var4.get();
            var5.increaseWarningLevel();
            var3.forEach(var12 -> var12.getWardenSpawnTracker().ifPresent(var1 -> var1.copyData(var5)));
            return OptionalInt.of(var5.warningLevel);
        }
        return OptionalInt.empty();
    }

    private boolean onCooldown() {
        return this.cooldownTicks > 0;
    }

    private static boolean hasNearbyWarden(WorldServer var0, BlockPosition var1) {
        AxisAlignedBB var2 = AxisAlignedBB.ofSize(Vec3D.atCenterOf(var1), 48.0, 48.0, 48.0);
        return !var0.getEntitiesOfClass(Warden.class, var2).isEmpty();
    }

    private static List<EntityPlayer> getNearbyPlayers(WorldServer var0, BlockPosition var12) {
        Vec3D var2 = Vec3D.atCenterOf(var12);
        Predicate<EntityPlayer> var3 = var1 -> var1.position().closerThan(var2, 16.0);
        return var0.getPlayers(var3.and(EntityLiving::isAlive).and(IEntitySelector.NO_SPECTATORS));
    }

    private void increaseWarningLevel() {
        if (!this.onCooldown()) {
            this.ticksSinceLastWarning = 0;
            this.cooldownTicks = 200;
            this.setWarningLevel(this.getWarningLevel() + 1);
        }
    }

    private void decreaseWarningLevel() {
        this.setWarningLevel(this.getWarningLevel() - 1);
    }

    public void setWarningLevel(int var0) {
        this.warningLevel = MathHelper.clamp(var0, 0, 4);
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    private void copyData(WardenSpawnTracker var0) {
        this.warningLevel = var0.warningLevel;
        this.cooldownTicks = var0.cooldownTicks;
        this.ticksSinceLastWarning = var0.ticksSinceLastWarning;
    }
}

