/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.piglin;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeRange;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetForget;
import net.minecraft.world.entity.ai.behavior.BehaviorAttackTargetSet;
import net.minecraft.world.entity.ai.behavior.BehaviorCelebrateDeath;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorCrossbowAttack;
import net.minecraft.world.entity.ai.behavior.BehaviorExpirableMemory;
import net.minecraft.world.entity.ai.behavior.BehaviorFindAdmirableItem;
import net.minecraft.world.entity.ai.behavior.BehaviorForgetAnger;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorInteractDoor;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookInteract;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorRemoveMemory;
import net.minecraft.world.entity.ai.behavior.BehaviorRetreat;
import net.minecraft.world.entity.ai.behavior.BehaviorStartRiding;
import net.minecraft.world.entity.ai.behavior.BehaviorStopRiding;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAway;
import net.minecraft.world.entity.ai.behavior.BehaviorWalkAwayOutOfRange;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.behavior.GoToTargetLocation;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.TriggerGate;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.hoglin.EntityHoglin;
import net.minecraft.world.entity.monster.piglin.BehaviorAdmireTimeout;
import net.minecraft.world.entity.monster.piglin.BehaviorHuntHoglin;
import net.minecraft.world.entity.monster.piglin.BehaviorRememberHuntedHoglin;
import net.minecraft.world.entity.monster.piglin.BehaviorStartAdmiringItem;
import net.minecraft.world.entity.monster.piglin.BehaviorStopAdmiring;
import net.minecraft.world.entity.monster.piglin.BehaviorStopAdmiringItem;
import net.minecraft.world.entity.monster.piglin.EntityPiglin;
import net.minecraft.world.entity.monster.piglin.EntityPiglinAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;

public class PiglinAI {
    public static final int REPELLENT_DETECTION_RANGE_HORIZONTAL = 8;
    public static final int REPELLENT_DETECTION_RANGE_VERTICAL = 4;
    public static final Item BARTERING_ITEM = Items.GOLD_INGOT;
    private static final int PLAYER_ANGER_RANGE = 16;
    private static final int ANGER_DURATION = 600;
    private static final int ADMIRE_DURATION = 120;
    private static final int MAX_DISTANCE_TO_WALK_TO_ITEM = 9;
    private static final int MAX_TIME_TO_WALK_TO_ITEM = 200;
    private static final int HOW_LONG_TIME_TO_DISABLE_ADMIRE_WALKING_IF_CANT_REACH_ITEM = 200;
    private static final int CELEBRATION_TIME = 300;
    protected static final UniformInt TIME_BETWEEN_HUNTS = TimeRange.rangeOfSeconds(30, 120);
    private static final int BABY_FLEE_DURATION_AFTER_GETTING_HIT = 100;
    private static final int HIT_BY_PLAYER_MEMORY_TIMEOUT = 400;
    private static final int MAX_WALK_DISTANCE_TO_START_RIDING = 8;
    private static final UniformInt RIDE_START_INTERVAL = TimeRange.rangeOfSeconds(10, 40);
    private static final UniformInt RIDE_DURATION = TimeRange.rangeOfSeconds(10, 30);
    private static final UniformInt RETREAT_DURATION = TimeRange.rangeOfSeconds(5, 20);
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final int EAT_COOLDOWN = 200;
    private static final int DESIRED_DISTANCE_FROM_ENTITY_WHEN_AVOIDING = 12;
    private static final int MAX_LOOK_DIST = 8;
    private static final int MAX_LOOK_DIST_FOR_PLAYER_HOLDING_LOVED_ITEM = 14;
    private static final int INTERACTION_RANGE = 8;
    private static final int MIN_DESIRED_DIST_FROM_TARGET_WHEN_HOLDING_CROSSBOW = 5;
    private static final float SPEED_WHEN_STRAFING_BACK_FROM_TARGET = 0.75f;
    private static final int DESIRED_DISTANCE_FROM_ZOMBIFIED = 6;
    private static final UniformInt AVOID_ZOMBIFIED_DURATION = TimeRange.rangeOfSeconds(5, 7);
    private static final UniformInt BABY_AVOID_NEMESIS_DURATION = TimeRange.rangeOfSeconds(5, 7);
    private static final float PROBABILITY_OF_CELEBRATION_DANCE = 0.1f;
    private static final float SPEED_MULTIPLIER_WHEN_AVOIDING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_RETREATING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_MOUNTING = 0.8f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_WANTED_ITEM = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_GOING_TO_CELEBRATE_LOCATION = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_DANCING = 0.6f;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;

    protected static BehaviorController<?> makeBrain(EntityPiglin var0, BehaviorController<EntityPiglin> var1) {
        PiglinAI.initCoreActivity(var1);
        PiglinAI.initIdleActivity(var1);
        PiglinAI.initAdmireItemActivity(var1);
        PiglinAI.initFightActivity(var0, var1);
        PiglinAI.initCelebrateActivity(var1);
        PiglinAI.initRetreatActivity(var1);
        PiglinAI.initRideHoglinActivity(var1);
        var1.setCoreActivities((Set<Activity>)ImmutableSet.of((Object)Activity.CORE));
        var1.setDefaultActivity(Activity.IDLE);
        var1.useDefaultActivity();
        return var1;
    }

    protected static void initMemories(EntityPiglin var0, RandomSource var1) {
        int var2 = TIME_BETWEEN_HUNTS.sample(var1);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, var2);
    }

    private static void initCoreActivity(BehaviorController<EntityPiglin> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of((Object)new BehaviorLook(45, 90), (Object)new BehavorMove(), BehaviorInteractDoor.create(), PiglinAI.babyAvoidNemesis(), PiglinAI.avoidZombified(), BehaviorStopAdmiring.create(), BehaviorStartAdmiringItem.create(120), BehaviorCelebrateDeath.create(300, PiglinAI::wantsToDance), BehaviorForgetAnger.create()));
    }

    private static void initIdleActivity(BehaviorController<EntityPiglin> var0) {
        var0.addActivity(Activity.IDLE, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(BehaviorLookTarget.create(PiglinAI::isPlayerHoldingLovedItem, 14.0f), BehaviorAttackTargetSet.create(EntityPiglinAbstract::isAdult, PiglinAI::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(EntityPiglin::canHunt, BehaviorHuntHoglin.create()), PiglinAI.avoidRepellent(), PiglinAI.babySometimesRideBabyHoglin(), PiglinAI.createIdleLookBehaviors(), PiglinAI.createIdleMovementBehaviors(), BehaviorLookInteract.create(EntityTypes.PLAYER, 4)));
    }

    private static void initFightActivity(EntityPiglin var0, BehaviorController<EntityPiglin> var12) {
        var12.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(BehaviorAttackTargetForget.create(var1 -> !PiglinAI.isNearestValidAttackTarget(var0, var1)), BehaviorBuilder.triggerIf(PiglinAI::hasCrossbow, BehaviorRetreat.create(5, 0.75f)), BehaviorWalkAwayOutOfRange.create(1.0f), BehaviorAttack.create(20), new BehaviorCrossbowAttack(), BehaviorRememberHuntedHoglin.create(), BehaviorRemoveMemory.create(PiglinAI::isNearZombified, MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initCelebrateActivity(BehaviorController<EntityPiglin> var02) {
        var02.addActivityAndRemoveMemoryWhenStopped(Activity.CELEBRATE, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(PiglinAI.avoidRepellent(), BehaviorLookTarget.create(PiglinAI::isPlayerHoldingLovedItem, 14.0f), BehaviorAttackTargetSet.create(EntityPiglinAbstract::isAdult, PiglinAI::findNearestValidAttackTarget), BehaviorBuilder.triggerIf(var0 -> !var0.isDancing(), GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 2, 1.0f)), BehaviorBuilder.triggerIf(EntityPiglin::isDancing, GoToTargetLocation.create(MemoryModuleType.CELEBRATE_LOCATION, 4, 0.6f)), new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.6f, 2, 1), (Object)1), (Object)Pair.of((Object)new BehaviorNop(10, 20), (Object)1)))), MemoryModuleType.CELEBRATE_LOCATION);
    }

    private static void initAdmireItemActivity(BehaviorController<EntityPiglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.ADMIRE_ITEM, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(BehaviorFindAdmirableItem.create(PiglinAI::isNotHoldingLovedItemInOffHand, 1.0f, true, 9), BehaviorStopAdmiringItem.create(9), BehaviorAdmireTimeout.create(200, 200)), MemoryModuleType.ADMIRING_ITEM);
    }

    private static void initRetreatActivity(BehaviorController<EntityPiglin> var0) {
        var0.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(BehaviorWalkAway.entity(MemoryModuleType.AVOID_TARGET, 1.0f, 12, true), PiglinAI.createIdleLookBehaviors(), PiglinAI.createIdleMovementBehaviors(), BehaviorRemoveMemory.create(PiglinAI::wantsToStopFleeing, MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static void initRideHoglinActivity(BehaviorController<EntityPiglin> var02) {
        var02.addActivityAndRemoveMemoryWhenStopped(Activity.RIDE, 10, (ImmutableList<BehaviorControl<EntityPiglin>>)ImmutableList.of(BehaviorStartRiding.create(0.8f), BehaviorLookTarget.create(PiglinAI::isPlayerHoldingLovedItem, 8.0f), BehaviorBuilder.sequence(BehaviorBuilder.triggerIf(Entity::isPassenger), TriggerGate.triggerOneShuffled(ImmutableList.builder().addAll(PiglinAI.createLookBehaviors()).add((Object)Pair.of(BehaviorBuilder.triggerIf(var0 -> true), (Object)1)).build())), BehaviorStopRiding.create(8, PiglinAI::wantsToStopRiding)), MemoryModuleType.RIDE_TARGET);
    }

    private static ImmutableList<Pair<OneShot<EntityLiving>, Integer>> createLookBehaviors() {
        return ImmutableList.of((Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PLAYER, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PIGLIN, 8.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(8.0f), (Object)1));
    }

    private static BehaviorGateSingle<EntityLiving> createIdleLookBehaviors() {
        return new BehaviorGateSingle<EntityLiving>((List<Pair<BehaviorControl<EntityLiving>, Integer>>)ImmutableList.builder().addAll(PiglinAI.createLookBehaviors()).add((Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)).build());
    }

    private static BehaviorGateSingle<EntityPiglin> createIdleMovementBehaviors() {
        return new BehaviorGateSingle<EntityPiglin>((List<Pair<BehaviorControl<EntityPiglin>, Integer>>)ImmutableList.of((Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(0.6f), (Object)2), (Object)Pair.of(BehaviorInteract.of(EntityTypes.PIGLIN, 8, MemoryModuleType.INTERACTION_TARGET, 0.6f, 2), (Object)2), (Object)Pair.of(BehaviorBuilder.triggerIf(PiglinAI::doesntSeeAnyPlayerHoldingLovedItem, BehaviorLookWalk.create(0.6f, 3)), (Object)2), (Object)Pair.of((Object)new BehaviorNop(30, 60), (Object)1)));
    }

    private static BehaviorControl<EntityCreature> avoidRepellent() {
        return BehaviorWalkAway.pos(MemoryModuleType.NEAREST_REPELLENT, 1.0f, 8, false);
    }

    private static BehaviorControl<EntityPiglin> babyAvoidNemesis() {
        return BehaviorExpirableMemory.create(EntityPiglin::isBaby, MemoryModuleType.NEAREST_VISIBLE_NEMESIS, MemoryModuleType.AVOID_TARGET, BABY_AVOID_NEMESIS_DURATION);
    }

    private static BehaviorControl<EntityPiglin> avoidZombified() {
        return BehaviorExpirableMemory.create(PiglinAI::isNearZombified, MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, MemoryModuleType.AVOID_TARGET, AVOID_ZOMBIFIED_DURATION);
    }

    protected static void updateActivity(EntityPiglin var0) {
        BehaviorController<EntityPiglin> var1 = var0.getBrain();
        Activity var2 = var1.getActiveNonCoreActivity().orElse(null);
        var1.setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.ADMIRE_ITEM, (Object)Activity.FIGHT, (Object)Activity.AVOID, (Object)Activity.CELEBRATE, (Object)Activity.RIDE, (Object)Activity.IDLE));
        Activity var3 = var1.getActiveNonCoreActivity().orElse(null);
        if (var2 != var3) {
            PiglinAI.getSoundForCurrentActivity(var0).ifPresent(var0::playSoundEvent);
        }
        var0.setAggressive(var1.hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        if (!var1.hasMemoryValue(MemoryModuleType.RIDE_TARGET) && PiglinAI.isBabyRidingBaby(var0)) {
            var0.stopRiding();
        }
        if (!var1.hasMemoryValue(MemoryModuleType.CELEBRATE_LOCATION)) {
            var1.eraseMemory(MemoryModuleType.DANCING);
        }
        var0.setDancing(var1.hasMemoryValue(MemoryModuleType.DANCING));
    }

    private static boolean isBabyRidingBaby(EntityPiglin var0) {
        if (!var0.isBaby()) {
            return false;
        }
        Entity var1 = var0.getVehicle();
        return var1 instanceof EntityPiglin && ((EntityPiglin)var1).isBaby() || var1 instanceof EntityHoglin && ((EntityHoglin)var1).isBaby();
    }

    protected static void pickUpItem(EntityPiglin var0, EntityItem var1) {
        boolean var3;
        ItemStack var2;
        PiglinAI.stopWalking(var0);
        if (var1.getItem().is(Items.GOLD_NUGGET)) {
            var0.take(var1, var1.getItem().getCount());
            var2 = var1.getItem();
            var1.discard();
        } else {
            var0.take(var1, 1);
            var2 = PiglinAI.removeOneItemFromItemEntity(var1);
        }
        if (PiglinAI.isLovedItem(var2)) {
            var0.getBrain().eraseMemory(MemoryModuleType.TIME_TRYING_TO_REACH_ADMIRE_ITEM);
            PiglinAI.holdInOffhand(var0, var2);
            PiglinAI.admireGoldItem(var0);
            return;
        }
        if (PiglinAI.isFood(var2) && !PiglinAI.hasEatenRecently(var0)) {
            PiglinAI.eat(var0);
            return;
        }
        boolean bl = var3 = !var0.equipItemIfPossible(var2).equals(ItemStack.EMPTY);
        if (var3) {
            return;
        }
        PiglinAI.putInInventory(var0, var2);
    }

    private static void holdInOffhand(EntityPiglin var0, ItemStack var1) {
        if (PiglinAI.isHoldingItemInOffHand(var0)) {
            var0.spawnAtLocation(var0.getItemInHand(EnumHand.OFF_HAND));
        }
        var0.holdInOffHand(var1);
    }

    private static ItemStack removeOneItemFromItemEntity(EntityItem var0) {
        ItemStack var1 = var0.getItem();
        ItemStack var2 = var1.split(1);
        if (var1.isEmpty()) {
            var0.discard();
        } else {
            var0.setItem(var1);
        }
        return var2;
    }

    protected static void stopHoldingOffHandItem(EntityPiglin var0, boolean var1) {
        ItemStack var2 = var0.getItemInHand(EnumHand.OFF_HAND);
        var0.setItemInHand(EnumHand.OFF_HAND, ItemStack.EMPTY);
        if (var0.isAdult()) {
            boolean var3 = PiglinAI.isBarterCurrency(var2);
            if (var1 && var3) {
                PiglinAI.throwItems(var0, PiglinAI.getBarterResponseItems(var0));
            } else if (!var3) {
                boolean var4;
                boolean bl = var4 = !var0.equipItemIfPossible(var2).isEmpty();
                if (!var4) {
                    PiglinAI.putInInventory(var0, var2);
                }
            }
        } else {
            boolean var3;
            boolean bl = var3 = !var0.equipItemIfPossible(var2).isEmpty();
            if (!var3) {
                ItemStack var4 = var0.getMainHandItem();
                if (PiglinAI.isLovedItem(var4)) {
                    PiglinAI.putInInventory(var0, var4);
                } else {
                    PiglinAI.throwItems(var0, Collections.singletonList(var4));
                }
                var0.holdInMainHand(var2);
            }
        }
    }

    protected static void cancelAdmiring(EntityPiglin var0) {
        if (PiglinAI.isAdmiringItem(var0) && !var0.getOffhandItem().isEmpty()) {
            var0.spawnAtLocation(var0.getOffhandItem());
            var0.setItemInHand(EnumHand.OFF_HAND, ItemStack.EMPTY);
        }
    }

    private static void putInInventory(EntityPiglin var0, ItemStack var1) {
        ItemStack var2 = var0.addToInventory(var1);
        PiglinAI.throwItemsTowardRandomPos(var0, Collections.singletonList(var2));
    }

    private static void throwItems(EntityPiglin var0, List<ItemStack> var1) {
        Optional<EntityHuman> var2 = var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
        if (var2.isPresent()) {
            PiglinAI.throwItemsTowardPlayer(var0, var2.get(), var1);
        } else {
            PiglinAI.throwItemsTowardRandomPos(var0, var1);
        }
    }

    private static void throwItemsTowardRandomPos(EntityPiglin var0, List<ItemStack> var1) {
        PiglinAI.throwItemsTowardPos(var0, var1, PiglinAI.getRandomNearbyPos(var0));
    }

    private static void throwItemsTowardPlayer(EntityPiglin var0, EntityHuman var1, List<ItemStack> var2) {
        PiglinAI.throwItemsTowardPos(var0, var2, var1.position());
    }

    private static void throwItemsTowardPos(EntityPiglin var0, List<ItemStack> var1, Vec3D var2) {
        if (!var1.isEmpty()) {
            var0.swing(EnumHand.OFF_HAND);
            for (ItemStack var4 : var1) {
                BehaviorUtil.throwItem(var0, var4, var2.add(0.0, 1.0, 0.0));
            }
        }
    }

    private static List<ItemStack> getBarterResponseItems(EntityPiglin var0) {
        LootTable var1 = var0.level.getServer().getLootTables().get(LootTables.PIGLIN_BARTERING);
        ObjectArrayList<ItemStack> var2 = var1.getRandomItems(new LootTableInfo.Builder((WorldServer)var0.level).withParameter(LootContextParameters.THIS_ENTITY, var0).withRandom(var0.level.random).create(LootContextParameterSets.PIGLIN_BARTER));
        return var2;
    }

    private static boolean wantsToDance(EntityLiving var0, EntityLiving var1) {
        if (var1.getType() != EntityTypes.HOGLIN) {
            return false;
        }
        return RandomSource.create(var0.level.getGameTime()).nextFloat() < 0.1f;
    }

    protected static boolean wantsToPickup(EntityPiglin var0, ItemStack var1) {
        if (var0.isBaby() && var1.is(TagsItem.IGNORED_BY_PIGLIN_BABIES)) {
            return false;
        }
        if (var1.is(TagsItem.PIGLIN_REPELLENTS)) {
            return false;
        }
        if (PiglinAI.isAdmiringDisabled(var0) && var0.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET)) {
            return false;
        }
        if (PiglinAI.isBarterCurrency(var1)) {
            return PiglinAI.isNotHoldingLovedItemInOffHand(var0);
        }
        boolean var2 = var0.canAddToInventory(var1);
        if (var1.is(Items.GOLD_NUGGET)) {
            return var2;
        }
        if (PiglinAI.isFood(var1)) {
            return !PiglinAI.hasEatenRecently(var0) && var2;
        }
        if (PiglinAI.isLovedItem(var1)) {
            return PiglinAI.isNotHoldingLovedItemInOffHand(var0) && var2;
        }
        return var0.canReplaceCurrentItem(var1);
    }

    protected static boolean isLovedItem(ItemStack var0) {
        return var0.is(TagsItem.PIGLIN_LOVED);
    }

    private static boolean wantsToStopRiding(EntityPiglin var0, Entity var1) {
        if (var1 instanceof EntityInsentient) {
            EntityInsentient var2 = (EntityInsentient)var1;
            return !var2.isBaby() || !var2.isAlive() || PiglinAI.wasHurtRecently(var0) || PiglinAI.wasHurtRecently(var2) || var2 instanceof EntityPiglin && var2.getVehicle() == null;
        }
        return false;
    }

    private static boolean isNearestValidAttackTarget(EntityPiglin var0, EntityLiving var12) {
        return PiglinAI.findNearestValidAttackTarget(var0).filter(var1 -> var1 == var12).isPresent();
    }

    private static boolean isNearZombified(EntityPiglin var0) {
        BehaviorController<EntityPiglin> var1 = var0.getBrain();
        if (var1.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED)) {
            EntityLiving var2 = var1.getMemory(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED).get();
            return var0.closerThan(var2, 6.0);
        }
        return false;
    }

    private static Optional<? extends EntityLiving> findNearestValidAttackTarget(EntityPiglin var0) {
        Optional<EntityLiving> var3;
        BehaviorController<EntityPiglin> var1 = var0.getBrain();
        if (PiglinAI.isNearZombified(var0)) {
            return Optional.empty();
        }
        Optional<EntityLiving> var2 = BehaviorUtil.getLivingEntityFromUUIDMemory(var0, MemoryModuleType.ANGRY_AT);
        if (var2.isPresent() && Sensor.isEntityAttackableIgnoringLineOfSight(var0, var2.get())) {
            return var2;
        }
        if (var1.hasMemoryValue(MemoryModuleType.UNIVERSAL_ANGER) && (var3 = var1.getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)).isPresent()) {
            return var3;
        }
        var3 = var1.getMemory(MemoryModuleType.NEAREST_VISIBLE_NEMESIS);
        if (var3.isPresent()) {
            return var3;
        }
        Optional<EntityHuman> var4 = var1.getMemory(MemoryModuleType.NEAREST_TARGETABLE_PLAYER_NOT_WEARING_GOLD);
        if (var4.isPresent() && Sensor.isEntityAttackable(var0, var4.get())) {
            return var4;
        }
        return Optional.empty();
    }

    public static void angerNearbyPiglins(EntityHuman var0, boolean var12) {
        List<EntityPiglin> var22 = var0.level.getEntitiesOfClass(EntityPiglin.class, var0.getBoundingBox().inflate(16.0));
        var22.stream().filter(PiglinAI::isIdle).filter(var2 -> !var12 || BehaviorUtil.canSee(var2, var0)).forEach(var1 -> {
            if (var1.level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
                PiglinAI.setAngerTargetToNearestTargetablePlayerIfFound(var1, var0);
            } else {
                PiglinAI.setAngerTarget(var1, var0);
            }
        });
    }

    public static EnumInteractionResult mobInteract(EntityPiglin var0, EntityHuman var1, EnumHand var2) {
        ItemStack var3 = var1.getItemInHand(var2);
        if (PiglinAI.canAdmire(var0, var3)) {
            ItemStack var4 = var3.split(1);
            PiglinAI.holdInOffhand(var0, var4);
            PiglinAI.admireGoldItem(var0);
            PiglinAI.stopWalking(var0);
            return EnumInteractionResult.CONSUME;
        }
        return EnumInteractionResult.PASS;
    }

    protected static boolean canAdmire(EntityPiglin var0, ItemStack var1) {
        return !PiglinAI.isAdmiringDisabled(var0) && !PiglinAI.isAdmiringItem(var0) && var0.isAdult() && PiglinAI.isBarterCurrency(var1);
    }

    protected static void wasHurtBy(EntityPiglin var0, EntityLiving var1) {
        if (var1 instanceof EntityPiglin) {
            return;
        }
        if (PiglinAI.isHoldingItemInOffHand(var0)) {
            PiglinAI.stopHoldingOffHandItem(var0, false);
        }
        BehaviorController<EntityPiglin> var22 = var0.getBrain();
        var22.eraseMemory(MemoryModuleType.CELEBRATE_LOCATION);
        var22.eraseMemory(MemoryModuleType.DANCING);
        var22.eraseMemory(MemoryModuleType.ADMIRING_ITEM);
        if (var1 instanceof EntityHuman) {
            var22.setMemoryWithExpiry(MemoryModuleType.ADMIRING_DISABLED, true, 400L);
        }
        PiglinAI.getAvoidTarget(var0).ifPresent(var2 -> {
            if (var2.getType() != var1.getType()) {
                var22.eraseMemory(MemoryModuleType.AVOID_TARGET);
            }
        });
        if (var0.isBaby()) {
            var22.setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, var1, 100L);
            if (Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1)) {
                PiglinAI.broadcastAngerTarget(var0, var1);
            }
            return;
        }
        if (var1.getType() == EntityTypes.HOGLIN && PiglinAI.hoglinsOutnumberPiglins(var0)) {
            PiglinAI.setAvoidTargetAndDontHuntForAWhile(var0, var1);
            PiglinAI.broadcastRetreat(var0, var1);
            return;
        }
        PiglinAI.maybeRetaliate(var0, var1);
    }

    protected static void maybeRetaliate(EntityPiglinAbstract var0, EntityLiving var1) {
        if (var0.getBrain().isActive(Activity.AVOID)) {
            return;
        }
        if (!Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1)) {
            return;
        }
        if (BehaviorUtil.isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(var0, var1, 4.0)) {
            return;
        }
        if (var1.getType() == EntityTypes.PLAYER && var0.level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
            PiglinAI.setAngerTargetToNearestTargetablePlayerIfFound(var0, var1);
            PiglinAI.broadcastUniversalAnger(var0);
        } else {
            PiglinAI.setAngerTarget(var0, var1);
            PiglinAI.broadcastAngerTarget(var0, var1);
        }
    }

    public static Optional<SoundEffect> getSoundForCurrentActivity(EntityPiglin var0) {
        return var0.getBrain().getActiveNonCoreActivity().map(var1 -> PiglinAI.getSoundForActivity(var0, var1));
    }

    private static SoundEffect getSoundForActivity(EntityPiglin var0, Activity var1) {
        if (var1 == Activity.FIGHT) {
            return SoundEffects.PIGLIN_ANGRY;
        }
        if (var0.isConverting()) {
            return SoundEffects.PIGLIN_RETREAT;
        }
        if (var1 == Activity.AVOID && PiglinAI.isNearAvoidTarget(var0)) {
            return SoundEffects.PIGLIN_RETREAT;
        }
        if (var1 == Activity.ADMIRE_ITEM) {
            return SoundEffects.PIGLIN_ADMIRING_ITEM;
        }
        if (var1 == Activity.CELEBRATE) {
            return SoundEffects.PIGLIN_CELEBRATE;
        }
        if (PiglinAI.seesPlayerHoldingLovedItem(var0)) {
            return SoundEffects.PIGLIN_JEALOUS;
        }
        if (PiglinAI.isNearRepellent(var0)) {
            return SoundEffects.PIGLIN_RETREAT;
        }
        return SoundEffects.PIGLIN_AMBIENT;
    }

    private static boolean isNearAvoidTarget(EntityPiglin var0) {
        BehaviorController<EntityPiglin> var1 = var0.getBrain();
        if (!var1.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return false;
        }
        return var1.getMemory(MemoryModuleType.AVOID_TARGET).get().closerThan(var0, 12.0);
    }

    protected static List<EntityPiglinAbstract> getVisibleAdultPiglins(EntityPiglin var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLINS).orElse((List<EntityPiglinAbstract>)ImmutableList.of());
    }

    private static List<EntityPiglinAbstract> getAdultPiglins(EntityPiglinAbstract var0) {
        return var0.getBrain().getMemory(MemoryModuleType.NEARBY_ADULT_PIGLINS).orElse((List<EntityPiglinAbstract>)ImmutableList.of());
    }

    public static boolean isWearingGold(EntityLiving var0) {
        Iterable<ItemStack> var1 = var0.getArmorSlots();
        for (ItemStack var3 : var1) {
            Item var4 = var3.getItem();
            if (!(var4 instanceof ItemArmor) || ((ItemArmor)var4).getMaterial() != EnumArmorMaterial.GOLD) continue;
            return true;
        }
        return false;
    }

    private static void stopWalking(EntityPiglin var0) {
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var0.getNavigation().stop();
    }

    private static BehaviorControl<EntityLiving> babySometimesRideBabyHoglin() {
        SetEntityLookTargetSometimes.a var0 = new SetEntityLookTargetSometimes.a(RIDE_START_INTERVAL);
        return BehaviorExpirableMemory.create(var1 -> var1.isBaby() && var0.tickDownAndCheck(var1.level.random), MemoryModuleType.NEAREST_VISIBLE_BABY_HOGLIN, MemoryModuleType.RIDE_TARGET, RIDE_DURATION);
    }

    protected static void broadcastAngerTarget(EntityPiglinAbstract var0, EntityLiving var12) {
        PiglinAI.getAdultPiglins(var0).forEach(var1 -> {
            if (!(var12.getType() != EntityTypes.HOGLIN || var1.canHunt() && ((EntityHoglin)var12).canBeHunted())) {
                return;
            }
            PiglinAI.setAngerTargetIfCloserThanCurrent(var1, var12);
        });
    }

    protected static void broadcastUniversalAnger(EntityPiglinAbstract var02) {
        PiglinAI.getAdultPiglins(var02).forEach(var0 -> PiglinAI.getNearestVisibleTargetablePlayer(var0).ifPresent(var1 -> PiglinAI.setAngerTarget(var0, var1)));
    }

    protected static void setAngerTarget(EntityPiglinAbstract var0, EntityLiving var1) {
        if (!Sensor.isEntityAttackableIgnoringLineOfSight(var0, var1)) {
            return;
        }
        var0.getBrain().eraseMemory(MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.ANGRY_AT, var1.getUUID(), 600L);
        if (var1.getType() == EntityTypes.HOGLIN && var0.canHunt()) {
            PiglinAI.dontKillAnyMoreHoglinsForAWhile(var0);
        }
        if (var1.getType() == EntityTypes.PLAYER && var0.level.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER)) {
            var0.getBrain().setMemoryWithExpiry(MemoryModuleType.UNIVERSAL_ANGER, true, 600L);
        }
    }

    private static void setAngerTargetToNearestTargetablePlayerIfFound(EntityPiglinAbstract var0, EntityLiving var1) {
        Optional<EntityHuman> var2 = PiglinAI.getNearestVisibleTargetablePlayer(var0);
        if (var2.isPresent()) {
            PiglinAI.setAngerTarget(var0, var2.get());
        } else {
            PiglinAI.setAngerTarget(var0, var1);
        }
    }

    private static void setAngerTargetIfCloserThanCurrent(EntityPiglinAbstract var0, EntityLiving var1) {
        Optional<EntityLiving> var2 = PiglinAI.getAngerTarget(var0);
        EntityLiving var3 = BehaviorUtil.getNearestTarget(var0, var2, var1);
        if (var2.isPresent() && var2.get() == var3) {
            return;
        }
        PiglinAI.setAngerTarget(var0, var3);
    }

    private static Optional<EntityLiving> getAngerTarget(EntityPiglinAbstract var0) {
        return BehaviorUtil.getLivingEntityFromUUIDMemory(var0, MemoryModuleType.ANGRY_AT);
    }

    public static Optional<EntityLiving> getAvoidTarget(EntityPiglin var0) {
        if (var0.getBrain().hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return var0.getBrain().getMemory(MemoryModuleType.AVOID_TARGET);
        }
        return Optional.empty();
    }

    public static Optional<EntityHuman> getNearestVisibleTargetablePlayer(EntityPiglinAbstract var0) {
        if (var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER)) {
            return var0.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
        }
        return Optional.empty();
    }

    private static void broadcastRetreat(EntityPiglin var02, EntityLiving var12) {
        PiglinAI.getVisibleAdultPiglins(var02).stream().filter(var0 -> var0 instanceof EntityPiglin).forEach(var1 -> PiglinAI.retreatFromNearestTarget((EntityPiglin)var1, var12));
    }

    private static void retreatFromNearestTarget(EntityPiglin var0, EntityLiving var1) {
        BehaviorController<EntityPiglin> var2 = var0.getBrain();
        EntityLiving var3 = var1;
        var3 = BehaviorUtil.getNearestTarget(var0, var2.getMemory(MemoryModuleType.AVOID_TARGET), var3);
        var3 = BehaviorUtil.getNearestTarget(var0, var2.getMemory(MemoryModuleType.ATTACK_TARGET), var3);
        PiglinAI.setAvoidTargetAndDontHuntForAWhile(var0, var3);
    }

    private static boolean wantsToStopFleeing(EntityPiglin var0) {
        BehaviorController<EntityPiglin> var1 = var0.getBrain();
        if (!var1.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return true;
        }
        EntityLiving var2 = var1.getMemory(MemoryModuleType.AVOID_TARGET).get();
        EntityTypes<?> var3 = var2.getType();
        if (var3 == EntityTypes.HOGLIN) {
            return PiglinAI.piglinsEqualOrOutnumberHoglins(var0);
        }
        if (PiglinAI.isZombified(var3)) {
            return !var1.isMemoryValue(MemoryModuleType.NEAREST_VISIBLE_ZOMBIFIED, var2);
        }
        return false;
    }

    private static boolean piglinsEqualOrOutnumberHoglins(EntityPiglin var0) {
        return !PiglinAI.hoglinsOutnumberPiglins(var0);
    }

    private static boolean hoglinsOutnumberPiglins(EntityPiglin var0) {
        int var1 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT).orElse(0) + 1;
        int var2 = var0.getBrain().getMemory(MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT).orElse(0);
        return var2 > var1;
    }

    private static void setAvoidTargetAndDontHuntForAWhile(EntityPiglin var0, EntityLiving var1) {
        var0.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
        var0.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        var0.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, var1, RETREAT_DURATION.sample(var0.level.random));
        PiglinAI.dontKillAnyMoreHoglinsForAWhile(var0);
    }

    protected static void dontKillAnyMoreHoglinsForAWhile(EntityPiglinAbstract var0) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.HUNTED_RECENTLY, true, TIME_BETWEEN_HUNTS.sample(var0.level.random));
    }

    private static void eat(EntityPiglin var0) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.ATE_RECENTLY, true, 200L);
    }

    private static Vec3D getRandomNearbyPos(EntityPiglin var0) {
        Vec3D var1 = LandRandomPos.getPos(var0, 4, 2);
        return var1 == null ? var0.position() : var1;
    }

    private static boolean hasEatenRecently(EntityPiglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.ATE_RECENTLY);
    }

    protected static boolean isIdle(EntityPiglinAbstract var0) {
        return var0.getBrain().isActive(Activity.IDLE);
    }

    private static boolean hasCrossbow(EntityLiving var0) {
        return var0.isHolding(Items.CROSSBOW);
    }

    private static void admireGoldItem(EntityLiving var0) {
        var0.getBrain().setMemoryWithExpiry(MemoryModuleType.ADMIRING_ITEM, true, 120L);
    }

    private static boolean isAdmiringItem(EntityPiglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_ITEM);
    }

    private static boolean isBarterCurrency(ItemStack var0) {
        return var0.is(BARTERING_ITEM);
    }

    private static boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.PIGLIN_FOOD);
    }

    private static boolean isNearRepellent(EntityPiglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_REPELLENT);
    }

    private static boolean seesPlayerHoldingLovedItem(EntityLiving var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_PLAYER_HOLDING_WANTED_ITEM);
    }

    private static boolean doesntSeeAnyPlayerHoldingLovedItem(EntityLiving var0) {
        return !PiglinAI.seesPlayerHoldingLovedItem(var0);
    }

    public static boolean isPlayerHoldingLovedItem(EntityLiving var0) {
        return var0.getType() == EntityTypes.PLAYER && var0.isHolding(PiglinAI::isLovedItem);
    }

    private static boolean isAdmiringDisabled(EntityPiglin var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.ADMIRING_DISABLED);
    }

    private static boolean wasHurtRecently(EntityLiving var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.HURT_BY);
    }

    private static boolean isHoldingItemInOffHand(EntityPiglin var0) {
        return !var0.getOffhandItem().isEmpty();
    }

    private static boolean isNotHoldingLovedItemInOffHand(EntityPiglin var0) {
        return var0.getOffhandItem().isEmpty() || !PiglinAI.isLovedItem(var0.getOffhandItem());
    }

    public static boolean isZombified(EntityTypes<?> var0) {
        return var0 == EntityTypes.ZOMBIFIED_PIGLIN || var0 == EntityTypes.ZOGLIN;
    }
}

