/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.World;

public class EntityTNTPrimed
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<Integer> DATA_FUSE_ID = DataWatcher.defineId(EntityTNTPrimed.class, DataWatcherRegistry.INT);
    private static final int DEFAULT_FUSE_TIME = 80;
    @Nullable
    public EntityLiving owner;

    public EntityTNTPrimed(EntityTypes<? extends EntityTNTPrimed> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
    }

    public EntityTNTPrimed(World var0, double var1, double var3, double var5, @Nullable EntityLiving var7) {
        this((EntityTypes<? extends EntityTNTPrimed>)EntityTypes.TNT, var0);
        this.setPos(var1, var3, var5);
        double var8 = var0.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(var8) * 0.02, 0.2f, -Math.cos(var8) * 0.02);
        this.setFuse(80);
        this.xo = var1;
        this.yo = var3;
        this.zo = var5;
        this.owner = var7;
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_FUSE_ID, 80);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    public void tick() {
        if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.04, 0.0));
        }
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int var0 = this.getFuse() - 1;
        this.setFuse(var0);
        if (var0 <= 0) {
            this.discard();
            if (!this.level.isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level.isClientSide) {
                this.level.addParticle(Particles.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        float var0 = 4.0f;
        this.level.explode(this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, World.a.TNT);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort("Fuse", (short)this.getFuse());
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.setFuse(var0.getShort("Fuse"));
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        return this.owner;
    }

    @Override
    protected float getEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.15f;
    }

    public void setFuse(int var0) {
        this.entityData.set(DATA_FUSE_ID, var0);
    }

    public int getFuse() {
        return this.entityData.get(DATA_FUSE_ID);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

