/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;

public class EntityEnderCrystal
extends Entity {
    private static final DataWatcherObject<Optional<BlockPosition>> DATA_BEAM_TARGET = DataWatcher.defineId(EntityEnderCrystal.class, DataWatcherRegistry.OPTIONAL_BLOCK_POS);
    private static final DataWatcherObject<Boolean> DATA_SHOW_BOTTOM = DataWatcher.defineId(EntityEnderCrystal.class, DataWatcherRegistry.BOOLEAN);
    public int time;

    public EntityEnderCrystal(EntityTypes<? extends EntityEnderCrystal> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
        this.time = this.random.nextInt(100000);
    }

    public EntityEnderCrystal(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityEnderCrystal>)EntityTypes.END_CRYSTAL, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    protected void defineSynchedData() {
        this.getEntityData().define(DATA_BEAM_TARGET, Optional.empty());
        this.getEntityData().define(DATA_SHOW_BOTTOM, true);
    }

    @Override
    public void tick() {
        ++this.time;
        if (this.level instanceof WorldServer) {
            BlockPosition var0 = this.blockPosition();
            if (((WorldServer)this.level).dragonFight() != null && this.level.getBlockState(var0).isAir()) {
                this.level.setBlockAndUpdate(var0, BlockFireAbstract.getState(this.level, var0));
            }
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        if (this.getBeamTarget() != null) {
            var0.put("BeamTarget", GameProfileSerializer.writeBlockPos(this.getBeamTarget()));
        }
        var0.putBoolean("ShowBottom", this.showsBottom());
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        if (var0.contains("BeamTarget", 10)) {
            this.setBeamTarget(GameProfileSerializer.readBlockPos(var0.getCompound("BeamTarget")));
        }
        if (var0.contains("ShowBottom", 1)) {
            this.setShowBottom(var0.getBoolean("ShowBottom"));
        }
    }

    @Override
    public boolean isPickable() {
        return true;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        if (this.isInvulnerableTo(var0)) {
            return false;
        }
        if (var0.getEntity() instanceof EntityEnderDragon) {
            return false;
        }
        if (!this.isRemoved() && !this.level.isClientSide) {
            this.remove(Entity.RemovalReason.KILLED);
            if (!var0.is(DamageTypeTags.IS_EXPLOSION)) {
                DamageSource var2 = var0.getEntity() != null ? this.damageSources().explosion(this, var0.getEntity()) : null;
                this.level.explode(this, var2, null, this.getX(), this.getY(), this.getZ(), 6.0f, false, World.a.BLOCK);
            }
            this.onDestroyedBy(var0);
        }
        return true;
    }

    @Override
    public void kill() {
        this.onDestroyedBy(this.damageSources().generic());
        super.kill();
    }

    private void onDestroyedBy(DamageSource var0) {
        EnderDragonBattle var1;
        if (this.level instanceof WorldServer && (var1 = ((WorldServer)this.level).dragonFight()) != null) {
            var1.onCrystalDestroyed(this, var0);
        }
    }

    public void setBeamTarget(@Nullable BlockPosition var0) {
        this.getEntityData().set(DATA_BEAM_TARGET, Optional.ofNullable(var0));
    }

    @Nullable
    public BlockPosition getBeamTarget() {
        return this.getEntityData().get(DATA_BEAM_TARGET).orElse(null);
    }

    public void setShowBottom(boolean var0) {
        this.getEntityData().set(DATA_SHOW_BOTTOM, var0);
    }

    public boolean showsBottom() {
        return this.getEntityData().get(DATA_SHOW_BOTTOM);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return super.shouldRenderAtSqrDistance(var0) || this.getBeamTarget() != null;
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.END_CRYSTAL);
    }
}

