/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorGateSingle;
import net.minecraft.world.entity.ai.behavior.BehaviorLook;
import net.minecraft.world.entity.ai.behavior.BehaviorLookTarget;
import net.minecraft.world.entity.ai.behavior.BehaviorLookWalk;
import net.minecraft.world.entity.ai.behavior.BehaviorMakeLoveAnimal;
import net.minecraft.world.entity.ai.behavior.BehaviorNop;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorStrollRandomUnconstrained;
import net.minecraft.world.entity.ai.behavior.BehaviorSwim;
import net.minecraft.world.entity.ai.behavior.BehavorMove;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.schedule.Activity;
import org.slf4j.Logger;

public class SnifferAi {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int MAX_LOOK_DISTANCE = 6;
    static final List<SensorType<? extends Sensor<? super Sniffer>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.HURT_BY, SensorType.NEAREST_PLAYERS);
    static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.IS_PANICKING, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryModuleType.SNIFFER_DIGGING, MemoryModuleType.SNIFFER_HAPPY, MemoryModuleType.SNIFF_COOLDOWN, MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.BREED_TARGET, (Object[])new MemoryModuleType[0]);
    private static final int SNIFFING_COOLDOWN_TICKS = 9600;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 1.0f;
    private static final float SPEED_MULTIPLIER_WHEN_PANICKING = 2.0f;
    private static final float SPEED_MULTIPLIER_WHEN_SNIFFING = 1.25f;

    protected static BehaviorController<?> makeBrain(BehaviorController<Sniffer> var0) {
        SnifferAi.initCoreActivity(var0);
        SnifferAi.initIdleActivity(var0);
        SnifferAi.initSniffingActivity(var0);
        SnifferAi.initDigActivity(var0);
        var0.setCoreActivities(Set.of(Activity.CORE));
        var0.setDefaultActivity(Activity.IDLE);
        var0.useDefaultActivity();
        return var0;
    }

    private static void initCoreActivity(BehaviorController<Sniffer> var0) {
        var0.addActivity(Activity.CORE, 0, (ImmutableList<BehaviorControl<Sniffer>>)ImmutableList.of((Object)new BehaviorSwim(0.8f), (Object)new AnimalPanic(2.0f){

            @Override
            protected void start(WorldServer var0, EntityCreature var1, long var2) {
                var1.getBrain().eraseMemory(MemoryModuleType.SNIFFER_DIGGING);
                var1.getBrain().eraseMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
                ((Sniffer)var1).transitionTo(Sniffer.a.IDLING);
                super.start(var0, var1, var2);
            }

            @Override
            protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
                this.start(worldServer, (EntityCreature)entityLiving, l2);
            }
        }, (Object)new BehavorMove(10000, 15000)));
    }

    private static void initSniffingActivity(BehaviorController<Sniffer> var0) {
        var0.addActivityWithConditions(Activity.SNIFF, (ImmutableList<Pair<Integer, BehaviorControl<Sniffer>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new e())), Set.of(Pair.of(MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), Pair.of(MemoryModuleType.SNIFFER_SNIFFING_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), Pair.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
    }

    private static void initDigActivity(BehaviorController<Sniffer> var0) {
        var0.addActivityWithConditions(Activity.DIG, (ImmutableList<Pair<Integer, BehaviorControl<Sniffer>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new a(160, 180)), (Object)Pair.of((Object)0, (Object)new c(40))), Set.of(Pair.of(MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.VALUE_ABSENT)), Pair.of(MemoryModuleType.WALK_TARGET, (Object)((Object)MemoryStatus.VALUE_ABSENT)), Pair.of(MemoryModuleType.SNIFFER_DIGGING, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
    }

    private static void initIdleActivity(BehaviorController<Sniffer> var0) {
        var0.addActivityWithConditions(Activity.IDLE, (ImmutableList<Pair<Integer, BehaviorControl<Sniffer>>>)ImmutableList.of((Object)Pair.of((Object)0, (Object)new BehaviorLook(45, 90)), (Object)Pair.of((Object)0, (Object)new b(40, 100)), (Object)Pair.of((Object)0, new BehaviorGateSingle(ImmutableList.of((Object)Pair.of(BehaviorLookWalk.create(1.0f, 3), (Object)2), (Object)Pair.of((Object)new d(40, 80), (Object)1), (Object)Pair.of((Object)new f(40, 80), (Object)1), (Object)Pair.of((Object)new BehaviorMakeLoveAnimal(EntityTypes.SNIFFER, 1.0f), (Object)1), (Object)Pair.of(BehaviorLookTarget.create(EntityTypes.PLAYER, 6.0f), (Object)1), (Object)Pair.of(BehaviorStrollRandomUnconstrained.stroll(1.0f), (Object)1), (Object)Pair.of((Object)new BehaviorNop(5, 20), (Object)2))))), Set.of(Pair.of(MemoryModuleType.SNIFFER_DIGGING, (Object)((Object)MemoryStatus.VALUE_ABSENT))));
    }

    static void updateActivity(Sniffer var0) {
        var0.getBrain().setActiveActivityToFirstValid((List<Activity>)ImmutableList.of((Object)Activity.DIG, (Object)Activity.SNIFF, (Object)Activity.IDLE));
    }

    static class e
    extends Behavior<Sniffer> {
        e() {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_PRESENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_PRESENT), 600);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Sniffer var1) {
            return !var1.isPanicking() && !var1.isInWater();
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            if (var1.isPanicking() && !var1.isInWater()) {
                return false;
            }
            Optional<BlockPosition> var4 = var1.getBrain().getMemory(MemoryModuleType.WALK_TARGET).map(MemoryTarget::getTarget).map(BehaviorPosition::currentBlockPosition);
            Optional<BlockPosition> var5 = var1.getBrain().getMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
            if (var4.isEmpty() || var5.isEmpty()) {
                return false;
            }
            return var5.get().equals(var4.get());
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.SEARCHING);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var1, long var2) {
            if (var1.canDig()) {
                var1.getBrain().setMemory(MemoryModuleType.SNIFFER_DIGGING, true);
            }
            var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
            var1.getBrain().eraseMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }

    static class a
    extends Behavior<Sniffer> {
        a(int var0, int var1) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_PRESENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_ABSENT), var0, var1);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Sniffer var1) {
            return !var1.isPanicking() && !var1.isInWater();
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            return var1.getBrain().getMemory(MemoryModuleType.SNIFFER_DIGGING).isPresent() && !var1.isPanicking();
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.DIGGING);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var1, long var2) {
            var1.getBrain().setMemoryWithExpiry(MemoryModuleType.SNIFF_COOLDOWN, Unit.INSTANCE, 9600L);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }

    static class c
    extends Behavior<Sniffer> {
        c(int var0) {
            super(Map.of(MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_PRESENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_PRESENT), var0, var0);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Sniffer var1) {
            return true;
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            return var1.getBrain().getMemory(MemoryModuleType.SNIFFER_DIGGING).isPresent();
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.RISING);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var1, long var2) {
            boolean var4 = this.timedOut(var2);
            var1.transitionTo(Sniffer.a.IDLING).onDiggingComplete(var4);
            var1.getBrain().eraseMemory(MemoryModuleType.SNIFFER_DIGGING);
            var1.getBrain().setMemory(MemoryModuleType.SNIFFER_HAPPY, true);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }

    static class b
    extends Behavior<Sniffer> {
        b(int var0, int var1) {
            super(Map.of(MemoryModuleType.SNIFFER_HAPPY, MemoryStatus.VALUE_PRESENT), var0, var1);
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            return true;
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.FEELING_HAPPY);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.IDLING);
            var1.getBrain().eraseMemory(MemoryModuleType.SNIFFER_HAPPY);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }

    static class d
    extends Behavior<Sniffer> {
        d(int var0, int var1) {
            super(Map.of(MemoryModuleType.SNIFFER_DIGGING, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_HAPPY, MemoryStatus.VALUE_ABSENT), var0, var1);
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            return true;
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.SCENTING);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.IDLING);
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }

    static class f
    extends Behavior<Sniffer> {
        f(int var0, int var1) {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFFER_SNIFFING_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.SNIFF_COOLDOWN, MemoryStatus.VALUE_ABSENT), var0, var1);
        }

        @Override
        protected boolean checkExtraStartConditions(WorldServer var0, Sniffer var1) {
            return !var1.isBaby() && !var1.isInWater();
        }

        @Override
        protected boolean canStillUse(WorldServer var0, Sniffer var1, long var2) {
            return !var1.isPanicking();
        }

        @Override
        protected void start(WorldServer var0, Sniffer var1, long var2) {
            var1.transitionTo(Sniffer.a.SNIFFING);
        }

        @Override
        protected void stop(WorldServer var0, Sniffer var12, long var2) {
            boolean var4 = this.timedOut(var2);
            var12.transitionTo(Sniffer.a.IDLING);
            if (var4) {
                var12.calculateDigPosition().ifPresent(var1 -> {
                    var12.getBrain().setMemory(MemoryModuleType.SNIFFER_SNIFFING_TARGET, var1);
                    var12.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget((BlockPosition)var1, 1.25f, 0));
                });
            }
        }

        @Override
        protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.stop(worldServer, (Sniffer)entityLiving, l2);
        }

        @Override
        protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
            this.start(worldServer, (Sniffer)entityLiving, l2);
        }
    }
}

