/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.sniffer;

import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class Sniffer
extends EntityAnimal {
    private static final int DIGGING_PARTICLES_DELAY_TICKS = 1700;
    private static final int DIGGING_PARTICLES_DURATION_TICKS = 6000;
    private static final int DIGGING_PARTICLES_AMOUNT = 30;
    private static final int DIGGING_DROP_SEED_OFFSET_TICKS = 120;
    private static final int SNIFFING_PROXIMITY_DISTANCE = 10;
    private static final int SNIFFER_BABY_AGE_TICKS = 48000;
    private static final DataWatcherObject<a> DATA_STATE = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.SNIFFER_STATE);
    private static final DataWatcherObject<Integer> DATA_DROP_SEED_AT_TICK = DataWatcher.defineId(Sniffer.class, DataWatcherRegistry.INT);
    public final AnimationState walkingAnimationState = new AnimationState();
    public final AnimationState panicAnimationState = new AnimationState();
    public final AnimationState feelingHappyAnimationState = new AnimationState();
    public final AnimationState scentingAnimationState = new AnimationState();
    public final AnimationState sniffingAnimationState = new AnimationState();
    public final AnimationState searchingAnimationState = new AnimationState();
    public final AnimationState diggingAnimationState = new AnimationState();
    public final AnimationState risingAnimationState = new AnimationState();

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.1f).add(GenericAttributes.MAX_HEALTH, 14.0);
    }

    public Sniffer(EntityTypes<? extends EntityAnimal> var0, World var1) {
        super(var0, var1);
        this.entityData.define(DATA_STATE, a.IDLING);
        this.entityData.define(DATA_DROP_SEED_AT_TICK, 0);
        this.getNavigation().setCanFloat(true);
        this.setPathfindingMalus(PathType.WATER, -2.0f);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return this.getDimensions((EntityPose)var0).height * 0.6f;
    }

    private boolean isMoving() {
        boolean var0 = this.onGround || this.isInWaterOrBubble();
        return var0 && this.getDeltaMovement().horizontalDistanceSqr() > 1.0E-6;
    }

    private boolean isMovingInWater() {
        return this.isMoving() && this.isInWater() && !this.isUnderWater() && this.getDeltaMovement().horizontalDistanceSqr() > 9.999999999999999E-6;
    }

    private boolean isMovingOnLand() {
        return this.isMoving() && !this.isUnderWater() && !this.isInWater();
    }

    public boolean isPanicking() {
        return this.brain.getMemory(MemoryModuleType.IS_PANICKING).isPresent();
    }

    public boolean canPlayDiggingSound() {
        return this.getState() == a.DIGGING || this.getState() == a.SEARCHING;
    }

    private BlockPosition getHeadPosition() {
        Vec3D var0 = this.position().add(this.getForward().scale(2.25));
        return BlockPosition.containing(var0.x(), this.getY(), var0.z());
    }

    private a getState() {
        return this.entityData.get(DATA_STATE);
    }

    private Sniffer setState(a var0) {
        this.entityData.set(DATA_STATE, var0);
        return this;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_STATE.equals(var0)) {
            a var1 = this.getState();
            this.resetAnimations();
            switch (var1) {
                case SCENTING: {
                    this.scentingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case SNIFFING: {
                    this.sniffingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case SEARCHING: {
                    this.searchingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case DIGGING: {
                    this.diggingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case RISING: {
                    this.risingAnimationState.startIfStopped(this.tickCount);
                    break;
                }
                case FEELING_HAPPY: {
                    this.feelingHappyAnimationState.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(var0);
    }

    private void resetAnimations() {
        this.searchingAnimationState.stop();
        this.diggingAnimationState.stop();
        this.sniffingAnimationState.stop();
        this.risingAnimationState.stop();
        this.feelingHappyAnimationState.stop();
        this.scentingAnimationState.stop();
    }

    public Sniffer transitionTo(a var0) {
        switch (var0) {
            case IDLING: {
                this.setState(a.IDLING);
                break;
            }
            case SCENTING: {
                this.playSound(SoundEffects.SNIFFER_SCENTING, 1.0f, 1.0f);
                this.setState(a.SCENTING);
                break;
            }
            case SNIFFING: {
                this.playSound(SoundEffects.SNIFFER_SNIFFING, 1.0f, 1.0f);
                this.setState(a.SNIFFING);
                break;
            }
            case SEARCHING: {
                this.setState(a.SEARCHING);
                break;
            }
            case DIGGING: {
                this.setState(a.DIGGING).onDiggingStart();
                break;
            }
            case RISING: {
                this.playSound(SoundEffects.SNIFFER_DIGGING_STOP, 1.0f, 1.0f);
                this.setState(a.RISING);
                break;
            }
            case FEELING_HAPPY: {
                this.playSound(SoundEffects.SNIFFER_HAPPY, 1.0f, 1.0f);
                this.setState(a.FEELING_HAPPY);
            }
        }
        return this;
    }

    private Sniffer onDiggingStart() {
        this.entityData.set(DATA_DROP_SEED_AT_TICK, this.tickCount + 120);
        this.level.broadcastEntityEvent(this, (byte)63);
        return this;
    }

    public Sniffer onDiggingComplete(boolean var0) {
        if (var0) {
            this.storeExploredPosition(this.getOnPos());
        }
        return this;
    }

    Optional<BlockPosition> calculateDigPosition() {
        return IntStream.range(0, 5).mapToObj(var0 -> LandRandomPos.getPos(this, 10 + 2 * var0, 3)).filter(Objects::nonNull).map(BlockPosition::containing).map(BlockPosition::below).filter(this::canDig).findFirst();
    }

    @Override
    protected boolean canRide(Entity var0) {
        return false;
    }

    boolean canDig() {
        return !this.isPanicking() && !this.isBaby() && !this.isInWater() && this.canDig(this.getHeadPosition().below());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canDig(BlockPosition var0) {
        if (!this.level.getBlockState(var0).is(TagsBlock.SNIFFER_DIGGABLE_BLOCK)) return false;
        if (!this.level.getBlockState(var0.above()).isAir()) return false;
        if (!this.getExploredPositions().noneMatch(var0::equals)) return false;
        return true;
    }

    private void dropSeed() {
        if (this.level.isClientSide() || this.entityData.get(DATA_DROP_SEED_AT_TICK) != this.tickCount) {
            return;
        }
        ItemStack var0 = new ItemStack(Items.TORCHFLOWER_SEEDS);
        BlockPosition var1 = this.getHeadPosition();
        EntityItem var2 = new EntityItem(this.level, var1.getX(), var1.getY(), var1.getZ(), var0);
        var2.setDefaultPickUpDelay();
        this.level.addFreshEntity(var2);
        this.playSound(SoundEffects.SNIFFER_DROP_SEED, 1.0f, 1.0f);
    }

    private Sniffer emitDiggingParticles(AnimationState var0) {
        boolean var1;
        boolean bl = var1 = var0.getAccumulatedTime() > 1700L && var0.getAccumulatedTime() < 6000L;
        if (var1) {
            IBlockData var2 = this.getBlockStateOn();
            BlockPosition var3 = this.getHeadPosition();
            if (var2.getRenderShape() != EnumRenderType.INVISIBLE) {
                for (int var4 = 0; var4 < 30; ++var4) {
                    Vec3D var5 = Vec3D.atCenterOf(var3);
                    this.level.addParticle(new ParticleParamBlock(Particles.BLOCK, var2), var5.x, var5.y, var5.z, 0.0, 0.0, 0.0);
                }
                if (this.tickCount % 10 == 0) {
                    this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), var2.getSoundType().getHitSound(), this.getSoundSource(), 0.5f, 0.5f, false);
                }
            }
        }
        return this;
    }

    private Sniffer storeExploredPosition(BlockPosition var0) {
        List var1 = this.getExploredPositions().limit(20L).collect(Collectors.toList());
        var1.add(0, var0);
        this.getBrain().setMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS, var1);
        return this;
    }

    private Stream<BlockPosition> getExploredPositions() {
        return this.getBrain().getMemory(MemoryModuleType.SNIFFER_EXPLORED_POSITIONS).stream().flatMap(Collection::stream);
    }

    @Override
    protected void jumpFromGround() {
        double var2;
        super.jumpFromGround();
        double var0 = this.moveControl.getSpeedModifier();
        if (var0 > 0.0 && (var2 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3D(0.0, 0.0, 1.0));
        }
    }

    @Override
    public void tick() {
        boolean var0 = this.isInWater() && !this.isUnderWater();
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(var0 ? (double)0.2f : (double)0.1f);
        if (this.isMovingOnLand() || this.isMovingInWater()) {
            if (this.isPanicking()) {
                this.walkingAnimationState.stop();
                this.panicAnimationState.startIfStopped(this.tickCount);
            } else {
                this.panicAnimationState.stop();
                this.walkingAnimationState.startIfStopped(this.tickCount);
            }
        } else {
            this.panicAnimationState.stop();
            this.walkingAnimationState.stop();
        }
        switch (this.getState()) {
            case DIGGING: {
                this.emitDiggingParticles(this.diggingAnimationState).dropSeed();
                break;
            }
            case SEARCHING: {
                this.playSearchingSound();
            }
        }
        super.tick();
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        EnumInteractionResult var3 = super.mobInteract(var0, var1);
        if (var3.consumesAction() && this.isFood(var2)) {
            this.level.playSound(null, this, this.getEatingSound(var2), SoundCategory.NEUTRAL, 1.0f, MathHelper.randomBetween(this.level.random, 0.8f, 1.2f));
        }
        return var3;
    }

    private void playSearchingSound() {
        if (this.level.isClientSide() && this.tickCount % 20 == 0) {
            this.level.playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.SNIFFER_SEARCHING, this.getSoundSource(), 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SNIFFER_STEP, 0.15f, 1.0f);
    }

    @Override
    public SoundEffect getEatingSound(ItemStack var0) {
        return SoundEffects.SNIFFER_EAT;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return Set.of(a.DIGGING, a.SEARCHING).contains((Object)this.getState()) ? null : SoundEffects.SNIFFER_IDLE;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SNIFFER_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SNIFFER_DEATH;
    }

    @Override
    public int getMaxHeadYRot() {
        return 50;
    }

    @Override
    public void setBaby(boolean var0) {
        this.setAge(var0 ? -48000 : 0);
    }

    @Override
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.SNIFFER.create(var0);
    }

    @Override
    public boolean canMate(EntityAnimal var0) {
        if (var0 instanceof Sniffer) {
            Sniffer var1 = (Sniffer)var0;
            Set<a> var2 = Set.of(a.IDLING, a.SCENTING, a.FEELING_HAPPY);
            return var2.contains((Object)this.getState()) && var2.contains((Object)var1.getState()) && super.canMate(var0);
        }
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        return super.getBoundingBoxForCulling().inflate(0.6f);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.SNIFFER_FOOD);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return SnifferAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Sniffer> getBrain() {
        return super.getBrain();
    }

    protected BehaviorController.b<Sniffer> brainProvider() {
        return BehaviorController.provider(SnifferAi.MEMORY_TYPES, SnifferAi.SENSOR_TYPES);
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("snifferBrain");
        this.getBrain().tick((WorldServer)this.level, this);
        this.level.getProfiler().popPush("snifferActivityUpdate");
        SnifferAi.updateActivity(this);
        this.level.getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a IDLING = new a();
        public static final /* enum */ a FEELING_HAPPY = new a();
        public static final /* enum */ a SCENTING = new a();
        public static final /* enum */ a SNIFFING = new a();
        public static final /* enum */ a SEARCHING = new a();
        public static final /* enum */ a DIGGING = new a();
        public static final /* enum */ a RISING = new a();
        private static final /* synthetic */ a[] h;

        public static a[] values() {
            return (a[])h.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{IDLING, FEELING_HAPPY, SCENTING, SNIFFING, SEARCHING, DIGGING, RISING};
        }

        static {
            h = a.a();
        }
    }
}

