/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.frog;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Dynamic;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationGuardian;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.frog.TadpoleAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public class Tadpole
extends EntityFish {
    @VisibleForTesting
    public static int ticksToBeFrog = Math.abs(-24000);
    public static float HITBOX_WIDTH = 0.4f;
    public static float HITBOX_HEIGHT = 0.3f;
    public int age;
    protected static final ImmutableList<SensorType<? extends Sensor<? super Tadpole>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_PLAYERS, SensorType.HURT_BY, SensorType.FROG_TEMPTATIONS);
    protected static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.LOOK_TARGET, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.NEAREST_VISIBLE_ADULT, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING);

    public Tadpole(EntityTypes<? extends EntityFish> var0, World var1) {
        super(var0, var1);
        this.moveControl = new SmoothSwimmingMoveControl(this, 85, 10, 0.02f, 0.1f, true);
        this.lookControl = new SmoothSwimmingLookControl(this, 10);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new NavigationGuardian(this, var0);
    }

    protected BehaviorController.b<Tadpole> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return TadpoleAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Tadpole> getBrain() {
        return super.getBrain();
    }

    @Override
    protected SoundEffect getFlopSound() {
        return SoundEffects.TADPOLE_FLOP;
    }

    @Override
    protected void customServerAiStep() {
        this.level.getProfiler().push("tadpoleBrain");
        this.getBrain().tick((WorldServer)this.level, this);
        this.level.getProfiler().pop();
        this.level.getProfiler().push("tadpoleActivityUpdate");
        TadpoleAi.updateActivity(this);
        this.level.getProfiler().pop();
        super.customServerAiStep();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 1.0).add(GenericAttributes.MAX_HEALTH, 6.0);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level.isClientSide) {
            this.setAge(this.age + 1);
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Age", this.age);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setAge(var0.getInt("Age"));
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.TADPOLE_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.TADPOLE_DEATH;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        ItemStack var2 = var0.getItemInHand(var1);
        if (this.isFood(var2)) {
            this.feed(var0, var2);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        return Bucketable.bucketMobPickup(var0, var1, this).orElse(super.mobInteract(var0, var1));
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public boolean fromBucket() {
        return true;
    }

    @Override
    public void setFromBucket(boolean var0) {
    }

    @Override
    public void saveToBucketTag(ItemStack var0) {
        Bucketable.saveDefaultDataToBucketTag(this, var0);
        NBTTagCompound var1 = var0.getOrCreateTag();
        var1.putInt("Age", this.getAge());
    }

    @Override
    public void loadFromBucketTag(NBTTagCompound var0) {
        Bucketable.loadDefaultDataFromBucketTag(this, var0);
        if (var0.contains("Age")) {
            this.setAge(var0.getInt("Age"));
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.TADPOLE_BUCKET);
    }

    @Override
    public SoundEffect getPickupSound() {
        return SoundEffects.BUCKET_FILL_TADPOLE;
    }

    private boolean isFood(ItemStack var0) {
        return Frog.TEMPTATION_ITEM.test(var0);
    }

    private void feed(EntityHuman var0, ItemStack var1) {
        this.usePlayerItem(var0, var1);
        this.ageUp(EntityAgeable.getSpeedUpSecondsWhenFeeding(this.getTicksLeftUntilAdult()));
        this.level.addParticle(Particles.HAPPY_VILLAGER, this.getRandomX(1.0), this.getRandomY() + 0.5, this.getRandomZ(1.0), 0.0, 0.0, 0.0);
    }

    private void usePlayerItem(EntityHuman var0, ItemStack var1) {
        if (!var0.getAbilities().instabuild) {
            var1.shrink(1);
        }
    }

    private int getAge() {
        return this.age;
    }

    private void ageUp(int var0) {
        this.setAge(this.age + var0 * 20);
    }

    private void setAge(int var0) {
        this.age = var0;
        if (this.age >= ticksToBeFrog) {
            this.ageUp();
        }
    }

    private void ageUp() {
        World world = this.level;
        if (world instanceof WorldServer) {
            WorldServer var0 = (WorldServer)world;
            Frog var1 = EntityTypes.FROG.create(this.level);
            if (var1 != null) {
                var1.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
                var1.finalizeSpawn(var0, this.level.getCurrentDifficultyAt(var1.blockPosition()), EnumMobSpawn.CONVERSION, null, null);
                var1.setNoAi(this.isNoAi());
                if (this.hasCustomName()) {
                    var1.setCustomName(this.getCustomName());
                    var1.setCustomNameVisible(this.isCustomNameVisible());
                }
                var1.setPersistenceRequired();
                this.playSound(SoundEffects.TADPOLE_GROW_UP, 0.15f, 1.0f);
                var0.addFreshEntityWithPassengers(var1);
                this.discard();
            }
        }
    }

    private int getTicksLeftUntilAdult() {
        return Math.max(0, ticksToBeFrog - this.age);
    }

    @Override
    public boolean shouldDropExperience() {
        return false;
    }
}

