/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTurtleEgg;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityTurtle
extends EntityAnimal {
    private static final DataWatcherObject<BlockPosition> HOME_POS = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BLOCK_POS);
    private static final DataWatcherObject<Boolean> HAS_EGG = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> LAYING_EGG = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<BlockPosition> TRAVEL_POS = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BLOCK_POS);
    private static final DataWatcherObject<Boolean> GOING_HOME = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> TRAVELLING = DataWatcher.defineId(EntityTurtle.class, DataWatcherRegistry.BOOLEAN);
    public static final RecipeItemStack FOOD_ITEMS = RecipeItemStack.of(Blocks.SEAGRASS.asItem());
    int layEggCounter;
    public static final Predicate<EntityLiving> BABY_ON_LAND_SELECTOR = var0 -> var0.isBaby() && !var0.isInWater();

    public EntityTurtle(EntityTypes<? extends EntityTurtle> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DOOR_IRON_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_WOOD_CLOSED, -1.0f);
        this.setPathfindingMalus(PathType.DOOR_OPEN, -1.0f);
        this.moveControl = new e(this);
        this.setMaxUpStep(1.0f);
    }

    public void setHomePos(BlockPosition var0) {
        this.entityData.set(HOME_POS, var0);
    }

    BlockPosition getHomePos() {
        return this.entityData.get(HOME_POS);
    }

    void setTravelPos(BlockPosition var0) {
        this.entityData.set(TRAVEL_POS, var0);
    }

    BlockPosition getTravelPos() {
        return this.entityData.get(TRAVEL_POS);
    }

    public boolean hasEgg() {
        return this.entityData.get(HAS_EGG);
    }

    void setHasEgg(boolean var0) {
        this.entityData.set(HAS_EGG, var0);
    }

    public boolean isLayingEgg() {
        return this.entityData.get(LAYING_EGG);
    }

    void setLayingEgg(boolean var0) {
        this.layEggCounter = var0 ? 1 : 0;
        this.entityData.set(LAYING_EGG, var0);
    }

    boolean isGoingHome() {
        return this.entityData.get(GOING_HOME);
    }

    void setGoingHome(boolean var0) {
        this.entityData.set(GOING_HOME, var0);
    }

    boolean isTravelling() {
        return this.entityData.get(TRAVELLING);
    }

    void setTravelling(boolean var0) {
        this.entityData.set(TRAVELLING, var0);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(HOME_POS, BlockPosition.ZERO);
        this.entityData.define(HAS_EGG, false);
        this.entityData.define(TRAVEL_POS, BlockPosition.ZERO);
        this.entityData.define(GOING_HOME, false);
        this.entityData.define(TRAVELLING, false);
        this.entityData.define(LAYING_EGG, false);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("HomePosX", this.getHomePos().getX());
        var0.putInt("HomePosY", this.getHomePos().getY());
        var0.putInt("HomePosZ", this.getHomePos().getZ());
        var0.putBoolean("HasEgg", this.hasEgg());
        var0.putInt("TravelPosX", this.getTravelPos().getX());
        var0.putInt("TravelPosY", this.getTravelPos().getY());
        var0.putInt("TravelPosZ", this.getTravelPos().getZ());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        int var1 = var0.getInt("HomePosX");
        int var2 = var0.getInt("HomePosY");
        int var3 = var0.getInt("HomePosZ");
        this.setHomePos(new BlockPosition(var1, var2, var3));
        super.readAdditionalSaveData(var0);
        this.setHasEgg(var0.getBoolean("HasEgg"));
        int var4 = var0.getInt("TravelPosX");
        int var5 = var0.getInt("TravelPosY");
        int var6 = var0.getInt("TravelPosZ");
        this.setTravelPos(new BlockPosition(var4, var5, var6));
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.setHomePos(this.blockPosition());
        this.setTravelPos(BlockPosition.ZERO);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    public static boolean checkTurtleSpawnRules(EntityTypes<EntityTurtle> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var3.getY() < var1.getSeaLevel() + 4 && BlockTurtleEgg.onSand(var1, var3) && EntityTurtle.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, new f(this, 1.2));
        this.goalSelector.addGoal(1, new a(this, 1.0));
        this.goalSelector.addGoal(1, new d(this, 1.0));
        this.goalSelector.addGoal(2, new PathfinderGoalTempt(this, 1.1, FOOD_ITEMS, false));
        this.goalSelector.addGoal(3, new c(this, 1.0));
        this.goalSelector.addGoal(4, new b(this, 1.0));
        this.goalSelector.addGoal(7, new i(this, 1.0));
        this.goalSelector.addGoal(8, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f));
        this.goalSelector.addGoal(9, new h(this, 1.0, 100));
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 30.0).add(GenericAttributes.MOVEMENT_SPEED, 0.25);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    @Override
    public boolean canBreatheUnderwater() {
        return true;
    }

    @Override
    public EnumMonsterType getMobType() {
        return EnumMonsterType.WATER;
    }

    @Override
    public int getAmbientSoundInterval() {
        return 200;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        if (!this.isInWater() && this.onGround && !this.isBaby()) {
            return SoundEffects.TURTLE_AMBIENT_LAND;
        }
        return super.getAmbientSound();
    }

    @Override
    protected void playSwimSound(float var0) {
        super.playSwimSound(var0 * 1.5f);
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.TURTLE_SWIM;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isBaby()) {
            return SoundEffects.TURTLE_HURT_BABY;
        }
        return SoundEffects.TURTLE_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        if (this.isBaby()) {
            return SoundEffects.TURTLE_DEATH_BABY;
        }
        return SoundEffects.TURTLE_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        SoundEffect var2 = this.isBaby() ? SoundEffects.TURTLE_SHAMBLE_BABY : SoundEffects.TURTLE_SHAMBLE;
        this.playSound(var2, 0.15f, 1.0f);
    }

    @Override
    public boolean canFallInLove() {
        return super.canFallInLove() && !this.hasEgg();
    }

    @Override
    protected float nextStep() {
        return this.moveDist + 0.15f;
    }

    @Override
    public float getScale() {
        return this.isBaby() ? 0.3f : 1.0f;
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new g(this, var0);
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        return EntityTypes.TURTLE.create(var0);
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(Blocks.SEAGRASS.asItem());
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (!this.isGoingHome() && var1.getFluidState(var0).is(TagsFluid.WATER)) {
            return 10.0f;
        }
        if (BlockTurtleEgg.onSand(var1, var0)) {
            return 10.0f;
        }
        return var1.getPathfindingCostFromLightLevels(var0);
    }

    @Override
    public void aiStep() {
        BlockPosition var0;
        super.aiStep();
        if (this.isAlive() && this.isLayingEgg() && this.layEggCounter >= 1 && this.layEggCounter % 5 == 0 && BlockTurtleEgg.onSand(this.level, var0 = this.blockPosition())) {
            this.level.levelEvent(2001, var0, Block.getId(this.level.getBlockState(var0.below())));
        }
    }

    @Override
    protected void ageBoundaryReached() {
        super.ageBoundaryReached();
        if (!this.isBaby() && this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            this.spawnAtLocation(Items.SCUTE, 1);
        }
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(0.1f, var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (!(this.getTarget() != null || this.isGoingHome() && this.getHomePos().closerToCenterThan(this.position(), 20.0))) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(var0);
        }
    }

    @Override
    public boolean canBeLeashed(EntityHuman var0) {
        return false;
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        this.hurt(this.damageSources().lightningBolt(), Float.MAX_VALUE);
    }

    static class e
    extends ControllerMove {
        private final EntityTurtle turtle;

        e(EntityTurtle var0) {
            super(var0);
            this.turtle = var0;
        }

        private void updateSpeed() {
            if (this.turtle.isInWater()) {
                this.turtle.setDeltaMovement(this.turtle.getDeltaMovement().add(0.0, 0.005, 0.0));
                if (!this.turtle.getHomePos().closerToCenterThan(this.turtle.position(), 16.0)) {
                    this.turtle.setSpeed(Math.max(this.turtle.getSpeed() / 2.0f, 0.08f));
                }
                if (this.turtle.isBaby()) {
                    this.turtle.setSpeed(Math.max(this.turtle.getSpeed() / 3.0f, 0.06f));
                }
            } else if (this.turtle.onGround) {
                this.turtle.setSpeed(Math.max(this.turtle.getSpeed() / 2.0f, 0.06f));
            }
        }

        @Override
        public void tick() {
            double var4;
            double var2;
            this.updateSpeed();
            if (this.operation != ControllerMove.Operation.MOVE_TO || this.turtle.getNavigation().isDone()) {
                this.turtle.setSpeed(0.0f);
                return;
            }
            double var0 = this.wantedX - this.turtle.getX();
            double var6 = Math.sqrt(var0 * var0 + (var2 = this.wantedY - this.turtle.getY()) * var2 + (var4 = this.wantedZ - this.turtle.getZ()) * var4);
            if (var6 < (double)1.0E-5f) {
                this.mob.setSpeed(0.0f);
                return;
            }
            var2 /= var6;
            float var8 = (float)(MathHelper.atan2(var4, var0) * 57.2957763671875) - 90.0f;
            this.turtle.setYRot(this.rotlerp(this.turtle.getYRot(), var8, 90.0f));
            this.turtle.yBodyRot = this.turtle.getYRot();
            float var9 = (float)(this.speedModifier * this.turtle.getAttributeValue(GenericAttributes.MOVEMENT_SPEED));
            this.turtle.setSpeed(MathHelper.lerp(0.125f, this.turtle.getSpeed(), var9));
            this.turtle.setDeltaMovement(this.turtle.getDeltaMovement().add(0.0, (double)this.turtle.getSpeed() * var2 * 0.1, 0.0));
        }
    }

    static class f
    extends PathfinderGoalPanic {
        f(EntityTurtle var0, double var1) {
            super(var0, var1);
        }

        @Override
        public boolean canUse() {
            if (!this.shouldPanic()) {
                return false;
            }
            BlockPosition var0 = this.lookForWater(this.mob.level, this.mob, 7);
            if (var0 != null) {
                this.posX = var0.getX();
                this.posY = var0.getY();
                this.posZ = var0.getZ();
                return true;
            }
            return this.findRandomPosition();
        }
    }

    static class a
    extends PathfinderGoalBreed {
        private final EntityTurtle turtle;

        a(EntityTurtle var0, double var1) {
            super(var0, var1);
            this.turtle = var0;
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !this.turtle.hasEgg();
        }

        @Override
        protected void breed() {
            EntityPlayer var0 = this.animal.getLoveCause();
            if (var0 == null && this.partner.getLoveCause() != null) {
                var0 = this.partner.getLoveCause();
            }
            if (var0 != null) {
                var0.awardStat(StatisticList.ANIMALS_BRED);
                CriterionTriggers.BRED_ANIMALS.trigger(var0, this.animal, this.partner, null);
            }
            this.turtle.setHasEgg(true);
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            this.animal.resetLove();
            this.partner.resetLove();
            RandomSource var1 = this.animal.getRandom();
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.level.addFreshEntity(new EntityExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), var1.nextInt(7) + 1));
            }
        }
    }

    static class d
    extends PathfinderGoalGotoTarget {
        private final EntityTurtle turtle;

        d(EntityTurtle var0, double var1) {
            super(var0, var1, 16);
            this.turtle = var0;
        }

        @Override
        public boolean canUse() {
            if (this.turtle.hasEgg() && this.turtle.getHomePos().closerToCenterThan(this.turtle.position(), 9.0)) {
                return super.canUse();
            }
            return false;
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.turtle.hasEgg() && this.turtle.getHomePos().closerToCenterThan(this.turtle.position(), 9.0);
        }

        @Override
        public void tick() {
            super.tick();
            BlockPosition var0 = this.turtle.blockPosition();
            if (!this.turtle.isInWater() && this.isReachedTarget()) {
                if (this.turtle.layEggCounter < 1) {
                    this.turtle.setLayingEgg(true);
                } else if (this.turtle.layEggCounter > this.adjustedTickDelay(200)) {
                    World var1 = this.turtle.level;
                    var1.playSound(null, var0, SoundEffects.TURTLE_LAY_EGG, SoundCategory.BLOCKS, 0.3f, 0.9f + var1.random.nextFloat() * 0.2f);
                    BlockPosition var2 = this.blockPos.above();
                    IBlockData var3 = (IBlockData)Blocks.TURTLE_EGG.defaultBlockState().setValue(BlockTurtleEgg.EGGS, this.turtle.random.nextInt(4) + 1);
                    var1.setBlock(var2, var3, 3);
                    var1.gameEvent(GameEvent.BLOCK_PLACE, var2, GameEvent.a.of(this.turtle, var3));
                    this.turtle.setHasEgg(false);
                    this.turtle.setLayingEgg(false);
                    this.turtle.setInLoveTime(600);
                }
                if (this.turtle.isLayingEgg()) {
                    ++this.turtle.layEggCounter;
                }
            }
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            if (!var0.isEmptyBlock(var1.above())) {
                return false;
            }
            return BlockTurtleEgg.isSand(var0, var1);
        }
    }

    static class c
    extends PathfinderGoalGotoTarget {
        private static final int GIVE_UP_TICKS = 1200;
        private final EntityTurtle turtle;

        c(EntityTurtle var0, double var1) {
            super(var0, var0.isBaby() ? 2.0 : var1, 24);
            this.turtle = var0;
            this.verticalSearchStart = -1;
        }

        @Override
        public boolean canContinueToUse() {
            return !this.turtle.isInWater() && this.tryTicks <= 1200 && this.isValidTarget(this.turtle.level, this.blockPos);
        }

        @Override
        public boolean canUse() {
            if (this.turtle.isBaby() && !this.turtle.isInWater()) {
                return super.canUse();
            }
            if (!(this.turtle.isGoingHome() || this.turtle.isInWater() || this.turtle.hasEgg())) {
                return super.canUse();
            }
            return false;
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 160 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            return var0.getBlockState(var1).is(Blocks.WATER);
        }
    }

    static class b
    extends PathfinderGoal {
        private final EntityTurtle turtle;
        private final double speedModifier;
        private boolean stuck;
        private int closeToHomeTryTicks;
        private static final int GIVE_UP_TICKS = 600;

        b(EntityTurtle var0, double var1) {
            this.turtle = var0;
            this.speedModifier = var1;
        }

        @Override
        public boolean canUse() {
            if (this.turtle.isBaby()) {
                return false;
            }
            if (this.turtle.hasEgg()) {
                return true;
            }
            if (this.turtle.getRandom().nextInt(b.reducedTickDelay(700)) != 0) {
                return false;
            }
            return !this.turtle.getHomePos().closerToCenterThan(this.turtle.position(), 64.0);
        }

        @Override
        public void start() {
            this.turtle.setGoingHome(true);
            this.stuck = false;
            this.closeToHomeTryTicks = 0;
        }

        @Override
        public void stop() {
            this.turtle.setGoingHome(false);
        }

        @Override
        public boolean canContinueToUse() {
            return !this.turtle.getHomePos().closerToCenterThan(this.turtle.position(), 7.0) && !this.stuck && this.closeToHomeTryTicks <= this.adjustedTickDelay(600);
        }

        @Override
        public void tick() {
            BlockPosition var0 = this.turtle.getHomePos();
            boolean var1 = var0.closerToCenterThan(this.turtle.position(), 16.0);
            if (var1) {
                ++this.closeToHomeTryTicks;
            }
            if (this.turtle.getNavigation().isDone()) {
                Vec3D var2 = Vec3D.atBottomCenterOf(var0);
                Vec3D var3 = DefaultRandomPos.getPosTowards(this.turtle, 16, 3, var2, 0.3141592741012573);
                if (var3 == null) {
                    var3 = DefaultRandomPos.getPosTowards(this.turtle, 8, 7, var2, 1.5707963705062866);
                }
                if (var3 != null && !var1 && !this.turtle.level.getBlockState(BlockPosition.containing(var3)).is(Blocks.WATER)) {
                    var3 = DefaultRandomPos.getPosTowards(this.turtle, 16, 5, var2, 1.5707963705062866);
                }
                if (var3 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtle.getNavigation().moveTo(var3.x, var3.y, var3.z, this.speedModifier);
            }
        }
    }

    static class i
    extends PathfinderGoal {
        private final EntityTurtle turtle;
        private final double speedModifier;
        private boolean stuck;

        i(EntityTurtle var0, double var1) {
            this.turtle = var0;
            this.speedModifier = var1;
        }

        @Override
        public boolean canUse() {
            return !this.turtle.isGoingHome() && !this.turtle.hasEgg() && this.turtle.isInWater();
        }

        @Override
        public void start() {
            int var0 = 512;
            int var1 = 4;
            RandomSource var2 = this.turtle.random;
            int var3 = var2.nextInt(1025) - 512;
            int var4 = var2.nextInt(9) - 4;
            int var5 = var2.nextInt(1025) - 512;
            if ((double)var4 + this.turtle.getY() > (double)(this.turtle.level.getSeaLevel() - 1)) {
                var4 = 0;
            }
            BlockPosition var6 = BlockPosition.containing((double)var3 + this.turtle.getX(), (double)var4 + this.turtle.getY(), (double)var5 + this.turtle.getZ());
            this.turtle.setTravelPos(var6);
            this.turtle.setTravelling(true);
            this.stuck = false;
        }

        @Override
        public void tick() {
            if (this.turtle.getNavigation().isDone()) {
                Vec3D var0 = Vec3D.atBottomCenterOf(this.turtle.getTravelPos());
                Vec3D var1 = DefaultRandomPos.getPosTowards(this.turtle, 16, 3, var0, 0.3141592741012573);
                if (var1 == null) {
                    var1 = DefaultRandomPos.getPosTowards(this.turtle, 8, 7, var0, 1.5707963705062866);
                }
                if (var1 != null) {
                    int var2 = MathHelper.floor(var1.x);
                    int var3 = MathHelper.floor(var1.z);
                    int var4 = 34;
                    if (!this.turtle.level.hasChunksAt(var2 - 34, var3 - 34, var2 + 34, var3 + 34)) {
                        var1 = null;
                    }
                }
                if (var1 == null) {
                    this.stuck = true;
                    return;
                }
                this.turtle.getNavigation().moveTo(var1.x, var1.y, var1.z, this.speedModifier);
            }
        }

        @Override
        public boolean canContinueToUse() {
            return !this.turtle.getNavigation().isDone() && !this.stuck && !this.turtle.isGoingHome() && !this.turtle.isInLove() && !this.turtle.hasEgg();
        }

        @Override
        public void stop() {
            this.turtle.setTravelling(false);
            super.stop();
        }
    }

    static class h
    extends PathfinderGoalRandomStroll {
        private final EntityTurtle turtle;

        h(EntityTurtle var0, double var1, int var3) {
            super(var0, var1, var3);
            this.turtle = var0;
        }

        @Override
        public boolean canUse() {
            if (!(this.mob.isInWater() || this.turtle.isGoingHome() || this.turtle.hasEgg())) {
                return super.canUse();
            }
            return false;
        }
    }

    static class g
    extends AmphibiousPathNavigation {
        g(EntityTurtle var0, World var1) {
            super(var0, var1);
        }

        @Override
        public boolean isStableDestination(BlockPosition var0) {
            EntityTurtle var1;
            EntityInsentient entityInsentient = this.mob;
            if (entityInsentient instanceof EntityTurtle && (var1 = (EntityTurtle)entityInsentient).isTravelling()) {
                return this.level.getBlockState(var0).is(Blocks.WATER);
            }
            return !this.level.getBlockState(var0.below()).isAir();
        }
    }
}

