/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalEatTile;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalTempt;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemDye;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTables;

public class EntitySheep
extends EntityAnimal
implements IShearable {
    private static final int EAT_ANIMATION_TICKS = 40;
    private static final DataWatcherObject<Byte> DATA_WOOL_ID = DataWatcher.defineId(EntitySheep.class, DataWatcherRegistry.BYTE);
    private static final Map<EnumColor, IMaterial> ITEM_BY_DYE = SystemUtils.make(Maps.newEnumMap(EnumColor.class), var0 -> {
        var0.put(EnumColor.WHITE, Blocks.WHITE_WOOL);
        var0.put(EnumColor.ORANGE, Blocks.ORANGE_WOOL);
        var0.put(EnumColor.MAGENTA, Blocks.MAGENTA_WOOL);
        var0.put(EnumColor.LIGHT_BLUE, Blocks.LIGHT_BLUE_WOOL);
        var0.put(EnumColor.YELLOW, Blocks.YELLOW_WOOL);
        var0.put(EnumColor.LIME, Blocks.LIME_WOOL);
        var0.put(EnumColor.PINK, Blocks.PINK_WOOL);
        var0.put(EnumColor.GRAY, Blocks.GRAY_WOOL);
        var0.put(EnumColor.LIGHT_GRAY, Blocks.LIGHT_GRAY_WOOL);
        var0.put(EnumColor.CYAN, Blocks.CYAN_WOOL);
        var0.put(EnumColor.PURPLE, Blocks.PURPLE_WOOL);
        var0.put(EnumColor.BLUE, Blocks.BLUE_WOOL);
        var0.put(EnumColor.BROWN, Blocks.BROWN_WOOL);
        var0.put(EnumColor.GREEN, Blocks.GREEN_WOOL);
        var0.put(EnumColor.RED, Blocks.RED_WOOL);
        var0.put(EnumColor.BLACK, Blocks.BLACK_WOOL);
    });
    private static final Map<EnumColor, float[]> COLORARRAY_BY_COLOR = Maps.newEnumMap(Arrays.stream(EnumColor.values()).collect(Collectors.toMap(var0 -> var0, EntitySheep::createSheepColor)));
    private int eatAnimationTick;
    private PathfinderGoalEatTile eatBlockGoal;

    private static float[] createSheepColor(EnumColor var0) {
        if (var0 == EnumColor.WHITE) {
            return new float[]{0.9019608f, 0.9019608f, 0.9019608f};
        }
        float[] var1 = var0.getTextureDiffuseColors();
        float var2 = 0.75f;
        return new float[]{var1[0] * 0.75f, var1[1] * 0.75f, var1[2] * 0.75f};
    }

    public static float[] getColorArray(EnumColor var0) {
        return COLORARRAY_BY_COLOR.get(var0);
    }

    public EntitySheep(EntityTypes<? extends EntitySheep> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
    }

    @Override
    protected void registerGoals() {
        this.eatBlockGoal = new PathfinderGoalEatTile(this);
        this.goalSelector.addGoal(0, new PathfinderGoalFloat(this));
        this.goalSelector.addGoal(1, new PathfinderGoalPanic(this, 1.25));
        this.goalSelector.addGoal(2, new PathfinderGoalBreed(this, 1.0));
        this.goalSelector.addGoal(3, new PathfinderGoalTempt(this, 1.1, RecipeItemStack.of(Items.WHEAT), false));
        this.goalSelector.addGoal(4, new PathfinderGoalFollowParent(this, 1.1));
        this.goalSelector.addGoal(5, this.eatBlockGoal);
        this.goalSelector.addGoal(6, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(7, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
    }

    @Override
    protected void customServerAiStep() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.customServerAiStep();
    }

    @Override
    public void aiStep() {
        if (this.level.isClientSide) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.aiStep();
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 8.0).add(GenericAttributes.MOVEMENT_SPEED, 0.23f);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_WOOL_ID, (byte)0);
    }

    @Override
    public MinecraftKey getDefaultLootTable() {
        if (this.isSheared()) {
            return this.getType().getDefaultLootTable();
        }
        return switch (this.getColor()) {
            default -> throw new IncompatibleClassChangeError();
            case EnumColor.WHITE -> LootTables.SHEEP_WHITE;
            case EnumColor.ORANGE -> LootTables.SHEEP_ORANGE;
            case EnumColor.MAGENTA -> LootTables.SHEEP_MAGENTA;
            case EnumColor.LIGHT_BLUE -> LootTables.SHEEP_LIGHT_BLUE;
            case EnumColor.YELLOW -> LootTables.SHEEP_YELLOW;
            case EnumColor.LIME -> LootTables.SHEEP_LIME;
            case EnumColor.PINK -> LootTables.SHEEP_PINK;
            case EnumColor.GRAY -> LootTables.SHEEP_GRAY;
            case EnumColor.LIGHT_GRAY -> LootTables.SHEEP_LIGHT_GRAY;
            case EnumColor.CYAN -> LootTables.SHEEP_CYAN;
            case EnumColor.PURPLE -> LootTables.SHEEP_PURPLE;
            case EnumColor.BLUE -> LootTables.SHEEP_BLUE;
            case EnumColor.BROWN -> LootTables.SHEEP_BROWN;
            case EnumColor.GREEN -> LootTables.SHEEP_GREEN;
            case EnumColor.RED -> LootTables.SHEEP_RED;
            case EnumColor.BLACK -> LootTables.SHEEP_BLACK;
        };
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public float getHeadEatPositionScale(float var0) {
        if (this.eatAnimationTick <= 0) {
            return 0.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return 1.0f;
        }
        if (this.eatAnimationTick < 4) {
            return ((float)this.eatAnimationTick - var0) / 4.0f;
        }
        return -((float)(this.eatAnimationTick - 40) - var0) / 4.0f;
    }

    public float getHeadEatAngleScale(float var0) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float var1 = ((float)(this.eatAnimationTick - 4) - var0) / 32.0f;
            return 0.62831855f + 0.21991149f * MathHelper.sin(var1 * 28.7f);
        }
        if (this.eatAnimationTick > 0) {
            return 0.62831855f;
        }
        return this.getXRot() * ((float)Math.PI / 180);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var12) {
        ItemStack var2 = var0.getItemInHand(var12);
        if (var2.is(Items.SHEARS)) {
            if (!this.level.isClientSide && this.readyForShearing()) {
                this.shear(SoundCategory.PLAYERS);
                this.gameEvent(GameEvent.SHEAR, var0);
                var2.hurtAndBreak(1, var0, var1 -> var1.broadcastBreakEvent(var12));
                return EnumInteractionResult.SUCCESS;
            }
            return EnumInteractionResult.CONSUME;
        }
        return super.mobInteract(var0, var12);
    }

    @Override
    public void shear(SoundCategory var0) {
        this.level.playSound(null, this, SoundEffects.SHEEP_SHEAR, var0, 1.0f, 1.0f);
        this.setSheared(true);
        int var1 = 1 + this.random.nextInt(3);
        for (int var2 = 0; var2 < var1; ++var2) {
            EntityItem var3 = this.spawnAtLocation(ITEM_BY_DYE.get(this.getColor()), 1);
            if (var3 == null) continue;
            var3.setDeltaMovement(var3.getDeltaMovement().add((this.random.nextFloat() - this.random.nextFloat()) * 0.1f, this.random.nextFloat() * 0.05f, (this.random.nextFloat() - this.random.nextFloat()) * 0.1f));
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isSheared() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("Sheared", this.isSheared());
        var0.putByte("Color", (byte)this.getColor().getId());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setSheared(var0.getBoolean("Sheared"));
        this.setColor(EnumColor.byId(var0.getByte("Color")));
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SHEEP_AMBIENT;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.SHEEP_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SHEEP_DEATH;
    }

    @Override
    protected void playStepSound(BlockPosition var0, IBlockData var1) {
        this.playSound(SoundEffects.SHEEP_STEP, 0.15f, 1.0f);
    }

    public EnumColor getColor() {
        return EnumColor.byId(this.entityData.get(DATA_WOOL_ID) & 0xF);
    }

    public void setColor(EnumColor var0) {
        byte var1 = this.entityData.get(DATA_WOOL_ID);
        this.entityData.set(DATA_WOOL_ID, (byte)(var1 & 0xF0 | var0.getId() & 0xF));
    }

    public boolean isSheared() {
        return (this.entityData.get(DATA_WOOL_ID) & 0x10) != 0;
    }

    public void setSheared(boolean var0) {
        byte var1 = this.entityData.get(DATA_WOOL_ID);
        if (var0) {
            this.entityData.set(DATA_WOOL_ID, (byte)(var1 | 0x10));
        } else {
            this.entityData.set(DATA_WOOL_ID, (byte)(var1 & 0xFFFFFFEF));
        }
    }

    public static EnumColor getRandomSheepColor(RandomSource var0) {
        int var1 = var0.nextInt(100);
        if (var1 < 5) {
            return EnumColor.BLACK;
        }
        if (var1 < 10) {
            return EnumColor.GRAY;
        }
        if (var1 < 15) {
            return EnumColor.LIGHT_GRAY;
        }
        if (var1 < 18) {
            return EnumColor.BROWN;
        }
        if (var0.nextInt(500) == 0) {
            return EnumColor.PINK;
        }
        return EnumColor.WHITE;
    }

    @Override
    @Nullable
    public EntitySheep getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntitySheep var2 = EntityTypes.SHEEP.create(var0);
        if (var2 != null) {
            var2.setColor(this.getOffspringColor(this, (EntitySheep)var1));
        }
        return var2;
    }

    @Override
    public void ate() {
        super.ate();
        this.setSheared(false);
        if (this.isBaby()) {
            this.ageUp(60);
        }
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        this.setColor(EntitySheep.getRandomSheepColor(var0.getRandom()));
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    private EnumColor getOffspringColor(EntityAnimal var0, EntityAnimal var12) {
        EnumColor var2 = ((EntitySheep)var0).getColor();
        EnumColor var3 = ((EntitySheep)var12).getColor();
        InventoryCrafting var4 = EntitySheep.makeContainer(var2, var3);
        return this.level.getRecipeManager().getRecipeFor(Recipes.CRAFTING, var4, this.level).map(var1 -> var1.assemble(var4, this.level.registryAccess())).map(ItemStack::getItem).filter(ItemDye.class::isInstance).map(ItemDye.class::cast).map(ItemDye::getDyeColor).orElseGet(() -> this.level.random.nextBoolean() ? var2 : var3);
    }

    private static InventoryCrafting makeContainer(EnumColor var0, EnumColor var1) {
        InventoryCrafting var2 = new InventoryCrafting(new Container(null, -1){

            @Override
            public ItemStack quickMoveStack(EntityHuman var0, int var1) {
                return ItemStack.EMPTY;
            }

            @Override
            public boolean stillValid(EntityHuman var0) {
                return false;
            }
        }, 2, 1);
        var2.setItem(0, new ItemStack(ItemDye.byColor(var0)));
        var2.setItem(1, new ItemStack(ItemDye.byColor(var1)));
        return var2;
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        return 0.95f * var1.height;
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }
}

