/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.EntityCow;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemLiquidUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.commons.lang3.tuple.Pair;

public class EntityMushroomCow
extends EntityCow
implements IShearable,
VariantHolder<Type> {
    private static final DataWatcherObject<String> DATA_TYPE = DataWatcher.defineId(EntityMushroomCow.class, DataWatcherRegistry.STRING);
    private static final int MUTATE_CHANCE = 1024;
    @Nullable
    private MobEffectList effect;
    private int effectDuration;
    @Nullable
    private UUID lastLightningBoltUUID;

    public EntityMushroomCow(EntityTypes<? extends EntityMushroomCow> var0, World var1) {
        super((EntityTypes<? extends EntityCow>)var0, var1);
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        if (var1.getBlockState(var0.below()).is(Blocks.MYCELIUM)) {
            return 10.0f;
        }
        return var1.getPathfindingCostFromLightLevels(var0);
    }

    public static boolean checkMushroomSpawnRules(EntityTypes<EntityMushroomCow> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.MOOSHROOMS_SPAWNABLE_ON) && EntityMushroomCow.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
        UUID var2 = var1.getUUID();
        if (!var2.equals(this.lastLightningBoltUUID)) {
            this.setVariant(this.getVariant() == Type.RED ? Type.BROWN : Type.RED);
            this.lastLightningBoltUUID = var2;
            this.playSound(SoundEffects.MOOSHROOM_CONVERT, 2.0f, 1.0f);
        }
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_TYPE, Type.RED.type);
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var12) {
        ItemStack var2 = var0.getItemInHand(var12);
        if (var2.is(Items.BOWL) && !this.isBaby()) {
            ItemStack var3;
            boolean var4 = false;
            if (this.effect != null) {
                var4 = true;
                var3 = new ItemStack(Items.SUSPICIOUS_STEW);
                ItemSuspiciousStew.saveMobEffect(var3, this.effect, this.effectDuration);
                this.effect = null;
                this.effectDuration = 0;
            } else {
                var3 = new ItemStack(Items.MUSHROOM_STEW);
            }
            ItemStack var5 = ItemLiquidUtil.createFilledResult(var2, var0, var3, false);
            var0.setItemInHand(var12, var5);
            SoundEffect var6 = var4 ? SoundEffects.MOOSHROOM_MILK_SUSPICIOUSLY : SoundEffects.MOOSHROOM_MILK;
            this.playSound(var6, 1.0f, 1.0f);
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (var2.is(Items.SHEARS) && this.readyForShearing()) {
            this.shear(SoundCategory.PLAYERS);
            this.gameEvent(GameEvent.SHEAR, var0);
            if (!this.level.isClientSide) {
                var2.hurtAndBreak(1, var0, var1 -> var1.broadcastBreakEvent(var12));
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        if (this.getVariant() == Type.BROWN && var2.is(TagsItem.SMALL_FLOWERS)) {
            if (this.effect != null) {
                for (int var3 = 0; var3 < 2; ++var3) {
                    this.level.addParticle(Particles.SMOKE, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
            } else {
                Optional<Pair<MobEffectList, Integer>> var3 = this.getEffectFromItemStack(var2);
                if (!var3.isPresent()) {
                    return EnumInteractionResult.PASS;
                }
                Pair<MobEffectList, Integer> var4 = var3.get();
                if (!var0.getAbilities().instabuild) {
                    var2.shrink(1);
                }
                for (int var5 = 0; var5 < 4; ++var5) {
                    this.level.addParticle(Particles.EFFECT, this.getX() + this.random.nextDouble() / 2.0, this.getY(0.5), this.getZ() + this.random.nextDouble() / 2.0, 0.0, this.random.nextDouble() / 5.0, 0.0);
                }
                this.effect = (MobEffectList)var4.getLeft();
                this.effectDuration = (Integer)var4.getRight();
                this.playSound(SoundEffects.MOOSHROOM_EAT, 2.0f, 1.0f);
            }
            return EnumInteractionResult.sidedSuccess(this.level.isClientSide);
        }
        return super.mobInteract(var0, var12);
    }

    @Override
    public void shear(SoundCategory var0) {
        EntityCow var1;
        this.level.playSound(null, this, SoundEffects.MOOSHROOM_SHEAR, var0, 1.0f, 1.0f);
        if (!this.level.isClientSide() && (var1 = EntityTypes.COW.create(this.level)) != null) {
            ((WorldServer)this.level).sendParticles(Particles.EXPLOSION, this.getX(), this.getY(0.5), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
            this.discard();
            var1.moveTo(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot());
            var1.setHealth(this.getHealth());
            var1.yBodyRot = this.yBodyRot;
            if (this.hasCustomName()) {
                var1.setCustomName(this.getCustomName());
                var1.setCustomNameVisible(this.isCustomNameVisible());
            }
            if (this.isPersistenceRequired()) {
                var1.setPersistenceRequired();
            }
            var1.setInvulnerable(this.isInvulnerable());
            this.level.addFreshEntity(var1);
            for (int var2 = 0; var2 < 5; ++var2) {
                this.level.addFreshEntity(new EntityItem(this.level, this.getX(), this.getY(1.0), this.getZ(), new ItemStack(this.getVariant().blockState.getBlock())));
            }
        }
    }

    @Override
    public boolean readyForShearing() {
        return this.isAlive() && !this.isBaby();
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putString("Type", this.getVariant().getSerializedName());
        if (this.effect != null) {
            var0.putInt("EffectId", MobEffectList.getId(this.effect));
            var0.putInt("EffectDuration", this.effectDuration);
        }
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(Type.byType(var0.getString("Type")));
        if (var0.contains("EffectId", 1)) {
            this.effect = MobEffectList.byId(var0.getInt("EffectId"));
        }
        if (var0.contains("EffectDuration", 3)) {
            this.effectDuration = var0.getInt("EffectDuration");
        }
    }

    private Optional<Pair<MobEffectList, Integer>> getEffectFromItemStack(ItemStack var0) {
        SuspiciousEffectHolder var1 = SuspiciousEffectHolder.tryGet(var0.getItem());
        if (var1 != null) {
            return Optional.of(Pair.of((Object)var1.getSuspiciousEffect(), (Object)var1.getEffectDuration()));
        }
        return Optional.empty();
    }

    @Override
    public void setVariant(Type var0) {
        this.entityData.set(DATA_TYPE, var0.type);
    }

    @Override
    public Type getVariant() {
        return Type.byType(this.entityData.get(DATA_TYPE));
    }

    @Override
    @Nullable
    public EntityMushroomCow getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityMushroomCow var2 = EntityTypes.MOOSHROOM.create(var0);
        if (var2 != null) {
            var2.setVariant(this.getOffspringType((EntityMushroomCow)var1));
        }
        return var2;
    }

    private Type getOffspringType(EntityMushroomCow var0) {
        Type var2;
        Type var1 = this.getVariant();
        Type var3 = var1 == (var2 = var0.getVariant()) && this.random.nextInt(1024) == 0 ? (var1 == Type.BROWN ? Type.RED : Type.BROWN) : (this.random.nextBoolean() ? var1 : var2);
        return var3;
    }

    @Override
    @Nullable
    public /* synthetic */ EntityCow getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type RED = new Type("red", Blocks.RED_MUSHROOM.defaultBlockState());
        public static final /* enum */ Type BROWN = new Type("brown", Blocks.BROWN_MUSHROOM.defaultBlockState());
        public static final INamable.a<Type> CODEC;
        final String type;
        final IBlockData blockState;
        private static final /* synthetic */ Type[] f;

        public static Type[] values() {
            return (Type[])f.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(String var2, IBlockData var3) {
            this.type = var2;
            this.blockState = var3;
        }

        public IBlockData getBlockState() {
            return this.blockState;
        }

        @Override
        public String getSerializedName() {
            return this.type;
        }

        static Type byType(String var0) {
            return CODEC.byName(var0, RED);
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{RED, BROWN};
        }

        static {
            f = Type.b();
            CODEC = INamable.fromEnum(Type::values);
        }
    }
}

