/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalAvoidTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalBreed;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFleeSun;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFloat;
import net.minecraft.world.entity.ai.goal.PathfinderGoalFollowParent;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLeapAtTarget;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalMeleeAttack;
import net.minecraft.world.entity.ai.goal.PathfinderGoalNearestVillage;
import net.minecraft.world.entity.ai.goal.PathfinderGoalPanic;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStrollLand;
import net.minecraft.world.entity.ai.goal.PathfinderGoalWaterJumpAbstract;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.EntityFish;
import net.minecraft.world.entity.animal.EntityFishSchool;
import net.minecraft.world.entity.animal.EntityPolarBear;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTurtle;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSweetBerryBush;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class EntityFox
extends EntityAnimal
implements VariantHolder<Type> {
    private static final DataWatcherObject<Integer> DATA_TYPE_ID = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Byte> DATA_FLAGS_ID = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.BYTE);
    private static final int FLAG_SITTING = 1;
    public static final int FLAG_CROUCHING = 4;
    public static final int FLAG_INTERESTED = 8;
    public static final int FLAG_POUNCING = 16;
    private static final int FLAG_SLEEPING = 32;
    private static final int FLAG_FACEPLANTED = 64;
    private static final int FLAG_DEFENDING = 128;
    public static final DataWatcherObject<Optional<UUID>> DATA_TRUSTED_ID_0 = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.OPTIONAL_UUID);
    public static final DataWatcherObject<Optional<UUID>> DATA_TRUSTED_ID_1 = DataWatcher.defineId(EntityFox.class, DataWatcherRegistry.OPTIONAL_UUID);
    static final Predicate<EntityItem> ALLOWED_ITEMS = var0 -> !var0.hasPickUpDelay() && var0.isAlive();
    private static final Predicate<Entity> TRUSTED_TARGET_SELECTOR = var0 -> {
        if (var0 instanceof EntityLiving) {
            EntityLiving var1 = (EntityLiving)var0;
            return var1.getLastHurtMob() != null && var1.getLastHurtMobTimestamp() < var1.tickCount + 600;
        }
        return false;
    };
    static final Predicate<Entity> STALKABLE_PREY = var0 -> var0 instanceof EntityChicken || var0 instanceof EntityRabbit;
    private static final Predicate<Entity> AVOID_PLAYERS = var0 -> !var0.isDiscrete() && IEntitySelector.NO_CREATIVE_OR_SPECTATOR.test((Entity)var0);
    private static final int MIN_TICKS_BEFORE_EAT = 600;
    private PathfinderGoal landTargetGoal;
    private PathfinderGoal turtleEggTargetGoal;
    private PathfinderGoal fishTargetGoal;
    private float interestedAngle;
    private float interestedAngleO;
    float crouchAmount;
    float crouchAmountO;
    private int ticksSinceEaten;

    public EntityFox(EntityTypes<? extends EntityFox> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.lookControl = new k();
        this.moveControl = new m();
        this.setPathfindingMalus(PathType.DANGER_OTHER, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_OTHER, 0.0f);
        this.setCanPickUpLoot(true);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(DATA_TRUSTED_ID_0, Optional.empty());
        this.entityData.define(DATA_TRUSTED_ID_1, Optional.empty());
        this.entityData.define(DATA_TYPE_ID, 0);
        this.entityData.define(DATA_FLAGS_ID, (byte)0);
    }

    @Override
    protected void registerGoals() {
        this.landTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityAnimal>(this, EntityAnimal.class, 10, false, false, var0 -> var0 instanceof EntityChicken || var0 instanceof EntityRabbit);
        this.turtleEggTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityTurtle>(this, EntityTurtle.class, 10, false, false, EntityTurtle.BABY_ON_LAND_SELECTOR);
        this.fishTargetGoal = new PathfinderGoalNearestAttackableTarget<EntityFish>(this, EntityFish.class, 20, false, false, var0 -> var0 instanceof EntityFishSchool);
        this.goalSelector.addGoal(0, new g());
        this.goalSelector.addGoal(0, new ClimbOnTopOfPowderSnowGoal(this, this.level));
        this.goalSelector.addGoal(1, new b());
        this.goalSelector.addGoal(2, new n(2.2));
        this.goalSelector.addGoal(3, new e(1.0));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityHuman>(this, EntityHuman.class, 16.0f, 1.6, 1.4, var0 -> AVOID_PLAYERS.test((Entity)var0) && !this.trusts(var0.getUUID()) && !this.isDefending()));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityWolf>(this, EntityWolf.class, 8.0f, 1.6, 1.4, var0 -> !((EntityWolf)var0).isTame() && !this.isDefending()));
        this.goalSelector.addGoal(4, new PathfinderGoalAvoidTarget<EntityPolarBear>(this, EntityPolarBear.class, 8.0f, 1.6, 1.4, var0 -> !this.isDefending()));
        this.goalSelector.addGoal(5, new u());
        this.goalSelector.addGoal(6, new o());
        this.goalSelector.addGoal(6, new s(1.25));
        this.goalSelector.addGoal(7, new l((double)1.2f, true));
        this.goalSelector.addGoal(7, new t());
        this.goalSelector.addGoal(8, new h(this, 1.25));
        this.goalSelector.addGoal(9, new q(32, 200));
        this.goalSelector.addGoal(10, new f((double)1.2f, 12, 1));
        this.goalSelector.addGoal(10, new PathfinderGoalLeapAtTarget(this, 0.4f));
        this.goalSelector.addGoal(11, new PathfinderGoalRandomStrollLand(this, 1.0));
        this.goalSelector.addGoal(11, new p());
        this.goalSelector.addGoal(12, new j(this, EntityHuman.class, 24.0f));
        this.goalSelector.addGoal(13, new r());
        this.targetSelector.addGoal(3, new a(EntityLiving.class, false, false, var0 -> TRUSTED_TARGET_SELECTOR.test((Entity)var0) && !this.trusts(var0.getUUID())));
    }

    @Override
    public SoundEffect getEatingSound(ItemStack var0) {
        return SoundEffects.FOX_EAT;
    }

    @Override
    public void aiStep() {
        if (!this.level.isClientSide && this.isAlive() && this.isEffectiveAi()) {
            Object var1;
            ++this.ticksSinceEaten;
            ItemStack var0 = this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (this.canEat(var0)) {
                if (this.ticksSinceEaten > 600) {
                    var1 = var0.finishUsingItem(this.level, this);
                    if (!((ItemStack)var1).isEmpty()) {
                        this.setItemSlot(EnumItemSlot.MAINHAND, (ItemStack)var1);
                    }
                    this.ticksSinceEaten = 0;
                } else if (this.ticksSinceEaten > 560 && this.random.nextFloat() < 0.1f) {
                    this.playSound(this.getEatingSound(var0), 1.0f, 1.0f);
                    this.level.broadcastEntityEvent(this, (byte)45);
                }
            }
            if ((var1 = this.getTarget()) == null || !((EntityLiving)var1).isAlive()) {
                this.setIsCrouching(false);
                this.setIsInterested(false);
            }
        }
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        super.aiStep();
        if (this.isDefending() && this.random.nextFloat() < 0.05f) {
            this.playSound(SoundEffects.FOX_AGGRO, 1.0f, 1.0f);
        }
    }

    @Override
    protected boolean isImmobile() {
        return this.isDeadOrDying();
    }

    private boolean canEat(ItemStack var0) {
        return var0.getItem().isEdible() && this.getTarget() == null && this.onGround && !this.isSleeping();
    }

    @Override
    protected void populateDefaultEquipmentSlots(RandomSource var0, DifficultyDamageScaler var1) {
        if (var0.nextFloat() < 0.2f) {
            float var2 = var0.nextFloat();
            ItemStack var3 = var2 < 0.05f ? new ItemStack(Items.EMERALD) : (var2 < 0.2f ? new ItemStack(Items.EGG) : (var2 < 0.4f ? (var0.nextBoolean() ? new ItemStack(Items.RABBIT_FOOT) : new ItemStack(Items.RABBIT_HIDE)) : (var2 < 0.6f ? new ItemStack(Items.WHEAT) : (var2 < 0.8f ? new ItemStack(Items.LEATHER) : new ItemStack(Items.FEATHER)))));
            this.setItemSlot(EnumItemSlot.MAINHAND, var3);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 45) {
            ItemStack var1 = this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (!var1.isEmpty()) {
                for (int var2 = 0; var2 < 8; ++var2) {
                    Vec3D var3 = new Vec3D(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0).xRot(-this.getXRot() * ((float)Math.PI / 180)).yRot(-this.getYRot() * ((float)Math.PI / 180));
                    this.level.addParticle(new ParticleParamItem(Particles.ITEM, var1), this.getX() + this.getLookAngle().x / 2.0, this.getY(), this.getZ() + this.getLookAngle().z / 2.0, var3.x, var3.y + 0.05, var3.z);
                }
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.3f).add(GenericAttributes.MAX_HEALTH, 10.0).add(GenericAttributes.FOLLOW_RANGE, 32.0).add(GenericAttributes.ATTACK_DAMAGE, 2.0);
    }

    @Override
    @Nullable
    public EntityFox getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        EntityFox var2 = EntityTypes.FOX.create(var0);
        if (var2 != null) {
            var2.setVariant(this.random.nextBoolean() ? this.getVariant() : ((EntityFox)var1).getVariant());
        }
        return var2;
    }

    public static boolean checkFoxSpawnRules(EntityTypes<EntityFox> var0, GeneratorAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.FOXES_SPAWNABLE_ON) && EntityFox.isBrightEnoughToSpawn(var1, var3);
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3, @Nullable NBTTagCompound var4) {
        Holder<BiomeBase> var5 = var0.getBiome(this.blockPosition());
        Type var6 = Type.byBiome(var5);
        boolean var7 = false;
        if (var3 instanceof i) {
            i var8 = (i)var3;
            var6 = var8.type;
            if (var8.getGroupSize() >= 2) {
                var7 = true;
            }
        } else {
            var3 = new i(var6);
        }
        this.setVariant(var6);
        if (var7) {
            this.setAge(-24000);
        }
        if (var0 instanceof WorldServer) {
            this.setTargetGoals();
        }
        this.populateDefaultEquipmentSlots(var0.getRandom(), var1);
        return super.finalizeSpawn(var0, var1, var2, var3, var4);
    }

    private void setTargetGoals() {
        if (this.getVariant() == Type.RED) {
            this.targetSelector.addGoal(4, this.landTargetGoal);
            this.targetSelector.addGoal(4, this.turtleEggTargetGoal);
            this.targetSelector.addGoal(6, this.fishTargetGoal);
        } else {
            this.targetSelector.addGoal(4, this.fishTargetGoal);
            this.targetSelector.addGoal(6, this.landTargetGoal);
            this.targetSelector.addGoal(6, this.turtleEggTargetGoal);
        }
    }

    @Override
    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (this.isFood(var2)) {
            this.playSound(this.getEatingSound(var2), 1.0f, 1.0f);
        }
        super.usePlayerItem(var0, var1, var2);
    }

    @Override
    protected float getStandingEyeHeight(EntityPose var0, EntitySize var1) {
        if (this.isBaby()) {
            return var1.height * 0.85f;
        }
        return 0.4f;
    }

    @Override
    public Type getVariant() {
        return Type.byId(this.entityData.get(DATA_TYPE_ID));
    }

    @Override
    public void setVariant(Type var0) {
        this.entityData.set(DATA_TYPE_ID, var0.getId());
    }

    List<UUID> getTrustedUUIDs() {
        ArrayList var0 = Lists.newArrayList();
        var0.add(this.entityData.get(DATA_TRUSTED_ID_0).orElse(null));
        var0.add(this.entityData.get(DATA_TRUSTED_ID_1).orElse(null));
        return var0;
    }

    void addTrustedUUID(@Nullable UUID var0) {
        if (this.entityData.get(DATA_TRUSTED_ID_0).isPresent()) {
            this.entityData.set(DATA_TRUSTED_ID_1, Optional.ofNullable(var0));
        } else {
            this.entityData.set(DATA_TRUSTED_ID_0, Optional.ofNullable(var0));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        List<UUID> var1 = this.getTrustedUUIDs();
        NBTTagList var2 = new NBTTagList();
        for (UUID var4 : var1) {
            if (var4 == null) continue;
            var2.add(GameProfileSerializer.createUUID(var4));
        }
        var0.put("Trusted", var2);
        var0.putBoolean("Sleeping", this.isSleeping());
        var0.putString("Type", this.getVariant().getSerializedName());
        var0.putBoolean("Sitting", this.isSitting());
        var0.putBoolean("Crouching", this.isCrouching());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        NBTTagList var1 = var0.getList("Trusted", 11);
        for (int var2 = 0; var2 < var1.size(); ++var2) {
            this.addTrustedUUID(GameProfileSerializer.loadUUID(var1.get(var2)));
        }
        this.setSleeping(var0.getBoolean("Sleeping"));
        this.setVariant(Type.byName(var0.getString("Type")));
        this.setSitting(var0.getBoolean("Sitting"));
        this.setIsCrouching(var0.getBoolean("Crouching"));
        if (this.level instanceof WorldServer) {
            this.setTargetGoals();
        }
    }

    public boolean isSitting() {
        return this.getFlag(1);
    }

    public void setSitting(boolean var0) {
        this.setFlag(1, var0);
    }

    public boolean isFaceplanted() {
        return this.getFlag(64);
    }

    void setFaceplanted(boolean var0) {
        this.setFlag(64, var0);
    }

    boolean isDefending() {
        return this.getFlag(128);
    }

    void setDefending(boolean var0) {
        this.setFlag(128, var0);
    }

    @Override
    public boolean isSleeping() {
        return this.getFlag(32);
    }

    public void setSleeping(boolean var0) {
        this.setFlag(32, var0);
    }

    private void setFlag(int var0, boolean var1) {
        if (var1) {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) | var0));
        } else {
            this.entityData.set(DATA_FLAGS_ID, (byte)(this.entityData.get(DATA_FLAGS_ID) & ~var0));
        }
    }

    private boolean getFlag(int var0) {
        return (this.entityData.get(DATA_FLAGS_ID) & var0) != 0;
    }

    @Override
    public boolean canTakeItem(ItemStack var0) {
        EnumItemSlot var1 = EntityInsentient.getEquipmentSlotForItem(var0);
        if (!this.getItemBySlot(var1).isEmpty()) {
            return false;
        }
        return var1 == EnumItemSlot.MAINHAND && super.canTakeItem(var0);
    }

    @Override
    public boolean canHoldItem(ItemStack var0) {
        Item var1 = var0.getItem();
        ItemStack var2 = this.getItemBySlot(EnumItemSlot.MAINHAND);
        return var2.isEmpty() || this.ticksSinceEaten > 0 && var1.isEdible() && !var2.getItem().isEdible();
    }

    private void spitOutItem(ItemStack var0) {
        if (var0.isEmpty() || this.level.isClientSide) {
            return;
        }
        EntityItem var1 = new EntityItem(this.level, this.getX() + this.getLookAngle().x, this.getY() + 1.0, this.getZ() + this.getLookAngle().z, var0);
        var1.setPickUpDelay(40);
        var1.setThrower(this.getUUID());
        this.playSound(SoundEffects.FOX_SPIT, 1.0f, 1.0f);
        this.level.addFreshEntity(var1);
    }

    private void dropItemStack(ItemStack var0) {
        EntityItem var1 = new EntityItem(this.level, this.getX(), this.getY(), this.getZ(), var0);
        this.level.addFreshEntity(var1);
    }

    @Override
    protected void pickUpItem(EntityItem var0) {
        ItemStack var1 = var0.getItem();
        if (this.canHoldItem(var1)) {
            int var2 = var1.getCount();
            if (var2 > 1) {
                this.dropItemStack(var1.split(var2 - 1));
            }
            this.spitOutItem(this.getItemBySlot(EnumItemSlot.MAINHAND));
            this.onItemPickup(var0);
            this.setItemSlot(EnumItemSlot.MAINHAND, var1.split(1));
            this.setGuaranteedDrop(EnumItemSlot.MAINHAND);
            this.take(var0, var1.getCount());
            var0.discard();
            this.ticksSinceEaten = 0;
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isEffectiveAi()) {
            boolean var0 = this.isInWater();
            if (var0 || this.getTarget() != null || this.level.isThundering()) {
                this.wakeUp();
            }
            if (var0 || this.isSleeping()) {
                this.setSitting(false);
            }
            if (this.isFaceplanted() && this.level.random.nextFloat() < 0.2f) {
                BlockPosition var1 = this.blockPosition();
                IBlockData var2 = this.level.getBlockState(var1);
                this.level.levelEvent(2001, var1, Block.getId(var2));
            }
        }
        this.interestedAngleO = this.interestedAngle;
        this.interestedAngle = this.isInterested() ? (this.interestedAngle += (1.0f - this.interestedAngle) * 0.4f) : (this.interestedAngle += (0.0f - this.interestedAngle) * 0.4f);
        this.crouchAmountO = this.crouchAmount;
        if (this.isCrouching()) {
            this.crouchAmount += 0.2f;
            if (this.crouchAmount > 3.0f) {
                this.crouchAmount = 3.0f;
            }
        } else {
            this.crouchAmount = 0.0f;
        }
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.FOX_FOOD);
    }

    @Override
    protected void onOffspringSpawnedFromEgg(EntityHuman var0, EntityInsentient var1) {
        ((EntityFox)var1).addTrustedUUID(var0.getUUID());
    }

    public boolean isPouncing() {
        return this.getFlag(16);
    }

    public void setIsPouncing(boolean var0) {
        this.setFlag(16, var0);
    }

    public boolean isJumping() {
        return this.jumping;
    }

    public boolean isFullyCrouched() {
        return this.crouchAmount == 3.0f;
    }

    public void setIsCrouching(boolean var0) {
        this.setFlag(4, var0);
    }

    @Override
    public boolean isCrouching() {
        return this.getFlag(4);
    }

    public void setIsInterested(boolean var0) {
        this.setFlag(8, var0);
    }

    public boolean isInterested() {
        return this.getFlag(8);
    }

    public float getHeadRollAngle(float var0) {
        return MathHelper.lerp(var0, this.interestedAngleO, this.interestedAngle) * 0.11f * (float)Math.PI;
    }

    public float getCrouchAmount(float var0) {
        return MathHelper.lerp(var0, this.crouchAmountO, this.crouchAmount);
    }

    @Override
    public void setTarget(@Nullable EntityLiving var0) {
        if (this.isDefending() && var0 == null) {
            this.setDefending(false);
        }
        super.setTarget(var0);
    }

    @Override
    protected int calculateFallDamage(float var0, float var1) {
        return MathHelper.ceil((var0 - 5.0f) * var1);
    }

    void wakeUp() {
        this.setSleeping(false);
    }

    void clearStates() {
        this.setIsInterested(false);
        this.setIsCrouching(false);
        this.setSitting(false);
        this.setSleeping(false);
        this.setDefending(false);
        this.setFaceplanted(false);
    }

    boolean canMove() {
        return !this.isSleeping() && !this.isSitting() && !this.isFaceplanted();
    }

    @Override
    public void playAmbientSound() {
        SoundEffect var0 = this.getAmbientSound();
        if (var0 == SoundEffects.FOX_SCREECH) {
            this.playSound(var0, 2.0f, this.getVoicePitch());
        } else {
            super.playAmbientSound();
        }
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        List<Entity> var0;
        if (this.isSleeping()) {
            return SoundEffects.FOX_SLEEP;
        }
        if (!this.level.isDay() && this.random.nextFloat() < 0.1f && (var0 = this.level.getEntitiesOfClass(EntityHuman.class, this.getBoundingBox().inflate(16.0, 16.0, 16.0), IEntitySelector.NO_SPECTATORS)).isEmpty()) {
            return SoundEffects.FOX_SCREECH;
        }
        return SoundEffects.FOX_AMBIENT;
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.FOX_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.FOX_DEATH;
    }

    boolean trusts(UUID var0) {
        return this.getTrustedUUIDs().contains(var0);
    }

    @Override
    protected void dropAllDeathLoot(DamageSource var0) {
        ItemStack var1 = this.getItemBySlot(EnumItemSlot.MAINHAND);
        if (!var1.isEmpty()) {
            this.spawnAtLocation(var1);
            this.setItemSlot(EnumItemSlot.MAINHAND, ItemStack.EMPTY);
        }
        super.dropAllDeathLoot(var0);
    }

    public static boolean isPathClear(EntityFox var0, EntityLiving var1) {
        double var2 = var1.getZ() - var0.getZ();
        double var4 = var1.getX() - var0.getX();
        double var6 = var2 / var4;
        int var8 = 6;
        for (int var9 = 0; var9 < 6; ++var9) {
            double var10 = var6 == 0.0 ? 0.0 : var2 * (double)((float)var9 / 6.0f);
            double var12 = var6 == 0.0 ? var4 * (double)((float)var9 / 6.0f) : var10 / var6;
            for (int var14 = 1; var14 < 4; ++var14) {
                if (var0.level.getBlockState(BlockPosition.containing(var0.getX() + var12, var0.getY() + (double)var14, var0.getZ() + var10)).canBeReplaced()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Vec3D getLeashOffset() {
        return new Vec3D(0.0, 0.55f * this.getEyeHeight(), this.getBbWidth() * 0.4f);
    }

    @Override
    @Nullable
    public /* synthetic */ EntityAgeable getBreedOffspring(WorldServer worldServer, EntityAgeable entityAgeable) {
        return this.getBreedOffspring(worldServer, entityAgeable);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    public class k
    extends ControllerLook {
        public k() {
            super(EntityFox.this);
        }

        @Override
        public void tick() {
            if (!EntityFox.this.isSleeping()) {
                super.tick();
            }
        }

        @Override
        protected boolean resetXRotOnTick() {
            return !EntityFox.this.isPouncing() && !EntityFox.this.isCrouching() && !EntityFox.this.isInterested() && !EntityFox.this.isFaceplanted();
        }
    }

    class m
    extends ControllerMove {
        public m() {
            super(EntityFox.this);
        }

        @Override
        public void tick() {
            if (EntityFox.this.canMove()) {
                super.tick();
            }
        }
    }

    class g
    extends PathfinderGoalFloat {
        public g() {
            super(EntityFox.this);
        }

        @Override
        public void start() {
            super.start();
            EntityFox.this.clearStates();
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.isInWater() && EntityFox.this.getFluidHeight(TagsFluid.WATER) > 0.25 || EntityFox.this.isInLava();
        }
    }

    class b
    extends PathfinderGoal {
        int countdown;

        public b() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.isFaceplanted();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canUse() && this.countdown > 0;
        }

        @Override
        public void start() {
            this.countdown = this.adjustedTickDelay(40);
        }

        @Override
        public void stop() {
            EntityFox.this.setFaceplanted(false);
        }

        @Override
        public void tick() {
            --this.countdown;
        }
    }

    class n
    extends PathfinderGoalPanic {
        public n(double var1) {
            super(EntityFox.this, var1);
        }

        @Override
        public boolean shouldPanic() {
            return !EntityFox.this.isDefending() && super.shouldPanic();
        }
    }

    class e
    extends PathfinderGoalBreed {
        public e(double var1) {
            super(EntityFox.this, var1);
        }

        @Override
        public void start() {
            ((EntityFox)this.animal).clearStates();
            ((EntityFox)this.partner).clearStates();
            super.start();
        }

        @Override
        protected void breed() {
            WorldServer var0 = (WorldServer)this.level;
            EntityFox var1 = (EntityFox)this.animal.getBreedOffspring(var0, this.partner);
            if (var1 == null) {
                return;
            }
            EntityPlayer var2 = this.animal.getLoveCause();
            EntityPlayer var3 = this.partner.getLoveCause();
            EntityPlayer var4 = var2;
            if (var2 != null) {
                var1.addTrustedUUID(var2.getUUID());
            } else {
                var4 = var3;
            }
            if (var3 != null && var2 != var3) {
                var1.addTrustedUUID(var3.getUUID());
            }
            if (var4 != null) {
                var4.awardStat(StatisticList.ANIMALS_BRED);
                CriterionTriggers.BRED_ANIMALS.trigger(var4, this.animal, this.partner, var1);
            }
            this.animal.setAge(6000);
            this.partner.setAge(6000);
            this.animal.resetLove();
            this.partner.resetLove();
            var1.setAge(-24000);
            var1.moveTo(this.animal.getX(), this.animal.getY(), this.animal.getZ(), 0.0f, 0.0f);
            var0.addFreshEntityWithPassengers(var1);
            this.level.broadcastEntityEvent(this.animal, (byte)18);
            if (this.level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
                this.level.addFreshEntity(new EntityExperienceOrb(this.level, this.animal.getX(), this.animal.getY(), this.animal.getZ(), this.animal.getRandom().nextInt(7) + 1));
            }
        }
    }

    class u
    extends PathfinderGoal {
        public u() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            if (EntityFox.this.isSleeping()) {
                return false;
            }
            EntityLiving var0 = EntityFox.this.getTarget();
            return var0 != null && var0.isAlive() && STALKABLE_PREY.test(var0) && EntityFox.this.distanceToSqr(var0) > 36.0 && !EntityFox.this.isCrouching() && !EntityFox.this.isInterested() && !EntityFox.this.jumping;
        }

        @Override
        public void start() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setFaceplanted(false);
        }

        @Override
        public void stop() {
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 != null && EntityFox.isPathClear(EntityFox.this, var0)) {
                EntityFox.this.setIsInterested(true);
                EntityFox.this.setIsCrouching(true);
                EntityFox.this.getNavigation().stop();
                EntityFox.this.getLookControl().setLookAt(var0, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
            } else {
                EntityFox.this.setIsInterested(false);
                EntityFox.this.setIsCrouching(false);
            }
        }

        @Override
        public void tick() {
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 == null) {
                return;
            }
            EntityFox.this.getLookControl().setLookAt(var0, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
            if (EntityFox.this.distanceToSqr(var0) <= 36.0) {
                EntityFox.this.setIsInterested(true);
                EntityFox.this.setIsCrouching(true);
                EntityFox.this.getNavigation().stop();
            } else {
                EntityFox.this.getNavigation().moveTo(var0, 1.5);
            }
        }
    }

    public class o
    extends PathfinderGoalWaterJumpAbstract {
        @Override
        public boolean canUse() {
            if (!EntityFox.this.isFullyCrouched()) {
                return false;
            }
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 == null || !var0.isAlive()) {
                return false;
            }
            if (var0.getMotionDirection() != var0.getDirection()) {
                return false;
            }
            boolean var1 = EntityFox.isPathClear(EntityFox.this, var0);
            if (!var1) {
                EntityFox.this.getNavigation().createPath(var0, 0);
                EntityFox.this.setIsCrouching(false);
                EntityFox.this.setIsInterested(false);
            }
            return var1;
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 == null || !var0.isAlive()) {
                return false;
            }
            double var1 = EntityFox.this.getDeltaMovement().y;
            return !(var1 * var1 < (double)0.05f && Math.abs(EntityFox.this.getXRot()) < 15.0f && EntityFox.this.onGround || EntityFox.this.isFaceplanted());
        }

        @Override
        public boolean isInterruptable() {
            return false;
        }

        @Override
        public void start() {
            EntityFox.this.setJumping(true);
            EntityFox.this.setIsPouncing(true);
            EntityFox.this.setIsInterested(false);
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 != null) {
                EntityFox.this.getLookControl().setLookAt(var0, 60.0f, 30.0f);
                Vec3D var1 = new Vec3D(var0.getX() - EntityFox.this.getX(), var0.getY() - EntityFox.this.getY(), var0.getZ() - EntityFox.this.getZ()).normalize();
                EntityFox.this.setDeltaMovement(EntityFox.this.getDeltaMovement().add(var1.x * 0.8, 0.9, var1.z * 0.8));
            }
            EntityFox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            EntityFox.this.setIsCrouching(false);
            EntityFox.this.crouchAmount = 0.0f;
            EntityFox.this.crouchAmountO = 0.0f;
            EntityFox.this.setIsInterested(false);
            EntityFox.this.setIsPouncing(false);
        }

        @Override
        public void tick() {
            EntityLiving var0 = EntityFox.this.getTarget();
            if (var0 != null) {
                EntityFox.this.getLookControl().setLookAt(var0, 60.0f, 30.0f);
            }
            if (!EntityFox.this.isFaceplanted()) {
                Vec3D var1 = EntityFox.this.getDeltaMovement();
                if (var1.y * var1.y < (double)0.03f && EntityFox.this.getXRot() != 0.0f) {
                    EntityFox.this.setXRot(MathHelper.rotLerp(0.2f, EntityFox.this.getXRot(), 0.0f));
                } else {
                    double var2 = var1.horizontalDistance();
                    double var4 = Math.signum(-var1.y) * Math.acos(var2 / var1.length()) * 57.2957763671875;
                    EntityFox.this.setXRot((float)var4);
                }
            }
            if (var0 != null && EntityFox.this.distanceTo(var0) <= 2.0f) {
                EntityFox.this.doHurtTarget(var0);
            } else if (EntityFox.this.getXRot() > 0.0f && EntityFox.this.onGround && (float)EntityFox.this.getDeltaMovement().y != 0.0f && EntityFox.this.level.getBlockState(EntityFox.this.blockPosition()).is(Blocks.SNOW)) {
                EntityFox.this.setXRot(60.0f);
                EntityFox.this.setTarget(null);
                EntityFox.this.setFaceplanted(true);
            }
        }
    }

    class s
    extends PathfinderGoalFleeSun {
        private int interval;

        public s(double var1) {
            super(EntityFox.this, var1);
            this.interval = s.reducedTickDelay(100);
        }

        @Override
        public boolean canUse() {
            if (EntityFox.this.isSleeping() || this.mob.getTarget() != null) {
                return false;
            }
            if (EntityFox.this.level.isThundering() && EntityFox.this.level.canSeeSky(this.mob.blockPosition())) {
                return this.setWantedPos();
            }
            if (this.interval > 0) {
                --this.interval;
                return false;
            }
            this.interval = 100;
            BlockPosition var0 = this.mob.blockPosition();
            return EntityFox.this.level.isDay() && EntityFox.this.level.canSeeSky(var0) && !((WorldServer)EntityFox.this.level).isVillage(var0) && this.setWantedPos();
        }

        @Override
        public void start() {
            EntityFox.this.clearStates();
            super.start();
        }
    }

    class l
    extends PathfinderGoalMeleeAttack {
        public l(double var1, boolean var3) {
            super(EntityFox.this, var1, var3);
        }

        @Override
        protected void checkAndPerformAttack(EntityLiving var0, double var1) {
            double var3 = this.getAttackReachSqr(var0);
            if (var1 <= var3 && this.isTimeToAttack()) {
                this.resetAttackCooldown();
                this.mob.doHurtTarget(var0);
                EntityFox.this.playSound(SoundEffects.FOX_BITE, 1.0f, 1.0f);
            }
        }

        @Override
        public void start() {
            EntityFox.this.setIsInterested(false);
            super.start();
        }

        @Override
        public boolean canUse() {
            return !EntityFox.this.isSitting() && !EntityFox.this.isSleeping() && !EntityFox.this.isCrouching() && !EntityFox.this.isFaceplanted() && super.canUse();
        }
    }

    class t
    extends d {
        private static final int WAIT_TIME_BEFORE_SLEEP = t.reducedTickDelay(140);
        private int countdown;

        public t() {
            this.countdown = EntityFox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK, PathfinderGoal.Type.JUMP));
        }

        @Override
        public boolean canUse() {
            if (EntityFox.this.xxa != 0.0f || EntityFox.this.yya != 0.0f || EntityFox.this.zza != 0.0f) {
                return false;
            }
            return this.canSleep() || EntityFox.this.isSleeping();
        }

        @Override
        public boolean canContinueToUse() {
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return EntityFox.this.level.isDay() && this.hasShelter() && !this.alertable() && !EntityFox.this.isInPowderSnow;
        }

        @Override
        public void stop() {
            this.countdown = EntityFox.this.random.nextInt(WAIT_TIME_BEFORE_SLEEP);
            EntityFox.this.clearStates();
        }

        @Override
        public void start() {
            EntityFox.this.setSitting(false);
            EntityFox.this.setIsCrouching(false);
            EntityFox.this.setIsInterested(false);
            EntityFox.this.setJumping(false);
            EntityFox.this.setSleeping(true);
            EntityFox.this.getNavigation().stop();
            EntityFox.this.getMoveControl().setWantedPosition(EntityFox.this.getX(), EntityFox.this.getY(), EntityFox.this.getZ(), 0.0);
        }
    }

    class h
    extends PathfinderGoalFollowParent {
        private final EntityFox fox;

        public h(EntityFox var1, double var2) {
            super(var1, var2);
            this.fox = var1;
        }

        @Override
        public boolean canUse() {
            return !this.fox.isDefending() && super.canUse();
        }

        @Override
        public boolean canContinueToUse() {
            return !this.fox.isDefending() && super.canContinueToUse();
        }

        @Override
        public void start() {
            this.fox.clearStates();
            super.start();
        }
    }

    class q
    extends PathfinderGoalNearestVillage {
        public q(int var1, int var2) {
            super(EntityFox.this, var2);
        }

        @Override
        public void start() {
            EntityFox.this.clearStates();
            super.start();
        }

        @Override
        public boolean canUse() {
            return super.canUse() && this.canFoxMove();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.canFoxMove();
        }

        private boolean canFoxMove() {
            return !EntityFox.this.isSleeping() && !EntityFox.this.isSitting() && !EntityFox.this.isDefending() && EntityFox.this.getTarget() == null;
        }
    }

    public class f
    extends PathfinderGoalGotoTarget {
        private static final int WAIT_TICKS = 40;
        protected int ticksWaited;

        public f(double var1, int var3, int var4) {
            super(EntityFox.this, var1, var3, var4);
        }

        @Override
        public double acceptedDistance() {
            return 2.0;
        }

        @Override
        public boolean shouldRecalculatePath() {
            return this.tryTicks % 100 == 0;
        }

        @Override
        protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
            IBlockData var2 = var0.getBlockState(var1);
            return var2.is(Blocks.SWEET_BERRY_BUSH) && var2.getValue(BlockSweetBerryBush.AGE) >= 2 || CaveVines.hasGlowBerries(var2);
        }

        @Override
        public void tick() {
            if (this.isReachedTarget()) {
                if (this.ticksWaited >= 40) {
                    this.onReachedTarget();
                } else {
                    ++this.ticksWaited;
                }
            } else if (!this.isReachedTarget() && EntityFox.this.random.nextFloat() < 0.05f) {
                EntityFox.this.playSound(SoundEffects.FOX_SNIFF, 1.0f, 1.0f);
            }
            super.tick();
        }

        protected void onReachedTarget() {
            if (!EntityFox.this.level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
                return;
            }
            IBlockData var0 = EntityFox.this.level.getBlockState(this.blockPos);
            if (var0.is(Blocks.SWEET_BERRY_BUSH)) {
                this.pickSweetBerries(var0);
            } else if (CaveVines.hasGlowBerries(var0)) {
                this.pickGlowBerry(var0);
            }
        }

        private void pickGlowBerry(IBlockData var0) {
            CaveVines.use(EntityFox.this, var0, EntityFox.this.level, this.blockPos);
        }

        private void pickSweetBerries(IBlockData var0) {
            int var1 = var0.getValue(BlockSweetBerryBush.AGE);
            var0.setValue(BlockSweetBerryBush.AGE, 1);
            int var2 = 1 + EntityFox.this.level.random.nextInt(2) + (var1 == 3 ? 1 : 0);
            ItemStack var3 = EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (var3.isEmpty()) {
                EntityFox.this.setItemSlot(EnumItemSlot.MAINHAND, new ItemStack(Items.SWEET_BERRIES));
                --var2;
            }
            if (var2 > 0) {
                Block.popResource(EntityFox.this.level, this.blockPos, new ItemStack(Items.SWEET_BERRIES, var2));
            }
            EntityFox.this.playSound(SoundEffects.SWEET_BERRY_BUSH_PICK_BERRIES, 1.0f, 1.0f);
            EntityFox.this.level.setBlock(this.blockPos, (IBlockData)var0.setValue(BlockSweetBerryBush.AGE, 1), 2);
        }

        @Override
        public boolean canUse() {
            return !EntityFox.this.isSleeping() && super.canUse();
        }

        @Override
        public void start() {
            this.ticksWaited = 0;
            EntityFox.this.setSitting(false);
            super.start();
        }
    }

    class p
    extends PathfinderGoal {
        public p() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            if (!EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty()) {
                return false;
            }
            if (EntityFox.this.getTarget() != null || EntityFox.this.getLastHurtByMob() != null) {
                return false;
            }
            if (!EntityFox.this.canMove()) {
                return false;
            }
            if (EntityFox.this.getRandom().nextInt(p.reducedTickDelay(10)) != 0) {
                return false;
            }
            List<EntityItem> var0 = EntityFox.this.level.getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            return !var0.isEmpty() && EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND).isEmpty();
        }

        @Override
        public void tick() {
            List<EntityItem> var0 = EntityFox.this.level.getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            ItemStack var1 = EntityFox.this.getItemBySlot(EnumItemSlot.MAINHAND);
            if (var1.isEmpty() && !var0.isEmpty()) {
                EntityFox.this.getNavigation().moveTo(var0.get(0), (double)1.2f);
            }
        }

        @Override
        public void start() {
            List<EntityItem> var0 = EntityFox.this.level.getEntitiesOfClass(EntityItem.class, EntityFox.this.getBoundingBox().inflate(8.0, 8.0, 8.0), ALLOWED_ITEMS);
            if (!var0.isEmpty()) {
                EntityFox.this.getNavigation().moveTo(var0.get(0), (double)1.2f);
            }
        }
    }

    class j
    extends PathfinderGoalLookAtPlayer {
        public j(EntityInsentient var1, Class var2, float var3) {
            super(var1, var2, var3);
        }

        @Override
        public boolean canUse() {
            return super.canUse() && !EntityFox.this.isFaceplanted() && !EntityFox.this.isInterested();
        }

        @Override
        public boolean canContinueToUse() {
            return super.canContinueToUse() && !EntityFox.this.isFaceplanted() && !EntityFox.this.isInterested();
        }
    }

    class r
    extends d {
        private double relX;
        private double relZ;
        private int lookTime;
        private int looksRemaining;

        public r() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return EntityFox.this.getLastHurtByMob() == null && EntityFox.this.getRandom().nextFloat() < 0.02f && !EntityFox.this.isSleeping() && EntityFox.this.getTarget() == null && EntityFox.this.getNavigation().isDone() && !this.alertable() && !EntityFox.this.isPouncing() && !EntityFox.this.isCrouching();
        }

        @Override
        public boolean canContinueToUse() {
            return this.looksRemaining > 0;
        }

        @Override
        public void start() {
            this.resetLook();
            this.looksRemaining = 2 + EntityFox.this.getRandom().nextInt(3);
            EntityFox.this.setSitting(true);
            EntityFox.this.getNavigation().stop();
        }

        @Override
        public void stop() {
            EntityFox.this.setSitting(false);
        }

        @Override
        public void tick() {
            --this.lookTime;
            if (this.lookTime <= 0) {
                --this.looksRemaining;
                this.resetLook();
            }
            EntityFox.this.getLookControl().setLookAt(EntityFox.this.getX() + this.relX, EntityFox.this.getEyeY(), EntityFox.this.getZ() + this.relZ, EntityFox.this.getMaxHeadYRot(), EntityFox.this.getMaxHeadXRot());
        }

        private void resetLook() {
            double var0 = Math.PI * 2 * EntityFox.this.getRandom().nextDouble();
            this.relX = Math.cos(var0);
            this.relZ = Math.sin(var0);
            this.lookTime = this.adjustedTickDelay(80 + EntityFox.this.getRandom().nextInt(20));
        }
    }

    class a
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        @Nullable
        private EntityLiving trustedLastHurtBy;
        @Nullable
        private EntityLiving trustedLastHurt;
        private int timestamp;

        public a(Class var1, boolean var2, @Nullable boolean var3, Predicate var4) {
            super(EntityFox.this, var1, 10, var2, var3, var4);
        }

        @Override
        public boolean canUse() {
            if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
                return false;
            }
            for (UUID var1 : EntityFox.this.getTrustedUUIDs()) {
                EntityLiving var3;
                Entity var2;
                if (var1 == null || !(EntityFox.this.level instanceof WorldServer) || !((var2 = ((WorldServer)EntityFox.this.level).getEntity(var1)) instanceof EntityLiving)) continue;
                this.trustedLastHurt = var3 = (EntityLiving)var2;
                this.trustedLastHurtBy = var3.getLastHurtByMob();
                int var4 = var3.getLastHurtByMobTimestamp();
                return var4 != this.timestamp && this.canAttack(this.trustedLastHurtBy, this.targetConditions);
            }
            return false;
        }

        @Override
        public void start() {
            this.setTarget(this.trustedLastHurtBy);
            this.target = this.trustedLastHurtBy;
            if (this.trustedLastHurt != null) {
                this.timestamp = this.trustedLastHurt.getLastHurtByMobTimestamp();
            }
            EntityFox.this.playSound(SoundEffects.FOX_AGGRO, 1.0f, 1.0f);
            EntityFox.this.setDefending(true);
            EntityFox.this.wakeUp();
            super.start();
        }
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type RED = new Type(0, "red");
        public static final /* enum */ Type SNOW = new Type(1, "snow");
        public static final INamable.a<Type> CODEC;
        private static final IntFunction<Type> BY_ID;
        private final int id;
        private final String name;
        private static final /* synthetic */ Type[] g;

        public static Type[] values() {
            return (Type[])g.clone();
        }

        public static Type valueOf(String var0) {
            return Enum.valueOf(Type.class, var0);
        }

        private Type(int var2, String var3) {
            this.id = var2;
            this.name = var3;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static Type byName(String var0) {
            return CODEC.byName(var0, RED);
        }

        public static Type byId(int var0) {
            return BY_ID.apply(var0);
        }

        public static Type byBiome(Holder<BiomeBase> var0) {
            return var0.is(BiomeTags.SPAWNS_SNOW_FOXES) ? SNOW : RED;
        }

        private static /* synthetic */ Type[] b() {
            return new Type[]{RED, SNOW};
        }

        static {
            g = Type.b();
            CODEC = INamable.fromEnum(Type::values);
            BY_ID = ByIdMap.continuous(Type::getId, Type.values(), ByIdMap.a.ZERO);
        }
    }

    public static class i
    extends EntityAgeable.a {
        public final Type type;

        public i(Type var0) {
            super(false);
            this.type = var0;
        }
    }

    abstract class d
    extends PathfinderGoal {
        private final PathfinderTargetCondition alertableTargeting;

        d() {
            this.alertableTargeting = PathfinderTargetCondition.forCombat().range(12.0).ignoreLineOfSight().selector(new c());
        }

        protected boolean hasShelter() {
            BlockPosition var0 = BlockPosition.containing(EntityFox.this.getX(), EntityFox.this.getBoundingBox().maxY, EntityFox.this.getZ());
            return !EntityFox.this.level.canSeeSky(var0) && EntityFox.this.getWalkTargetValue(var0) >= 0.0f;
        }

        protected boolean alertable() {
            return !EntityFox.this.level.getNearbyEntities(EntityLiving.class, this.alertableTargeting, EntityFox.this, EntityFox.this.getBoundingBox().inflate(12.0, 6.0, 12.0)).isEmpty();
        }
    }

    public class c
    implements Predicate<EntityLiving> {
        @Override
        public boolean test(EntityLiving var0) {
            if (var0 instanceof EntityFox) {
                return false;
            }
            if (var0 instanceof EntityChicken || var0 instanceof EntityRabbit || var0 instanceof EntityMonster) {
                return true;
            }
            if (var0 instanceof EntityTameableAnimal) {
                return !((EntityTameableAnimal)var0).isTame();
            }
            if (var0 instanceof EntityHuman && (var0.isSpectator() || ((EntityHuman)var0).isCreative())) {
                return false;
            }
            if (EntityFox.this.trusts(var0.getUUID())) {
                return false;
            }
            return !var0.isSleeping() && !var0.isDiscrete();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((EntityLiving)object);
        }
    }
}

