/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomStroll;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3D;

public class PathfinderGoalStrollVillage
extends PathfinderGoalRandomStroll {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;

    public PathfinderGoalStrollVillage(EntityCreature var0, double var1, boolean var3) {
        super(var0, var1, 10, var3);
    }

    @Override
    public boolean canUse() {
        WorldServer var0 = (WorldServer)this.mob.level;
        BlockPosition var1 = this.mob.blockPosition();
        if (var0.isVillage(var1)) {
            return false;
        }
        return super.canUse();
    }

    @Override
    @Nullable
    protected Vec3D getPosition() {
        WorldServer var0 = (WorldServer)this.mob.level;
        BlockPosition var1 = this.mob.blockPosition();
        SectionPosition var2 = SectionPosition.of(var1);
        SectionPosition var3 = BehaviorUtil.findSectionClosestToVillage(var0, var2, 2);
        if (var3 != var2) {
            return DefaultRandomPos.getPosTowards(this.mob, 10, 7, Vec3D.atBottomCenterOf(var3.center()), 1.5707963705062866);
        }
        return null;
    }
}

