/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.core.BlockPosition;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.ai.goal.PathfinderGoalGotoTarget;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockFurnaceFurace;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyBedPart;

public class PathfinderGoalJumpOnBlock
extends PathfinderGoalGotoTarget {
    private final EntityCat cat;

    public PathfinderGoalJumpOnBlock(EntityCat var0, double var1) {
        super(var0, var1, 8);
        this.cat = var0;
    }

    @Override
    public boolean canUse() {
        return this.cat.isTame() && !this.cat.isOrderedToSit() && super.canUse();
    }

    @Override
    public void start() {
        super.start();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void stop() {
        super.stop();
        this.cat.setInSittingPose(false);
    }

    @Override
    public void tick() {
        super.tick();
        this.cat.setInSittingPose(this.isReachedTarget());
    }

    @Override
    protected boolean isValidTarget(IWorldReader var0, BlockPosition var1) {
        if (!var0.isEmptyBlock(var1.above())) {
            return false;
        }
        IBlockData var2 = var0.getBlockState(var1);
        if (var2.is(Blocks.CHEST)) {
            return TileEntityChest.getOpenCount(var0, var1) < 1;
        }
        if (var2.is(Blocks.FURNACE) && var2.getValue(BlockFurnaceFurace.LIT).booleanValue()) {
            return true;
        }
        return var2.is(TagsBlock.BEDS, var02 -> var02.getOptionalValue(BlockBed.PART).map(var0 -> var0 != BlockPropertyBedPart.HEAD).orElse(true));
    }
}

