/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTameableAnimal;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.navigation.NavigationFlying;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;

public class PathfinderGoalFollowOwner
extends PathfinderGoal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final EntityTameableAnimal tamable;
    private EntityLiving owner;
    private final IWorldReader level;
    private final double speedModifier;
    private final NavigationAbstract navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;
    private final boolean canFly;

    public PathfinderGoalFollowOwner(EntityTameableAnimal var0, double var1, float var3, float var4, boolean var5) {
        this.tamable = var0;
        this.level = var0.level;
        this.speedModifier = var1;
        this.navigation = var0.getNavigation();
        this.startDistance = var3;
        this.stopDistance = var4;
        this.canFly = var5;
        this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        if (!(var0.getNavigation() instanceof Navigation) && !(var0.getNavigation() instanceof NavigationFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    @Override
    public boolean canUse() {
        EntityLiving var0 = this.tamable.getOwner();
        if (var0 == null) {
            return false;
        }
        if (var0.isSpectator()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tamable.distanceToSqr(var0) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = var0;
        return true;
    }

    @Override
    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        return !(this.tamable.distanceToSqr(this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.tamable.isOrderedToSit() || this.tamable.isPassenger() || this.tamable.isLeashed();
    }

    @Override
    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.tamable.getPathfindingMalus(PathType.WATER);
        this.tamable.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    @Override
    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.tamable.setPathfindingMalus(PathType.WATER, this.oldWaterCost);
    }

    @Override
    public void tick() {
        this.tamable.getLookControl().setLookAt(this.owner, 10.0f, this.tamable.getMaxHeadXRot());
        if (--this.timeToRecalcPath > 0) {
            return;
        }
        this.timeToRecalcPath = this.adjustedTickDelay(10);
        if (this.tamable.distanceToSqr(this.owner) >= 144.0) {
            this.teleportToOwner();
        } else {
            this.navigation.moveTo(this.owner, this.speedModifier);
        }
    }

    private void teleportToOwner() {
        BlockPosition var0 = this.owner.blockPosition();
        for (int var1 = 0; var1 < 10; ++var1) {
            int var2 = this.randomIntInclusive(-3, 3);
            int var3 = this.randomIntInclusive(-1, 1);
            int var4 = this.randomIntInclusive(-3, 3);
            boolean var5 = this.maybeTeleportTo(var0.getX() + var2, var0.getY() + var3, var0.getZ() + var4);
            if (!var5) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int var0, int var1, int var2) {
        if (Math.abs((double)var0 - this.owner.getX()) < 2.0 && Math.abs((double)var2 - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPosition(var0, var1, var2))) {
            return false;
        }
        this.tamable.moveTo((double)var0 + 0.5, var1, (double)var2 + 0.5, this.tamable.getYRot(), this.tamable.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPosition var0) {
        PathType var1 = PathfinderNormal.getBlockPathTypeStatic(this.level, var0.mutable());
        if (var1 != PathType.WALKABLE) {
            return false;
        }
        IBlockData var2 = this.level.getBlockState(var0.below());
        if (!this.canFly && var2.getBlock() instanceof BlockLeaves) {
            return false;
        }
        BlockPosition var3 = var0.subtract(this.tamable.blockPosition());
        return this.level.noCollision(this.tamable, this.tamable.getBoundingBox().move(var3));
    }

    private int randomIntInclusive(int var0, int var1) {
        return this.tamable.getRandom().nextInt(var1 - var0 + 1) + var0;
    }
}

