/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.ai.behavior.BehaviorWork;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.BlockComposter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class BehaviorWorkComposter
extends BehaviorWork {
    private static final List<Item> COMPOSTABLE_ITEMS = ImmutableList.of((Object)Items.WHEAT_SEEDS, (Object)Items.BEETROOT_SEEDS);

    @Override
    protected void useWorkstation(WorldServer var0, EntityVillager var1) {
        Optional<GlobalPos> var2 = var1.getBrain().getMemory(MemoryModuleType.JOB_SITE);
        if (!var2.isPresent()) {
            return;
        }
        GlobalPos var3 = var2.get();
        IBlockData var4 = var0.getBlockState(var3.pos());
        if (var4.is(Blocks.COMPOSTER)) {
            this.makeBread(var1);
            this.compostItems(var0, var1, var3, var4);
        }
    }

    private void compostItems(WorldServer var0, EntityVillager var1, GlobalPos var2, IBlockData var3) {
        BlockPosition var4 = var2.pos();
        if (var3.getValue(BlockComposter.LEVEL) == 8) {
            var3 = BlockComposter.extractProduce(var1, var3, var0, var4);
        }
        int var5 = 20;
        int var6 = 10;
        int[] var7 = new int[COMPOSTABLE_ITEMS.size()];
        InventorySubcontainer var8 = var1.getInventory();
        int var9 = var8.getContainerSize();
        IBlockData var10 = var3;
        for (int var11 = var9 - 1; var11 >= 0 && var5 > 0; --var11) {
            int var15;
            ItemStack var12 = var8.getItem(var11);
            int var13 = COMPOSTABLE_ITEMS.indexOf(var12.getItem());
            if (var13 == -1) continue;
            int var14 = var12.getCount();
            var7[var13] = var15 = var7[var13] + var14;
            int var16 = Math.min(Math.min(var15 - 10, var5), var14);
            if (var16 <= 0) continue;
            var5 -= var16;
            for (int var17 = 0; var17 < var16; ++var17) {
                if ((var10 = BlockComposter.insertItem(var1, var10, var0, var12, var4)).getValue(BlockComposter.LEVEL) != 7) continue;
                this.spawnComposterFillEffects(var0, var3, var4, var10);
                return;
            }
        }
        this.spawnComposterFillEffects(var0, var3, var4, var10);
    }

    private void spawnComposterFillEffects(WorldServer var0, IBlockData var1, BlockPosition var2, IBlockData var3) {
        var0.levelEvent(1500, var2, var3 != var1 ? 1 : 0);
    }

    private void makeBread(EntityVillager var0) {
        InventorySubcontainer var1 = var0.getInventory();
        if (var1.countItem(Items.BREAD) > 36) {
            return;
        }
        int var2 = var1.countItem(Items.WHEAT);
        int var3 = 3;
        int var4 = 3;
        int var5 = Math.min(3, var2 / 3);
        if (var5 == 0) {
            return;
        }
        int var6 = var5 * 3;
        var1.removeItemType(Items.WHEAT, var6);
        ItemStack var7 = var1.addItem(new ItemStack(Items.BREAD, var5));
        if (!var7.isEmpty()) {
            var0.spawnAtLocation(var7, 0.5f);
        }
    }
}

