/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import java.util.Comparator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorPosition;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemProjectileWeapon;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.Vec3D;

public class BehaviorUtil {
    private BehaviorUtil() {
    }

    public static void lockGazeAndWalkToEachOther(EntityLiving var0, EntityLiving var1, float var2) {
        BehaviorUtil.lookAtEachOther(var0, var1);
        BehaviorUtil.setWalkAndLookTargetMemoriesToEachOther(var0, var1, var2);
    }

    public static boolean entityIsVisible(BehaviorController<?> var0, EntityLiving var1) {
        Optional<NearestVisibleLivingEntities> var2 = var0.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
        return var2.isPresent() && var2.get().contains(var1);
    }

    public static boolean targetIsValid(BehaviorController<?> var0, MemoryModuleType<? extends EntityLiving> var12, EntityTypes<?> var2) {
        return BehaviorUtil.targetIsValid(var0, var12, (EntityLiving var1) -> var1.getType() == var2);
    }

    private static boolean targetIsValid(BehaviorController<?> var0, MemoryModuleType<? extends EntityLiving> var12, Predicate<EntityLiving> var2) {
        return var0.getMemory(var12).filter(var2).filter(EntityLiving::isAlive).filter(var1 -> BehaviorUtil.entityIsVisible(var0, var1)).isPresent();
    }

    private static void lookAtEachOther(EntityLiving var0, EntityLiving var1) {
        BehaviorUtil.lookAtEntity(var0, var1);
        BehaviorUtil.lookAtEntity(var1, var0);
    }

    public static void lookAtEntity(EntityLiving var0, EntityLiving var1) {
        var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var1, true));
    }

    private static void setWalkAndLookTargetMemoriesToEachOther(EntityLiving var0, EntityLiving var1, float var2) {
        int var3 = 2;
        BehaviorUtil.setWalkAndLookTargetMemories(var0, var1, var2, 2);
        BehaviorUtil.setWalkAndLookTargetMemories(var1, var0, var2, 2);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving var0, Entity var1, float var2, int var3) {
        BehaviorUtil.setWalkAndLookTargetMemories(var0, new BehaviorPositionEntity(var1, true), var2, var3);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving var0, BlockPosition var1, float var2, int var3) {
        BehaviorUtil.setWalkAndLookTargetMemories(var0, new BehaviorTarget(var1), var2, var3);
    }

    public static void setWalkAndLookTargetMemories(EntityLiving var0, BehaviorPosition var1, float var2, int var3) {
        MemoryTarget var4 = new MemoryTarget(var1, var2, var3);
        var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, var1);
        var0.getBrain().setMemory(MemoryModuleType.WALK_TARGET, var4);
    }

    public static void throwItem(EntityLiving var0, ItemStack var1, Vec3D var2) {
        Vec3D var3 = new Vec3D(0.3f, 0.3f, 0.3f);
        BehaviorUtil.throwItem(var0, var1, var2, var3, 0.3f);
    }

    public static void throwItem(EntityLiving var0, ItemStack var1, Vec3D var2, Vec3D var3, float var4) {
        double var5 = var0.getEyeY() - (double)var4;
        EntityItem var7 = new EntityItem(var0.level, var0.getX(), var5, var0.getZ(), var1);
        var7.setThrower(var0.getUUID());
        Vec3D var8 = var2.subtract(var0.position());
        var8 = var8.normalize().multiply(var3.x, var3.y, var3.z);
        var7.setDeltaMovement(var8);
        var7.setDefaultPickUpDelay();
        var0.level.addFreshEntity(var7);
    }

    public static SectionPosition findSectionClosestToVillage(WorldServer var0, SectionPosition var1, int var22) {
        int var3 = var0.sectionsToVillage(var1);
        return SectionPosition.cube(var1, var22).filter(var2 -> var0.sectionsToVillage((SectionPosition)var2) < var3).min(Comparator.comparingInt(var0::sectionsToVillage)).orElse(var1);
    }

    public static boolean isWithinAttackRange(EntityInsentient var0, EntityLiving var1, int var2) {
        ItemProjectileWeapon var3;
        Item item = var0.getMainHandItem().getItem();
        if (item instanceof ItemProjectileWeapon && var0.canFireProjectileWeapon(var3 = (ItemProjectileWeapon)item)) {
            int var4 = var3.getDefaultProjectileRange() - var2;
            return var0.closerThan(var1, var4);
        }
        return var0.isWithinMeleeAttackRange(var1);
    }

    public static boolean isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(EntityLiving var0, EntityLiving var1, double var2) {
        Optional<EntityLiving> var4 = var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET);
        if (var4.isEmpty()) {
            return false;
        }
        double var5 = var0.distanceToSqr(var4.get().position());
        double var7 = var0.distanceToSqr(var1.position());
        return var7 > var5 + var2 * var2;
    }

    public static boolean canSee(EntityLiving var0, EntityLiving var1) {
        BehaviorController<NearestVisibleLivingEntities> var2 = var0.getBrain();
        if (!var2.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)) {
            return false;
        }
        return var2.getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).get().contains(var1);
    }

    public static EntityLiving getNearestTarget(EntityLiving var0, Optional<EntityLiving> var1, EntityLiving var2) {
        if (var1.isEmpty()) {
            return var2;
        }
        return BehaviorUtil.getTargetNearestMe(var0, var1.get(), var2);
    }

    public static EntityLiving getTargetNearestMe(EntityLiving var0, EntityLiving var1, EntityLiving var2) {
        Vec3D var3 = var1.position();
        Vec3D var4 = var2.position();
        return var0.distanceToSqr(var3) < var0.distanceToSqr(var4) ? var1 : var2;
    }

    public static Optional<EntityLiving> getLivingEntityFromUUIDMemory(EntityLiving var02, MemoryModuleType<UUID> var12) {
        Optional<UUID> var2 = var02.getBrain().getMemory(var12);
        return var2.map(var1 -> ((WorldServer)var0.level).getEntity((UUID)var1)).map(var0 -> {
            EntityLiving var1;
            return var0 instanceof EntityLiving ? (var1 = (EntityLiving)var0) : null;
        });
    }

    @Nullable
    public static Vec3D getRandomSwimmablePos(EntityCreature var0, int var1, int var2) {
        Vec3D var3 = DefaultRandomPos.getPos(var0, var1, var2);
        int var4 = 0;
        while (var3 != null && !var0.level.getBlockState(BlockPosition.containing(var3)).isPathfindable(var0.level, BlockPosition.containing(var3), PathMode.WATER) && var4++ < 10) {
            var3 = DefaultRandomPos.getPos(var0, var1, var2);
        }
        return var3;
    }

    public static boolean isBreeding(EntityLiving var0) {
        return var0.getBrain().hasMemoryValue(MemoryModuleType.BREED_TARGET);
    }
}

