/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3D;

public class BehaviorStrollRandomUnconstrained {
    private static final int MAX_XZ_DIST = 10;
    private static final int MAX_Y_DIST = 7;
    private static final int[][] SWIM_XY_DISTANCE_TIERS = new int[][]{{1, 1}, {3, 3}, {5, 5}, {6, 5}, {7, 7}, {10, 7}};

    public static OneShot<EntityCreature> stroll(float var0) {
        return BehaviorStrollRandomUnconstrained.stroll(var0, true);
    }

    public static OneShot<EntityCreature> stroll(float var02, boolean var1) {
        return BehaviorStrollRandomUnconstrained.strollFlyOrSwim(var02, var0 -> LandRandomPos.getPos(var0, 10, 7), var1 ? var0 -> true : var0 -> !var0.isInWaterOrBubble());
    }

    public static BehaviorControl<EntityCreature> stroll(float var02, int var1, int var22) {
        return BehaviorStrollRandomUnconstrained.strollFlyOrSwim(var02, var2 -> LandRandomPos.getPos(var2, var1, var22), var0 -> true);
    }

    public static BehaviorControl<EntityCreature> fly(float var02) {
        return BehaviorStrollRandomUnconstrained.strollFlyOrSwim(var02, var0 -> BehaviorStrollRandomUnconstrained.getTargetFlyPos(var0, 10, 7), var0 -> true);
    }

    public static BehaviorControl<EntityCreature> swim(float var0) {
        return BehaviorStrollRandomUnconstrained.strollFlyOrSwim(var0, BehaviorStrollRandomUnconstrained::getTargetSwimPos, Entity::isInWaterOrBubble);
    }

    private static OneShot<EntityCreature> strollFlyOrSwim(float var0, Function<EntityCreature, Vec3D> var1, Predicate<EntityCreature> var2) {
        return BehaviorBuilder.create(var32 -> var32.group(var32.absent(MemoryModuleType.WALK_TARGET)).apply((Applicative)var32, var3 -> (var4, var5, var6) -> {
            if (!var2.test((EntityCreature)var5)) {
                return false;
            }
            Optional<Vec3D> var8 = Optional.ofNullable((Vec3D)var1.apply((EntityCreature)var5));
            var3.setOrErase(var8.map(var1 -> new MemoryTarget((Vec3D)var1, var0, 0)));
            return true;
        }));
    }

    @Nullable
    private static Vec3D getTargetSwimPos(EntityCreature var0) {
        Vec3D var1 = null;
        Vec3D var2 = null;
        for (int[] var6 : SWIM_XY_DISTANCE_TIERS) {
            var2 = var1 == null ? BehaviorUtil.getRandomSwimmablePos(var0, var6[0], var6[1]) : var0.position().add(var0.position().vectorTo(var1).normalize().multiply(var6[0], var6[1], var6[0]));
            if (var2 == null || var0.level.getFluidState(BlockPosition.containing(var2)).isEmpty()) {
                return var1;
            }
            var1 = var2;
        }
        return var2;
    }

    @Nullable
    private static Vec3D getTargetFlyPos(EntityCreature var0, int var1, int var2) {
        Vec3D var3 = var0.getViewVector(0.0f);
        return AirAndWaterRandomPos.getPos(var0, var1, var2, -2, var3.x, var3.z, 1.5707963705062866);
    }
}

