/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.phys.Vec3D;

public class AnimalPanic
extends Behavior<EntityCreature> {
    private static final int PANIC_MIN_DURATION = 100;
    private static final int PANIC_MAX_DURATION = 120;
    private static final int PANIC_DISTANCE_HORIZONTAL = 5;
    private static final int PANIC_DISTANCE_VERTICAL = 4;
    private static final Predicate<EntityCreature> DEFAULT_SHOULD_PANIC_PREDICATE = var0 -> var0.getLastHurtByMob() != null || var0.isFreezing() || var0.isOnFire();
    private final float speedMultiplier;
    private final Predicate<EntityCreature> shouldPanic;

    public AnimalPanic(float var0) {
        this(var0, DEFAULT_SHOULD_PANIC_PREDICATE);
    }

    public AnimalPanic(float var0, Predicate<EntityCreature> var1) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.IS_PANICKING, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.HURT_BY, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 100, 120);
        this.speedMultiplier = var0;
        this.shouldPanic = var1;
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityCreature var1) {
        return this.shouldPanic.test(var1);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityCreature var1, long var2) {
        return true;
    }

    @Override
    protected void start(WorldServer var0, EntityCreature var1, long var2) {
        var1.getBrain().setMemory(MemoryModuleType.IS_PANICKING, true);
        var1.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }

    @Override
    protected void stop(WorldServer var0, EntityCreature var1, long var2) {
        BehaviorController<?> var4 = var1.getBrain();
        var4.eraseMemory(MemoryModuleType.IS_PANICKING);
    }

    @Override
    protected void tick(WorldServer var0, EntityCreature var1, long var2) {
        Vec3D var4;
        if (var1.getNavigation().isDone() && (var4 = this.getPanicPos(var1, var0)) != null) {
            var1.getBrain().setMemory(MemoryModuleType.WALK_TARGET, new MemoryTarget(var4, this.speedMultiplier, 0));
        }
    }

    @Nullable
    private Vec3D getPanicPos(EntityCreature var0, WorldServer var1) {
        Optional<Vec3D> var2;
        if (var0.isOnFire() && (var2 = this.lookForWater(var1, var0).map(Vec3D::atBottomCenterOf)).isPresent()) {
            return var2.get();
        }
        return LandRandomPos.getPos(var0, 5, 4);
    }

    private Optional<BlockPosition> lookForWater(IBlockAccess var0, Entity var12) {
        BlockPosition var2 = var12.blockPosition();
        if (!var0.getBlockState(var2).getCollisionShape(var0, var2).isEmpty()) {
            return Optional.empty();
        }
        return BlockPosition.findClosestMatch(var2, 5, 1, var1 -> var0.getFluidState((BlockPosition)var1).is(TagsFluid.WATER));
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (EntityCreature)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityCreature)entityLiving, l2);
    }
}

