/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.math.Transformation;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.util.Brightness;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.FormattedString;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.phys.AxisAlignedBB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.slf4j.Logger;

public abstract class Display
extends Entity {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final float INITIAL_UPDATE_PROGRESS = Float.POSITIVE_INFINITY;
    public static final int NO_BRIGHTNESS_OVERRIDE = -1;
    private static final DataWatcherObject<Integer> DATA_INTERPOLATION_START_DELTA_TICKS_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Integer> DATA_INTERPOLATION_DURATION_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Vector3f> DATA_TRANSLATION_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.VECTOR3);
    private static final DataWatcherObject<Vector3f> DATA_SCALE_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.VECTOR3);
    private static final DataWatcherObject<Quaternionf> DATA_LEFT_ROTATION_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.QUATERNION);
    private static final DataWatcherObject<Quaternionf> DATA_RIGHT_ROTATION_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.QUATERNION);
    private static final DataWatcherObject<Byte> DATA_BILLBOARD_RENDER_CONSTRAINTS_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.BYTE);
    private static final DataWatcherObject<Integer> DATA_BRIGHTNESS_OVERRIDE_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Float> DATA_VIEW_RANGE_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_SHADOW_RADIUS_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_SHADOW_STRENGTH_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_WIDTH_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Float> DATA_HEIGHT_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Integer> DATA_GLOW_COLOR_OVERRIDE_ID = DataWatcher.defineId(Display.class, DataWatcherRegistry.INT);
    private static final float INITIAL_SHADOW_RADIUS = 0.0f;
    private static final float INITIAL_SHADOW_STRENGTH = 1.0f;
    private static final int NO_GLOW_COLOR_OVERRIDE = -1;
    public static final String TAG_INTERPOLATION_DURATION = "interpolation_duration";
    public static final String TAG_START_INTERPOLATION = "start_interpolation";
    public static final String TAG_TRANSFORMATION = "transformation";
    public static final String TAG_BILLBOARD = "billboard";
    public static final String TAG_BRIGHTNESS = "brightness";
    public static final String TAG_VIEW_RANGE = "view_range";
    public static final String TAG_SHADOW_RADIUS = "shadow_radius";
    public static final String TAG_SHADOW_STRENGTH = "shadow_strength";
    public static final String TAG_WIDTH = "width";
    public static final String TAG_HEIGHT = "height";
    public static final String TAG_GLOW_COLOR_OVERRIDE = "glow_color_override";
    private final GenericInterpolator<Transformation> transformation = new GenericInterpolator<Transformation>(Transformation.identity()){

        @Override
        protected Transformation interpolate(float var0, Transformation var1, Transformation var2) {
            return var1.slerp(var2, var0);
        }
    };
    private final FloatInterpolator shadowRadius = new FloatInterpolator(0.0f);
    private final FloatInterpolator shadowStrength = new FloatInterpolator(1.0f);
    private final Quaternionf orientation = new Quaternionf();
    protected final InterpolatorSet interpolators = new InterpolatorSet();
    private long interpolationStartClientTick;
    private float lastProgress;
    private AxisAlignedBB cullingBoundingBox;
    private boolean updateInterpolators;
    private boolean updateTime;

    public Display(EntityTypes<?> var02, World var12) {
        super(var02, var12);
        this.noPhysics = true;
        this.noCulling = true;
        this.cullingBoundingBox = this.getBoundingBox();
        this.interpolators.addEntry(Set.of(DATA_TRANSLATION_ID, DATA_LEFT_ROTATION_ID, DATA_SCALE_ID, DATA_RIGHT_ROTATION_ID), (var0, var1) -> this.transformation.updateValue(var0, Display.createTransformation(var1)));
        this.interpolators.addEntry(DATA_SHADOW_STRENGTH_ID, this.shadowStrength);
        this.interpolators.addEntry(DATA_SHADOW_RADIUS_ID, this.shadowRadius);
    }

    @Override
    public void onSyncedDataUpdated(List<DataWatcher.b<?>> var0) {
        super.onSyncedDataUpdated(var0);
        boolean var1 = false;
        for (DataWatcher.b<?> var3 : var0) {
            var1 |= this.interpolators.shouldTriggerUpdate(var3.id());
        }
        if (var1) {
            boolean var2;
            boolean bl = var2 = this.tickCount <= 0;
            if (var2) {
                this.interpolators.updateValues(Float.POSITIVE_INFINITY, this.entityData);
            } else {
                this.updateInterpolators = true;
            }
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        super.onSyncedDataUpdated(var0);
        if (DATA_HEIGHT_ID.equals(var0) || DATA_WIDTH_ID.equals(var0)) {
            this.updateCulling();
        }
        if (DATA_INTERPOLATION_START_DELTA_TICKS_ID.equals(var0)) {
            this.updateTime = true;
        }
    }

    public static Transformation createTransformation(DataWatcher var0) {
        Vector3f var1 = var0.get(DATA_TRANSLATION_ID);
        Quaternionf var2 = var0.get(DATA_LEFT_ROTATION_ID);
        Vector3f var3 = var0.get(DATA_SCALE_ID);
        Quaternionf var4 = var0.get(DATA_RIGHT_ROTATION_ID);
        return new Transformation(var1, var2, var3, var4);
    }

    @Override
    public void tick() {
        Entity var0 = this.getVehicle();
        if (var0 != null && var0.isRemoved()) {
            this.stopRiding();
        }
        if (this.level.isClientSide) {
            if (this.updateTime) {
                this.updateTime = false;
                int var1 = this.getInterpolationDelay();
                this.interpolationStartClientTick = this.tickCount + var1;
            }
            if (this.updateInterpolators) {
                this.updateInterpolators = false;
                this.interpolators.updateValues(this.lastProgress, this.entityData);
            }
        }
    }

    @Override
    protected void defineSynchedData() {
        this.entityData.define(DATA_INTERPOLATION_START_DELTA_TICKS_ID, 0);
        this.entityData.define(DATA_INTERPOLATION_DURATION_ID, 0);
        this.entityData.define(DATA_TRANSLATION_ID, new Vector3f());
        this.entityData.define(DATA_SCALE_ID, new Vector3f(1.0f, 1.0f, 1.0f));
        this.entityData.define(DATA_RIGHT_ROTATION_ID, new Quaternionf());
        this.entityData.define(DATA_LEFT_ROTATION_ID, new Quaternionf());
        this.entityData.define(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, BillboardConstraints.FIXED.getId());
        this.entityData.define(DATA_BRIGHTNESS_OVERRIDE_ID, -1);
        this.entityData.define(DATA_VIEW_RANGE_ID, Float.valueOf(1.0f));
        this.entityData.define(DATA_SHADOW_RADIUS_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_SHADOW_STRENGTH_ID, Float.valueOf(1.0f));
        this.entityData.define(DATA_WIDTH_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_HEIGHT_ID, Float.valueOf(0.0f));
        this.entityData.define(DATA_GLOW_COLOR_OVERRIDE_ID, -1);
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var02) {
        int var1;
        if (var02.contains(TAG_TRANSFORMATION)) {
            Transformation.EXTENDED_CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_TRANSFORMATION)).resultOrPartial(SystemUtils.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> this.setTransformation((Transformation)var0.getFirst()));
        }
        if (var02.contains(TAG_INTERPOLATION_DURATION, 99)) {
            var1 = var02.getInt(TAG_INTERPOLATION_DURATION);
            this.setInterpolationDuration(var1);
        }
        if (var02.contains(TAG_START_INTERPOLATION, 99)) {
            var1 = var02.getInt(TAG_START_INTERPOLATION);
            this.setInterpolationDelay(var1);
        }
        if (var02.contains(TAG_BILLBOARD, 8)) {
            BillboardConstraints.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_BILLBOARD)).resultOrPartial(SystemUtils.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> this.setBillboardConstraints((BillboardConstraints)var0.getFirst()));
        }
        if (var02.contains(TAG_VIEW_RANGE, 99)) {
            this.setViewRange(var02.getFloat(TAG_VIEW_RANGE));
        }
        if (var02.contains(TAG_SHADOW_RADIUS, 99)) {
            this.setShadowRadius(var02.getFloat(TAG_SHADOW_RADIUS));
        }
        if (var02.contains(TAG_SHADOW_STRENGTH, 99)) {
            this.setShadowStrength(var02.getFloat(TAG_SHADOW_STRENGTH));
        }
        if (var02.contains(TAG_WIDTH, 99)) {
            this.setWidth(var02.getFloat(TAG_WIDTH));
        }
        if (var02.contains(TAG_HEIGHT, 99)) {
            this.setHeight(var02.getFloat(TAG_HEIGHT));
        }
        if (var02.contains(TAG_GLOW_COLOR_OVERRIDE, 99)) {
            this.setGlowColorOverride(var02.getInt(TAG_GLOW_COLOR_OVERRIDE));
        }
        if (var02.contains(TAG_BRIGHTNESS, 10)) {
            Brightness.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_BRIGHTNESS)).resultOrPartial(SystemUtils.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> this.setBrightnessOverride((Brightness)var0.getFirst()));
        } else {
            this.setBrightnessOverride(null);
        }
    }

    public void setTransformation(Transformation var0) {
        this.entityData.set(DATA_TRANSLATION_ID, var0.getTranslation());
        this.entityData.set(DATA_LEFT_ROTATION_ID, var0.getLeftRotation());
        this.entityData.set(DATA_SCALE_ID, var0.getScale());
        this.entityData.set(DATA_RIGHT_ROTATION_ID, var0.getRightRotation());
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        Transformation.EXTENDED_CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)Display.createTransformation(this.entityData)).result().ifPresent(var1 -> var0.put(TAG_TRANSFORMATION, (NBTBase)var1));
        BillboardConstraints.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.getBillboardConstraints()).result().ifPresent(var1 -> var0.put(TAG_BILLBOARD, (NBTBase)var1));
        var0.putInt(TAG_INTERPOLATION_DURATION, this.getInterpolationDuration());
        var0.putFloat(TAG_VIEW_RANGE, this.getViewRange());
        var0.putFloat(TAG_SHADOW_RADIUS, this.getShadowRadius());
        var0.putFloat(TAG_SHADOW_STRENGTH, this.getShadowStrength());
        var0.putFloat(TAG_WIDTH, this.getWidth());
        var0.putFloat(TAG_HEIGHT, this.getHeight());
        var0.putInt(TAG_GLOW_COLOR_OVERRIDE, this.getGlowColorOverride());
        Brightness var12 = this.getBrightnessOverride();
        if (var12 != null) {
            Brightness.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var12).result().ifPresent(var1 -> var0.put(TAG_BRIGHTNESS, (NBTBase)var1));
        }
    }

    @Override
    public Packet<PacketListenerPlayOut> getAddEntityPacket() {
        return new PacketPlayOutSpawnEntity(this);
    }

    @Override
    public AxisAlignedBB getBoundingBoxForCulling() {
        return this.cullingBoundingBox;
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    public Quaternionf orientation() {
        return this.orientation;
    }

    public Transformation transformation(float var0) {
        return this.transformation.get(var0);
    }

    public void setInterpolationDuration(int var0) {
        this.entityData.set(DATA_INTERPOLATION_DURATION_ID, var0);
    }

    public int getInterpolationDuration() {
        return this.entityData.get(DATA_INTERPOLATION_DURATION_ID);
    }

    public void setInterpolationDelay(int var0) {
        this.entityData.set(DATA_INTERPOLATION_START_DELTA_TICKS_ID, var0, true);
    }

    public int getInterpolationDelay() {
        return this.entityData.get(DATA_INTERPOLATION_START_DELTA_TICKS_ID);
    }

    public void setBillboardConstraints(BillboardConstraints var0) {
        this.entityData.set(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID, var0.getId());
    }

    public BillboardConstraints getBillboardConstraints() {
        return BillboardConstraints.BY_ID.apply(this.entityData.get(DATA_BILLBOARD_RENDER_CONSTRAINTS_ID).byteValue());
    }

    public void setBrightnessOverride(@Nullable Brightness var0) {
        this.entityData.set(DATA_BRIGHTNESS_OVERRIDE_ID, var0 != null ? var0.pack() : -1);
    }

    @Nullable
    public Brightness getBrightnessOverride() {
        int var0 = this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
        return var0 != -1 ? Brightness.unpack(var0) : null;
    }

    public int getPackedBrightnessOverride() {
        return this.entityData.get(DATA_BRIGHTNESS_OVERRIDE_ID);
    }

    public void setViewRange(float var0) {
        this.entityData.set(DATA_VIEW_RANGE_ID, Float.valueOf(var0));
    }

    public float getViewRange() {
        return this.entityData.get(DATA_VIEW_RANGE_ID).floatValue();
    }

    public void setShadowRadius(float var0) {
        this.entityData.set(DATA_SHADOW_RADIUS_ID, Float.valueOf(var0));
    }

    public float getShadowRadius() {
        return this.entityData.get(DATA_SHADOW_RADIUS_ID).floatValue();
    }

    public float getShadowRadius(float var0) {
        return this.shadowRadius.get(var0);
    }

    public void setShadowStrength(float var0) {
        this.entityData.set(DATA_SHADOW_STRENGTH_ID, Float.valueOf(var0));
    }

    public float getShadowStrength() {
        return this.entityData.get(DATA_SHADOW_STRENGTH_ID).floatValue();
    }

    public float getShadowStrength(float var0) {
        return this.shadowStrength.get(var0);
    }

    public void setWidth(float var0) {
        this.entityData.set(DATA_WIDTH_ID, Float.valueOf(var0));
    }

    public float getWidth() {
        return this.entityData.get(DATA_WIDTH_ID).floatValue();
    }

    public void setHeight(float var0) {
        this.entityData.set(DATA_HEIGHT_ID, Float.valueOf(var0));
    }

    public int getGlowColorOverride() {
        return this.entityData.get(DATA_GLOW_COLOR_OVERRIDE_ID);
    }

    public void setGlowColorOverride(int var0) {
        this.entityData.set(DATA_GLOW_COLOR_OVERRIDE_ID, var0);
    }

    public float calculateInterpolationProgress(float var0) {
        float var4;
        int var1 = this.getInterpolationDuration();
        if (var1 <= 0) {
            return 1.0f;
        }
        float var2 = (long)this.tickCount - this.interpolationStartClientTick;
        float var3 = var2 + var0;
        this.lastProgress = var4 = MathHelper.clamp(MathHelper.inverseLerp(var3, 0.0f, var1), 0.0f, 1.0f);
        return var4;
    }

    public float getHeight() {
        return this.entityData.get(DATA_HEIGHT_ID).floatValue();
    }

    @Override
    public void setPos(double var0, double var2, double var4) {
        super.setPos(var0, var2, var4);
        this.updateCulling();
    }

    private void updateCulling() {
        float var0 = this.getWidth();
        float var1 = this.getHeight();
        if (var0 == 0.0f || var1 == 0.0f) {
            this.noCulling = true;
        } else {
            this.noCulling = false;
            float var2 = var0 / 2.0f;
            double var3 = this.getX();
            double var5 = this.getY();
            double var7 = this.getZ();
            this.cullingBoundingBox = new AxisAlignedBB(var3 - (double)var2, var5, var7 - (double)var2, var3 + (double)var2, var5 + (double)var1, var7 + (double)var2);
        }
    }

    @Override
    public void setXRot(float var0) {
        super.setXRot(var0);
        this.updateOrientation();
    }

    @Override
    public void setYRot(float var0) {
        super.setYRot(var0);
        this.updateOrientation();
    }

    private void updateOrientation() {
        this.orientation.rotationYXZ((float)(-Math.PI) / 180 * this.getYRot(), (float)Math.PI / 180 * this.getXRot(), 0.0f);
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        return var0 < MathHelper.square((double)this.getViewRange() * 64.0 * Display.getViewScale());
    }

    @Override
    public int getTeamColor() {
        int var0 = this.getGlowColorOverride();
        return var0 != -1 ? var0 : super.getTeamColor();
    }

    static abstract class GenericInterpolator<T>
    extends Interpolator<T> {
        protected GenericInterpolator(T var0) {
            super(var0);
        }

        protected abstract T interpolate(float var1, T var2, T var3);

        public T get(float var0) {
            if ((double)var0 >= 1.0 || this.lastValue == null) {
                return (T)this.currentValue;
            }
            return (T)this.interpolate(var0, this.lastValue, this.currentValue);
        }

        @Override
        protected T getGeneric(float var0) {
            return this.get(var0);
        }
    }

    static class FloatInterpolator
    extends Interpolator<Float> {
        protected FloatInterpolator(float var0) {
            super(Float.valueOf(var0));
        }

        protected float interpolate(float var0, float var1, float var2) {
            return MathHelper.lerp(var0, var1, var2);
        }

        public float get(float var0) {
            if ((double)var0 >= 1.0 || this.lastValue == null) {
                return ((Float)this.currentValue).floatValue();
            }
            return this.interpolate(var0, ((Float)this.lastValue).floatValue(), ((Float)this.currentValue).floatValue());
        }

        @Override
        protected Float getGeneric(float var0) {
            return Float.valueOf(this.get(var0));
        }

        @Override
        protected /* synthetic */ Object getGeneric(float f2) {
            return this.getGeneric(f2);
        }
    }

    static class InterpolatorSet {
        private final IntSet interpolatedData = new IntOpenHashSet();
        private final List<IntepolatorUpdater> updaters = new ArrayList<IntepolatorUpdater>();

        InterpolatorSet() {
        }

        protected <T> void addEntry(DataWatcherObject<T> var0, Interpolator<T> var1) {
            this.interpolatedData.add(var0.getId());
            this.updaters.add((var2, var3) -> var1.updateValue(var2, var3.get(var0)));
        }

        protected void addEntry(Set<DataWatcherObject<?>> var0, IntepolatorUpdater var1) {
            for (DataWatcherObject<?> var3 : var0) {
                this.interpolatedData.add(var3.getId());
            }
            this.updaters.add(var1);
        }

        public boolean shouldTriggerUpdate(int var0) {
            return this.interpolatedData.contains(var0);
        }

        public void updateValues(float var0, DataWatcher var1) {
            for (IntepolatorUpdater var3 : this.updaters) {
                var3.update(var0, var1);
            }
        }
    }

    @FunctionalInterface
    static interface IntepolatorUpdater {
        public void update(float var1, DataWatcher var2);
    }

    static abstract class Interpolator<T> {
        @Nullable
        protected T lastValue;
        protected T currentValue;

        protected Interpolator(T var0) {
            this.currentValue = var0;
        }

        protected abstract T getGeneric(float var1);

        public void updateValue(float var0, T var1) {
            if (var0 != Float.POSITIVE_INFINITY) {
                this.lastValue = this.getGeneric(var0);
            }
            this.currentValue = var1;
        }
    }

    public static final class BillboardConstraints
    extends Enum<BillboardConstraints>
    implements INamable {
        public static final /* enum */ BillboardConstraints FIXED = new BillboardConstraints(0, "fixed");
        public static final /* enum */ BillboardConstraints VERTICAL = new BillboardConstraints(1, "vertical");
        public static final /* enum */ BillboardConstraints HORIZONTAL = new BillboardConstraints(2, "horizontal");
        public static final /* enum */ BillboardConstraints CENTER = new BillboardConstraints(3, "center");
        public static final Codec<BillboardConstraints> CODEC;
        public static final IntFunction<BillboardConstraints> BY_ID;
        private final byte id;
        private final String name;
        private static final /* synthetic */ BillboardConstraints[] i;

        public static BillboardConstraints[] values() {
            return (BillboardConstraints[])i.clone();
        }

        public static BillboardConstraints valueOf(String var0) {
            return Enum.valueOf(BillboardConstraints.class, var0);
        }

        private BillboardConstraints(byte var2, String var3) {
            this.name = var3;
            this.id = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        byte getId() {
            return this.id;
        }

        private static /* synthetic */ BillboardConstraints[] b() {
            return new BillboardConstraints[]{FIXED, VERTICAL, HORIZONTAL, CENTER};
        }

        static {
            i = BillboardConstraints.b();
            CODEC = INamable.fromEnum(BillboardConstraints::values);
            BY_ID = ByIdMap.continuous(BillboardConstraints::getId, BillboardConstraints.values(), ByIdMap.a.ZERO);
        }
    }

    static class ColorInterpolator
    extends IntInterpolator {
        protected ColorInterpolator(int var0) {
            super(var0);
        }

        @Override
        protected int interpolate(float var0, int var1, int var2) {
            return ColorUtil.b.lerp(var0, var1, var2);
        }
    }

    static class IntInterpolator
    extends Interpolator<Integer> {
        protected IntInterpolator(int var0) {
            super(var0);
        }

        protected int interpolate(float var0, int var1, int var2) {
            return MathHelper.lerpInt(var0, var1, var2);
        }

        public int get(float var0) {
            if ((double)var0 >= 1.0 || this.lastValue == null) {
                return (Integer)this.currentValue;
            }
            return this.interpolate(var0, (Integer)this.lastValue, (Integer)this.currentValue);
        }

        @Override
        protected Integer getGeneric(float var0) {
            return this.get(var0);
        }

        @Override
        protected /* synthetic */ Object getGeneric(float f2) {
            return this.getGeneric(f2);
        }
    }

    public static class TextDisplay
    extends Display {
        public static final String TAG_TEXT = "text";
        private static final String TAG_LINE_WIDTH = "line_width";
        private static final String TAG_TEXT_OPACITY = "text_opacity";
        private static final String TAG_BACKGROUND_COLOR = "background";
        private static final String TAG_SHADOW = "shadow";
        private static final String TAG_SEE_THROUGH = "see_through";
        private static final String TAG_USE_DEFAULT_BACKGROUND = "default_background";
        private static final String TAG_ALIGNMENT = "alignment";
        public static final byte FLAG_SHADOW = 1;
        public static final byte FLAG_SEE_THROUGH = 2;
        public static final byte FLAG_USE_DEFAULT_BACKGROUND = 4;
        public static final byte FLAG_ALIGN_LEFT = 8;
        public static final byte FLAG_ALIGN_RIGHT = 16;
        private static final byte INITIAL_TEXT_OPACITY = -1;
        public static final int INITIAL_BACKGROUND = 0x40000000;
        private static final DataWatcherObject<IChatBaseComponent> DATA_TEXT_ID = DataWatcher.defineId(TextDisplay.class, DataWatcherRegistry.COMPONENT);
        private static final DataWatcherObject<Integer> DATA_LINE_WIDTH_ID = DataWatcher.defineId(TextDisplay.class, DataWatcherRegistry.INT);
        private static final DataWatcherObject<Integer> DATA_BACKGROUND_COLOR_ID = DataWatcher.defineId(TextDisplay.class, DataWatcherRegistry.INT);
        private static final DataWatcherObject<Byte> DATA_TEXT_OPACITY_ID = DataWatcher.defineId(TextDisplay.class, DataWatcherRegistry.BYTE);
        private static final DataWatcherObject<Byte> DATA_STYLE_FLAGS_ID = DataWatcher.defineId(TextDisplay.class, DataWatcherRegistry.BYTE);
        private final IntInterpolator textOpacity = new IntInterpolator(-1);
        private final IntInterpolator backgroundColor = new ColorInterpolator(0x40000000);
        @Nullable
        private CachedInfo clientDisplayCache;

        public TextDisplay(EntityTypes<?> var02, World var12) {
            super(var02, var12);
            this.interpolators.addEntry(DATA_BACKGROUND_COLOR_ID, this.backgroundColor);
            this.interpolators.addEntry(Set.of(DATA_TEXT_OPACITY_ID), (var0, var1) -> this.textOpacity.updateValue(var0, var1.get(DATA_TEXT_OPACITY_ID) & 0xFF));
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_TEXT_ID, IChatBaseComponent.empty());
            this.entityData.define(DATA_LINE_WIDTH_ID, 200);
            this.entityData.define(DATA_BACKGROUND_COLOR_ID, 0x40000000);
            this.entityData.define(DATA_TEXT_OPACITY_ID, (byte)-1);
            this.entityData.define(DATA_STYLE_FLAGS_ID, (byte)0);
        }

        @Override
        public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
            super.onSyncedDataUpdated(var0);
            this.clientDisplayCache = null;
        }

        public IChatBaseComponent getText() {
            return this.entityData.get(DATA_TEXT_ID);
        }

        public void setText(IChatBaseComponent var0) {
            this.entityData.set(DATA_TEXT_ID, var0);
        }

        public int getLineWidth() {
            return this.entityData.get(DATA_LINE_WIDTH_ID);
        }

        public void setLineWidth(int var0) {
            this.entityData.set(DATA_LINE_WIDTH_ID, var0);
        }

        public byte getTextOpacity(float var0) {
            return (byte)this.textOpacity.get(var0);
        }

        public byte getTextOpacity() {
            return this.entityData.get(DATA_TEXT_OPACITY_ID);
        }

        public void setTextOpacity(byte var0) {
            this.entityData.set(DATA_TEXT_OPACITY_ID, var0);
        }

        public int getBackgroundColor(float var0) {
            return this.backgroundColor.get(var0);
        }

        public int getBackgroundColor() {
            return this.entityData.get(DATA_BACKGROUND_COLOR_ID);
        }

        public void setBackgroundColor(int var0) {
            this.entityData.set(DATA_BACKGROUND_COLOR_ID, var0);
        }

        public byte getFlags() {
            return this.entityData.get(DATA_STYLE_FLAGS_ID);
        }

        public void setFlags(byte var0) {
            this.entityData.set(DATA_STYLE_FLAGS_ID, var0);
        }

        private static byte loadFlag(byte var0, NBTTagCompound var1, String var2, byte var3) {
            if (var1.getBoolean(var2)) {
                return (byte)(var0 | var3);
            }
            return var0;
        }

        @Override
        protected void readAdditionalSaveData(NBTTagCompound var0) {
            super.readAdditionalSaveData(var0);
            if (var0.contains(TAG_LINE_WIDTH, 99)) {
                this.setLineWidth(var0.getInt(TAG_LINE_WIDTH));
            }
            if (var0.contains(TAG_TEXT_OPACITY, 99)) {
                this.setTextOpacity(var0.getByte(TAG_TEXT_OPACITY));
            }
            if (var0.contains(TAG_BACKGROUND_COLOR, 99)) {
                this.setBackgroundColor(var0.getInt(TAG_BACKGROUND_COLOR));
            }
            byte var1 = TextDisplay.loadFlag((byte)0, var0, TAG_SHADOW, (byte)1);
            var1 = TextDisplay.loadFlag(var1, var0, TAG_SEE_THROUGH, (byte)2);
            var1 = TextDisplay.loadFlag(var1, var0, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Optional<Align> var2 = Align.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0.get(TAG_ALIGNMENT)).resultOrPartial(SystemUtils.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).map(Pair::getFirst);
            if (var2.isPresent()) {
                var1 = switch (var2.get()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Align.CENTER -> var1;
                    case Align.LEFT -> (byte)(var1 | 8);
                    case Align.RIGHT -> (byte)(var1 | 0x10);
                };
            }
            this.setFlags(var1);
            if (var0.contains(TAG_TEXT, 8)) {
                String var3 = var0.getString(TAG_TEXT);
                try {
                    IChatMutableComponent var4 = IChatBaseComponent.ChatSerializer.fromJson(var3);
                    if (var4 != null) {
                        CommandListenerWrapper var5 = this.createCommandSourceStack().withPermission(2);
                        IChatMutableComponent var6 = ChatComponentUtils.updateForEntity(var5, var4, (Entity)this, 0);
                        this.setText(var6);
                    } else {
                        this.setText(IChatBaseComponent.empty());
                    }
                }
                catch (Exception var4) {
                    LOGGER.warn("Failed to parse display entity text {}", (Object)var3, (Object)var4);
                }
            }
        }

        private static void storeFlag(byte var0, NBTTagCompound var1, String var2, byte var3) {
            var1.putBoolean(var2, (var0 & var3) != 0);
        }

        @Override
        protected void addAdditionalSaveData(NBTTagCompound var0) {
            super.addAdditionalSaveData(var0);
            var0.putString(TAG_TEXT, IChatBaseComponent.ChatSerializer.toJson(this.getText()));
            var0.putInt(TAG_LINE_WIDTH, this.getLineWidth());
            var0.putInt(TAG_BACKGROUND_COLOR, this.getBackgroundColor());
            var0.putByte(TAG_TEXT_OPACITY, this.getTextOpacity());
            byte var12 = this.getFlags();
            TextDisplay.storeFlag(var12, var0, TAG_SHADOW, (byte)1);
            TextDisplay.storeFlag(var12, var0, TAG_SEE_THROUGH, (byte)2);
            TextDisplay.storeFlag(var12, var0, TAG_USE_DEFAULT_BACKGROUND, (byte)4);
            Align.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)TextDisplay.getAlign(var12)).result().ifPresent(var1 -> var0.put(TAG_ALIGNMENT, (NBTBase)var1));
        }

        public CachedInfo cacheDisplay(LineSplitter var0) {
            if (this.clientDisplayCache == null) {
                int var1 = this.getLineWidth();
                this.clientDisplayCache = var0.split(this.getText(), var1);
            }
            return this.clientDisplayCache;
        }

        public static Align getAlign(byte var0) {
            if ((var0 & 8) != 0) {
                return Align.LEFT;
            }
            if ((var0 & 0x10) != 0) {
                return Align.RIGHT;
            }
            return Align.CENTER;
        }

        public record CachedInfo(List<CachedLine> lines, int width) {
        }

        public static final class Align
        extends Enum<Align>
        implements INamable {
            public static final /* enum */ Align CENTER = new Align("center");
            public static final /* enum */ Align LEFT = new Align("left");
            public static final /* enum */ Align RIGHT = new Align("right");
            public static final Codec<Align> CODEC;
            private final String name;
            private static final /* synthetic */ Align[] f;

            public static Align[] values() {
                return (Align[])f.clone();
            }

            public static Align valueOf(String var0) {
                return Enum.valueOf(Align.class, var0);
            }

            private Align(String var2) {
                this.name = var2;
            }

            @Override
            public String getSerializedName() {
                return this.name;
            }

            private static /* synthetic */ Align[] a() {
                return new Align[]{CENTER, LEFT, RIGHT};
            }

            static {
                f = Align.a();
                CODEC = INamable.fromEnum(Align::values);
            }
        }

        @FunctionalInterface
        public static interface LineSplitter {
            public CachedInfo split(IChatBaseComponent var1, int var2);
        }

        public record CachedLine(FormattedString contents, int width) {
        }
    }

    public static class BlockDisplay
    extends Display {
        public static final String TAG_BLOCK_STATE = "block_state";
        private static final DataWatcherObject<IBlockData> DATA_BLOCK_STATE_ID = DataWatcher.defineId(BlockDisplay.class, DataWatcherRegistry.BLOCK_STATE);

        public BlockDisplay(EntityTypes<?> var0, World var1) {
            super(var0, var1);
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_BLOCK_STATE_ID, Blocks.AIR.defaultBlockState());
        }

        public IBlockData getBlockState() {
            return this.entityData.get(DATA_BLOCK_STATE_ID);
        }

        public void setBlockState(IBlockData var0) {
            this.entityData.set(DATA_BLOCK_STATE_ID, var0);
        }

        @Override
        protected void readAdditionalSaveData(NBTTagCompound var0) {
            super.readAdditionalSaveData(var0);
            this.setBlockState(GameProfileSerializer.readBlockState(this.level.holderLookup(Registries.BLOCK), var0.getCompound(TAG_BLOCK_STATE)));
        }

        @Override
        protected void addAdditionalSaveData(NBTTagCompound var0) {
            super.addAdditionalSaveData(var0);
            var0.put(TAG_BLOCK_STATE, GameProfileSerializer.writeBlockState(this.getBlockState()));
        }
    }

    public static class ItemDisplay
    extends Display {
        private static final String TAG_ITEM = "item";
        private static final String TAG_ITEM_DISPLAY = "item_display";
        private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK_ID = DataWatcher.defineId(ItemDisplay.class, DataWatcherRegistry.ITEM_STACK);
        private static final DataWatcherObject<Byte> DATA_ITEM_DISPLAY_ID = DataWatcher.defineId(ItemDisplay.class, DataWatcherRegistry.BYTE);
        private final SlotAccess slot = new SlotAccess(){

            @Override
            public ItemStack get() {
                return this.getItemStack();
            }

            @Override
            public boolean set(ItemStack var0) {
                this.setItemStack(var0);
                return true;
            }
        };

        public ItemDisplay(EntityTypes<?> var0, World var1) {
            super(var0, var1);
        }

        @Override
        protected void defineSynchedData() {
            super.defineSynchedData();
            this.entityData.define(DATA_ITEM_STACK_ID, ItemStack.EMPTY);
            this.entityData.define(DATA_ITEM_DISPLAY_ID, ItemDisplayContext.NONE.getId());
        }

        public ItemStack getItemStack() {
            return this.entityData.get(DATA_ITEM_STACK_ID);
        }

        public void setItemStack(ItemStack var0) {
            this.entityData.set(DATA_ITEM_STACK_ID, var0);
        }

        public void setItemTransform(ItemDisplayContext var0) {
            this.entityData.set(DATA_ITEM_DISPLAY_ID, var0.getId());
        }

        public ItemDisplayContext getItemTransform() {
            return ItemDisplayContext.BY_ID.apply(this.entityData.get(DATA_ITEM_DISPLAY_ID).byteValue());
        }

        @Override
        protected void readAdditionalSaveData(NBTTagCompound var02) {
            super.readAdditionalSaveData(var02);
            this.setItemStack(ItemStack.of(var02.getCompound(TAG_ITEM)));
            if (var02.contains(TAG_ITEM_DISPLAY, 8)) {
                ItemDisplayContext.CODEC.decode((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var02.get(TAG_ITEM_DISPLAY)).resultOrPartial(SystemUtils.prefix("Display entity", arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(var0 -> this.setItemTransform((ItemDisplayContext)var0.getFirst()));
            }
        }

        @Override
        protected void addAdditionalSaveData(NBTTagCompound var0) {
            super.addAdditionalSaveData(var0);
            var0.put(TAG_ITEM, this.getItemStack().save(new NBTTagCompound()));
            ItemDisplayContext.CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this.getItemTransform()).result().ifPresent(var1 -> var0.put(TAG_ITEM_DISPLAY, (NBTBase)var1));
        }

        @Override
        public SlotAccess getSlot(int var0) {
            if (var0 == 0) {
                return this.slot;
            }
            return SlotAccess.NULL;
        }
    }
}

