/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.WorldPersistentData;
import org.slf4j.Logger;

public class WorldUpgrader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).build();
    private final IRegistry<WorldDimension> dimensions;
    private final Set<ResourceKey<World>> levels;
    private final boolean eraseCache;
    private final Convertable.ConversionSession levelStorage;
    private final Thread thread;
    private final DataFixer dataFixer;
    private volatile boolean running = true;
    private volatile boolean finished;
    private volatile float progress;
    private volatile int totalChunks;
    private volatile int converted;
    private volatile int skipped;
    private final Object2FloatMap<ResourceKey<World>> progressMap = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(SystemUtils.identityStrategy()));
    private volatile IChatBaseComponent status = IChatBaseComponent.translatable("optimizeWorld.stage.counting");
    private static final Pattern REGEX = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final WorldPersistentData overworldDataStorage;

    public WorldUpgrader(Convertable.ConversionSession var02, DataFixer var12, IRegistry<WorldDimension> var2, boolean var3) {
        this.dimensions = var2;
        this.levels = var2.registryKeySet().stream().map(Registries::levelStemToLevel).collect(Collectors.toUnmodifiableSet());
        this.eraseCache = var3;
        this.dataFixer = var12;
        this.levelStorage = var02;
        this.overworldDataStorage = new WorldPersistentData(this.levelStorage.getDimensionPath(World.OVERWORLD).resolve("data").toFile(), var12);
        this.thread = THREAD_FACTORY.newThread(this::work);
        this.thread.setUncaughtExceptionHandler((var0, var1) -> {
            LOGGER.error("Error upgrading world", var1);
            this.status = IChatBaseComponent.translatable("optimizeWorld.stage.failed");
            this.finished = true;
        });
        this.thread.start();
    }

    public void cancel() {
        this.running = false;
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void work() {
        ImmutableMap.Builder var3;
        this.totalChunks = 0;
        ImmutableMap.Builder var0 = ImmutableMap.builder();
        for (ResourceKey<World> resourceKey : this.levels) {
            var3 = this.getAllChunkPos(resourceKey);
            var0.put(resourceKey, var3.listIterator());
            this.totalChunks += var3.size();
        }
        if (this.totalChunks == 0) {
            this.finished = true;
            return;
        }
        float var1 = this.totalChunks;
        ImmutableMap immutableMap = var0.build();
        var3 = ImmutableMap.builder();
        for (ResourceKey<World> var5 : this.levels) {
            Path var6 = this.levelStorage.getDimensionPath(var5);
            var3.put(var5, (Object)new IChunkLoader(var6.resolve("region"), this.dataFixer, true));
        }
        ImmutableMap var4 = var3.build();
        long var5 = SystemUtils.getMillis();
        this.status = IChatBaseComponent.translatable("optimizeWorld.stage.upgrading");
        while (this.running) {
            boolean var7 = false;
            float var8 = 0.0f;
            for (ResourceKey<World> var10 : this.levels) {
                ListIterator var11 = (ListIterator)immutableMap.get(var10);
                IChunkLoader var12 = (IChunkLoader)var4.get(var10);
                if (var11.hasNext()) {
                    ChunkCoordIntPair var13 = (ChunkCoordIntPair)var11.next();
                    boolean var14 = false;
                    try {
                        NBTTagCompound var15 = var12.read(var13).join().orElse(null);
                        if (var15 != null) {
                            boolean var20;
                            int var16 = IChunkLoader.getVersion(var15);
                            ChunkGenerator var17 = this.dimensions.getOrThrow(Registries.levelToLevelStem(var10)).generator();
                            NBTTagCompound var18 = var12.upgradeChunkTag(var10, () -> this.overworldDataStorage, var15, var17.getTypeNameForDataFixer());
                            ChunkCoordIntPair var19 = new ChunkCoordIntPair(var18.getInt("xPos"), var18.getInt("zPos"));
                            if (!var19.equals(var13)) {
                                LOGGER.warn("Chunk {} has invalid position {}", (Object)var13, (Object)var19);
                            }
                            boolean bl = var20 = var16 < SharedConstants.getCurrentVersion().getDataVersion().getVersion();
                            if (this.eraseCache) {
                                var20 = var20 || var18.contains("Heightmaps");
                                var18.remove("Heightmaps");
                                var20 = var20 || var18.contains("isLightOn");
                                var18.remove("isLightOn");
                                NBTTagList var21 = var18.getList("sections", 10);
                                for (int var22 = 0; var22 < var21.size(); ++var22) {
                                    NBTTagCompound var23 = var21.getCompound(var22);
                                    var20 = var20 || var23.contains("BlockLight");
                                    var23.remove("BlockLight");
                                    var20 = var20 || var23.contains("SkyLight");
                                    var23.remove("SkyLight");
                                }
                            }
                            if (var20) {
                                var12.write(var13, var18);
                                var14 = true;
                            }
                        }
                    }
                    catch (CompletionException | ReportedException var15) {
                        Throwable var16 = var15.getCause();
                        if (var16 instanceof IOException) {
                            LOGGER.error("Error upgrading chunk {}", (Object)var13, (Object)var16);
                        }
                        throw var15;
                    }
                    if (var14) {
                        ++this.converted;
                    } else {
                        ++this.skipped;
                    }
                    var7 = true;
                }
                float var13 = (float)var11.nextIndex() / var1;
                this.progressMap.put(var10, var13);
                var8 += var13;
            }
            this.progress = var8;
            if (var7) continue;
            this.running = false;
        }
        this.status = IChatBaseComponent.translatable("optimizeWorld.stage.finished");
        for (IChunkLoader var8 : var4.values()) {
            try {
                var8.close();
            }
            catch (IOException var9) {
                LOGGER.error("Error upgrading chunk", (Throwable)var9);
            }
        }
        this.overworldDataStorage.save();
        var5 = SystemUtils.getMillis() - var5;
        LOGGER.info("World optimizaton finished after {} ms", (Object)var5);
        this.finished = true;
    }

    private List<ChunkCoordIntPair> getAllChunkPos(ResourceKey<World> var02) {
        File var12 = this.levelStorage.getDimensionPath(var02).toFile();
        File var2 = new File(var12, "region");
        File[] var3 = var2.listFiles((var0, var1) -> var1.endsWith(".mca"));
        if (var3 == null) {
            return ImmutableList.of();
        }
        ArrayList var4 = Lists.newArrayList();
        for (File var8 : var3) {
            Matcher var9 = REGEX.matcher(var8.getName());
            if (!var9.matches()) continue;
            int var10 = Integer.parseInt(var9.group(1)) << 5;
            int var11 = Integer.parseInt(var9.group(2)) << 5;
            try (RegionFile var122 = new RegionFile(var8.toPath(), var2.toPath(), true);){
                for (int var13 = 0; var13 < 32; ++var13) {
                    for (int var14 = 0; var14 < 32; ++var14) {
                        ChunkCoordIntPair var15 = new ChunkCoordIntPair(var13 + var10, var14 + var11);
                        if (!var122.doesChunkExist(var15)) continue;
                        var4.add(var15);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return var4;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Set<ResourceKey<World>> levels() {
        return this.levels;
    }

    public float dimensionProgress(ResourceKey<World> var0) {
        return this.progressMap.getFloat(var0);
    }

    public float getProgress() {
        return this.progress;
    }

    public int getTotalChunks() {
        return this.totalChunks;
    }

    public int getConverted() {
        return this.converted;
    }

    public int getSkipped() {
        return this.skipped;
    }

    public IChatBaseComponent getStatus() {
        return this.status;
    }
}

