/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Base64;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import net.minecraft.SystemUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ExtraCodecs {
    public static final Codec<JsonElement> JSON = Codec.PASSTHROUGH.xmap(var0 -> (JsonElement)var0.convert((DynamicOps)JsonOps.INSTANCE).getValue(), var0 -> new Dynamic((DynamicOps)JsonOps.INSTANCE, var0));
    public static final Codec<IChatBaseComponent> COMPONENT = JSON.flatXmap(var0 -> {
        try {
            return DataResult.success((Object)IChatBaseComponent.ChatSerializer.fromJson(var0));
        }
        catch (JsonParseException var1) {
            return DataResult.error(var1::getMessage);
        }
    }, var0 -> {
        try {
            return DataResult.success((Object)IChatBaseComponent.ChatSerializer.toJsonTree(var0));
        }
        catch (IllegalArgumentException var1) {
            return DataResult.error(var1::getMessage);
        }
    });
    public static final Codec<Vector3f> VECTOR3F = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 3).map(var0 -> new Vector3f(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue())), var0 -> List.of(Float.valueOf(var0.x()), Float.valueOf(var0.y()), Float.valueOf(var0.z())));
    public static final Codec<Quaternionf> QUATERNIONF_COMPONENTS = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 4).map(var0 -> new Quaternionf(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue(), ((Float)var0.get(2)).floatValue(), ((Float)var0.get(3)).floatValue())), var0 -> List.of(Float.valueOf(var0.x), Float.valueOf(var0.y), Float.valueOf(var0.z), Float.valueOf(var0.w)));
    public static final Codec<AxisAngle4f> AXISANGLE4F = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.FLOAT.fieldOf("angle").forGetter(var0 -> Float.valueOf(var0.angle)), (App)VECTOR3F.fieldOf("axis").forGetter(var0 -> new Vector3f(var0.x, var0.y, var0.z))).apply((Applicative)var02, AxisAngle4f::new));
    public static final Codec<Quaternionf> QUATERNIONF = Codec.either(QUATERNIONF_COMPONENTS, (Codec)AXISANGLE4F.xmap(Quaternionf::new, AxisAngle4f::new)).xmap(var02 -> (Quaternionf)var02.map(var0 -> var0, var0 -> var0), Either::left);
    public static Codec<Matrix4f> MATRIX4F = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 16).map(var0 -> {
        Matrix4f var1 = new Matrix4f();
        for (int var2 = 0; var2 < var0.size(); ++var2) {
            var1.setRowColumn(var2 >> 2, var2 & 3, ((Float)var0.get(var2)).floatValue());
        }
        return var1.determineProperties();
    }), var0 -> {
        FloatArrayList var1 = new FloatArrayList(16);
        for (int var2 = 0; var2 < 16; ++var2) {
            var1.add(var0.getRowColumn(var2 >> 2, var2 & 3));
        }
        return var1;
    });
    public static final Codec<Integer> NON_NEGATIVE_INT = ExtraCodecs.intRangeWithMessage(0, Integer.MAX_VALUE, var0 -> "Value must be non-negative: " + var0);
    public static final Codec<Integer> POSITIVE_INT = ExtraCodecs.intRangeWithMessage(1, Integer.MAX_VALUE, var0 -> "Value must be positive: " + var0);
    public static final Codec<Float> POSITIVE_FLOAT = ExtraCodecs.floatRangeMinExclusiveWithMessage(0.0f, Float.MAX_VALUE, var0 -> "Value must be positive: " + var0);
    public static final Codec<Pattern> PATTERN = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)Pattern.compile(var0));
        }
        catch (PatternSyntaxException var1) {
            return DataResult.error(() -> "Invalid regex pattern '" + var0 + "': " + var1.getMessage());
        }
    }, Pattern::pattern);
    public static final Codec<Instant> INSTANT_ISO8601 = ExtraCodecs.instantCodec(DateTimeFormatter.ISO_INSTANT);
    public static final Codec<byte[]> BASE64_STRING = Codec.STRING.comapFlatMap(var0 -> {
        try {
            return DataResult.success((Object)Base64.getDecoder().decode((String)var0));
        }
        catch (IllegalArgumentException var1) {
            return DataResult.error(() -> "Malformed base64 string");
        }
    }, var0 -> Base64.getEncoder().encodeToString((byte[])var0));
    public static final Codec<d> TAG_OR_ELEMENT_ID = Codec.STRING.comapFlatMap(var02 -> var02.startsWith("#") ? MinecraftKey.read(var02.substring(1)).map(var0 -> new d((MinecraftKey)var0, true)) : MinecraftKey.read(var02).map(var0 -> new d((MinecraftKey)var0, false)), d::decoratedId);
    public static final Function<Optional<Long>, OptionalLong> toOptionalLong = var0 -> var0.map(OptionalLong::of).orElseGet(OptionalLong::empty);
    public static final Function<OptionalLong, Optional<Long>> fromOptionalLong = var0 -> var0.isPresent() ? Optional.of(var0.getAsLong()) : Optional.empty();
    public static final Codec<BitSet> BIT_SET = Codec.LONG_STREAM.xmap(var0 -> BitSet.valueOf(var0.toArray()), var0 -> Arrays.stream(var0.toLongArray()));
    private static final Codec<Property> PROPERTY = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.STRING.fieldOf("name").forGetter(Property::getName), (App)Codec.STRING.fieldOf("value").forGetter(Property::getValue), (App)Codec.STRING.optionalFieldOf("signature").forGetter(var0 -> Optional.ofNullable(var0.getSignature()))).apply((Applicative)var02, (var0, var1, var2) -> new Property(var0, var1, (String)var2.orElse(null))));
    @VisibleForTesting
    public static final Codec<PropertyMap> PROPERTY_MAP = Codec.either((Codec)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()), (Codec)PROPERTY.listOf()).xmap(var0 -> {
        PropertyMap var13 = new PropertyMap();
        var0.ifLeft(var12 -> var12.forEach((var1, var2) -> {
            for (String var4 : var2) {
                var13.put(var1, (Object)new Property(var1, var4));
            }
        })).ifRight(var1 -> {
            for (Property var3 : var1) {
                var13.put((Object)var3.getName(), (Object)var3);
            }
        });
        return var13;
    }, var0 -> Either.right(var0.values().stream().toList()));
    public static final Codec<GameProfile> GAME_PROFILE = RecordCodecBuilder.create(var02 -> var02.group((App)Codec.mapPair((MapCodec)UUIDUtil.AUTHLIB_CODEC.xmap(Optional::of, var0 -> var0.orElse(null)).optionalFieldOf("id", Optional.empty()), (MapCodec)Codec.STRING.xmap(Optional::of, var0 -> var0.orElse(null)).optionalFieldOf("name", Optional.empty())).flatXmap(ExtraCodecs::mapIdNameToGameProfile, ExtraCodecs::mapGameProfileToIdName).forGetter(Function.identity()), (App)PROPERTY_MAP.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(GameProfile::getProperties)).apply((Applicative)var02, (var0, var12) -> {
        var12.forEach((var1, var2) -> var0.getProperties().put(var1, var2));
        return var0;
    }));
    public static final Codec<String> NON_EMPTY_STRING = ExtraCodecs.validate(Codec.STRING, var0 -> var0.isEmpty() ? DataResult.error(() -> "Expected non-empty string") : DataResult.success((Object)var0));

    public static <F, S> Codec<Either<F, S>> xor(Codec<F> var0, Codec<S> var1) {
        return new e<F, S>(var0, var1);
    }

    public static <P, I> Codec<I> intervalCodec(Codec<P> var0, String var13, String var22, BiFunction<P, P, DataResult<I>> var32, Function<I, P> var4, Function<I, P> var5) {
        Codec var6 = Codec.list(var0).comapFlatMap(var12 -> SystemUtils.fixedSize(var12, 2).flatMap(var1 -> {
            Object var2 = var1.get(0);
            Object var3 = var1.get(1);
            return (DataResult)var32.apply(var2, var3);
        }), var2 -> ImmutableList.of(var4.apply(var2), var5.apply(var2)));
        Codec var7 = RecordCodecBuilder.create(var3 -> var3.group((App)var0.fieldOf(var13).forGetter(Pair::getFirst), (App)var0.fieldOf(var22).forGetter(Pair::getSecond)).apply((Applicative)var3, Pair::of)).comapFlatMap(var1 -> (DataResult)var32.apply(var1.getFirst(), var1.getSecond()), var2 -> Pair.of(var4.apply(var2), var5.apply(var2)));
        Codec var8 = new b(var6, var7).xmap(var02 -> var02.map(var0 -> var0, var0 -> var0), Either::left);
        return Codec.either(var0, (Codec)var8).comapFlatMap(var12 -> (DataResult)var12.map(var1 -> (DataResult)var32.apply(var1, var1), DataResult::success), var2 -> {
            Object var4;
            Object var3 = var4.apply(var2);
            if (Objects.equals(var3, var4 = var5.apply(var2))) {
                return Either.left(var3);
            }
            return Either.right((Object)var2);
        });
    }

    public static <A> Codec.ResultFunction<A> orElsePartial(final A var0) {
        return new Codec.ResultFunction<A>(){

            public <T> DataResult<Pair<A, T>> apply(DynamicOps<T> var02, T var1, DataResult<Pair<A, T>> var2) {
                MutableObject var3 = new MutableObject();
                Optional var4 = var2.resultOrPartial(arg_0 -> ((MutableObject)var3).setValue(arg_0));
                if (var4.isPresent()) {
                    return var2;
                }
                return DataResult.error(() -> "(" + (String)var3.getValue() + " -> using default)", (Object)Pair.of((Object)var0, var1));
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var02, A var1, DataResult<T> var2) {
                return var2;
            }

            public String toString() {
                return "OrElsePartial[" + var0 + "]";
            }
        };
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> var0, IntFunction<E> var12, int var22) {
        return Codec.INT.flatXmap(var1 -> Optional.ofNullable(var12.apply((int)var1)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element id: " + var1)), var2 -> {
            int var3 = var0.applyAsInt(var2);
            return var3 == var22 ? DataResult.error(() -> "Element with unknown id: " + var2) : DataResult.success((Object)var3);
        });
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> var0, Function<String, E> var12) {
        return Codec.STRING.flatXmap(var1 -> Optional.ofNullable(var12.apply((String)var1)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown element name:" + var1)), var1 -> Optional.ofNullable((String)var0.apply(var1)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Element with unknown name: " + var1)));
    }

    public static <E> Codec<E> orCompressed(final Codec<E> var0, final Codec<E> var1) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E var02, DynamicOps<T> var12, T var2) {
                if (var12.compressMaps()) {
                    return var1.encode(var02, var12, var2);
                }
                return var0.encode(var02, var12, var2);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> var02, T var12) {
                if (var02.compressMaps()) {
                    return var1.decode(var02, var12);
                }
                return var0.decode(var02, var12);
            }

            public String toString() {
                return var0 + " orCompressed " + var1;
            }
        };
    }

    public static <E> Codec<E> overrideLifecycle(Codec<E> var0, final Function<E, Lifecycle> var1, final Function<E, Lifecycle> var2) {
        return var0.mapResult(new Codec.ResultFunction<E>(){

            public <T> DataResult<Pair<E, T>> apply(DynamicOps<T> var0, T var12, DataResult<Pair<E, T>> var22) {
                return var22.result().map(var2 -> var22.setLifecycle((Lifecycle)var1.apply(var2.getFirst()))).orElse(var22);
            }

            public <T> DataResult<T> coApply(DynamicOps<T> var0, E var12, DataResult<T> var22) {
                return var22.setLifecycle((Lifecycle)var2.apply(var12));
            }

            public String toString() {
                return "WithLifecycle[" + var1 + " " + var2 + "]";
            }
        });
    }

    public static <T> Codec<T> validate(Codec<T> var0, Function<T, DataResult<T>> var1) {
        return var0.flatXmap(var1, var1);
    }

    private static Codec<Integer> intRangeWithMessage(int var0, int var1, Function<Integer, String> var2) {
        return ExtraCodecs.validate(Codec.INT, var3 -> {
            if (var3.compareTo(var0) >= 0 && var3.compareTo(var1) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> (String)var2.apply((Integer)var3));
        });
    }

    public static Codec<Integer> intRange(int var0, int var1) {
        return ExtraCodecs.intRangeWithMessage(var0, var1, var2 -> "Value must be within range [" + var0 + ";" + var1 + "]: " + var2);
    }

    private static Codec<Float> floatRangeMinExclusiveWithMessage(float var0, float var1, Function<Float, String> var2) {
        return ExtraCodecs.validate(Codec.FLOAT, var3 -> {
            if (var3.compareTo(Float.valueOf(var0)) > 0 && var3.compareTo(Float.valueOf(var1)) <= 0) {
                return DataResult.success((Object)var3);
            }
            return DataResult.error(() -> (String)var2.apply((Float)var3));
        });
    }

    public static <T> Codec<List<T>> nonEmptyList(Codec<List<T>> var02) {
        return ExtraCodecs.validate(var02, var0 -> var0.isEmpty() ? DataResult.error(() -> "List must have contents") : DataResult.success((Object)var0));
    }

    public static <T> Codec<HolderSet<T>> nonEmptyHolderSet(Codec<HolderSet<T>> var02) {
        return ExtraCodecs.validate(var02, var0 -> {
            if (var0.unwrap().right().filter(List::isEmpty).isPresent()) {
                return DataResult.error(() -> "List must have contents");
            }
            return DataResult.success((Object)var0);
        });
    }

    public static <A> Codec<A> lazyInitializedCodec(Supplier<Codec<A>> var0) {
        return new c<A>(var0);
    }

    public static <E> MapCodec<E> retrieveContext(Function<DynamicOps<?>, DataResult<E>> var0) {
        class A
        extends MapCodec<E> {
            final /* synthetic */ Function a;

            A(Function function) {
                this.a = function;
            }

            public <T> RecordBuilder<T> encode(E var0, DynamicOps<T> var1, RecordBuilder<T> var2) {
                return var2;
            }

            public <T> DataResult<E> decode(DynamicOps<T> var0, MapLike<T> var1) {
                return (DataResult)this.a.apply(var0);
            }

            public String toString() {
                return "ContextRetrievalCodec[" + this.a + "]";
            }

            public <T> Stream<T> keys(DynamicOps<T> var0) {
                return Stream.empty();
            }
        }
        return new A(var0);
    }

    public static <E, L extends Collection<E>, T> Function<L, DataResult<L>> ensureHomogenous(Function<E, T> var0) {
        return var1 -> {
            Iterator var2 = var1.iterator();
            if (var2.hasNext()) {
                Object var3 = var0.apply(var2.next());
                while (var2.hasNext()) {
                    Object var4 = var2.next();
                    Object var5 = var0.apply(var4);
                    if (var5 == var3) continue;
                    return DataResult.error(() -> "Mixed type list: element " + var4 + " had type " + var5 + ", but list is of type " + var3);
                }
            }
            return DataResult.success((Object)var1, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <A> Codec<A> catchDecoderException(final Codec<A> var0) {
        return Codec.of(var0, (Decoder)new Decoder<A>(){

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var02, T var1) {
                try {
                    return var0.decode(var02, var1);
                }
                catch (Exception var2) {
                    return DataResult.error(() -> "Caught exception decoding " + var1 + ": " + var2.getMessage());
                }
            }
        });
    }

    public static Codec<Instant> instantCodec(DateTimeFormatter var0) {
        return Codec.STRING.comapFlatMap(var1 -> {
            try {
                return DataResult.success((Object)Instant.from(var0.parse((CharSequence)var1)));
            }
            catch (Exception var2) {
                return DataResult.error(var2::getMessage);
            }
        }, var0::format);
    }

    public static MapCodec<OptionalLong> asOptionalLong(MapCodec<Optional<Long>> var0) {
        return var0.xmap(toOptionalLong, fromOptionalLong);
    }

    private static DataResult<GameProfile> mapIdNameToGameProfile(Pair<Optional<UUID>, Optional<String>> var0) {
        try {
            return DataResult.success((Object)new GameProfile((UUID)((Optional)var0.getFirst()).orElse(null), (String)((Optional)var0.getSecond()).orElse(null)));
        }
        catch (Throwable var1) {
            return DataResult.error(var1::getMessage);
        }
    }

    private static DataResult<Pair<Optional<UUID>, Optional<String>>> mapGameProfileToIdName(GameProfile var0) {
        return DataResult.success((Object)Pair.of(Optional.ofNullable(var0.getId()), Optional.ofNullable(var0.getName())));
    }

    public static Codec<String> sizeLimitedString(int var0, int var1) {
        return ExtraCodecs.validate(Codec.STRING, var2 -> {
            int var3 = var2.length();
            if (var3 < var0) {
                return DataResult.error(() -> "String \"" + var2 + "\" is too short: " + var3 + ", expected range [" + var0 + "-" + var1 + "]");
            }
            if (var3 > var1) {
                return DataResult.error(() -> "String \"" + var2 + "\" is too long: " + var3 + ", expected range [" + var0 + "-" + var1 + "]");
            }
            return DataResult.success((Object)var2);
        });
    }

    static final class e<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public e(Codec<F> var0, Codec<S> var1) {
            this.first = var0;
            this.second = var1;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> var02, T var1) {
            DataResult var2 = this.first.decode(var02, var1).map(var0 -> var0.mapFirst(Either::left));
            DataResult var3 = this.second.decode(var02, var1).map(var0 -> var0.mapFirst(Either::right));
            Optional var4 = var2.result();
            Optional var5 = var3.result();
            if (var4.isPresent() && var5.isPresent()) {
                return DataResult.error(() -> "Both alternatives read successfully, can not pick the correct one; first: " + var4.get() + " second: " + var5.get(), (Object)((Pair)var4.get()));
            }
            return var4.isPresent() ? var2 : var3;
        }

        public <T> DataResult<T> encode(Either<F, S> var0, DynamicOps<T> var1, T var22) {
            return (DataResult)var0.map(var2 -> this.first.encode(var2, var1, var22), var2 -> this.second.encode(var2, var1, var22));
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            e var1 = (e)var0;
            return Objects.equals(this.first, var1.first) && Objects.equals(this.second, var1.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "XorCodec[" + this.first + ", " + this.second + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    static final class b<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> first;
        private final Codec<S> second;

        public b(Codec<F> var0, Codec<S> var1) {
            this.first = var0;
            this.second = var1;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> var02, T var12) {
            DataResult var2 = this.first.decode(var02, var12).map(var0 -> var0.mapFirst(Either::left));
            if (!var2.error().isPresent()) {
                return var2;
            }
            DataResult var3 = this.second.decode(var02, var12).map(var0 -> var0.mapFirst(Either::right));
            if (!var3.error().isPresent()) {
                return var3;
            }
            return var2.apply2((var0, var1) -> var1, var3);
        }

        public <T> DataResult<T> encode(Either<F, S> var0, DynamicOps<T> var1, T var22) {
            return (DataResult)var0.map(var2 -> this.first.encode(var2, var1, var22), var2 -> this.second.encode(var2, var1, var22));
        }

        public boolean equals(Object var0) {
            if (this == var0) {
                return true;
            }
            if (var0 == null || this.getClass() != var0.getClass()) {
                return false;
            }
            b var1 = (b)var0;
            return Objects.equals(this.first, var1.first) && Objects.equals(this.second, var1.second);
        }

        public int hashCode() {
            return Objects.hash(this.first, this.second);
        }

        public String toString() {
            return "EitherCodec[" + this.first + ", " + this.second + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }

    record c<A>(Supplier<Codec<A>> delegate) implements Codec<A>
    {
        c(Supplier<Codec<A>> var0) {
            this.delegate = var0 = Suppliers.memoize(() -> var0.get());
        }

        public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> var0, T var1) {
            return this.delegate.get().decode(var0, var1);
        }

        public <T> DataResult<T> encode(A var0, DynamicOps<T> var1, T var2) {
            return this.delegate.get().encode(var0, var1, var2);
        }
    }

    public record d(MinecraftKey id, boolean tag) {
        @Override
        public String toString() {
            return this.decoratedId();
        }

        private String decoratedId() {
            return this.tag ? "#" + this.id : this.id.toString();
        }
    }
}

