/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrySynchronization;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSimulationDistancePacket;
import net.minecraft.network.protocol.game.ClientboundUpdateEnabledFeaturesPacket;
import net.minecraft.network.protocol.game.PacketPlayOutAbilities;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutLogin;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutRecipeUpdate;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTags;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.game.PacketPlayOutViewDistance;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.GameProfileBanEntry;
import net.minecraft.server.players.GameProfileBanList;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.OpList;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagNetworkSerialization;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.scores.ScoreboardTeamBase;
import org.slf4j.Logger;

public abstract class PlayerList {
    public static final File USERBANLIST_FILE = new File("banned-players.json");
    public static final File IPBANLIST_FILE = new File("banned-ips.json");
    public static final File OPLIST_FILE = new File("ops.json");
    public static final File WHITELIST_FILE = new File("whitelist.json");
    public static final IChatBaseComponent CHAT_FILTERED_FULL = IChatBaseComponent.translatable("chat.filtered_full");
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SEND_PLAYER_INFO_INTERVAL = 600;
    private static final SimpleDateFormat BAN_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer server;
    public final List<EntityPlayer> players = Lists.newArrayList();
    private final Map<UUID, EntityPlayer> playersByUUID = Maps.newHashMap();
    private final GameProfileBanList bans = new GameProfileBanList(USERBANLIST_FILE);
    private final IpBanList ipBans = new IpBanList(IPBANLIST_FILE);
    private final OpList ops = new OpList(OPLIST_FILE);
    private final WhiteList whitelist = new WhiteList(WHITELIST_FILE);
    private final Map<UUID, ServerStatisticManager> stats = Maps.newHashMap();
    private final Map<UUID, AdvancementDataPlayer> advancements = Maps.newHashMap();
    public final WorldNBTStorage playerIo;
    private boolean doWhiteList;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private final IRegistryCustom.Dimension synchronizedRegistries;
    protected final int maxPlayers;
    private int viewDistance;
    private int simulationDistance;
    private boolean allowCheatsForAllPlayers;
    private static final boolean ALLOW_LOGOUTIVATOR = false;
    private int sendAllPlayerInfoIn;

    public PlayerList(MinecraftServer var0, LayeredRegistryAccess<RegistryLayer> var1, WorldNBTStorage var2, int var3) {
        this.server = var0;
        this.registries = var1;
        this.synchronizedRegistries = new IRegistryCustom.c(RegistrySynchronization.networkedRegistries(var1)).freeze();
        this.maxPlayers = var3;
        this.playerIo = var2;
    }

    public void placeNewPlayer(NetworkManager var0, EntityPlayer var12) {
        NBTTagCompound var18;
        Entity entity;
        WorldServer var9;
        GameProfile var2 = var12.getGameProfile();
        UserCache var3 = this.server.getProfileCache();
        Optional<GameProfile> var4 = var3.get(var2.getId());
        String var5 = var4.map(GameProfile::getName).orElse(var2.getName());
        var3.add(var2);
        NBTTagCompound var6 = this.load(var12);
        ResourceKey<World> var7 = var6 != null ? DimensionManager.parseLegacy(new Dynamic((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var6.get("Dimension"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(World.OVERWORLD) : World.OVERWORLD;
        WorldServer var8 = this.server.getLevel(var7);
        if (var8 == null) {
            LOGGER.warn("Unknown respawn dimension {}, defaulting to overworld", var7);
            var9 = this.server.overworld();
        } else {
            var9 = var8;
        }
        var12.setLevel(var9);
        String var10 = "local";
        if (var0.getRemoteAddress() != null) {
            var10 = var0.getRemoteAddress().toString();
        }
        LOGGER.info("{}[{}] logged in with entity id {} at ({}, {}, {})", new Object[]{var12.getName().getString(), var10, var12.getId(), var12.getX(), var12.getY(), var12.getZ()});
        WorldData var11 = var9.getLevelData();
        var12.loadGameTypes(var6);
        PlayerConnection var122 = new PlayerConnection(this.server, var0, var12);
        GameRules var13 = var9.getGameRules();
        boolean var14 = var13.getBoolean(GameRules.RULE_DO_IMMEDIATE_RESPAWN);
        boolean var15 = var13.getBoolean(GameRules.RULE_REDUCEDDEBUGINFO);
        var122.send(new PacketPlayOutLogin(var12.getId(), var11.isHardcore(), var12.gameMode.getGameModeForPlayer(), var12.gameMode.getPreviousGameModeForPlayer(), this.server.levelKeys(), this.synchronizedRegistries, var9.dimensionTypeId(), var9.dimension(), BiomeManager.obfuscateSeed(var9.getSeed()), this.getMaxPlayers(), this.viewDistance, this.simulationDistance, var15, !var14, var9.isDebug(), var9.isFlat(), var12.getLastDeathLocation()));
        var122.send(new ClientboundUpdateEnabledFeaturesPacket(FeatureFlags.REGISTRY.toNames(var9.enabledFeatures())));
        var122.send(new PacketPlayOutCustomPayload(PacketPlayOutCustomPayload.BRAND, new PacketDataSerializer(Unpooled.buffer()).writeUtf(this.getServer().getServerModName())));
        var122.send(new PacketPlayOutServerDifficulty(var11.getDifficulty(), var11.isDifficultyLocked()));
        var122.send(new PacketPlayOutAbilities(var12.getAbilities()));
        var122.send(new PacketPlayOutHeldItemSlot(var12.getInventory().selected));
        var122.send(new PacketPlayOutRecipeUpdate(this.server.getRecipeManager().getRecipes()));
        var122.send(new PacketPlayOutTags(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        this.sendPlayerPermissionLevel(var12);
        var12.getStats().markAllDirty();
        var12.getRecipeBook().sendInitialRecipeBook(var12);
        this.updateEntireScoreboard(var9.getScoreboard(), var12);
        this.server.invalidateStatus();
        IChatMutableComponent var16 = var12.getGameProfile().getName().equalsIgnoreCase(var5) ? IChatBaseComponent.translatable("multiplayer.player.joined", var12.getDisplayName()) : IChatBaseComponent.translatable("multiplayer.player.joined.renamed", var12.getDisplayName(), var5);
        this.broadcastSystemMessage(var16.withStyle(EnumChatFormat.YELLOW), false);
        var122.teleport(var12.getX(), var12.getY(), var12.getZ(), var12.getYRot(), var12.getXRot());
        ServerPing var17 = this.server.getStatus();
        if (var17 != null) {
            var12.sendServerStatus(var17);
        }
        var12.connection.send(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(this.players));
        this.players.add(var12);
        this.playersByUUID.put(var12.getUUID(), var12);
        this.broadcastAll(ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(List.of(var12)));
        this.sendLevelInfo(var12, var9);
        var9.addNewPlayer(var12);
        this.server.getCustomBossEvents().onPlayerConnect(var12);
        this.server.getServerResourcePack().ifPresent(var1 -> var12.sendTexturePack(var1.url(), var1.hash(), var1.isRequired(), var1.prompt()));
        for (MobEffect mobEffect : var12.getActiveEffects()) {
            var122.send(new PacketPlayOutEntityEffect(var12.getId(), mobEffect));
        }
        if (var6 != null && var6.contains("RootVehicle", 10) && (entity = EntityTypes.loadEntityRecursive((var18 = var6.getCompound("RootVehicle")).getCompound("Entity"), var9, var1 -> {
            if (!var9.addWithUUID((Entity)var1)) {
                return null;
            }
            return var1;
        })) != null) {
            UUID var20 = var18.hasUUID("Attach") ? var18.getUUID("Attach") : null;
            if (entity.getUUID().equals(var20)) {
                var12.startRiding(entity, true);
            } else {
                for (Entity var22 : entity.getIndirectPassengers()) {
                    if (!var22.getUUID().equals(var20)) continue;
                    var12.startRiding(var22, true);
                    break;
                }
            }
            if (!var12.isPassenger()) {
                LOGGER.warn("Couldn't reattach entity to player");
                entity.discard();
                for (Entity var22 : entity.getIndirectPassengers()) {
                    var22.discard();
                }
            }
        }
        var12.initInventoryMenu();
    }

    public void updateEntireScoreboard(ScoreboardServer var0, EntityPlayer var1) {
        HashSet var2 = Sets.newHashSet();
        for (ScoreboardTeam scoreboardTeam : var0.getPlayerTeams()) {
            var1.connection.send(PacketPlayOutScoreboardTeam.createAddOrModifyPacket(scoreboardTeam, true));
        }
        for (int var3 = 0; var3 < 19; ++var3) {
            ScoreboardObjective scoreboardObjective = var0.getDisplayObjective(var3);
            if (scoreboardObjective == null || var2.contains(scoreboardObjective)) continue;
            List<Packet<?>> var5 = var0.getStartTrackingPackets(scoreboardObjective);
            for (Packet<?> var7 : var5) {
                var1.connection.send(var7);
            }
            var2.add(scoreboardObjective);
        }
    }

    public void addWorldborderListener(WorldServer var0) {
        var0.getWorldBorder().addListener(new IWorldBorderListener(){

            @Override
            public void onBorderSizeSet(WorldBorder var0, double var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderSizePacket(var0));
            }

            @Override
            public void onBorderSizeLerping(WorldBorder var0, double var1, double var3, long var5) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderLerpSizePacket(var0));
            }

            @Override
            public void onBorderCenterSet(WorldBorder var0, double var1, double var3) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderCenterPacket(var0));
            }

            @Override
            public void onBorderSetWarningTime(WorldBorder var0, int var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDelayPacket(var0));
            }

            @Override
            public void onBorderSetWarningBlocks(WorldBorder var0, int var1) {
                PlayerList.this.broadcastAll(new ClientboundSetBorderWarningDistancePacket(var0));
            }

            @Override
            public void onBorderSetDamagePerBlock(WorldBorder var0, double var1) {
            }

            @Override
            public void onBorderSetDamageSafeZOne(WorldBorder var0, double var1) {
            }
        });
    }

    @Nullable
    public NBTTagCompound load(EntityPlayer var0) {
        NBTTagCompound var2;
        NBTTagCompound var1 = this.server.getWorldData().getLoadedPlayerTag();
        if (this.server.isSingleplayerOwner(var0.getGameProfile()) && var1 != null) {
            var2 = var1;
            var0.load(var2);
            LOGGER.debug("loading single player");
        } else {
            var2 = this.playerIo.load(var0);
        }
        return var2;
    }

    protected void save(EntityPlayer var0) {
        AdvancementDataPlayer var2;
        this.playerIo.save(var0);
        ServerStatisticManager var1 = this.stats.get(var0.getUUID());
        if (var1 != null) {
            var1.save();
        }
        if ((var2 = this.advancements.get(var0.getUUID())) != null) {
            var2.save();
        }
    }

    public void remove(EntityPlayer var02) {
        Object var2;
        WorldServer var1 = var02.getLevel();
        var02.awardStat(StatisticList.LEAVE_GAME);
        this.save(var02);
        if (var02.isPassenger() && ((Entity)(var2 = var02.getRootVehicle())).hasExactlyOnePlayerPassenger()) {
            LOGGER.debug("Removing player mount");
            var02.stopRiding();
            ((Entity)var2).getPassengersAndSelf().forEach(var0 -> var0.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
        var02.unRide();
        var1.removePlayerImmediately(var02, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        var02.getAdvancements().stopListening();
        this.players.remove(var02);
        this.server.getCustomBossEvents().onPlayerDisconnect(var02);
        var2 = var02.getUUID();
        EntityPlayer var3 = this.playersByUUID.get(var2);
        if (var3 == var02) {
            this.playersByUUID.remove(var2);
            this.stats.remove(var2);
            this.advancements.remove(var2);
        }
        this.broadcastAll(new ClientboundPlayerInfoRemovePacket(List.of(var02.getUUID())));
    }

    @Nullable
    public IChatBaseComponent canPlayerLogin(SocketAddress var0, GameProfile var1) {
        if (this.bans.isBanned(var1)) {
            GameProfileBanEntry var2 = (GameProfileBanEntry)this.bans.get(var1);
            IChatMutableComponent var3 = IChatBaseComponent.translatable("multiplayer.disconnect.banned.reason", var2.getReason());
            if (var2.getExpires() != null) {
                var3.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned.expiration", BAN_DATE_FORMAT.format(var2.getExpires())));
            }
            return var3;
        }
        if (!this.isWhiteListed(var1)) {
            return IChatBaseComponent.translatable("multiplayer.disconnect.not_whitelisted");
        }
        if (this.ipBans.isBanned(var0)) {
            IpBanEntry var2 = this.ipBans.get(var0);
            IChatMutableComponent var3 = IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.reason", var2.getReason());
            if (var2.getExpires() != null) {
                var3.append(IChatBaseComponent.translatable("multiplayer.disconnect.banned_ip.expiration", BAN_DATE_FORMAT.format(var2.getExpires())));
            }
            return var3;
        }
        if (this.players.size() >= this.maxPlayers && !this.canBypassPlayerLimit(var1)) {
            return IChatBaseComponent.translatable("multiplayer.disconnect.server_full");
        }
        return null;
    }

    public EntityPlayer getPlayerForLogin(GameProfile var0) {
        UUID var1 = UUIDUtil.getOrCreatePlayerUUID(var0);
        ArrayList var2 = Lists.newArrayList();
        for (int var3 = 0; var3 < this.players.size(); ++var3) {
            EntityPlayer var4 = this.players.get(var3);
            if (!var4.getUUID().equals(var1)) continue;
            var2.add(var4);
        }
        EntityPlayer var3 = this.playersByUUID.get(var0.getId());
        if (var3 != null && !var2.contains(var3)) {
            var2.add(var3);
        }
        for (EntityPlayer var5 : var2) {
            var5.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.duplicate_login"));
        }
        return new EntityPlayer(this.server, this.server.overworld(), var0);
    }

    public EntityPlayer respawn(EntityPlayer var0, boolean var1) {
        this.players.remove(var0);
        var0.getLevel().removePlayerImmediately(var0, Entity.RemovalReason.DISCARDED);
        BlockPosition var2 = var0.getRespawnPosition();
        float var3 = var0.getRespawnAngle();
        boolean var4 = var0.isRespawnForced();
        WorldServer var5 = this.server.getLevel(var0.getRespawnDimension());
        Optional<Object> var6 = var5 != null && var2 != null ? EntityHuman.findRespawnPositionAndUseSpawnBlock(var5, var2, var3, var4, var1) : Optional.empty();
        WorldServer var7 = var5 != null && var6.isPresent() ? var5 : this.server.overworld();
        EntityPlayer var8 = new EntityPlayer(this.server, var7, var0.getGameProfile());
        var8.connection = var0.connection;
        var8.restoreFrom(var0, var1);
        var8.setId(var0.getId());
        var8.setMainArm(var0.getMainArm());
        for (String string : var0.getTags()) {
            var8.addTag(string);
        }
        boolean var9 = false;
        if (var6.isPresent()) {
            float var13;
            IBlockData iBlockData = var7.getBlockState(var2);
            boolean var11 = iBlockData.is(Blocks.RESPAWN_ANCHOR);
            Vec3D var12 = (Vec3D)var6.get();
            if (iBlockData.is(TagsBlock.BEDS) || var11) {
                Vec3D var14 = Vec3D.atBottomCenterOf(var2).subtract(var12).normalize();
                var13 = (float)MathHelper.wrapDegrees(MathHelper.atan2(var14.z, var14.x) * 57.2957763671875 - 90.0);
            } else {
                var13 = var3;
            }
            var8.moveTo(var12.x, var12.y, var12.z, var13, 0.0f);
            var8.setRespawnPosition(var7.dimension(), var2, var3, var4, false);
            var9 = !var1 && var11;
        } else if (var2 != null) {
            var8.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.NO_RESPAWN_BLOCK_AVAILABLE, 0.0f));
        }
        while (!var7.noCollision(var8) && var8.getY() < (double)var7.getMaxBuildHeight()) {
            var8.setPos(var8.getX(), var8.getY() + 1.0, var8.getZ());
        }
        byte by = var1 ? (byte)1 : 0;
        WorldData var11 = var8.level.getLevelData();
        var8.connection.send(new PacketPlayOutRespawn(var8.level.dimensionTypeId(), var8.level.dimension(), BiomeManager.obfuscateSeed(var8.getLevel().getSeed()), var8.gameMode.getGameModeForPlayer(), var8.gameMode.getPreviousGameModeForPlayer(), var8.getLevel().isDebug(), var8.getLevel().isFlat(), by, var8.getLastDeathLocation()));
        var8.connection.teleport(var8.getX(), var8.getY(), var8.getZ(), var8.getYRot(), var8.getXRot());
        var8.connection.send(new PacketPlayOutSpawnPosition(var7.getSharedSpawnPos(), var7.getSharedSpawnAngle()));
        var8.connection.send(new PacketPlayOutServerDifficulty(var11.getDifficulty(), var11.isDifficultyLocked()));
        var8.connection.send(new PacketPlayOutExperience(var8.experienceProgress, var8.totalExperience, var8.experienceLevel));
        this.sendLevelInfo(var8, var7);
        this.sendPlayerPermissionLevel(var8);
        var7.addRespawnedPlayer(var8);
        this.players.add(var8);
        this.playersByUUID.put(var8.getUUID(), var8);
        var8.initInventoryMenu();
        var8.setHealth(var8.getHealth());
        if (var9) {
            var8.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RESPAWN_ANCHOR_DEPLETE, SoundCategory.BLOCKS, var2.getX(), var2.getY(), var2.getZ(), 1.0f, 1.0f, var7.getRandom().nextLong()));
        }
        return var8;
    }

    public void sendPlayerPermissionLevel(EntityPlayer var0) {
        GameProfile var1 = var0.getGameProfile();
        int var2 = this.server.getProfilePermissions(var1);
        this.sendPlayerPermissionLevel(var0, var2);
    }

    public void tick() {
        if (++this.sendAllPlayerInfoIn > 600) {
            this.broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.UPDATE_LATENCY), this.players));
            this.sendAllPlayerInfoIn = 0;
        }
    }

    public void broadcastAll(Packet<?> var0) {
        for (EntityPlayer var2 : this.players) {
            var2.connection.send(var0);
        }
    }

    public void broadcastAll(Packet<?> var0, ResourceKey<World> var1) {
        for (EntityPlayer var3 : this.players) {
            if (var3.level.dimension() != var1) continue;
            var3.connection.send(var0);
        }
    }

    public void broadcastSystemToTeam(EntityHuman var0, IChatBaseComponent var1) {
        ScoreboardTeamBase var2 = var0.getTeam();
        if (var2 == null) {
            return;
        }
        Collection<String> var3 = var2.getPlayers();
        for (String var5 : var3) {
            EntityPlayer var6 = this.getPlayerByName(var5);
            if (var6 == null || var6 == var0) continue;
            var6.sendSystemMessage(var1);
        }
    }

    public void broadcastSystemToAllExceptTeam(EntityHuman var0, IChatBaseComponent var1) {
        ScoreboardTeamBase var2 = var0.getTeam();
        if (var2 == null) {
            this.broadcastSystemMessage(var1, false);
            return;
        }
        for (int var3 = 0; var3 < this.players.size(); ++var3) {
            EntityPlayer var4 = this.players.get(var3);
            if (var4.getTeam() == var2) continue;
            var4.sendSystemMessage(var1);
        }
    }

    public String[] getPlayerNamesArray() {
        String[] var0 = new String[this.players.size()];
        for (int var1 = 0; var1 < this.players.size(); ++var1) {
            var0[var1] = this.players.get(var1).getGameProfile().getName();
        }
        return var0;
    }

    public GameProfileBanList getBans() {
        return this.bans;
    }

    public IpBanList getIpBans() {
        return this.ipBans;
    }

    public void op(GameProfile var0) {
        this.ops.add(new OpListEntry(var0, this.server.getOperatorUserPermissionLevel(), this.ops.canBypassPlayerLimit(var0)));
        EntityPlayer var1 = this.getPlayer(var0.getId());
        if (var1 != null) {
            this.sendPlayerPermissionLevel(var1);
        }
    }

    public void deop(GameProfile var0) {
        this.ops.remove(var0);
        EntityPlayer var1 = this.getPlayer(var0.getId());
        if (var1 != null) {
            this.sendPlayerPermissionLevel(var1);
        }
    }

    private void sendPlayerPermissionLevel(EntityPlayer var0, int var1) {
        if (var0.connection != null) {
            byte var2 = var1 <= 0 ? (byte)24 : (var1 >= 4 ? (byte)28 : (byte)((byte)(24 + var1)));
            var0.connection.send(new PacketPlayOutEntityStatus(var0, var2));
        }
        this.server.getCommands().sendCommands(var0);
    }

    public boolean isWhiteListed(GameProfile var0) {
        return !this.doWhiteList || this.ops.contains(var0) || this.whitelist.contains(var0);
    }

    public boolean isOp(GameProfile var0) {
        return this.ops.contains(var0) || this.server.isSingleplayerOwner(var0) && this.server.getWorldData().getAllowCommands() || this.allowCheatsForAllPlayers;
    }

    @Nullable
    public EntityPlayer getPlayerByName(String var0) {
        for (EntityPlayer var2 : this.players) {
            if (!var2.getGameProfile().getName().equalsIgnoreCase(var0)) continue;
            return var2;
        }
        return null;
    }

    public void broadcast(@Nullable EntityHuman var0, double var1, double var3, double var5, double var7, ResourceKey<World> var9, Packet<?> var10) {
        for (int var11 = 0; var11 < this.players.size(); ++var11) {
            double var17;
            double var15;
            double var13;
            EntityPlayer var12 = this.players.get(var11);
            if (var12 == var0 || var12.level.dimension() != var9 || !((var13 = var1 - var12.getX()) * var13 + (var15 = var3 - var12.getY()) * var15 + (var17 = var5 - var12.getZ()) * var17 < var7 * var7)) continue;
            var12.connection.send(var10);
        }
    }

    public void saveAll() {
        for (int var0 = 0; var0 < this.players.size(); ++var0) {
            this.save(this.players.get(var0));
        }
    }

    public WhiteList getWhiteList() {
        return this.whitelist;
    }

    public String[] getWhiteListNames() {
        return this.whitelist.getUserList();
    }

    public OpList getOps() {
        return this.ops;
    }

    public String[] getOpNames() {
        return this.ops.getUserList();
    }

    public void reloadWhiteList() {
    }

    public void sendLevelInfo(EntityPlayer var0, WorldServer var1) {
        WorldBorder var2 = this.server.overworld().getWorldBorder();
        var0.connection.send(new ClientboundInitializeBorderPacket(var2));
        var0.connection.send(new PacketPlayOutUpdateTime(var1.getGameTime(), var1.getDayTime(), var1.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)));
        var0.connection.send(new PacketPlayOutSpawnPosition(var1.getSharedSpawnPos(), var1.getSharedSpawnAngle()));
        if (var1.isRaining()) {
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.START_RAINING, 0.0f));
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.RAIN_LEVEL_CHANGE, var1.getRainLevel(1.0f)));
            var0.connection.send(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.THUNDER_LEVEL_CHANGE, var1.getThunderLevel(1.0f)));
        }
    }

    public void sendAllPlayerInfo(EntityPlayer var0) {
        var0.inventoryMenu.sendAllDataToRemote();
        var0.resetSentInfo();
        var0.connection.send(new PacketPlayOutHeldItemSlot(var0.getInventory().selected));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isUsingWhitelist() {
        return this.doWhiteList;
    }

    public void setUsingWhiteList(boolean var0) {
        this.doWhiteList = var0;
    }

    public List<EntityPlayer> getPlayersWithAddress(String var0) {
        ArrayList var1 = Lists.newArrayList();
        for (EntityPlayer var3 : this.players) {
            if (!var3.getIpAddress().equals(var0)) continue;
            var1.add(var3);
        }
        return var1;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    @Nullable
    public NBTTagCompound getSingleplayerData() {
        return null;
    }

    public void setAllowCheatsForAllPlayers(boolean var0) {
        this.allowCheatsForAllPlayers = var0;
    }

    public void removeAll() {
        for (int var0 = 0; var0 < this.players.size(); ++var0) {
            this.players.get((int)var0).connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void broadcastSystemMessage(IChatBaseComponent var0, boolean var12) {
        this.broadcastSystemMessage(var0, var1 -> var0, var12);
    }

    public void broadcastSystemMessage(IChatBaseComponent var0, Function<EntityPlayer, IChatBaseComponent> var1, boolean var2) {
        this.server.sendSystemMessage(var0);
        for (EntityPlayer var4 : this.players) {
            IChatBaseComponent var5 = var1.apply(var4);
            if (var5 == null) continue;
            var4.sendSystemMessage(var5, var2);
        }
    }

    public void broadcastChatMessage(PlayerChatMessage var0, CommandListenerWrapper var1, ChatMessageType.a var2) {
        this.broadcastChatMessage(var0, var1::shouldFilterMessageTo, var1.getPlayer(), var2);
    }

    public void broadcastChatMessage(PlayerChatMessage var0, EntityPlayer var1, ChatMessageType.a var2) {
        this.broadcastChatMessage(var0, var1::shouldFilterMessageTo, var1, var2);
    }

    private void broadcastChatMessage(PlayerChatMessage var0, Predicate<EntityPlayer> var1, @Nullable EntityPlayer var2, ChatMessageType.a var3) {
        boolean var4 = this.verifyChatTrusted(var0);
        this.server.logChatMessage(var0.decoratedContent(), var3, var4 ? null : "Not Secure");
        OutgoingChatMessage var5 = OutgoingChatMessage.create(var0);
        boolean var6 = false;
        for (EntityPlayer var8 : this.players) {
            boolean var9 = var1.test(var8);
            var8.sendChatMessage(var5, var9, var3);
            var6 |= var9 && var0.isFullyFiltered();
        }
        if (var6 && var2 != null) {
            var2.sendSystemMessage(CHAT_FILTERED_FULL);
        }
    }

    private boolean verifyChatTrusted(PlayerChatMessage var0) {
        return var0.hasSignature() && !var0.hasExpiredServer(Instant.now());
    }

    public ServerStatisticManager getPlayerStats(EntityHuman var0) {
        UUID var1 = var0.getUUID();
        ServerStatisticManager var2 = this.stats.get(var1);
        if (var2 == null) {
            File var5;
            Path var6;
            File var3 = this.server.getWorldPath(SavedFile.PLAYER_STATS_DIR).toFile();
            File var4 = new File(var3, var1 + ".json");
            if (!var4.exists() && FileUtils.isPathNormalized(var6 = (var5 = new File(var3, var0.getName().getString() + ".json")).toPath()) && FileUtils.isPathPortable(var6) && var6.startsWith(var3.getPath()) && var5.isFile()) {
                var5.renameTo(var4);
            }
            var2 = new ServerStatisticManager(this.server, var4);
            this.stats.put(var1, var2);
        }
        return var2;
    }

    public AdvancementDataPlayer getPlayerAdvancements(EntityPlayer var0) {
        UUID var1 = var0.getUUID();
        AdvancementDataPlayer var2 = this.advancements.get(var1);
        if (var2 == null) {
            Path var3 = this.server.getWorldPath(SavedFile.PLAYER_ADVANCEMENTS_DIR).resolve(var1 + ".json");
            var2 = new AdvancementDataPlayer(this.server.getFixerUpper(), this, this.server.getAdvancements(), var3, var0);
            this.advancements.put(var1, var2);
        }
        var2.setPlayer(var0);
        return var2;
    }

    public void setViewDistance(int var0) {
        this.viewDistance = var0;
        this.broadcastAll(new PacketPlayOutViewDistance(var0));
        for (WorldServer var2 : this.server.getAllLevels()) {
            if (var2 == null) continue;
            var2.getChunkSource().setViewDistance(var0);
        }
    }

    public void setSimulationDistance(int var0) {
        this.simulationDistance = var0;
        this.broadcastAll(new ClientboundSetSimulationDistancePacket(var0));
        for (WorldServer var2 : this.server.getAllLevels()) {
            if (var2 == null) continue;
            var2.getChunkSource().setSimulationDistance(var0);
        }
    }

    public List<EntityPlayer> getPlayers() {
        return this.players;
    }

    @Nullable
    public EntityPlayer getPlayer(UUID var0) {
        return this.playersByUUID.get(var0);
    }

    public boolean canBypassPlayerLimit(GameProfile var0) {
        return false;
    }

    public void reloadResources() {
        for (AdvancementDataPlayer var1 : this.advancements.values()) {
            var1.reload(this.server.getAdvancements());
        }
        this.broadcastAll(new PacketPlayOutTags(TagNetworkSerialization.serializeTagsToNetwork(this.registries)));
        PacketPlayOutRecipeUpdate var0 = new PacketPlayOutRecipeUpdate(this.server.getRecipeManager().getRecipes());
        for (EntityPlayer var2 : this.players) {
            var2.connection.send(var0);
            var2.getRecipeBook().sendInitialRecipeBook(var2);
        }
    }

    public boolean isAllowCheatsForAllPlayers() {
        return this.allowCheatsForAllPlayers;
    }
}

