/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResource;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataAbstract;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.profiling.GameProfilerFiller;
import org.slf4j.Logger;

public abstract class ResourceDataJson
extends ResourceDataAbstract<Map<MinecraftKey, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Gson gson;
    private final String directory;

    public ResourceDataJson(Gson var0, String var1) {
        this.gson = var0;
        this.directory = var1;
    }

    @Override
    protected Map<MinecraftKey, JsonElement> prepare(IResourceManager var0, GameProfilerFiller var1) {
        HashMap var2 = Maps.newHashMap();
        FileToIdConverter var3 = FileToIdConverter.json(this.directory);
        for (Map.Entry<MinecraftKey, IResource> var5 : var3.listMatchingResources(var0).entrySet()) {
            MinecraftKey var6 = var5.getKey();
            MinecraftKey var7 = var3.fileToId(var6);
            try {
                BufferedReader var8 = var5.getValue().openAsReader();
                try {
                    JsonElement var9 = ChatDeserializer.fromJson(this.gson, (Reader)var8, JsonElement.class);
                    JsonElement var10 = var2.put(var7, var9);
                    if (var10 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + var7);
                }
                finally {
                    if (var8 == null) continue;
                    ((Reader)var8).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException var8) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{var7, var6, var8});
            }
        }
        return var2;
    }

    @Override
    protected /* synthetic */ Object prepare(IResourceManager iResourceManager, GameProfilerFiller gameProfilerFiller) {
        return this.prepare(iResourceManager, gameProfilerFiller);
    }
}

