/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.EnumResourcePackVersion;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.flag.FeatureFlagSet;
import org.slf4j.Logger;

public class ResourcePackLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String id;
    private final c resources;
    private final IChatBaseComponent title;
    private final IChatBaseComponent description;
    private final EnumResourcePackVersion compatibility;
    private final FeatureFlagSet requestedFeatures;
    private final Position defaultPosition;
    private final boolean required;
    private final boolean fixedPosition;
    private final PackSource packSource;

    @Nullable
    public static ResourcePackLoader readMetaAndCreate(String var0, IChatBaseComponent var1, boolean var2, c var3, EnumResourcePackType var4, Position var5, PackSource var6) {
        a var7 = ResourcePackLoader.readPackInfo(var0, var3);
        return var7 != null ? ResourcePackLoader.create(var0, var1, var2, var3, var7, var4, var5, false, var6) : null;
    }

    public static ResourcePackLoader create(String var0, IChatBaseComponent var1, boolean var2, c var3, a var4, EnumResourcePackType var5, Position var6, boolean var7, PackSource var8) {
        return new ResourcePackLoader(var0, var2, var3, var1, var4, var4.compatibility(var5), var6, var7, var8);
    }

    private ResourcePackLoader(String var0, boolean var1, c var2, IChatBaseComponent var3, a var4, EnumResourcePackVersion var5, Position var6, boolean var7, PackSource var8) {
        this.id = var0;
        this.resources = var2;
        this.title = var3;
        this.description = var4.description();
        this.compatibility = var5;
        this.requestedFeatures = var4.requestedFeatures();
        this.required = var1;
        this.defaultPosition = var6;
        this.fixedPosition = var7;
        this.packSource = var8;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static a readPackInfo(String var0, c var1) {
        try (IResourcePack var2 = var1.open(var0);){
            ResourcePackInfo var3 = var2.getMetadataSection(ResourcePackInfo.TYPE);
            if (var3 == null) {
                LOGGER.warn("Missing metadata in pack {}", (Object)var0);
                a a2 = null;
                return a2;
            }
            FeatureFlagsMetadataSection var4 = var2.getMetadataSection(FeatureFlagsMetadataSection.TYPE);
            FeatureFlagSet var5 = var4 != null ? var4.flags() : FeatureFlagSet.of();
            a a3 = new a(var3.getDescription(), var3.getPackFormat(), var5);
            return a3;
        }
        catch (Exception var22) {
            LOGGER.warn("Failed to read pack metadata", (Throwable)var22);
            return null;
        }
    }

    public IChatBaseComponent getTitle() {
        return this.title;
    }

    public IChatBaseComponent getDescription() {
        return this.description;
    }

    public IChatBaseComponent getChatLink(boolean var0) {
        return ChatComponentUtils.wrapInSquareBrackets(this.packSource.decorate(IChatBaseComponent.literal(this.id))).withStyle(var1 -> var1.withColor(var0 ? EnumChatFormat.GREEN : EnumChatFormat.RED).withInsertion(StringArgumentType.escapeIfRequired((String)this.id)).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.empty().append(this.title).append("\n").append(this.description))));
    }

    public EnumResourcePackVersion getCompatibility() {
        return this.compatibility;
    }

    public FeatureFlagSet getRequestedFeatures() {
        return this.requestedFeatures;
    }

    public IResourcePack open() {
        return this.resources.open(this.id);
    }

    public String getId() {
        return this.id;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public Position getDefaultPosition() {
        return this.defaultPosition;
    }

    public PackSource getPackSource() {
        return this.packSource;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ResourcePackLoader)) {
            return false;
        }
        ResourcePackLoader var1 = (ResourcePackLoader)var0;
        return this.id.equals(var1.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @FunctionalInterface
    public static interface c {
        public IResourcePack open(String var1);
    }

    public record a(IChatBaseComponent description, int format, FeatureFlagSet requestedFeatures) {
        public EnumResourcePackVersion compatibility(EnumResourcePackType var0) {
            return EnumResourcePackVersion.forFormat(this.format, var0);
        }
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] c;

        public static Position[] values() {
            return (Position[])c.clone();
        }

        public static Position valueOf(String var0) {
            return Enum.valueOf(Position.class, var0);
        }

        public <T> int insert(List<T> var0, T var1, Function<T, ResourcePackLoader> var2, boolean var3) {
            ResourcePackLoader var6;
            int var5;
            Position var4;
            Position position = var4 = var3 ? this.opposite() : this;
            if (var4 == BOTTOM) {
                ResourcePackLoader var62;
                int var52;
                for (var52 = 0; var52 < var0.size() && (var62 = var2.apply(var0.get(var52))).isFixedPosition() && var62.getDefaultPosition() == this; ++var52) {
                }
                var0.add(var52, var1);
                return var52;
            }
            for (var5 = var0.size() - 1; var5 >= 0 && (var6 = var2.apply(var0.get(var5))).isFixedPosition() && var6.getDefaultPosition() == this; --var5) {
            }
            var0.add(var5 + 1, var1);
            return var5 + 1;
        }

        public Position opposite() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] b() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            c = Position.b();
        }
    }
}

