/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.metadata.pack;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.packs.metadata.MetadataSectionType;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.util.ChatDeserializer;

public class ResourcePackInfoDeserializer
implements MetadataSectionType<ResourcePackInfo> {
    @Override
    public ResourcePackInfo fromJson(JsonObject var0) {
        IChatMutableComponent var1 = IChatBaseComponent.ChatSerializer.fromJson(var0.get("description"));
        if (var1 == null) {
            throw new JsonParseException("Invalid/missing description!");
        }
        int var2 = ChatDeserializer.getAsInt(var0, "pack_format");
        return new ResourcePackInfo(var1, var2);
    }

    @Override
    public JsonObject toJson(ResourcePackInfo var0) {
        JsonObject var1 = new JsonObject();
        var1.add("description", IChatBaseComponent.ChatSerializer.toJsonTree(var0.getDescription()));
        var1.addProperty("pack_format", (Number)var0.getPackFormat());
        return var1;
    }

    @Override
    public String getMetadataSectionName() {
        return "pack";
    }

    @Override
    public /* synthetic */ Object fromJson(JsonObject jsonObject) {
        return this.fromJson(jsonObject);
    }
}

