/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.EnumChatFormat;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayInPickItem;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInResourcePackStatus;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSettings;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutKeepAlive;
import net.minecraft.network.protocol.game.PacketPlayOutKickDisconnect;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.IRecipe;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.slf4j.Logger;

public class PlayerConnection
implements ServerPlayerConnection,
TickablePacketListener,
PacketListenerPlayIn {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int LATENCY_CHECK_INTERVAL = 15000;
    public static final double MAX_INTERACTION_DISTANCE = MathHelper.square(6.0);
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final IChatBaseComponent CHAT_VALIDATION_FAILED = IChatBaseComponent.translatable("multiplayer.disconnect.chat_validation_failed");
    private final NetworkManager connection;
    private final MinecraftServer server;
    public EntityPlayer player;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private long keepAliveTime;
    private boolean keepAlivePending;
    private long keepAliveChallenge;
    private int chatSpamTickCount;
    private int dropSpamTickCount;
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3D awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    private final AtomicReference<Instant> lastChatTimeStamp = new AtomicReference<Instant>(Instant.EPOCH);
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageChain.b signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;

    public PlayerConnection(MinecraftServer var0, NetworkManager var1, EntityPlayer var2) {
        this.server = var0;
        this.connection = var1;
        var1.setListener(this);
        this.player = var2;
        var2.connection = this;
        this.keepAliveTime = SystemUtils.getMillis();
        var2.getTextFilter().join();
        this.signedMessageDecoder = var0.enforceSecureProfile() ? SignedMessageChain.b.REJECT_ALL : SignedMessageChain.b.unsigned(var2.getUUID());
        this.chatMessageChain = new FutureChain(var0);
    }

    @Override
    public void tick() {
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absMoveTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > 80) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle == this.player || this.lastVehicle.getControllingPassenger() != this.player) {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        } else {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.player.getRootVehicle().getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > 80) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        }
        this.server.getProfiler().push("keepAlive");
        long var0 = SystemUtils.getMillis();
        if (var0 - this.keepAliveTime >= 15000L) {
            if (this.keepAlivePending) {
                this.disconnect(IChatBaseComponent.translatable("disconnect.timeout"));
            } else {
                this.keepAlivePending = true;
                this.keepAliveTime = var0;
                this.keepAliveChallenge = var0;
                this.send(new PacketPlayOutKeepAlive(this.keepAliveChallenge));
            }
        }
        this.server.getProfiler().pop();
        if (this.chatSpamTickCount > 0) {
            --this.chatSpamTickCount;
        }
        if (this.dropSpamTickCount > 0) {
            --this.dropSpamTickCount;
        }
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && SystemUtils.getMillis() - this.player.getLastActionTime() > (long)(this.server.getPlayerIdleTimeout() * 1000 * 60)) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.idling"));
        }
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected();
    }

    private boolean isSingleplayerOwner() {
        return this.server.isSingleplayerOwner(this.player.getGameProfile());
    }

    public void disconnect(IChatBaseComponent var0) {
        this.connection.send(new PacketPlayOutKickDisconnect(var0), PacketSendListener.thenRun(() -> this.connection.disconnect(var0)));
        this.connection.setReadOnly();
        this.server.executeBlocking(this.connection::handleDisconnection);
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T var02, BiFunction<ITextFilter, T, CompletableFuture<R>> var1) {
        return var1.apply(this.player.getTextFilter(), (ITextFilter)var02).thenApply(var0 -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return var0;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String var0) {
        return this.filterTextPacket(var0, ITextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> var0) {
        return this.filterTextPacket(var0, ITextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(PacketPlayInSteerVehicle var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.setPlayerInput(var0.getXxa(), var0.getZza(), var0.isJumping(), var0.isShiftKeyDown());
    }

    private static boolean containsInvalidValues(double var0, double var2, double var4, float var6, float var7) {
        return Double.isNaN(var0) || Double.isNaN(var2) || Double.isNaN(var4) || !Floats.isFinite((float)var7) || !Floats.isFinite((float)var6);
    }

    private static double clampHorizontal(double var0) {
        return MathHelper.clamp(var0, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double var0) {
        return MathHelper.clamp(var0, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(PacketPlayInVehicleMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (PlayerConnection.containsInvalidValues(var0.getX(), var0.getY(), var0.getZ(), var0.getYRot(), var0.getXRot())) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        Entity var1 = this.player.getRootVehicle();
        if (var1 != this.player && var1.getControllingPassenger() == this.player && var1 == this.lastVehicle) {
            WorldServer var2 = this.player.getLevel();
            double var3 = var1.getX();
            double var5 = var1.getY();
            double var7 = var1.getZ();
            double var9 = PlayerConnection.clampHorizontal(var0.getX());
            double var11 = PlayerConnection.clampVertical(var0.getY());
            double var13 = PlayerConnection.clampHorizontal(var0.getZ());
            float var15 = MathHelper.wrapDegrees(var0.getYRot());
            float var16 = MathHelper.wrapDegrees(var0.getXRot());
            double var17 = var9 - this.vehicleFirstGoodX;
            double var19 = var11 - this.vehicleFirstGoodY;
            double var21 = var13 - this.vehicleFirstGoodZ;
            double var25 = var17 * var17 + var19 * var19 + var21 * var21;
            double var23 = var1.getDeltaMovement().lengthSqr();
            if (var25 - var23 > 100.0 && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{var1.getName().getString(), this.player.getName().getString(), var17, var19, var21});
                this.connection.send(new PacketPlayOutVehicleMove(var1));
                return;
            }
            boolean var27 = var2.noCollision(var1, var1.getBoundingBox().deflate(0.0625));
            var17 = var9 - this.vehicleLastGoodX;
            var19 = var11 - this.vehicleLastGoodY - 1.0E-6;
            var21 = var13 - this.vehicleLastGoodZ;
            boolean var28 = var1.verticalCollisionBelow;
            var1.move(EnumMoveType.PLAYER, new Vec3D(var17, var19, var21));
            double var29 = var19;
            var17 = var9 - var1.getX();
            var19 = var11 - var1.getY();
            if (var19 > -0.5 || var19 < 0.5) {
                var19 = 0.0;
            }
            var21 = var13 - var1.getZ();
            var25 = var17 * var17 + var19 * var19 + var21 * var21;
            boolean var31 = false;
            if (var25 > 0.0625) {
                var31 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{var1.getName().getString(), this.player.getName().getString(), Math.sqrt(var25)});
            }
            var1.absMoveTo(var9, var11, var13, var15, var16);
            boolean var32 = var2.noCollision(var1, var1.getBoundingBox().deflate(0.0625));
            if (var27 && (var31 || !var32)) {
                var1.absMoveTo(var3, var5, var7, var15, var16);
                this.connection.send(new PacketPlayOutVehicleMove(var1));
                return;
            }
            this.player.getLevel().getChunkSource().move(this.player);
            this.player.checkMovementStatistics(this.player.getX() - var3, this.player.getY() - var5, this.player.getZ() - var7);
            this.clientVehicleIsFloating = var29 >= -0.03125 && !var28 && !this.server.isFlightAllowed() && !var1.isNoGravity() && this.noBlocksAround(var1);
            this.vehicleLastGoodX = var1.getX();
            this.vehicleLastGoodY = var1.getY();
            this.vehicleLastGoodZ = var1.getZ();
        }
    }

    private boolean noBlocksAround(Entity var0) {
        return var0.level.getBlockStates(var0.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(PacketPlayInTeleportAccept var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.player.absMoveTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            if (this.player.isChangingDimension()) {
                this.player.hasChangedDimension();
            }
            this.awaitingPositionFromClient = null;
        }
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(PacketPlayInRecipeDisplayed var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.server.getRecipeManager().byKey(var0.getRecipe()).ifPresent(this.player.getRecipeBook()::removeHighlight);
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(PacketPlayInRecipeSettings var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getRecipeBook().setBookSetting(var0.getBookType(), var0.isOpen(), var0.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(PacketPlayInAdvancements var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getAction() == PacketPlayInAdvancements.Status.OPENED_TAB) {
            MinecraftKey var1 = var0.getTab();
            Advancement var2 = this.server.getAdvancements().getAdvancement(var1);
            if (var2 != null) {
                this.player.getAdvancements().setSelectedTab(var2);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(PacketPlayInTabComplete var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        StringReader var12 = new StringReader(var0.getCommand());
        if (var12.canRead() && var12.peek() == '/') {
            var12.skip();
        }
        ParseResults var2 = this.server.getCommands().getDispatcher().parse(var12, (Object)this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions(var2).thenAccept(var1 -> this.connection.send(new PacketPlayOutTabComplete(var0.getId(), (Suggestions)var1)));
    }

    @Override
    public void handleSetCommandBlock(PacketPlayInSetCommandBlock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
            return;
        }
        CommandBlockListenerAbstract var1 = null;
        TileEntityCommand var2 = null;
        BlockPosition var3 = var0.getPos();
        TileEntity var4 = this.player.level.getBlockEntity(var3);
        if (var4 instanceof TileEntityCommand) {
            var2 = (TileEntityCommand)var4;
            var1 = var2.getCommandBlock();
        }
        String var5 = var0.getCommand();
        boolean var6 = var0.isTrackOutput();
        if (var1 != null) {
            TileEntityCommand.Type var7 = var2.getMode();
            IBlockData var8 = this.player.level.getBlockState(var3);
            EnumDirection var9 = var8.getValue(BlockCommand.FACING);
            IBlockData var11 = (IBlockData)((IBlockData)(switch (var0.getMode()) {
                case TileEntityCommand.Type.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                case TileEntityCommand.Type.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                default -> Blocks.COMMAND_BLOCK.defaultBlockState();
            }).setValue(BlockCommand.FACING, var9)).setValue(BlockCommand.CONDITIONAL, var0.isConditional());
            if (var11 != var8) {
                this.player.level.setBlock(var3, var11, 2);
                var4.setBlockState(var11);
                this.player.level.getChunkAt(var3).setBlockEntity(var4);
            }
            var1.setCommand(var5);
            var1.setTrackOutput(var6);
            if (!var6) {
                var1.setLastOutput(null);
            }
            var2.setAutomatic(var0.isAutomatic());
            if (var7 != var0.getMode()) {
                var2.onModeSwitch();
            }
            var1.onUpdated();
            if (!UtilColor.isNullOrEmpty(var5)) {
                this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", var5));
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(PacketPlayInSetCommandMinecart var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
            return;
        }
        CommandBlockListenerAbstract var1 = var0.getCommandBlock(this.player.level);
        if (var1 != null) {
            var1.setCommand(var0.getCommand());
            var1.setTrackOutput(var0.isTrackOutput());
            if (!var0.isTrackOutput()) {
                var1.setLastOutput(null);
            }
            var1.onUpdated();
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", var0.getCommand()));
        }
    }

    @Override
    public void handlePickItem(PacketPlayInPickItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getInventory().pickSlot(var0.getSlot());
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, this.player.getInventory().selected, this.player.getInventory().getItem(this.player.getInventory().selected)));
        this.player.connection.send(new PacketPlayOutSetSlot(-2, 0, var0.getSlot(), this.player.getInventory().getItem(var0.getSlot())));
        this.player.connection.send(new PacketPlayOutHeldItemSlot(this.player.getInventory().selected));
    }

    @Override
    public void handleRenameItem(PacketPlayInItemName var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil var1 = (ContainerAnvil)container;
            if (!var1.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)var1);
                return;
            }
            String var2 = SharedConstants.filterText(var0.getName());
            if (var2.length() <= 50) {
                var1.setItemName(var2);
            }
        }
    }

    @Override
    public void handleSetBeaconPacket(PacketPlayInBeacon var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon var1 = (ContainerBeacon)container;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            var1.updateEffects(var0.getPrimary(), var0.getSecondary());
        }
    }

    @Override
    public void handleSetStructureBlock(PacketPlayInStruct var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level.getBlockState(var1);
        TileEntity var3 = this.player.level.getBlockEntity(var1);
        if (var3 instanceof TileEntityStructure) {
            TileEntityStructure var4 = (TileEntityStructure)var3;
            var4.setMode(var0.getMode());
            var4.setStructureName(var0.getName());
            var4.setStructurePos(var0.getOffset());
            var4.setStructureSize(var0.getSize());
            var4.setMirror(var0.getMirror());
            var4.setRotation(var0.getRotation());
            var4.setMetaData(var0.getData());
            var4.setIgnoreEntities(var0.isIgnoreEntities());
            var4.setShowAir(var0.isShowAir());
            var4.setShowBoundingBox(var0.isShowBoundingBox());
            var4.setIntegrity(var0.getIntegrity());
            var4.setSeed(var0.getSeed());
            if (var4.hasStructureName()) {
                String var5 = var4.getStructureName();
                if (var0.getUpdateType() == TileEntityStructure.UpdateType.SAVE_AREA) {
                    if (var4.saveStructure()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_failure", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.LOAD_AREA) {
                    if (!var4.isStructureLoadable()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_not_found", var5), false);
                    } else if (var4.loadStructure(this.player.getLevel())) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_prepare", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.SCAN_AREA) {
                    if (var4.detectSize()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_failure"), false);
                    }
                }
            } else {
                this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.invalid_structure_name", var0.getName()), false);
            }
            var4.setChanged();
            this.player.level.sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleSetJigsawBlock(PacketPlayInSetJigsaw var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level.getBlockState(var1);
        TileEntity var3 = this.player.level.getBlockEntity(var1);
        if (var3 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var4 = (TileEntityJigsaw)var3;
            var4.setName(var0.getName());
            var4.setTarget(var0.getTarget());
            var4.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, var0.getPool()));
            var4.setFinalState(var0.getFinalState());
            var4.setJoint(var0.getJoint());
            var4.setChanged();
            this.player.level.sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleJigsawGenerate(PacketPlayInJigsawGenerate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        TileEntity var2 = this.player.level.getBlockEntity(var1);
        if (var2 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var3 = (TileEntityJigsaw)var2;
            var3.generate(this.player.getLevel(), var0.levels(), var0.keepJigsaws());
        }
    }

    @Override
    public void handleSelectTrade(PacketPlayInTrSel var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        int var1 = var0.getItem();
        Container container = this.player.containerMenu;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant var2 = (ContainerMerchant)container;
            if (!var2.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)var2);
                return;
            }
            var2.setSelectionHint(var1);
            var2.tryMoveItems(var1);
        }
    }

    @Override
    public void handleEditBook(PacketPlayInBEdit var0) {
        int var12 = var0.getSlot();
        if (!PlayerInventory.isHotbarSlot(var12) && var12 != 40) {
            return;
        }
        ArrayList var2 = Lists.newArrayList();
        Optional<String> var3 = var0.getTitle();
        var3.ifPresent(var2::add);
        var0.getPages().stream().limit(100L).forEach(var2::add);
        Consumer<List> var4 = var3.isPresent() ? var1 -> this.signBook((FilteredText)var1.get(0), var1.subList(1, var1.size()), var12) : var1 -> this.updateBookContents((List<FilteredText>)var1, var12);
        this.filterTextPacket(var2).thenAcceptAsync(var4, (Executor)this.server);
    }

    private void updateBookContents(List<FilteredText> var0, int var1) {
        ItemStack var2 = this.player.getInventory().getItem(var1);
        if (!var2.is(Items.WRITABLE_BOOK)) {
            return;
        }
        this.updateBookPages(var0, UnaryOperator.identity(), var2);
    }

    private void signBook(FilteredText var02, List<FilteredText> var1, int var2) {
        ItemStack var3 = this.player.getInventory().getItem(var2);
        if (!var3.is(Items.WRITABLE_BOOK)) {
            return;
        }
        ItemStack var4 = new ItemStack(Items.WRITTEN_BOOK);
        NBTTagCompound var5 = var3.getTag();
        if (var5 != null) {
            var4.setTag(var5.copy());
        }
        var4.addTagElement("author", NBTTagString.valueOf(this.player.getName().getString()));
        if (this.player.isTextFilteringEnabled()) {
            var4.addTagElement("title", NBTTagString.valueOf(var02.filteredOrEmpty()));
        } else {
            var4.addTagElement("filtered_title", NBTTagString.valueOf(var02.filteredOrEmpty()));
            var4.addTagElement("title", NBTTagString.valueOf(var02.raw()));
        }
        this.updateBookPages(var1, var0 -> IChatBaseComponent.ChatSerializer.toJson(IChatBaseComponent.literal(var0)), var4);
        this.player.getInventory().setItem(var2, var4);
    }

    private void updateBookPages(List<FilteredText> var0, UnaryOperator<String> var12, ItemStack var2) {
        NBTTagList var3 = new NBTTagList();
        if (this.player.isTextFilteringEnabled()) {
            var0.stream().map(var1 -> NBTTagString.valueOf((String)var12.apply(var1.filteredOrEmpty()))).forEach(var3::add);
        } else {
            NBTTagCompound var4 = new NBTTagCompound();
            int var6 = var0.size();
            for (int var5 = 0; var5 < var6; ++var5) {
                FilteredText var7 = var0.get(var5);
                String var8 = var7.raw();
                var3.add(NBTTagString.valueOf((String)var12.apply(var8)));
                if (!var7.isFiltered()) continue;
                var4.putString(String.valueOf(var5), (String)var12.apply(var7.filteredOrEmpty()));
            }
            if (!var4.isEmpty()) {
                var2.addTagElement("filtered_pages", var4);
            }
        }
        var2.addTagElement("pages", var3);
    }

    @Override
    public void handleEntityTagQuery(PacketPlayInEntityNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        Entity var1 = this.player.getLevel().getEntity(var0.getEntityId());
        if (var1 != null) {
            NBTTagCompound var2 = var1.saveWithoutId(new NBTTagCompound());
            this.player.connection.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var2));
        }
    }

    @Override
    public void handleBlockEntityTagQuery(PacketPlayInTileNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        TileEntity var1 = this.player.getLevel().getBlockEntity(var0.getPos());
        NBTTagCompound var2 = var1 != null ? var1.saveWithoutMetadata() : null;
        this.player.connection.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var2));
    }

    @Override
    public void handleMovePlayer(PacketPlayInFlying var0) {
        boolean var30;
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (PlayerConnection.containsInvalidValues(var0.getX(0.0), var0.getY(0.0), var0.getZ(0.0), var0.getYRot(0.0f), var0.getXRot(0.0f))) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        WorldServer var1 = this.player.getLevel();
        if (this.player.wonGame) {
            return;
        }
        if (this.tickCount == 0) {
            this.resetPosition();
        }
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            return;
        }
        this.awaitingTeleportTime = this.tickCount;
        double var2 = PlayerConnection.clampHorizontal(var0.getX(this.player.getX()));
        double var4 = PlayerConnection.clampVertical(var0.getY(this.player.getY()));
        double var6 = PlayerConnection.clampHorizontal(var0.getZ(this.player.getZ()));
        float var8 = MathHelper.wrapDegrees(var0.getYRot(this.player.getYRot()));
        float var9 = MathHelper.wrapDegrees(var0.getXRot(this.player.getXRot()));
        if (this.player.isPassenger()) {
            this.player.absMoveTo(this.player.getX(), this.player.getY(), this.player.getZ(), var8, var9);
            this.player.getLevel().getChunkSource().move(this.player);
            return;
        }
        double var10 = this.player.getX();
        double var12 = this.player.getY();
        double var14 = this.player.getZ();
        double var16 = this.player.getY();
        double var18 = var2 - this.firstGoodX;
        double var20 = var4 - this.firstGoodY;
        double var22 = var6 - this.firstGoodZ;
        double var24 = this.player.getDeltaMovement().lengthSqr();
        double var26 = var18 * var18 + var20 * var20 + var22 * var22;
        if (this.player.isSleeping()) {
            if (var26 > 1.0) {
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), var8, var9);
            }
            return;
        }
        ++this.receivedMovePacketCount;
        int var28 = this.receivedMovePacketCount - this.knownMovePacketCount;
        if (var28 > 5) {
            LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)var28);
            var28 = 1;
        }
        if (!(this.player.isChangingDimension() || this.player.getLevel().getGameRules().getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK) && this.player.isFallFlying())) {
            float var29;
            float f2 = var29 = this.player.isFallFlying() ? 300.0f : 100.0f;
            if (var26 - var24 > (double)(var29 * (float)var28) && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getName().getString(), var18, var20, var22});
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                return;
            }
        }
        AxisAlignedBB var29 = this.player.getBoundingBox();
        var18 = var2 - this.lastGoodX;
        var20 = var4 - this.lastGoodY;
        var22 = var6 - this.lastGoodZ;
        boolean bl = var30 = var20 > 0.0;
        if (this.player.isOnGround() && !var0.isOnGround() && var30) {
            this.player.jumpFromGround();
        }
        boolean var31 = this.player.verticalCollisionBelow;
        this.player.move(EnumMoveType.PLAYER, new Vec3D(var18, var20, var22));
        double var32 = var20;
        var18 = var2 - this.player.getX();
        var20 = var4 - this.player.getY();
        if (var20 > -0.5 || var20 < 0.5) {
            var20 = 0.0;
        }
        var22 = var6 - this.player.getZ();
        var26 = var18 * var18 + var20 * var20 + var22 * var22;
        boolean var34 = false;
        if (!this.player.isChangingDimension() && var26 > 0.0625 && !this.player.isSleeping() && !this.player.gameMode.isCreative() && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR) {
            var34 = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.player.getName().getString());
        }
        this.player.absMoveTo(var2, var4, var6, var8, var9);
        if (!this.player.noPhysics && !this.player.isSleeping() && (var34 && var1.noCollision(this.player, var29) || this.isPlayerCollidingWithAnythingNew(var1, var29))) {
            this.teleport(var10, var12, var14, var8, var9);
            this.player.doCheckFallDamage(this.player.getY() - var16, var0.isOnGround());
            return;
        }
        this.clientIsFloating = var32 >= -0.03125 && !var31 && this.player.gameMode.getGameModeForPlayer() != EnumGamemode.SPECTATOR && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !this.player.isFallFlying() && !this.player.isAutoSpinAttack() && this.noBlocksAround(this.player);
        this.player.getLevel().getChunkSource().move(this.player);
        this.player.doCheckFallDamage(this.player.getY() - var16, var0.isOnGround());
        this.player.setOnGround(var0.isOnGround());
        if (var30) {
            this.player.resetFallDistance();
        }
        this.player.checkMovementStatistics(this.player.getX() - var10, this.player.getY() - var12, this.player.getZ() - var14);
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    private boolean isPlayerCollidingWithAnythingNew(IWorldReader var0, AxisAlignedBB var1) {
        Iterable<VoxelShape> var2 = var0.getCollisions(this.player, this.player.getBoundingBox().deflate(1.0E-5f));
        VoxelShape var3 = VoxelShapes.create(var1.deflate(1.0E-5f));
        for (VoxelShape var5 : var2) {
            if (VoxelShapes.joinIsNotEmpty(var5, var3, OperatorBoolean.AND)) continue;
            return true;
        }
        return false;
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7) {
        this.teleport(var0, var2, var4, var6, var7, Collections.emptySet());
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7, Set<RelativeMovement> var8) {
        double var9 = var8.contains((Object)RelativeMovement.X) ? this.player.getX() : 0.0;
        double var11 = var8.contains((Object)RelativeMovement.Y) ? this.player.getY() : 0.0;
        double var13 = var8.contains((Object)RelativeMovement.Z) ? this.player.getZ() : 0.0;
        float var15 = var8.contains((Object)RelativeMovement.Y_ROT) ? this.player.getYRot() : 0.0f;
        float var16 = var8.contains((Object)RelativeMovement.X_ROT) ? this.player.getXRot() : 0.0f;
        this.awaitingPositionFromClient = new Vec3D(var0, var2, var4);
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.awaitingTeleportTime = this.tickCount;
        this.player.absMoveTo(var0, var2, var4, var6, var7);
        this.player.connection.send(new PacketPlayOutPosition(var0 - var9, var2 - var11, var4 - var13, var6 - var15, var7 - var16, var8, this.awaitingTeleport));
    }

    @Override
    public void handlePlayerAction(PacketPlayInBlockDig var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        BlockPosition var1 = var0.getPos();
        this.player.resetLastActionTime();
        PacketPlayInBlockDig.EnumPlayerDigType var2 = var0.getAction();
        switch (var2) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack var3 = this.player.getItemInHand(EnumHand.OFF_HAND);
                    this.player.setItemInHand(EnumHand.OFF_HAND, this.player.getItemInHand(EnumHand.MAIN_HAND));
                    this.player.setItemInHand(EnumHand.MAIN_HAND, var3);
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.player.gameMode.handleBlockBreakAction(var1, var2, var0.getDirection(), this.player.level.getMaxBuildHeight(), var0.getSequence());
                this.player.connection.ackBlockChangesUpTo(var0.getSequence());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(EntityPlayer var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return false;
        }
        Item var2 = var1.getItem();
        return (var2 instanceof ItemBlock || var2 instanceof ItemBucket) && !var0.getCooldowns().isOnCooldown(var2);
    }

    @Override
    public void handleUseItemOn(PacketPlayInUseItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.connection.ackBlockChangesUpTo(var0.getSequence());
        WorldServer var1 = this.player.getLevel();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        if (!var3.isItemEnabled(var1.enabledFeatures())) {
            return;
        }
        MovingObjectPositionBlock var4 = var0.getHitResult();
        Vec3D var5 = var4.getLocation();
        BlockPosition var6 = var4.getBlockPos();
        Vec3D var7 = Vec3D.atCenterOf(var6);
        if (this.player.getEyePosition().distanceToSqr(var7) > MAX_INTERACTION_DISTANCE) {
            return;
        }
        Vec3D var8 = var5.subtract(var7);
        double var9 = 1.0000001;
        if (!(Math.abs(var8.x()) < 1.0000001 && Math.abs(var8.y()) < 1.0000001 && Math.abs(var8.z()) < 1.0000001)) {
            LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().getName(), var5, var6});
            return;
        }
        EnumDirection var11 = var4.getDirection();
        this.player.resetLastActionTime();
        int var12 = this.player.level.getMaxBuildHeight();
        if (var6.getY() < var12) {
            if (this.awaitingPositionFromClient == null && this.player.distanceToSqr((double)var6.getX() + 0.5, (double)var6.getY() + 0.5, (double)var6.getZ() + 0.5) < 64.0 && var1.mayInteract(this.player, var6)) {
                EnumInteractionResult var13 = this.player.gameMode.useItemOn(this.player, var1, var3, var2, var4);
                if (var11 == EnumDirection.UP && !var13.consumesAction() && var6.getY() >= var12 - 1 && PlayerConnection.wasBlockPlacementAttempt(this.player, var3)) {
                    IChatMutableComponent var14 = IChatBaseComponent.translatable("build.tooHigh", var12 - 1).withStyle(EnumChatFormat.RED);
                    this.player.sendSystemMessage(var14, true);
                } else if (var13.shouldSwing()) {
                    this.player.swing(var2, true);
                }
            }
        } else {
            IChatMutableComponent var13 = IChatBaseComponent.translatable("build.tooHigh", var12 - 1).withStyle(EnumChatFormat.RED);
            this.player.sendSystemMessage(var13, true);
        }
        this.player.connection.send(new PacketPlayOutBlockChange(var1, var6));
        this.player.connection.send(new PacketPlayOutBlockChange(var1, var6.relative(var11)));
    }

    @Override
    public void handleUseItem(PacketPlayInBlockPlace var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.ackBlockChangesUpTo(var0.getSequence());
        WorldServer var1 = this.player.getLevel();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        this.player.resetLastActionTime();
        if (var3.isEmpty() || !var3.isItemEnabled(var1.enabledFeatures())) {
            return;
        }
        EnumInteractionResult var4 = this.player.gameMode.useItem(this.player, var1, var3, var2);
        if (var4.shouldSwing()) {
            this.player.swing(var2, true);
        }
    }

    @Override
    public void handleTeleportToEntityPacket(PacketPlayInSpectate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.isSpectator()) {
            for (WorldServer var2 : this.server.getAllLevels()) {
                Entity var3 = var0.getEntity(var2);
                if (var3 == null) continue;
                this.player.teleportTo(var2, var3.getX(), var3.getY(), var3.getZ(), var3.getYRot(), var3.getXRot());
                return;
            }
        }
    }

    @Override
    public void handleResourcePackResponse(PacketPlayInResourcePackStatus var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getAction() == PacketPlayInResourcePackStatus.EnumResourcePackStatus.DECLINED && this.server.isResourcePackRequired()) {
            LOGGER.info("Disconnecting {} due to resource pack rejection", (Object)this.player.getName());
            this.disconnect(IChatBaseComponent.translatable("multiplayer.requiredTexturePrompt.disconnect"));
        }
    }

    @Override
    public void handlePaddleBoat(PacketPlayInBoatMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        Entity var1 = this.player.getControlledVehicle();
        if (var1 instanceof EntityBoat) {
            EntityBoat var2 = (EntityBoat)var1;
            var2.setPaddleState(var0.getLeft(), var0.getRight());
        }
    }

    @Override
    public void handlePong(ServerboundPongPacket var0) {
    }

    @Override
    public void onDisconnect(IChatBaseComponent var0) {
        this.chatMessageChain.close();
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)var0.getString());
        this.server.invalidateStatus();
        this.server.getPlayerList().broadcastSystemMessage(IChatBaseComponent.translatable("multiplayer.player.left", this.player.getDisplayName()).withStyle(EnumChatFormat.YELLOW), false);
        this.player.disconnect();
        this.server.getPlayerList().remove(this.player);
        this.player.getTextFilter().leave();
        if (this.isSingleplayerOwner()) {
            LOGGER.info("Stopping singleplayer server as player logged out");
            this.server.halt(false);
        }
    }

    public void ackBlockChangesUpTo(int var0) {
        if (var0 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(var0, this.ackBlockChangesUpTo);
    }

    @Override
    public void send(Packet<?> var0) {
        this.send(var0, null);
    }

    public void send(Packet<?> var0, @Nullable PacketSendListener var1) {
        try {
            this.connection.send(var0, var1);
        }
        catch (Throwable var2) {
            CrashReport var3 = CrashReport.forThrowable(var2, "Sending packet");
            CrashReportSystemDetails var4 = var3.addCategory("Packet being sent");
            var4.setDetail("Packet class", () -> var0.getClass().getCanonicalName());
            throw new ReportedException(var3);
        }
    }

    @Override
    public void handleSetCarriedItem(PacketPlayInHeldItemSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (var0.getSlot() < 0 || var0.getSlot() >= PlayerInventory.getSelectionSize()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            return;
        }
        if (this.player.getInventory().selected != var0.getSlot() && this.player.getUsedItemHand() == EnumHand.MAIN_HAND) {
            this.player.stopUsingItem();
        }
        this.player.getInventory().selected = var0.getSlot();
        this.player.resetLastActionTime();
    }

    @Override
    public void handleChat(PacketPlayInChat var0) {
        if (PlayerConnection.isChatMessageIllegal(var0.message())) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.illegal_characters"));
            return;
        }
        Optional<LastSeenMessages> var1 = this.tryHandleChat(var0.message(), var0.timeStamp(), var0.lastSeenMessages());
        if (var1.isPresent()) {
            this.server.submit(() -> {
                PlayerChatMessage var2;
                try {
                    var2 = this.getSignedMessage(var0, (LastSeenMessages)var1.get());
                }
                catch (SignedMessageChain.a var3) {
                    this.handleMessageDecodeFailure(var3);
                    return;
                }
                CompletableFuture<FilteredText> var3 = this.filterTextPacket(var2.signedContent());
                CompletableFuture<IChatBaseComponent> var4 = this.server.getChatDecorator().decorate(this.player, var2.decoratedContent());
                this.chatMessageChain.append(var32 -> CompletableFuture.allOf(var3, var4).thenAcceptAsync(var3 -> {
                    PlayerChatMessage var4 = var2.withUnsignedContent((IChatBaseComponent)var4.join()).filter(((FilteredText)var3.join()).mask());
                    this.broadcastChatMessage(var4);
                }, var32));
            });
        }
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket var0) {
        if (PlayerConnection.isChatMessageIllegal(var0.command())) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.illegal_characters"));
            return;
        }
        Optional<LastSeenMessages> var1 = this.tryHandleChat(var0.command(), var0.timeStamp(), var0.lastSeenMessages());
        if (var1.isPresent()) {
            this.server.submit(() -> {
                this.performChatCommand(var0, (LastSeenMessages)var1.get());
                this.detectRateSpam();
            });
        }
    }

    private void performChatCommand(ServerboundChatCommandPacket var0, LastSeenMessages var12) {
        Map<String, PlayerChatMessage> var3;
        ParseResults<CommandListenerWrapper> var2 = this.parseCommand(var0.command());
        try {
            var3 = this.collectSignedArguments(var0, SignableCommand.of(var2), var12);
        }
        catch (SignedMessageChain.a var4) {
            this.handleMessageDecodeFailure(var4);
            return;
        }
        CommandSigningContext.a var4 = new CommandSigningContext.a(var3);
        var2 = net.minecraft.commands.CommandDispatcher.mapSource(var2, var1 -> var1.withSigningContext(var4));
        this.server.getCommands().performCommand(var2, var0.command());
    }

    private void handleMessageDecodeFailure(SignedMessageChain.a var0) {
        if (var0.shouldDisconnect()) {
            this.disconnect(var0.getComponent());
        } else {
            this.player.sendSystemMessage(var0.getComponent().copy().withStyle(EnumChatFormat.RED));
        }
    }

    private Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandPacket var0, SignableCommand<?> var1, LastSeenMessages var2) throws SignedMessageChain.a {
        Object2ObjectOpenHashMap var3 = new Object2ObjectOpenHashMap();
        for (SignableCommand.a<?> var5 : var1.arguments()) {
            MessageSignature var6 = var0.argumentSignatures().get(var5.name());
            SignedMessageBody var7 = new SignedMessageBody(var5.value(), var0.timeStamp(), var0.salt(), var2);
            var3.put(var5.name(), this.signedMessageDecoder.unpack(var6, var7));
        }
        return var3;
    }

    private ParseResults<CommandListenerWrapper> parseCommand(String var0) {
        CommandDispatcher<CommandListenerWrapper> var1 = this.server.getCommands().getDispatcher();
        return var1.parse(var0, (Object)this.player.createCommandSourceStack());
    }

    private Optional<LastSeenMessages> tryHandleChat(String var0, Instant var1, LastSeenMessages.b var2) {
        if (!this.updateChatOrder(var1)) {
            LOGGER.warn("{} sent out-of-order chat: '{}'", (Object)this.player.getName().getString(), (Object)var0);
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.out_of_order_chat"));
            return Optional.empty();
        }
        Optional<LastSeenMessages> var3 = this.unpackAndApplyLastSeen(var2);
        if (this.player.getChatVisibility() == EnumChatVisibility.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(IChatBaseComponent.translatable("chat.disabled.options").withStyle(EnumChatFormat.RED), false));
            return Optional.empty();
        }
        this.player.resetLastActionTime();
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.b var0) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            Optional<LastSeenMessages> var2 = this.lastSeenMessages.applyUpdate(var0);
            if (var2.isEmpty()) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
            return var2;
        }
    }

    private boolean updateChatOrder(Instant var0) {
        Instant var1;
        do {
            if (!var0.isBefore(var1 = this.lastChatTimeStamp.get())) continue;
            return false;
        } while (!this.lastChatTimeStamp.compareAndSet(var1, var0));
        return true;
    }

    private static boolean isChatMessageIllegal(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (SharedConstants.isAllowedChatCharacter(var0.charAt(var1))) continue;
            return true;
        }
        return false;
    }

    private PlayerChatMessage getSignedMessage(PacketPlayInChat var0, LastSeenMessages var1) throws SignedMessageChain.a {
        SignedMessageBody var2 = new SignedMessageBody(var0.message(), var0.timeStamp(), var0.salt(), var1);
        return this.signedMessageDecoder.unpack(var0.signature(), var2);
    }

    private void broadcastChatMessage(PlayerChatMessage var0) {
        this.server.getPlayerList().broadcastChatMessage(var0, this.player, ChatMessageType.bind(ChatMessageType.CHAT, this.player));
        this.detectRateSpam();
    }

    private void detectRateSpam() {
        this.chatSpamTickCount += 20;
        if (this.chatSpamTickCount > 200 && !this.server.getPlayerList().isOp(this.player.getGameProfile())) {
            this.disconnect(IChatBaseComponent.translatable("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket var0) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            if (!this.lastSeenMessages.applyOffset(var0.offset())) {
                LOGGER.warn("Failed to validate message acknowledgements from {}", (Object)this.player.getName().getString());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(PacketPlayInArmAnimation var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        this.player.swing(var0.getHand());
    }

    @Override
    public void handlePlayerCommand(PacketPlayInEntityAction var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        switch (var0.getAction()) {
            case PRESS_SHIFT_KEY: {
                this.player.setShiftKeyDown(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.player.setShiftKeyDown(false);
                break;
            }
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)entity);
                int var2 = var0.getData();
                if (!var1.canJump() || var2 <= 0) break;
                var1.handleStartJump(var2);
                break;
            }
            case STOP_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)entity);
                var1.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                Entity entity = this.player.getVehicle();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen var1 = (HasCustomInventoryScreen)((Object)entity);
                var1.openCustomInventoryScreen(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPendingMessage(PlayerChatMessage var0) {
        int var2;
        MessageSignature var1 = var0.signature();
        if (var1 == null) {
            return;
        }
        this.messageSignatureCache.push(var0);
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            this.lastSeenMessages.addPending(var1);
            var2 = this.lastSeenMessages.trackedMessagesCount();
        }
        if (var2 > 4096) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.too_many_pending_chats"));
        }
    }

    public void sendPlayerChatMessage(PlayerChatMessage var0, ChatMessageType.a var1) {
        this.send(new ClientboundPlayerChatPacket(var0.link().sender(), var0.link().index(), var0.signature(), var0.signedBody().pack(this.messageSignatureCache), var0.unsignedContent(), var0.filterMask(), var1.toNetwork(this.player.level.registryAccess())));
        this.addPendingMessage(var0);
    }

    public void sendDisguisedChatMessage(IChatBaseComponent var0, ChatMessageType.a var1) {
        this.send(new ClientboundDisguisedChatPacket(var0, var1.toNetwork(this.player.level.registryAccess())));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    @Override
    public void handleInteract(PacketPlayInUseEntity var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        final WorldServer var1 = this.player.getLevel();
        final Entity var2 = var0.getTarget(var1);
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(var0.isUsingSecondaryAction());
        if (var2 != null) {
            if (!var1.getWorldBorder().isWithinBounds(var2.blockPosition())) {
                return;
            }
            AxisAlignedBB var3 = var2.getBoundingBox();
            if (var3.distanceToSqr(this.player.getEyePosition()) < MAX_INTERACTION_DISTANCE) {
                var0.dispatch(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand var0, a var12) {
                        ItemStack var22 = PlayerConnection.this.player.getItemInHand(var0);
                        if (!var22.isItemEnabled(var1.enabledFeatures())) {
                            return;
                        }
                        ItemStack var3 = var22.copy();
                        EnumInteractionResult var4 = var12.run(PlayerConnection.this.player, var2, var0);
                        if (var4.consumesAction()) {
                            CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(PlayerConnection.this.player, var3, var2);
                            if (var4.shouldSwing()) {
                                PlayerConnection.this.player.swing(var0, true);
                            }
                        }
                    }

                    @Override
                    public void onInteraction(EnumHand var0) {
                        this.performInteraction(var0, EntityHuman::interactOn);
                    }

                    @Override
                    public void onInteraction(EnumHand var0, Vec3D var12) {
                        this.performInteraction(var0, (var1, var2, var3) -> var2.interactAt(var1, var12, var3));
                    }

                    @Override
                    public void onAttack() {
                        if (var2 instanceof EntityItem || var2 instanceof EntityExperienceOrb || var2 instanceof EntityArrow || var2 == PlayerConnection.this.player) {
                            PlayerConnection.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.player.getName().getString());
                            return;
                        }
                        ItemStack var0 = PlayerConnection.this.player.getItemInHand(EnumHand.MAIN_HAND);
                        if (!var0.isItemEnabled(var1.enabledFeatures())) {
                            return;
                        }
                        PlayerConnection.this.player.attack(var2);
                    }
                });
            }
        }
    }

    @Override
    public void handleClientCommand(PacketPlayInClientCommand var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        PacketPlayInClientCommand.EnumClientCommand var1 = var0.getAction();
        switch (var1) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true);
                    CriterionTriggers.CHANGED_DIMENSION.trigger(this.player, World.END, World.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false);
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(EnumGamemode.SPECTATOR);
                this.player.getLevel().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.server);
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(PacketPlayInCloseWindow var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(PacketPlayInWindowClick var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != var0.getContainerId()) {
            return;
        }
        if (this.player.isSpectator()) {
            this.player.containerMenu.sendAllDataToRemote();
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        int var1 = var0.getSlotNum();
        if (!this.player.containerMenu.isValidSlotIndex(var1)) {
            LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getName(), var1, this.player.containerMenu.slots.size()});
            return;
        }
        boolean var2 = var0.getStateId() != this.player.containerMenu.getStateId();
        this.player.containerMenu.suppressRemoteUpdates();
        this.player.containerMenu.clicked(var1, var0.getButtonNum(), var0.getClickType(), this.player);
        for (Int2ObjectMap.Entry var4 : Int2ObjectMaps.fastIterable(var0.getChangedSlots())) {
            this.player.containerMenu.setRemoteSlotNoCopy(var4.getIntKey(), (ItemStack)var4.getValue());
        }
        this.player.containerMenu.setRemoteCarried(var0.getCarriedItem());
        this.player.containerMenu.resumeRemoteUpdates();
        if (var2) {
            this.player.containerMenu.broadcastFullState();
        } else {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handlePlaceRecipe(PacketPlayInAutoRecipe var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.isSpectator() || this.player.containerMenu.containerId != var0.getContainerId() || !(this.player.containerMenu instanceof ContainerRecipeBook)) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        this.server.getRecipeManager().byKey(var0.getRecipe()).ifPresent(var1 -> ((ContainerRecipeBook)this.player.containerMenu).handlePlacement(var0.isShiftDown(), (IRecipe<?>)var1, this.player));
    }

    @Override
    public void handleContainerButtonClick(PacketPlayInEnchantItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != var0.getContainerId() || this.player.isSpectator()) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        boolean var1 = this.player.containerMenu.clickMenuButton(this.player, var0.getButtonId());
        if (var1) {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handleSetCreativeModeSlot(PacketPlayInSetCreativeSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (this.player.gameMode.isCreative()) {
            boolean var5;
            TileEntity var52;
            BlockPosition var4;
            boolean var1 = var0.getSlotNum() < 0;
            ItemStack var2 = var0.getItem();
            if (!var2.isItemEnabled(this.player.getLevel().enabledFeatures())) {
                return;
            }
            NBTTagCompound var3 = ItemBlock.getBlockEntityData(var2);
            if (!var2.isEmpty() && var3 != null && var3.contains("x") && var3.contains("y") && var3.contains("z") && this.player.level.isLoaded(var4 = TileEntity.getPosFromTag(var3)) && (var52 = this.player.level.getBlockEntity(var4)) != null) {
                var52.saveToItem(var2);
            }
            boolean var42 = var0.getSlotNum() >= 1 && var0.getSlotNum() <= 45;
            boolean bl = var5 = var2.isEmpty() || var2.getDamageValue() >= 0 && var2.getCount() <= 64 && !var2.isEmpty();
            if (var42 && var5) {
                this.player.inventoryMenu.getSlot(var0.getSlotNum()).setByPlayer(var2);
                this.player.inventoryMenu.broadcastChanges();
            } else if (var1 && var5 && this.dropSpamTickCount < 200) {
                this.dropSpamTickCount += 20;
                this.player.drop(var2, true);
            }
        }
    }

    @Override
    public void handleSignUpdate(PacketPlayInUpdateSign var0) {
        List<String> var12 = Stream.of(var0.getLines()).map(EnumChatFormat::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(var12).thenAcceptAsync(var1 -> this.updateSignText(var0, (List<FilteredText>)var1), (Executor)this.server);
    }

    private void updateSignText(PacketPlayInUpdateSign var0, List<FilteredText> var1) {
        this.player.resetLastActionTime();
        WorldServer var2 = this.player.getLevel();
        BlockPosition var3 = var0.getPos();
        if (var2.hasChunkAt(var3)) {
            IBlockData var4 = var2.getBlockState(var3);
            TileEntity var5 = var2.getBlockEntity(var3);
            if (!(var5 instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign var6 = (TileEntitySign)var5;
            if (!var6.isEditable() || !this.player.getUUID().equals(var6.getPlayerWhoMayEdit())) {
                LOGGER.warn("Player {} just tried to change non-editable sign", (Object)this.player.getName().getString());
                return;
            }
            for (int var7 = 0; var7 < var1.size(); ++var7) {
                FilteredText var8 = var1.get(var7);
                if (this.player.isTextFilteringEnabled()) {
                    var6.setMessage(var7, IChatBaseComponent.literal(var8.filteredOrEmpty()));
                    continue;
                }
                var6.setMessage(var7, IChatBaseComponent.literal(var8.raw()), IChatBaseComponent.literal(var8.filteredOrEmpty()));
            }
            var6.setChanged();
            var2.sendBlockUpdated(var3, var4, var4, 3);
        }
    }

    @Override
    public void handleKeepAlive(PacketPlayInKeepAlive var0) {
        if (this.keepAlivePending && var0.getId() == this.keepAliveChallenge) {
            int var1 = (int)(SystemUtils.getMillis() - this.keepAliveTime);
            this.player.latency = (this.player.latency * 3 + var1) / 4;
            this.keepAlivePending = false;
        } else if (!this.isSingleplayerOwner()) {
            this.disconnect(IChatBaseComponent.translatable("disconnect.timeout"));
        }
    }

    @Override
    public void handlePlayerAbilities(PacketPlayInAbilities var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.getAbilities().flying = var0.isFlying() && this.player.getAbilities().mayfly;
    }

    @Override
    public void handleClientInformation(PacketPlayInSettings var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        this.player.updateOptions(var0);
    }

    @Override
    public void handleCustomPayload(PacketPlayInCustomPayload var0) {
    }

    @Override
    public void handleChangeDifficulty(PacketPlayInDifficultyChange var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficulty(var0.getDifficulty(), false);
    }

    @Override
    public void handleLockDifficulty(PacketPlayInDifficultyLock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficultyLocked(var0.isLocked());
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.getLevel());
        RemoteChatSession.a var1 = var0.chatSession();
        ProfilePublicKey.a var2 = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.a var3 = var1.profilePublicKey();
        if (Objects.equals(var2, var3)) {
            return;
        }
        if (var2 != null && var3.expiresAt().isBefore(var2.expiresAt())) {
            this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY);
            return;
        }
        try {
            SignatureValidator var4 = this.server.getServiceSignatureValidator();
            this.resetPlayerChatState(var1.validate(this.player.getGameProfile(), var4, Duration.ZERO));
        }
        catch (ProfilePublicKey.b var4) {
            LOGGER.error("Failed to validate profile key: {}", (Object)var4.getMessage());
            this.disconnect(var4.getComponent());
        }
    }

    private void resetPlayerChatState(RemoteChatSession var0) {
        this.chatSession = var0;
        this.signedMessageDecoder = var0.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(var1 -> {
            this.player.setChatSession(var0);
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.INITIALIZE_CHAT), List.of(this.player)));
            return CompletableFuture.completedFuture(null);
        });
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, Entity var2, EnumHand var3);
    }
}

