/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutAttachEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutMount;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.VecDeltaCodec;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemWorldMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class EntityTrackerEntry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TOLERANCE_LEVEL_ROTATION = 1;
    private final WorldServer level;
    private final Entity entity;
    private final int updateInterval;
    private final boolean trackDelta;
    private final Consumer<Packet<?>> broadcast;
    private final VecDeltaCodec positionCodec = new VecDeltaCodec();
    private int yRotp;
    private int xRotp;
    private int yHeadRotp;
    private Vec3D ap = Vec3D.ZERO;
    private int tickCount;
    private int teleportDelay;
    private List<Entity> lastPassengers = Collections.emptyList();
    private boolean wasRiding;
    private boolean wasOnGround;
    @Nullable
    private List<DataWatcher.b<?>> trackedDataValues;

    public EntityTrackerEntry(WorldServer var0, Entity var1, int var2, boolean var3, Consumer<Packet<?>> var4) {
        this.level = var0;
        this.broadcast = var4;
        this.entity = var1;
        this.updateInterval = var2;
        this.trackDelta = var3;
        this.positionCodec.setBase(var1.trackingPosition());
        this.yRotp = MathHelper.floor(var1.getYRot() * 256.0f / 360.0f);
        this.xRotp = MathHelper.floor(var1.getXRot() * 256.0f / 360.0f);
        this.yHeadRotp = MathHelper.floor(var1.getYHeadRot() * 256.0f / 360.0f);
        this.wasOnGround = var1.isOnGround();
        this.trackedDataValues = var1.getEntityData().getNonDefaultValues();
    }

    public void sendChanges() {
        Object var3;
        Entity entity;
        List<Entity> var0 = this.entity.getPassengers();
        if (!var0.equals(this.lastPassengers)) {
            this.broadcast.accept(new PacketPlayOutMount(this.entity));
            this.changedPassengers(var0, this.lastPassengers).forEach(var1 -> {
                EntityPlayer var2;
                if (var1 instanceof EntityPlayer && !var0.contains(var2 = (EntityPlayer)var1)) {
                    var2.connection.teleport(var2.getX(), var2.getY(), var2.getZ(), var2.getYRot(), var2.getXRot());
                }
            });
            this.lastPassengers = var0;
        }
        if ((entity = this.entity) instanceof EntityItemFrame) {
            EntityItemFrame var12 = (EntityItemFrame)entity;
            if (this.tickCount % 10 == 0) {
                WorldMap var4;
                ItemStack var2 = var12.getItem();
                if (var2.getItem() instanceof ItemWorldMap && (var4 = ItemWorldMap.getSavedData((Integer)(var3 = ItemWorldMap.getMapId(var2)), (World)this.level)) != null) {
                    for (EntityPlayer var6 : this.level.players()) {
                        var4.tickCarriedBy(var6, var2);
                        Packet<?> var7 = var4.getUpdatePacket((Integer)var3, var6);
                        if (var7 == null) continue;
                        var6.connection.send(var7);
                    }
                }
                this.sendDirtyEntityData();
            }
        }
        if (this.tickCount % this.updateInterval == 0 || this.entity.hasImpulse || this.entity.getEntityData().isDirty()) {
            int var13;
            if (this.entity.isPassenger()) {
                boolean var32;
                var13 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int var2 = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                boolean bl = var32 = Math.abs(var13 - this.yRotp) >= 1 || Math.abs(var2 - this.xRotp) >= 1;
                if (var32) {
                    this.broadcast.accept(new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)var13, (byte)var2, this.entity.isOnGround()));
                    this.yRotp = var13;
                    this.xRotp = var2;
                }
                this.positionCodec.setBase(this.entity.trackingPosition());
                this.sendDirtyEntityData();
                this.wasRiding = true;
            } else {
                Vec3D var10;
                double var11;
                ++this.teleportDelay;
                var13 = MathHelper.floor(this.entity.getYRot() * 256.0f / 360.0f);
                int var2 = MathHelper.floor(this.entity.getXRot() * 256.0f / 360.0f);
                var3 = this.entity.trackingPosition();
                boolean var4 = this.positionCodec.delta((Vec3D)var3).lengthSqr() >= 7.62939453125E-6;
                Packet<PacketListenerPlayOut> var5 = null;
                boolean var6 = var4 || this.tickCount % 60 == 0;
                boolean var7 = Math.abs(var13 - this.yRotp) >= 1 || Math.abs(var2 - this.xRotp) >= 1;
                boolean var8 = false;
                boolean var9 = false;
                if (this.tickCount > 0 || this.entity instanceof EntityArrow) {
                    boolean var16;
                    long var102 = this.positionCodec.encodeX((Vec3D)var3);
                    long var12 = this.positionCodec.encodeY((Vec3D)var3);
                    long var14 = this.positionCodec.encodeZ((Vec3D)var3);
                    boolean bl = var16 = var102 < -32768L || var102 > 32767L || var12 < -32768L || var12 > 32767L || var14 < -32768L || var14 > 32767L;
                    if (var16 || this.teleportDelay > 400 || this.wasRiding || this.wasOnGround != this.entity.isOnGround()) {
                        this.wasOnGround = this.entity.isOnGround();
                        this.teleportDelay = 0;
                        var5 = new PacketPlayOutEntityTeleport(this.entity);
                        var8 = true;
                        var9 = true;
                    } else if (var6 && var7 || this.entity instanceof EntityArrow) {
                        var5 = new PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook(this.entity.getId(), (short)var102, (short)var12, (short)var14, (byte)var13, (byte)var2, this.entity.isOnGround());
                        var8 = true;
                        var9 = true;
                    } else if (var6) {
                        var5 = new PacketPlayOutEntity.PacketPlayOutRelEntityMove(this.entity.getId(), (short)var102, (short)var12, (short)var14, this.entity.isOnGround());
                        var8 = true;
                    } else if (var7) {
                        var5 = new PacketPlayOutEntity.PacketPlayOutEntityLook(this.entity.getId(), (byte)var13, (byte)var2, this.entity.isOnGround());
                        var9 = true;
                    }
                }
                if ((this.trackDelta || this.entity.hasImpulse || this.entity instanceof EntityLiving && ((EntityLiving)this.entity).isFallFlying()) && this.tickCount > 0 && ((var11 = (var10 = this.entity.getDeltaMovement()).distanceToSqr(this.ap)) > 1.0E-7 || var11 > 0.0 && var10.lengthSqr() == 0.0)) {
                    this.ap = var10;
                    this.broadcast.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.ap));
                }
                if (var5 != null) {
                    this.broadcast.accept(var5);
                }
                this.sendDirtyEntityData();
                if (var8) {
                    this.positionCodec.setBase((Vec3D)var3);
                }
                if (var9) {
                    this.yRotp = var13;
                    this.xRotp = var2;
                }
                this.wasRiding = false;
            }
            var13 = MathHelper.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
            if (Math.abs(var13 - this.yHeadRotp) >= 1) {
                this.broadcast.accept(new PacketPlayOutEntityHeadRotation(this.entity, (byte)var13));
                this.yHeadRotp = var13;
            }
            this.entity.hasImpulse = false;
        }
        ++this.tickCount;
        if (this.entity.hurtMarked) {
            this.broadcastAndSend(new PacketPlayOutEntityVelocity(this.entity));
            this.entity.hurtMarked = false;
        }
    }

    private Stream<Entity> changedPassengers(List<Entity> var0, List<Entity> var12) {
        return Stream.concat(var12.stream().filter(var1 -> !var0.contains(var1)), var0.stream().filter(var1 -> !var12.contains(var1)));
    }

    public void removePairing(EntityPlayer var0) {
        this.entity.stopSeenByPlayer(var0);
        var0.connection.send(new PacketPlayOutEntityDestroy(this.entity.getId()));
    }

    public void addPairing(EntityPlayer var0) {
        ArrayList<Packet<PacketListenerPlayOut>> var1 = new ArrayList<Packet<PacketListenerPlayOut>>();
        this.sendPairingData(var1::add);
        var0.connection.send(new ClientboundBundlePacket((Iterable<Packet<PacketListenerPlayOut>>)var1));
        this.entity.startSeenByPlayer(var0);
    }

    public void sendPairingData(Consumer<Packet<PacketListenerPlayOut>> var0) {
        Object var3;
        if (this.entity.isRemoved()) {
            LOGGER.warn("Fetching packet for removed entity {}", (Object)this.entity);
        }
        Packet<PacketListenerPlayOut> var1 = this.entity.getAddEntityPacket();
        this.yHeadRotp = MathHelper.floor(this.entity.getYHeadRot() * 256.0f / 360.0f);
        var0.accept(var1);
        if (this.trackedDataValues != null) {
            var0.accept(new PacketPlayOutEntityMetadata(this.entity.getId(), this.trackedDataValues));
        }
        boolean var2 = this.trackDelta;
        if (this.entity instanceof EntityLiving) {
            var3 = ((EntityLiving)this.entity).getAttributes().getSyncableAttributes();
            if (!var3.isEmpty()) {
                var0.accept(new PacketPlayOutUpdateAttributes(this.entity.getId(), (Collection<AttributeModifiable>)var3));
            }
            if (((EntityLiving)this.entity).isFallFlying()) {
                var2 = true;
            }
        }
        this.ap = this.entity.getDeltaMovement();
        if (var2 && !(this.entity instanceof EntityLiving)) {
            var0.accept(new PacketPlayOutEntityVelocity(this.entity.getId(), this.ap));
        }
        if (this.entity instanceof EntityLiving) {
            var3 = Lists.newArrayList();
            for (EnumItemSlot var7 : EnumItemSlot.values()) {
                ItemStack var8 = ((EntityLiving)this.entity).getItemBySlot(var7);
                if (var8.isEmpty()) continue;
                var3.add(Pair.of((Object)((Object)var7), (Object)var8.copy()));
            }
            if (!var3.isEmpty()) {
                var0.accept(new PacketPlayOutEntityEquipment(this.entity.getId(), (List<Pair<EnumItemSlot, ItemStack>>)var3));
            }
        }
        if (this.entity instanceof EntityLiving) {
            var3 = (EntityLiving)this.entity;
            for (MobEffect var5 : ((EntityLiving)var3).getActiveEffects()) {
                var0.accept(new PacketPlayOutEntityEffect(this.entity.getId(), var5));
            }
        }
        if (!this.entity.getPassengers().isEmpty()) {
            var0.accept(new PacketPlayOutMount(this.entity));
        }
        if (this.entity.isPassenger()) {
            var0.accept(new PacketPlayOutMount(this.entity.getVehicle()));
        }
        if (this.entity instanceof EntityInsentient && ((EntityInsentient)(var3 = (EntityInsentient)this.entity)).isLeashed()) {
            var0.accept(new PacketPlayOutAttachEntity((Entity)var3, ((EntityInsentient)var3).getLeashHolder()));
        }
    }

    private void sendDirtyEntityData() {
        DataWatcher var0 = this.entity.getEntityData();
        List<DataWatcher.b<?>> var1 = var0.packDirty();
        if (var1 != null) {
            this.trackedDataValues = var0.getNonDefaultValues();
            this.broadcastAndSend(new PacketPlayOutEntityMetadata(this.entity.getId(), var1));
        }
        if (this.entity instanceof EntityLiving) {
            Set<AttributeModifiable> var2 = ((EntityLiving)this.entity).getAttributes().getDirtyAttributes();
            if (!var2.isEmpty()) {
                this.broadcastAndSend(new PacketPlayOutUpdateAttributes(this.entity.getId(), var2));
            }
            var2.clear();
        }
    }

    private void broadcastAndSend(Packet<?> var0) {
        this.broadcast.accept(var0);
        if (this.entity instanceof EntityPlayer) {
            ((EntityPlayer)this.entity).connection.send(var0);
        }
    }
}

