/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.ToIntFunction;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.EnumArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.level.World;

public class SpawnArmorTrimsCommand {
    private static final Map<Pair<ArmorMaterial, EnumItemSlot>, Item> MATERIAL_AND_SLOT_TO_ITEM = SystemUtils.make(Maps.newHashMap(), var0 -> {
        var0.put(Pair.of((Object)EnumArmorMaterial.CHAIN, (Object)((Object)EnumItemSlot.HEAD)), Items.CHAINMAIL_HELMET);
        var0.put(Pair.of((Object)EnumArmorMaterial.CHAIN, (Object)((Object)EnumItemSlot.CHEST)), Items.CHAINMAIL_CHESTPLATE);
        var0.put(Pair.of((Object)EnumArmorMaterial.CHAIN, (Object)((Object)EnumItemSlot.LEGS)), Items.CHAINMAIL_LEGGINGS);
        var0.put(Pair.of((Object)EnumArmorMaterial.CHAIN, (Object)((Object)EnumItemSlot.FEET)), Items.CHAINMAIL_BOOTS);
        var0.put(Pair.of((Object)EnumArmorMaterial.IRON, (Object)((Object)EnumItemSlot.HEAD)), Items.IRON_HELMET);
        var0.put(Pair.of((Object)EnumArmorMaterial.IRON, (Object)((Object)EnumItemSlot.CHEST)), Items.IRON_CHESTPLATE);
        var0.put(Pair.of((Object)EnumArmorMaterial.IRON, (Object)((Object)EnumItemSlot.LEGS)), Items.IRON_LEGGINGS);
        var0.put(Pair.of((Object)EnumArmorMaterial.IRON, (Object)((Object)EnumItemSlot.FEET)), Items.IRON_BOOTS);
        var0.put(Pair.of((Object)EnumArmorMaterial.GOLD, (Object)((Object)EnumItemSlot.HEAD)), Items.GOLDEN_HELMET);
        var0.put(Pair.of((Object)EnumArmorMaterial.GOLD, (Object)((Object)EnumItemSlot.CHEST)), Items.GOLDEN_CHESTPLATE);
        var0.put(Pair.of((Object)EnumArmorMaterial.GOLD, (Object)((Object)EnumItemSlot.LEGS)), Items.GOLDEN_LEGGINGS);
        var0.put(Pair.of((Object)EnumArmorMaterial.GOLD, (Object)((Object)EnumItemSlot.FEET)), Items.GOLDEN_BOOTS);
        var0.put(Pair.of((Object)EnumArmorMaterial.NETHERITE, (Object)((Object)EnumItemSlot.HEAD)), Items.NETHERITE_HELMET);
        var0.put(Pair.of((Object)EnumArmorMaterial.NETHERITE, (Object)((Object)EnumItemSlot.CHEST)), Items.NETHERITE_CHESTPLATE);
        var0.put(Pair.of((Object)EnumArmorMaterial.NETHERITE, (Object)((Object)EnumItemSlot.LEGS)), Items.NETHERITE_LEGGINGS);
        var0.put(Pair.of((Object)EnumArmorMaterial.NETHERITE, (Object)((Object)EnumItemSlot.FEET)), Items.NETHERITE_BOOTS);
        var0.put(Pair.of((Object)EnumArmorMaterial.DIAMOND, (Object)((Object)EnumItemSlot.HEAD)), Items.DIAMOND_HELMET);
        var0.put(Pair.of((Object)EnumArmorMaterial.DIAMOND, (Object)((Object)EnumItemSlot.CHEST)), Items.DIAMOND_CHESTPLATE);
        var0.put(Pair.of((Object)EnumArmorMaterial.DIAMOND, (Object)((Object)EnumItemSlot.LEGS)), Items.DIAMOND_LEGGINGS);
        var0.put(Pair.of((Object)EnumArmorMaterial.DIAMOND, (Object)((Object)EnumItemSlot.FEET)), Items.DIAMOND_BOOTS);
        var0.put(Pair.of((Object)EnumArmorMaterial.TURTLE, (Object)((Object)EnumItemSlot.HEAD)), Items.TURTLE_HELMET);
    });
    private static final List<ResourceKey<TrimPattern>> VANILLA_TRIM_PATTERNS = List.of(TrimPatterns.SENTRY, TrimPatterns.DUNE, TrimPatterns.COAST, TrimPatterns.WILD, TrimPatterns.WARD, TrimPatterns.EYE, TrimPatterns.VEX, TrimPatterns.TIDE, TrimPatterns.SNOUT, TrimPatterns.RIB, TrimPatterns.SPIRE);
    private static final List<ResourceKey<TrimMaterial>> VANILLA_TRIM_MATERIALS = List.of(TrimMaterials.QUARTZ, TrimMaterials.IRON, TrimMaterials.NETHERITE, TrimMaterials.REDSTONE, TrimMaterials.COPPER, TrimMaterials.GOLD, TrimMaterials.EMERALD, TrimMaterials.DIAMOND, TrimMaterials.LAPIS, TrimMaterials.AMETHYST);
    private static final ToIntFunction<ResourceKey<TrimPattern>> TRIM_PATTERN_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_PATTERNS);
    private static final ToIntFunction<ResourceKey<TrimMaterial>> TRIM_MATERIAL_ORDER = SystemUtils.createIndexLookup(VANILLA_TRIM_MATERIALS);

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("spawn_armor_trims").requires(var0 -> var0.hasPermission(2) && var0.getLevel().enabledFeatures().contains(FeatureFlags.UPDATE_1_20))).executes(var0 -> SpawnArmorTrimsCommand.spawnArmorTrims((CommandListenerWrapper)var0.getSource(), ((CommandListenerWrapper)var0.getSource()).getPlayerOrException())));
    }

    private static int spawnArmorTrims(CommandListenerWrapper var0, EntityHuman var12) {
        World var2 = var12.getLevel();
        NonNullList<ArmorTrim> var32 = NonNullList.create();
        IRegistry<TrimPattern> var4 = var2.registryAccess().registryOrThrow(Registries.TRIM_PATTERN);
        IRegistry<TrimMaterial> var5 = var2.registryAccess().registryOrThrow(Registries.TRIM_MATERIAL);
        var4.stream().sorted(Comparator.comparing(var1 -> TRIM_PATTERN_ORDER.applyAsInt(var4.getResourceKey((TrimPattern)var1).orElse(null)))).forEachOrdered(var3 -> var5.stream().sorted(Comparator.comparing(var1 -> TRIM_MATERIAL_ORDER.applyAsInt(var5.getResourceKey((TrimMaterial)var1).orElse(null)))).forEachOrdered(var4 -> var32.add(new ArmorTrim(var5.wrapAsHolder((TrimMaterial)var4), var4.wrapAsHolder((TrimPattern)var3)))));
        BlockPosition var6 = var12.blockPosition().relative(var12.getDirection(), 5);
        int var7 = EnumArmorMaterial.values().length - 1;
        double var8 = 3.0;
        int var10 = 0;
        int var11 = 0;
        for (ArmorTrim var13 : var32) {
            for (EnumArmorMaterial var17 : EnumArmorMaterial.values()) {
                if (var17 == EnumArmorMaterial.LEATHER) continue;
                double var18 = (double)var6.getX() + 0.5 - (double)(var10 % var5.size()) * 3.0;
                double var20 = (double)var6.getY() + 0.5 + (double)(var11 % var7) * 3.0;
                double var22 = (double)var6.getZ() + 0.5 + (double)(var10 / var5.size() * 10);
                EntityArmorStand var24 = new EntityArmorStand(var2, var18, var20, var22);
                var24.setYRot(180.0f);
                var24.setNoGravity(true);
                for (EnumItemSlot var28 : EnumItemSlot.values()) {
                    ItemArmor var31;
                    Item var29 = MATERIAL_AND_SLOT_TO_ITEM.get(Pair.of((Object)var17, (Object)((Object)var28)));
                    if (var29 == null) continue;
                    ItemStack var30 = new ItemStack(var29);
                    ArmorTrim.setTrim(var2.registryAccess(), var30, var13);
                    var24.setItemSlot(var28, var30);
                    if (var29 instanceof ItemArmor && (var31 = (ItemArmor)var29).getMaterial() == EnumArmorMaterial.TURTLE) {
                        var24.setCustomName(var13.pattern().value().copyWithStyle(var13.material()).copy().append(" ").append(var13.material().value().description()));
                        var24.setCustomNameVisible(true);
                        continue;
                    }
                    var24.setInvisible(true);
                }
                var2.addFreshEntity(var24);
                ++var11;
            }
            ++var10;
        }
        var0.sendSuccess(IChatBaseComponent.literal("Armorstands with trimmed armor spawned around you"), true);
        return 1;
    }
}

