/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.criteria.IScoreboardCriteria;

public class CommandTrigger {
    private static final SimpleCommandExceptionType ERROR_NOT_PRIMED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.trigger.failed.unprimed"));
    private static final SimpleCommandExceptionType ERROR_INVALID_OBJECTIVE = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.trigger.failed.invalid"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("trigger").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("objective", ArgumentScoreboardObjective.objective()).suggests((var0, var1) -> CommandTrigger.suggestObjectives((CommandListenerWrapper)var0.getSource(), var1)).executes(var0 -> CommandTrigger.simpleTrigger((CommandListenerWrapper)var0.getSource(), CommandTrigger.getScore(((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective"))))).then(net.minecraft.commands.CommandDispatcher.literal("add").then(net.minecraft.commands.CommandDispatcher.argument("value", IntegerArgumentType.integer()).executes(var0 -> CommandTrigger.addValue((CommandListenerWrapper)var0.getSource(), CommandTrigger.getScore(((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective")), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))).then(net.minecraft.commands.CommandDispatcher.literal("set").then(net.minecraft.commands.CommandDispatcher.argument("value", IntegerArgumentType.integer()).executes(var0 -> CommandTrigger.setValue((CommandListenerWrapper)var0.getSource(), CommandTrigger.getScore(((CommandListenerWrapper)var0.getSource()).getPlayerOrException(), ArgumentScoreboardObjective.getObjective((CommandContext<CommandListenerWrapper>)var0, "objective")), IntegerArgumentType.getInteger((CommandContext)var0, (String)"value")))))));
    }

    public static CompletableFuture<Suggestions> suggestObjectives(CommandListenerWrapper var0, SuggestionsBuilder var1) {
        Entity var2 = var0.getEntity();
        ArrayList var3 = Lists.newArrayList();
        if (var2 != null) {
            ScoreboardServer var4 = var0.getServer().getScoreboard();
            String var5 = var2.getScoreboardName();
            for (ScoreboardObjective var7 : var4.getObjectives()) {
                ScoreboardScore var8;
                if (var7.getCriteria() != IScoreboardCriteria.TRIGGER || !var4.hasPlayerScore(var5, var7) || (var8 = var4.getOrCreatePlayerScore(var5, var7)).isLocked()) continue;
                var3.add(var7.getName());
            }
        }
        return ICompletionProvider.suggest(var3, var1);
    }

    private static int addValue(CommandListenerWrapper var0, ScoreboardScore var1, int var2) {
        var1.add(var2);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.trigger.add.success", var1.getObjective().getFormattedDisplayName(), var2), true);
        return var1.getScore();
    }

    private static int setValue(CommandListenerWrapper var0, ScoreboardScore var1, int var2) {
        var1.setScore(var2);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.trigger.set.success", var1.getObjective().getFormattedDisplayName(), var2), true);
        return var2;
    }

    private static int simpleTrigger(CommandListenerWrapper var0, ScoreboardScore var1) {
        var1.add(1);
        var0.sendSuccess(IChatBaseComponent.translatable("commands.trigger.simple.success", var1.getObjective().getFormattedDisplayName()), true);
        return var1.getScore();
    }

    private static ScoreboardScore getScore(EntityPlayer var0, ScoreboardObjective var1) throws CommandSyntaxException {
        String var3;
        if (var1.getCriteria() != IScoreboardCriteria.TRIGGER) {
            throw ERROR_INVALID_OBJECTIVE.create();
        }
        Scoreboard var2 = var0.getScoreboard();
        if (!var2.hasPlayerScore(var3 = var0.getScoreboardName(), var1)) {
            throw ERROR_NOT_PRIMED.create();
        }
        ScoreboardScore var4 = var2.getOrCreatePlayerScore(var3, var1);
        if (var4.isLocked()) {
            throw ERROR_NOT_PRIMED.create();
        }
        var4.setLocked(true);
        return var4;
    }
}

