/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.commands.arguments.coordinates.VectorPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class CommandTeleport {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.teleport.invalidPosition"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        LiteralCommandNode var1 = var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("teleport").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("location", ArgumentVec3.vec3()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), Collections.singleton(((CommandListenerWrapper)var0.getSource()).getEntityOrException()), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), VectorPosition.current(), null)))).then(net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentEntity.entity()).executes(var0 -> CommandTeleport.teleportToEntity((CommandListenerWrapper)var0.getSource(), Collections.singleton(((CommandListenerWrapper)var0.getSource()).getEntityOrException()), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "destination"))))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("location", ArgumentVec3.vec3()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), null, null))).then(net.minecraft.commands.CommandDispatcher.argument("rotation", ArgumentRotation.rotation()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), ArgumentRotation.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation"), null)))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("facing").then(net.minecraft.commands.CommandDispatcher.literal("entity").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("facingEntity", ArgumentEntity.entity()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), null, new a(ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "facingEntity"), ArgumentAnchor.Anchor.FEET)))).then(net.minecraft.commands.CommandDispatcher.argument("facingAnchor", ArgumentAnchor.anchor()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), null, new a(ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "facingEntity"), ArgumentAnchor.getAnchor((CommandContext<CommandListenerWrapper>)var0, "facingAnchor")))))))).then(net.minecraft.commands.CommandDispatcher.argument("facingLocation", ArgumentVec3.vec3()).executes(var0 -> CommandTeleport.teleportToPos((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ((CommandListenerWrapper)var0.getSource()).getLevel(), ArgumentVec3.getCoordinates((CommandContext<CommandListenerWrapper>)var0, "location"), null, new a(ArgumentVec3.getVec3((CommandContext<CommandListenerWrapper>)var0, "facingLocation")))))))).then(net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentEntity.entity()).executes(var0 -> CommandTeleport.teleportToEntity((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "destination"))))));
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("tp").requires(var0 -> var0.hasPermission(2))).redirect((CommandNode)var1));
    }

    private static int teleportToEntity(CommandListenerWrapper var0, Collection<? extends Entity> var1, Entity var2) throws CommandSyntaxException {
        for (Entity entity : var1) {
            CommandTeleport.performTeleport(var0, entity, (WorldServer)var2.level, var2.getX(), var2.getY(), var2.getZ(), EnumSet.noneOf(RelativeMovement.class), var2.getYRot(), var2.getXRot(), null);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.teleport.success.entity.single", var1.iterator().next().getDisplayName(), var2.getDisplayName()), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.teleport.success.entity.multiple", var1.size(), var2.getDisplayName()), true);
        }
        return var1.size();
    }

    private static int teleportToPos(CommandListenerWrapper var0, Collection<? extends Entity> var1, WorldServer var2, IVectorPosition var3, @Nullable IVectorPosition var4, @Nullable a var5) throws CommandSyntaxException {
        Vec3D var6 = var3.getPosition(var0);
        Vec2F var7 = var4 == null ? null : var4.getRotation(var0);
        EnumSet<RelativeMovement> var8 = EnumSet.noneOf(RelativeMovement.class);
        if (var3.isXRelative()) {
            var8.add(RelativeMovement.X);
        }
        if (var3.isYRelative()) {
            var8.add(RelativeMovement.Y);
        }
        if (var3.isZRelative()) {
            var8.add(RelativeMovement.Z);
        }
        if (var4 == null) {
            var8.add(RelativeMovement.X_ROT);
            var8.add(RelativeMovement.Y_ROT);
        } else {
            if (var4.isXRelative()) {
                var8.add(RelativeMovement.X_ROT);
            }
            if (var4.isYRelative()) {
                var8.add(RelativeMovement.Y_ROT);
            }
        }
        for (Entity entity : var1) {
            if (var4 == null) {
                CommandTeleport.performTeleport(var0, entity, var2, var6.x, var6.y, var6.z, var8, entity.getYRot(), entity.getXRot(), var5);
                continue;
            }
            CommandTeleport.performTeleport(var0, entity, var2, var6.x, var6.y, var6.z, var8, var7.y, var7.x, var5);
        }
        if (var1.size() == 1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.teleport.success.location.single", var1.iterator().next().getDisplayName(), CommandTeleport.formatDouble(var6.x), CommandTeleport.formatDouble(var6.y), CommandTeleport.formatDouble(var6.z)), true);
        } else {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.teleport.success.location.multiple", var1.size(), CommandTeleport.formatDouble(var6.x), CommandTeleport.formatDouble(var6.y), CommandTeleport.formatDouble(var6.z)), true);
        }
        return var1.size();
    }

    private static String formatDouble(double var0) {
        return String.format(Locale.ROOT, "%f", var0);
    }

    private static void performTeleport(CommandListenerWrapper var0, Entity var1, WorldServer var2, double var3, double var5, double var7, Set<RelativeMovement> var9, float var10, float var11, @Nullable a var12) throws CommandSyntaxException {
        EntityLiving var16;
        float var15;
        BlockPosition var13 = BlockPosition.containing(var3, var5, var7);
        if (!World.isInSpawnableBounds(var13)) {
            throw INVALID_POSITION.create();
        }
        float var14 = MathHelper.wrapDegrees(var10);
        if (!var1.teleportTo(var2, var3, var5, var7, var9, var14, var15 = MathHelper.wrapDegrees(var11))) {
            return;
        }
        if (var12 != null) {
            var12.perform(var0, var1);
        }
        if (!(var1 instanceof EntityLiving) || !(var16 = (EntityLiving)var1).isFallFlying()) {
            var1.setDeltaMovement(var1.getDeltaMovement().multiply(1.0, 0.0, 1.0));
            var1.setOnGround(true);
        }
        if (var1 instanceof EntityCreature) {
            var16 = (EntityCreature)var1;
            ((EntityInsentient)var16).getNavigation().stop();
        }
    }

    static class a {
        private final Vec3D position;
        private final Entity entity;
        private final ArgumentAnchor.Anchor anchor;

        public a(Entity var0, ArgumentAnchor.Anchor var1) {
            this.entity = var0;
            this.anchor = var1;
            this.position = var1.apply(var0);
        }

        public a(Vec3D var0) {
            this.entity = null;
            this.position = var0;
            this.anchor = null;
        }

        public void perform(CommandListenerWrapper var0, Entity var1) {
            if (this.entity != null) {
                if (var1 instanceof EntityPlayer) {
                    ((EntityPlayer)var1).lookAt(var0.getAnchor(), this.entity, this.anchor);
                } else {
                    var1.lookAt(var0.getAnchor(), this.position);
                }
            } else {
                var1.lookAt(var0.getAnchor(), this.position);
            }
        }
    }
}

