/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.GameModeArgument;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;

public class CommandGamemode {
    public static final int PERMISSION_LEVEL = 2;

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("gamemode").requires(var0 -> var0.hasPermission(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("gamemode", GameModeArgument.gameMode()).executes(var0 -> CommandGamemode.setMode((CommandContext<CommandListenerWrapper>)var0, Collections.singleton(((CommandListenerWrapper)var0.getSource()).getPlayerOrException()), GameModeArgument.getGameMode((CommandContext<CommandListenerWrapper>)var0, "gamemode")))).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentEntity.players()).executes(var0 -> CommandGamemode.setMode((CommandContext<CommandListenerWrapper>)var0, ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "target"), GameModeArgument.getGameMode((CommandContext<CommandListenerWrapper>)var0, "gamemode"))))));
    }

    private static void logGamemodeChange(CommandListenerWrapper var0, EntityPlayer var1, EnumGamemode var2) {
        IChatMutableComponent var3 = IChatBaseComponent.translatable("gameMode." + var2.getName());
        if (var0.getEntity() == var1) {
            var0.sendSuccess(IChatBaseComponent.translatable("commands.gamemode.success.self", var3), true);
        } else {
            if (var0.getLevel().getGameRules().getBoolean(GameRules.RULE_SENDCOMMANDFEEDBACK)) {
                var1.sendSystemMessage(IChatBaseComponent.translatable("gameMode.changed", var3));
            }
            var0.sendSuccess(IChatBaseComponent.translatable("commands.gamemode.success.other", var1.getDisplayName(), var3), true);
        }
    }

    private static int setMode(CommandContext<CommandListenerWrapper> var0, Collection<EntityPlayer> var1, EnumGamemode var2) {
        int var3 = 0;
        for (EntityPlayer var5 : var1) {
            if (!var5.setGameMode(var2)) continue;
            CommandGamemode.logGamemodeChange((CommandListenerWrapper)var0.getSource(), var5, var2);
            ++var3;
        }
        return var3;
    }
}

