/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.blocks.ArgumentBlockPredicate;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.Clearable;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.ticks.TickListServer;

public class CommandClone {
    private static final SimpleCommandExceptionType ERROR_OVERLAP = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.clone.overlap"));
    private static final Dynamic2CommandExceptionType ERROR_AREA_TOO_LARGE = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatable("commands.clone.toobig", var0, var1));
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.clone.failed"));
    public static final Predicate<ShapeDetectorBlock> FILTER_AIR = var0 -> !var0.getState().isAir();

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clone").requires(var0 -> var0.hasPermission(2))).then(CommandClone.beginEndDestinationAndModeSuffix(var1, var0 -> ((CommandListenerWrapper)var0.getSource()).getLevel()))).then(net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.argument("sourceDimension", ArgumentDimension.dimension()).then(CommandClone.beginEndDestinationAndModeSuffix(var1, var0 -> ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "sourceDimension"))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> beginEndDestinationAndModeSuffix(CommandBuildContext var02, b<CommandContext<CommandListenerWrapper>, WorldServer> var1) {
        return net.minecraft.commands.CommandDispatcher.argument("begin", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("end", ArgumentPosition.blockPos()).then(CommandClone.destinationAndModeSuffix(var02, var1, var0 -> ((CommandListenerWrapper)var0.getSource()).getLevel()))).then(net.minecraft.commands.CommandDispatcher.literal("to").then(net.minecraft.commands.CommandDispatcher.argument("targetDimension", ArgumentDimension.dimension()).then(CommandClone.destinationAndModeSuffix(var02, var1, var0 -> ArgumentDimension.getDimension((CommandContext<CommandListenerWrapper>)var0, "targetDimension"))))));
    }

    private static c getLoadedDimensionAndPosition(CommandContext<CommandListenerWrapper> var0, WorldServer var1, String var2) throws CommandSyntaxException {
        BlockPosition var3 = ArgumentPosition.getLoadedBlockPos(var0, var1, var2);
        return new c(var1, var3);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> destinationAndModeSuffix(CommandBuildContext var03, b<CommandContext<CommandListenerWrapper>, WorldServer> var12, b<CommandContext<CommandListenerWrapper>, WorldServer> var2) {
        b<CommandContext<CommandListenerWrapper>, c> var32 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var12.apply((CommandContext<CommandListenerWrapper>)var1), "begin");
        b<CommandContext<CommandListenerWrapper>, c> var4 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var12.apply((CommandContext<CommandListenerWrapper>)var1), "end");
        b<CommandContext<CommandListenerWrapper>, c> var5 = var1 -> CommandClone.getLoadedDimensionAndPosition((CommandContext<CommandListenerWrapper>)var1, (WorldServer)var2.apply((CommandContext<CommandListenerWrapper>)var1), "destination");
        return ((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("destination", ArgumentPosition.blockPos()).executes(var3 -> CommandClone.clone((CommandListenerWrapper)var3.getSource(), (c)var32.apply(var3), (c)var4.apply(var3), (c)var5.apply(var3), var0 -> true, Mode.NORMAL))).then(CommandClone.wrapWithCloneMode(var32, var4, var5, var02 -> var0 -> true, net.minecraft.commands.CommandDispatcher.literal("replace").executes(var3 -> CommandClone.clone((CommandListenerWrapper)var3.getSource(), (c)var32.apply(var3), (c)var4.apply(var3), (c)var5.apply(var3), var0 -> true, Mode.NORMAL))))).then(CommandClone.wrapWithCloneMode(var32, var4, var5, var0 -> FILTER_AIR, net.minecraft.commands.CommandDispatcher.literal("masked").executes(var3 -> CommandClone.clone((CommandListenerWrapper)var3.getSource(), (c)var32.apply(var3), (c)var4.apply(var3), (c)var5.apply(var3), FILTER_AIR, Mode.NORMAL))))).then(net.minecraft.commands.CommandDispatcher.literal("filtered").then(CommandClone.wrapWithCloneMode(var32, var4, var5, var0 -> ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var0, "filter"), net.minecraft.commands.CommandDispatcher.argument("filter", ArgumentBlockPredicate.blockPredicate(var03)).executes(var3 -> CommandClone.clone((CommandListenerWrapper)var3.getSource(), (c)var32.apply(var3), (c)var4.apply(var3), (c)var5.apply(var3), ArgumentBlockPredicate.getBlockPredicate((CommandContext<CommandListenerWrapper>)var3, "filter"), Mode.NORMAL)))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> wrapWithCloneMode(b<CommandContext<CommandListenerWrapper>, c> var0, b<CommandContext<CommandListenerWrapper>, c> var1, b<CommandContext<CommandListenerWrapper>, c> var2, b<CommandContext<CommandListenerWrapper>, Predicate<ShapeDetectorBlock>> var3, ArgumentBuilder<CommandListenerWrapper, ?> var42) {
        return var42.then(net.minecraft.commands.CommandDispatcher.literal("force").executes(var4 -> CommandClone.clone((CommandListenerWrapper)var4.getSource(), (c)var0.apply(var4), (c)var1.apply(var4), (c)var2.apply(var4), (Predicate)var3.apply(var4), Mode.FORCE))).then(net.minecraft.commands.CommandDispatcher.literal("move").executes(var4 -> CommandClone.clone((CommandListenerWrapper)var4.getSource(), (c)var0.apply(var4), (c)var1.apply(var4), (c)var2.apply(var4), (Predicate)var3.apply(var4), Mode.MOVE))).then(net.minecraft.commands.CommandDispatcher.literal("normal").executes(var4 -> CommandClone.clone((CommandListenerWrapper)var4.getSource(), (c)var0.apply(var4), (c)var1.apply(var4), (c)var2.apply(var4), (Predicate)var3.apply(var4), Mode.NORMAL)));
    }

    private static int clone(CommandListenerWrapper var0, c var1, c var2, c var3, Predicate<ShapeDetectorBlock> var4, Mode var5) throws CommandSyntaxException {
        Object var26;
        Object var252;
        int var15;
        BlockPosition var6 = var1.position();
        BlockPosition var7 = var2.position();
        StructureBoundingBox var8 = StructureBoundingBox.fromCorners(var6, var7);
        BlockPosition var9 = var3.position();
        BlockPosition var10 = var9.offset(var8.getLength());
        StructureBoundingBox var11 = StructureBoundingBox.fromCorners(var9, var10);
        WorldServer var12 = var1.dimension();
        WorldServer var13 = var3.dimension();
        if (!var5.canOverlap() && var12 == var13 && var11.intersects(var8)) {
            throw ERROR_OVERLAP.create();
        }
        int var14 = var8.getXSpan() * var8.getYSpan() * var8.getZSpan();
        if (var14 > (var15 = var0.getLevel().getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw ERROR_AREA_TOO_LARGE.create((Object)var15, (Object)var14);
        }
        if (!var12.hasChunksAt(var6, var7) || !var13.hasChunksAt(var9, var10)) {
            throw ArgumentPosition.ERROR_NOT_LOADED.create();
        }
        ArrayList var16 = Lists.newArrayList();
        ArrayList var17 = Lists.newArrayList();
        ArrayList var18 = Lists.newArrayList();
        LinkedList var19 = Lists.newLinkedList();
        BlockPosition var20 = new BlockPosition(var11.minX() - var8.minX(), var11.minY() - var8.minY(), var11.minZ() - var8.minZ());
        for (int var21 = var8.minZ(); var21 <= var8.maxZ(); ++var21) {
            for (int var22 = var8.minY(); var22 <= var8.maxY(); ++var22) {
                for (int var23 = var8.minX(); var23 <= var8.maxX(); ++var23) {
                    Object var24 = new BlockPosition(var23, var22, var21);
                    var252 = ((BlockPosition)var24).offset(var20);
                    var26 = new ShapeDetectorBlock(var12, (BlockPosition)var24, false);
                    IBlockData var27 = ((ShapeDetectorBlock)var26).getState();
                    if (!var4.test((ShapeDetectorBlock)var26)) continue;
                    TileEntity var28 = var12.getBlockEntity((BlockPosition)var24);
                    if (var28 != null) {
                        NBTTagCompound var29 = var28.saveWithoutMetadata();
                        var17.add(new CommandCloneStoredTileEntity((BlockPosition)var252, var27, var29));
                        var19.addLast(var24);
                        continue;
                    }
                    if (var27.isSolidRender(var12, (BlockPosition)var24) || var27.isCollisionShapeFullBlock(var12, (BlockPosition)var24)) {
                        var16.add(new CommandCloneStoredTileEntity((BlockPosition)var252, var27, null));
                        var19.addLast(var24);
                        continue;
                    }
                    var18.add(new CommandCloneStoredTileEntity((BlockPosition)var252, var27, null));
                    var19.addFirst(var24);
                }
            }
        }
        if (var5 == Mode.MOVE) {
            for (BlockPosition var22 : var19) {
                TileEntity var23 = var12.getBlockEntity(var22);
                Clearable.tryClear(var23);
                var12.setBlock(var22, Blocks.BARRIER.defaultBlockState(), 2);
            }
            for (BlockPosition var22 : var19) {
                var12.setBlock(var22, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        ArrayList var21 = Lists.newArrayList();
        var21.addAll(var16);
        var21.addAll(var17);
        var21.addAll(var18);
        List var22 = Lists.reverse((List)var21);
        for (Object var24 : var22) {
            var252 = var13.getBlockEntity(((CommandCloneStoredTileEntity)var24).pos);
            Clearable.tryClear(var252);
            var13.setBlock(((CommandCloneStoredTileEntity)var24).pos, Blocks.BARRIER.defaultBlockState(), 2);
        }
        int var23 = 0;
        for (Object var252 : var21) {
            if (!var13.setBlock(((CommandCloneStoredTileEntity)var252).pos, ((CommandCloneStoredTileEntity)var252).state, 2)) continue;
            ++var23;
        }
        for (Object var252 : var17) {
            var26 = var13.getBlockEntity(((CommandCloneStoredTileEntity)var252).pos);
            if (((CommandCloneStoredTileEntity)var252).tag != null && var26 != null) {
                ((TileEntity)var26).load(((CommandCloneStoredTileEntity)var252).tag);
                ((TileEntity)var26).setChanged();
            }
            var13.setBlock(((CommandCloneStoredTileEntity)var252).pos, ((CommandCloneStoredTileEntity)var252).state, 2);
        }
        for (Object var252 : var22) {
            var13.blockUpdated(((CommandCloneStoredTileEntity)var252).pos, ((CommandCloneStoredTileEntity)var252).state.getBlock());
        }
        ((TickListServer)var13.getBlockTicks()).copyAreaFrom(var12.getBlockTicks(), var8, var20);
        if (var23 == 0) {
            throw ERROR_FAILED.create();
        }
        var0.sendSuccess(IChatBaseComponent.translatable("commands.clone.success", var23), true);
        return var23;
    }

    @FunctionalInterface
    static interface b<T, R> {
        public R apply(T var1) throws CommandSyntaxException;
    }

    record c(WorldServer dimension, BlockPosition position) {
    }

    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode FORCE = new Mode(true);
        public static final /* enum */ Mode MOVE = new Mode(true);
        public static final /* enum */ Mode NORMAL = new Mode(false);
        private final boolean canOverlap;
        private static final /* synthetic */ Mode[] e;

        public static Mode[] values() {
            return (Mode[])e.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private Mode(boolean var2) {
            this.canOverlap = var2;
        }

        public boolean canOverlap() {
            return this.canOverlap;
        }

        private static /* synthetic */ Mode[] b() {
            return new Mode[]{FORCE, MOVE, NORMAL};
        }

        static {
            e = Mode.b();
        }
    }

    static class CommandCloneStoredTileEntity {
        public final BlockPosition pos;
        public final IBlockData state;
        @Nullable
        public final NBTTagCompound tag;

        public CommandCloneStoredTileEntity(BlockPosition var0, IBlockData var1, @Nullable NBTTagCompound var2) {
            this.pos = var0;
            this.state = var1;
            this.tag = var2;
        }
    }
}

