/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.SharedConstants;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionInstance;
import net.minecraft.advancements.CriterionProgress;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutAdvancements;
import net.minecraft.network.protocol.game.PacketPlayOutSelectAdvancementTab;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.advancements.AdvancementVisibilityEvaluator;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class AdvancementDataPlayer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(AdvancementProgress.class, (Object)new AdvancementProgress.a()).registerTypeAdapter(MinecraftKey.class, (Object)new MinecraftKey.b()).setPrettyPrinting().create();
    private static final TypeToken<Map<MinecraftKey, AdvancementProgress>> TYPE_TOKEN = new TypeToken<Map<MinecraftKey, AdvancementProgress>>(){};
    private final DataFixer dataFixer;
    private final PlayerList playerList;
    private final Path playerSavePath;
    private final Map<Advancement, AdvancementProgress> progress = new LinkedHashMap<Advancement, AdvancementProgress>();
    private final Set<Advancement> visible = new HashSet<Advancement>();
    private final Set<Advancement> progressChanged = new HashSet<Advancement>();
    private final Set<Advancement> rootsToUpdate = new HashSet<Advancement>();
    private EntityPlayer player;
    @Nullable
    private Advancement lastSelectedTab;
    private boolean isFirstPacket = true;

    public AdvancementDataPlayer(DataFixer var0, PlayerList var1, AdvancementDataWorld var2, Path var3, EntityPlayer var4) {
        this.dataFixer = var0;
        this.playerList = var1;
        this.playerSavePath = var3;
        this.player = var4;
        this.load(var2);
    }

    public void setPlayer(EntityPlayer var0) {
        this.player = var0;
    }

    public void stopListening() {
        for (CriterionTrigger<?> var1 : CriterionTriggers.all()) {
            var1.removePlayerListeners(this);
        }
    }

    public void reload(AdvancementDataWorld var0) {
        this.stopListening();
        this.progress.clear();
        this.visible.clear();
        this.rootsToUpdate.clear();
        this.progressChanged.clear();
        this.isFirstPacket = true;
        this.lastSelectedTab = null;
        this.load(var0);
    }

    private void registerListeners(AdvancementDataWorld var0) {
        for (Advancement var2 : var0.getAllAdvancements()) {
            this.registerListeners(var2);
        }
    }

    private void checkForAutomaticTriggers(AdvancementDataWorld var0) {
        for (Advancement var2 : var0.getAllAdvancements()) {
            if (!var2.getCriteria().isEmpty()) continue;
            this.award(var2, "");
            var2.getRewards().grant(this.player);
        }
    }

    private void load(AdvancementDataWorld var0) {
        if (Files.isRegularFile(this.playerSavePath, new LinkOption[0])) {
            try (JsonReader var12 = new JsonReader((Reader)Files.newBufferedReader(this.playerSavePath, StandardCharsets.UTF_8));){
                var12.setLenient(false);
                Dynamic var2 = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)var12));
                int var3 = var2.get("DataVersion").asInt(1343);
                var2 = var2.remove("DataVersion");
                var2 = DataFixTypes.ADVANCEMENTS.updateToCurrentVersion(this.dataFixer, var2, var3);
                Map var4 = (Map)GSON.getAdapter(TYPE_TOKEN).fromJsonTree((JsonElement)var2.getValue());
                if (var4 == null) {
                    throw new JsonParseException("Found null for advancements");
                }
                var4.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(var1 -> {
                    Advancement var2 = var0.getAdvancement((MinecraftKey)var1.getKey());
                    if (var2 == null) {
                        LOGGER.warn("Ignored advancement '{}' in progress file {} - it doesn't exist anymore?", var1.getKey(), (Object)this.playerSavePath);
                        return;
                    }
                    this.startProgress(var2, (AdvancementProgress)var1.getValue());
                    this.progressChanged.add(var2);
                    this.markForVisibilityUpdate(var2);
                });
            }
            catch (JsonParseException var13) {
                LOGGER.error("Couldn't parse player advancements in {}", (Object)this.playerSavePath, (Object)var13);
            }
            catch (IOException var14) {
                LOGGER.error("Couldn't access player advancements in {}", (Object)this.playerSavePath, (Object)var14);
            }
        }
        this.checkForAutomaticTriggers(var0);
        this.registerListeners(var0);
    }

    public void save() {
        LinkedHashMap<MinecraftKey, AdvancementProgress> var0 = new LinkedHashMap<MinecraftKey, AdvancementProgress>();
        for (Map.Entry<Advancement, AdvancementProgress> var2 : this.progress.entrySet()) {
            AdvancementProgress var3 = var2.getValue();
            if (!var3.hasProgress()) continue;
            var0.put(var2.getKey().getId(), var3);
        }
        JsonElement var1 = GSON.toJsonTree(var0);
        var1.getAsJsonObject().addProperty("DataVersion", (Number)SharedConstants.getCurrentVersion().getDataVersion().getVersion());
        try {
            Map.Entry<Advancement, AdvancementProgress> var2;
            FileUtils.createDirectoriesSafe(this.playerSavePath.getParent());
            var2 = Files.newBufferedWriter(this.playerSavePath, StandardCharsets.UTF_8, new OpenOption[0]);
            try {
                GSON.toJson(var1, (Appendable)((Object)var2));
            }
            finally {
                if (var2 != null) {
                    ((Writer)((Object)var2)).close();
                }
            }
        }
        catch (IOException var2) {
            LOGGER.error("Couldn't save player advancements to {}", (Object)this.playerSavePath, (Object)var2);
        }
    }

    public boolean award(Advancement var0, String var1) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        boolean var4 = var3.isDone();
        if (var3.grantProgress(var1)) {
            this.unregisterListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
            if (!var4 && var3.isDone()) {
                var0.getRewards().grant(this.player);
                if (var0.getDisplay() != null && var0.getDisplay().shouldAnnounceChat() && this.player.level.getGameRules().getBoolean(GameRules.RULE_ANNOUNCE_ADVANCEMENTS)) {
                    this.playerList.broadcastSystemMessage(IChatBaseComponent.translatable("chat.type.advancement." + var0.getDisplay().getFrame().getName(), this.player.getDisplayName(), var0.getChatComponent()), false);
                }
            }
        }
        if (!var4 && var3.isDone()) {
            this.markForVisibilityUpdate(var0);
        }
        return var2;
    }

    public boolean revoke(Advancement var0, String var1) {
        boolean var2 = false;
        AdvancementProgress var3 = this.getOrStartProgress(var0);
        boolean var4 = var3.isDone();
        if (var3.revokeProgress(var1)) {
            this.registerListeners(var0);
            this.progressChanged.add(var0);
            var2 = true;
        }
        if (var4 && !var3.isDone()) {
            this.markForVisibilityUpdate(var0);
        }
        return var2;
    }

    private void markForVisibilityUpdate(Advancement var0) {
        this.rootsToUpdate.add(var0.getRoot());
    }

    private void registerListeners(Advancement var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        if (var1.isDone()) {
            return;
        }
        for (Map.Entry<String, Criterion> var3 : var0.getCriteria().entrySet()) {
            CriterionTrigger<CriterionInstance> var6;
            CriterionInstance var5;
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || var4.isDone() || (var5 = var3.getValue().getTrigger()) == null || (var6 = CriterionTriggers.getCriterion(var5.getCriterion())) == null) continue;
            var6.addPlayerListener(this, new CriterionTrigger.a<CriterionInstance>(var5, var0, var3.getKey()));
        }
    }

    private void unregisterListeners(Advancement var0) {
        AdvancementProgress var1 = this.getOrStartProgress(var0);
        for (Map.Entry<String, Criterion> var3 : var0.getCriteria().entrySet()) {
            CriterionTrigger<CriterionInstance> var6;
            CriterionInstance var5;
            CriterionProgress var4 = var1.getCriterion(var3.getKey());
            if (var4 == null || !var4.isDone() && !var1.isDone() || (var5 = var3.getValue().getTrigger()) == null || (var6 = CriterionTriggers.getCriterion(var5.getCriterion())) == null) continue;
            var6.removePlayerListener(this, new CriterionTrigger.a<CriterionInstance>(var5, var0, var3.getKey()));
        }
    }

    public void flushDirty(EntityPlayer var0) {
        if (this.isFirstPacket || !this.rootsToUpdate.isEmpty() || !this.progressChanged.isEmpty()) {
            HashMap<MinecraftKey, AdvancementProgress> var1 = new HashMap<MinecraftKey, AdvancementProgress>();
            HashSet<Advancement> var2 = new HashSet<Advancement>();
            HashSet<MinecraftKey> var3 = new HashSet<MinecraftKey>();
            for (Advancement var5 : this.rootsToUpdate) {
                this.updateTreeVisibility(var5, var2, var3);
            }
            this.rootsToUpdate.clear();
            for (Advancement var5 : this.progressChanged) {
                if (!this.visible.contains(var5)) continue;
                var1.put(var5.getId(), this.progress.get(var5));
            }
            this.progressChanged.clear();
            if (!(var1.isEmpty() && var2.isEmpty() && var3.isEmpty())) {
                var0.connection.send(new PacketPlayOutAdvancements(this.isFirstPacket, var2, var3, var1));
            }
        }
        this.isFirstPacket = false;
    }

    public void setSelectedTab(@Nullable Advancement var0) {
        Advancement var1 = this.lastSelectedTab;
        this.lastSelectedTab = var0 != null && var0.getParent() == null && var0.getDisplay() != null ? var0 : null;
        if (var1 != this.lastSelectedTab) {
            this.player.connection.send(new PacketPlayOutSelectAdvancementTab(this.lastSelectedTab == null ? null : this.lastSelectedTab.getId()));
        }
    }

    public AdvancementProgress getOrStartProgress(Advancement var0) {
        AdvancementProgress var1 = this.progress.get(var0);
        if (var1 == null) {
            var1 = new AdvancementProgress();
            this.startProgress(var0, var1);
        }
        return var1;
    }

    private void startProgress(Advancement var0, AdvancementProgress var1) {
        var1.update(var0.getCriteria(), var0.getRequirements());
        this.progress.put(var0, var1);
    }

    private void updateTreeVisibility(Advancement var02, Set<Advancement> var1, Set<MinecraftKey> var22) {
        AdvancementVisibilityEvaluator.evaluateVisibility(var02, var0 -> this.getOrStartProgress((Advancement)var0).isDone(), (var2, var3) -> {
            if (var3) {
                if (this.visible.add(var2)) {
                    var1.add(var2);
                    if (this.progress.containsKey(var2)) {
                        this.progressChanged.add(var2);
                    }
                }
            } else if (this.visible.remove(var2)) {
                var22.add(var2.getId());
            }
        });
    }
}

