/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.login;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.SecretKey;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.PacketLoginInListener;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MinecraftEncryption;

public class PacketLoginInEncryptionBegin
implements Packet<PacketLoginInListener> {
    private final byte[] keybytes;
    private final byte[] encryptedChallenge;

    public PacketLoginInEncryptionBegin(SecretKey var0, PublicKey var1, byte[] var2) throws CryptographyException {
        this.keybytes = MinecraftEncryption.encryptUsingKey(var1, var0.getEncoded());
        this.encryptedChallenge = MinecraftEncryption.encryptUsingKey(var1, var2);
    }

    public PacketLoginInEncryptionBegin(PacketDataSerializer var0) {
        this.keybytes = var0.readByteArray();
        this.encryptedChallenge = var0.readByteArray();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeByteArray(this.keybytes);
        var0.writeByteArray(this.encryptedChallenge);
    }

    @Override
    public void handle(PacketLoginInListener var0) {
        var0.handleKey(this);
    }

    public SecretKey getSecretKey(PrivateKey var0) throws CryptographyException {
        return MinecraftEncryption.decryptByteToSecretKey(var0, this.keybytes);
    }

    public boolean isChallengeValid(byte[] var0, PrivateKey var1) {
        try {
            return Arrays.equals(var0, MinecraftEncryption.decryptUsingKey(var1, this.encryptedChallenge));
        }
        catch (CryptographyException var2) {
            return false;
        }
    }
}

