/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.player.EntityHuman;

public class PacketPlayOutNamedEntitySpawn
implements Packet<PacketListenerPlayOut> {
    private final int entityId;
    private final UUID playerId;
    private final double x;
    private final double y;
    private final double z;
    private final byte yRot;
    private final byte xRot;

    public PacketPlayOutNamedEntitySpawn(EntityHuman var0) {
        this.entityId = var0.getId();
        this.playerId = var0.getGameProfile().getId();
        this.x = var0.getX();
        this.y = var0.getY();
        this.z = var0.getZ();
        this.yRot = (byte)(var0.getYRot() * 256.0f / 360.0f);
        this.xRot = (byte)(var0.getXRot() * 256.0f / 360.0f);
    }

    public PacketPlayOutNamedEntitySpawn(PacketDataSerializer var0) {
        this.entityId = var0.readVarInt();
        this.playerId = var0.readUUID();
        this.x = var0.readDouble();
        this.y = var0.readDouble();
        this.z = var0.readDouble();
        this.yRot = var0.readByte();
        this.xRot = var0.readByte();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entityId);
        var0.writeUUID(this.playerId);
        var0.writeDouble(this.x);
        var0.writeDouble(this.y);
        var0.writeDouble(this.z);
        var0.writeByte(this.yRot);
        var0.writeByte(this.xRot);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleAddPlayer(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public byte getyRot() {
        return this.yRot;
    }

    public byte getxRot() {
        return this.xRot;
    }
}

