/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayOutAdvancements
implements Packet<PacketListenerPlayOut> {
    private final boolean reset;
    private final Map<MinecraftKey, Advancement.SerializedAdvancement> added;
    private final Set<MinecraftKey> removed;
    private final Map<MinecraftKey, AdvancementProgress> progress;

    public PacketPlayOutAdvancements(boolean var0, Collection<Advancement> var1, Set<MinecraftKey> var2, Map<MinecraftKey, AdvancementProgress> var3) {
        this.reset = var0;
        ImmutableMap.Builder var4 = ImmutableMap.builder();
        for (Advancement var6 : var1) {
            var4.put((Object)var6.getId(), (Object)var6.deconstruct());
        }
        this.added = var4.build();
        this.removed = ImmutableSet.copyOf(var2);
        this.progress = ImmutableMap.copyOf(var3);
    }

    public PacketPlayOutAdvancements(PacketDataSerializer var0) {
        this.reset = var0.readBoolean();
        this.added = var0.readMap(PacketDataSerializer::readResourceLocation, Advancement.SerializedAdvancement::fromNetwork);
        this.removed = var0.readCollection(Sets::newLinkedHashSetWithExpectedSize, PacketDataSerializer::readResourceLocation);
        this.progress = var0.readMap(PacketDataSerializer::readResourceLocation, AdvancementProgress::fromNetwork);
    }

    @Override
    public void write(PacketDataSerializer var02) {
        var02.writeBoolean(this.reset);
        var02.writeMap(this.added, PacketDataSerializer::writeResourceLocation, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
        var02.writeCollection(this.removed, PacketDataSerializer::writeResourceLocation);
        var02.writeMap(this.progress, PacketDataSerializer::writeResourceLocation, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateAdvancementsPacket(this);
    }

    public Map<MinecraftKey, Advancement.SerializedAdvancement> getAdded() {
        return this.added;
    }

    public Set<MinecraftKey> getRemoved() {
        return this.removed;
    }

    public Map<MinecraftKey, AdvancementProgress> getProgress() {
        return this.progress;
    }

    public boolean shouldReset() {
        return this.reset;
    }
}

