/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayInUseEntity
implements Packet<PacketListenerPlayIn> {
    private final int entityId;
    private final EnumEntityUseAction action;
    private final boolean usingSecondaryAction;
    static final EnumEntityUseAction ATTACK_ACTION = new EnumEntityUseAction(){

        @Override
        public b getType() {
            return b.ATTACK;
        }

        @Override
        public void dispatch(c var0) {
            var0.onAttack();
        }

        @Override
        public void write(PacketDataSerializer var0) {
        }
    };

    private PacketPlayInUseEntity(int var0, boolean var1, EnumEntityUseAction var2) {
        this.entityId = var0;
        this.action = var2;
        this.usingSecondaryAction = var1;
    }

    public static PacketPlayInUseEntity createAttackPacket(Entity var0, boolean var1) {
        return new PacketPlayInUseEntity(var0.getId(), var1, ATTACK_ACTION);
    }

    public static PacketPlayInUseEntity createInteractionPacket(Entity var0, boolean var1, EnumHand var2) {
        return new PacketPlayInUseEntity(var0.getId(), var1, new d(var2));
    }

    public static PacketPlayInUseEntity createInteractionPacket(Entity var0, boolean var1, EnumHand var2, Vec3D var3) {
        return new PacketPlayInUseEntity(var0.getId(), var1, new e(var2, var3));
    }

    public PacketPlayInUseEntity(PacketDataSerializer var0) {
        this.entityId = var0.readVarInt();
        b var1 = var0.readEnum(b.class);
        this.action = var1.reader.apply(var0);
        this.usingSecondaryAction = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.entityId);
        var0.writeEnum(this.action.getType());
        this.action.write(var0);
        var0.writeBoolean(this.usingSecondaryAction);
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handleInteract(this);
    }

    @Nullable
    public Entity getTarget(WorldServer var0) {
        return var0.getEntityOrPart(this.entityId);
    }

    public boolean isUsingSecondaryAction() {
        return this.usingSecondaryAction;
    }

    public void dispatch(c var0) {
        this.action.dispatch(var0);
    }

    static interface EnumEntityUseAction {
        public b getType();

        public void dispatch(c var1);

        public void write(PacketDataSerializer var1);
    }

    static class d
    implements EnumEntityUseAction {
        private final EnumHand hand;

        d(EnumHand var0) {
            this.hand = var0;
        }

        private d(PacketDataSerializer var0) {
            this.hand = var0.readEnum(EnumHand.class);
        }

        @Override
        public b getType() {
            return b.INTERACT;
        }

        @Override
        public void dispatch(c var0) {
            var0.onInteraction(this.hand);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeEnum(this.hand);
        }
    }

    static class e
    implements EnumEntityUseAction {
        private final EnumHand hand;
        private final Vec3D location;

        e(EnumHand var0, Vec3D var1) {
            this.hand = var0;
            this.location = var1;
        }

        private e(PacketDataSerializer var0) {
            this.location = new Vec3D(var0.readFloat(), var0.readFloat(), var0.readFloat());
            this.hand = var0.readEnum(EnumHand.class);
        }

        @Override
        public b getType() {
            return b.INTERACT_AT;
        }

        @Override
        public void dispatch(c var0) {
            var0.onInteraction(this.hand, this.location);
        }

        @Override
        public void write(PacketDataSerializer var0) {
            var0.writeFloat((float)this.location.x);
            var0.writeFloat((float)this.location.y);
            var0.writeFloat((float)this.location.z);
            var0.writeEnum(this.hand);
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b INTERACT = new b(d::new);
        public static final /* enum */ b ATTACK = new b(var0 -> ATTACK_ACTION);
        public static final /* enum */ b INTERACT_AT = new b(e::new);
        final Function<PacketDataSerializer, EnumEntityUseAction> reader;
        private static final /* synthetic */ b[] e;

        public static b[] values() {
            return (b[])e.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private b(Function var2) {
            this.reader = var2;
        }

        private static /* synthetic */ b[] a() {
            return new b[]{INTERACT, ATTACK, INTERACT_AT};
        }

        static {
            e = b.a();
        }
    }

    public static interface c {
        public void onInteraction(EnumHand var1);

        public void onInteraction(EnumHand var1, Vec3D var2);

        public void onAttack();
    }
}

