/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public class ClientboundServerDataPacket
implements Packet<PacketListenerPlayOut> {
    private final IChatBaseComponent motd;
    private final Optional<byte[]> iconBytes;
    private final boolean enforcesSecureChat;

    public ClientboundServerDataPacket(IChatBaseComponent var0, Optional<byte[]> var1, boolean var2) {
        this.motd = var0;
        this.iconBytes = var1;
        this.enforcesSecureChat = var2;
    }

    public ClientboundServerDataPacket(PacketDataSerializer var0) {
        this.motd = var0.readComponent();
        this.iconBytes = var0.readOptional(PacketDataSerializer::readByteArray);
        this.enforcesSecureChat = var0.readBoolean();
    }

    @Override
    public void write(PacketDataSerializer var0) {
        var0.writeComponent(this.motd);
        var0.writeOptional(this.iconBytes, PacketDataSerializer::writeByteArray);
        var0.writeBoolean(this.enforcesSecureChat);
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleServerData(this);
    }

    public IChatBaseComponent getMotd() {
        return this.motd;
    }

    public Optional<byte[]> getIconBytes() {
        return this.iconBytes;
    }

    public boolean enforcesSecureChat() {
        return this.enforcesSecureChat;
    }
}

